/*
 * Copyright (C) 2010 Motorola
 * Copyright (C) 2011-2012 Canonical, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include <stdio.h>
#include <string.h>
#include <waudio.h>

int main(int argc,char** argv)
{
	if (argc == 1 )
	{
		printf("No test target, please input target like './audiotest 1' \n");
		printf("1: Test AudioTrack\n");
		printf("2: Test AudioRecord\n");
		printf("3: Test AudioSystem\n");
		return 0;
	}	

	if (strcmp(argv[1], "1") == 0)
	{
		TrackHandle handle;
	        handle = CreateAudioTrack();

        	if ( handle != NULL)
        	{
                	printf("Create AudioTrack successfully");
                	if ( NO_ERROR == AudioTrack_set(handle,MUSIC, 44100,PCM_16_BIT,CHANNEL_OUT_STEREO))
	                {
				int i = 1024;
			        char localbuf[i];
				int position;
	        
        	                printf("Audio Track setting successfully");
                	        AudioTrack_start(handle);
                        	printf("Audio Track start successfully");
 		                if ( i == AudioTrack_write(handle,localbuf,i))
        	                {
                	                printf("Audio Track write first time successfully");
                        	        AudioTrack_pause(handle);
	                                printf("Audio Track pause");
        	                        AudioTrack_start(handle);
                	                printf("Audio Track get latency is %d.", (int)AudioTrack_latency(handle));
                        	        if ( i == AudioTrack_write(handle,localbuf,i))
	                                {
        	                                if( NO_ERROR == AudioTrack_getposition(handle, (long unsigned int*)&position))
	                                        {
        	                                        printf("Audio Track get position is %d.",position);
                	                                AudioTrack_stop(handle);
                        	                        printf("Audio Track stop successfully");
                                	                DestoryAudioTrack(handle);
	                                        }else
        	                                {
                	                                printf("Audio Track getposition fail");
                	   		        }

		                        }else
                                	{
                                        	printf("Audio Track write fail");
                                	}

                        	}else
                        	{
                                	printf("Audio Track write fail");
                        	}

	                }else
        	        {
                	        printf("Audio Track setting fail");
        	        }

	       	}else
	        {
        	       	printf("Create Audio Track fail");
	        }
	}else if (strcmp(argv[1], "2") == 0)
	{
		//Test AudioRecord
		RecordHandle rhandle;
		rhandle = CreateAudioRecord();

		if ( rhandle != NULL)
		{
		        printf("Create AudioRecord successfully");
		        if ( NO_ERROR == AudioRecord_set(rhandle,AUDIO_SOURCE_MIC))
		        {
				int i = 1024;
			        char localbuf[i];
				int position;

		                printf("Audio Record setting successfully");
		                AudioRecord_start(rhandle);
		                printf("Audio Record start successfully");
		                if ( i == AudioRecord_read(rhandle,localbuf,i))
		                {
		                        printf("Audio Record read first time successfully");
		                        printf("Audio Record get latency is %d.",(int)AudioRecord_latency(rhandle));
		                                if( NO_ERROR == AudioRecord_getposition(rhandle,&position))
		                                {
		                                        printf("Audio Record get position is %d.",position);
		                                        AudioRecord_stop(rhandle);
		                                        printf("Audio Record stop successfully");
		                                        DestoryAudioRecord(rhandle);
		                                }else
		                                {
		                                        printf("Audio Record getposition fail");
		                                }
		                }else
		                {
		                        printf("Audio Record read fail");
		                }
			}else		
			{
		                printf("Audio Record setting fail");
		        }
		}else
		{
		         printf("Create Audio Record fail");
		}       
	}else if (strcmp(argv[1], "3") == 0)
        {
		int volume = 0;
		if ( NO_ERROR == AudioSystem_getStreamVolumeIndex(MUSIC, &volume))
		{
			printf("Audio System get MUSIC volume is %d.", volume);
			volume = 1;
	 		if (NO_ERROR  == AudioSystem_setStreamVolumeIndex(MUSIC,volume))
	 			printf("Audio System get/set MUSIC volume is OK.");
		}else
		{
			printf("Audio System get MUSIC volume fail");
		}

		int mute = 0;
		if ( NO_ERROR == AudioSystem_getStreamMute(MUSIC, &mute ))
		{
			printf("Audio System get MUSIC mute is %d.", mute);
		        mute = 1;
		        if (NO_ERROR  == AudioSystem_setStreamMute(MUSIC,mute))
		                printf("Audio System get/set MUSIC mute is OK.");
		}else
		{
			printf("Audio System get MUSIC Mute fail");
		}

        }

	return 0;
}

	

