#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2011-2012 Canonical, Ltd.
#
# Authors:
#  Ugo Riboni <ugo.riboni@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gi.repository import GObject, GLib
from subprocess import Popen
import threading

class QuestionDialog(threading.Thread):
   def __init__ (self, title, question, ok_text, cancel_text, callback, *args):
      self.title = title
      self.question = question
      self.ok_text = ok_text
      self.cancel_text = cancel_text
      self.callback = callback
      self.callback_args = args
      self.process = None
      threading.Thread.__init__(self)

   def run(self):
      self.process = Popen(['zenity', '--question', '--title', self.title,
                                 '--text', self.question, '--ok-label', self.ok_text,
                                 '--cancel-label', self.cancel_text])

      # Wait for process to terminate
      self.process.communicate()

      retcode = self.process.returncode
      if retcode < 0:
         api_returncode = -3 # clearSnapDecision was called before user decided
      elif retcode == 0 or retcode == 1:
         # 0 is the ok button, 1 is the cancel button (or closing the window)
         api_returncode = retcode
      else:
         print "Unexpected snap decision return code %d" % retcode
         api_returncode = -3

      # NOTE: by doing this we are ensuring that the callback is called in the
      # main thread. There may be a cleaner way to do it, but I don't know glib
      # bowels well enough to be able to find it.
      # In any case this entire zenity-based system is a temporary hack until
      # the real snap decisions are released, so it will suffice.
      GLib.timeout_add(0, self.callback, api_returncode, *self.callback_args)

   def stop(self):
      if self.process is not None:
         self.process.terminate()
