------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                        G N A T P P . C O M M O N                         --
--                                                                          --
--                                 Spec                                     --
--                                                                          --
--                   Copyright (C) 2001-2004, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Characters.Handling;   use Ada.Characters.Handling;
with Ada.Command_Line;          use Ada.Command_Line;
with Ada.Strings.Fixed;         use Ada.Strings.Fixed;

with GNAT.OS_Lib;               use GNAT.OS_Lib;
with GNAT.Directory_Operations; use GNAT.Directory_Operations;

package body GNATPP.Common is

   -----------------------
   -- Local subprograms --
   -----------------------

   function Detect_Target return String;
   --  Detects if this is a cross version of the tool by analyzing its name.
   --  In case if it is a cross version, returns the prefix of the name
   --  detecting the specific cross version, otherwise returns an empty
   --  string (in case of gnaamppp, returns "AAMP")

   function Compiler_To_Call return String;
   --  Detects the name of the compiler to call

   ----------------------
   -- Compiler_To_Call --
   ----------------------

   function Compiler_To_Call return String is
      Target : constant String := Detect_Target;
   begin

      if Target = "AAMP" then
         return "gnaamp";
      else
         return Target & "gcc";
      end if;

   end Compiler_To_Call;

   -------------------
   -- Detect_Target --
   -------------------

   function Detect_Target return String is
      Name     : constant String :=
                   To_Lower (Base_Name (Normalize_Pathname (Command_Name)));
      Dot_Idx  : Positive := Name'Last;
      Tgt_Last : constant Integer := Index (Name, "gnatpp") - 1;
   begin
      for J in reverse Name'Range loop
         if Name (J) = '.' then
            Dot_Idx := J - 1;
            exit;
         end if;
      end loop;

      if Name (Name'First .. Dot_Idx) = "gnaamppp" then
         return "AAMP";
      elsif Tgt_Last > Name'First then
         return Name (Name'First .. Tgt_Last);
      else
         return "";
      end if;

   exception
      when others =>
         return "";

   end Detect_Target;

   -----------
   -- Image --
   -----------

   function Image (Val : Natural) return String is
   begin
      return Trim (Integer'Image (Val), Ada.Strings.Left);
   end Image;

begin
   Gcc_To_Call := GNAT.OS_Lib.Locate_Exec_On_Path (Compiler_To_Call);
end GNATPP.Common;
