#!/usr/bin/env python

# This file is part of Atabake
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Authors: Artur Duque de Souza <artur.souza@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

__author__ = "Artur Duque de Souza / Leonardo Sobral Cunha"
__author_email__ = "artur.souza@openbossa.org / leonardo.cunha@openbossa.org"

import dbus
import sys

from atabake.lib.media_engine  import MediaEngine
from atabake.lib.player import Player

"""This script is used to test the daemon
functions of our media engine"""
bus = dbus.SessionBus()
media_engine_obj = bus.get_object(MediaEngine.DBUS_SERVICE_NAME,
                                  MediaEngine.DBUS_OBJ_PATH)

media_engine_iface = dbus.Interface(media_engine_obj,
                                    MediaEngine.DBUS_IFACE)

print "Media Engine DBus Introspection:"
print media_engine_obj.Introspect(dbus_interface="org.freedesktop.DBus.Introspectable")

# stop media engine
stop = media_engine_iface.stop()
print "Stop action: %s" % stop
