#!/bin/bash

# Generate diff of databases on remote machine..
THIS=`basename $0`

# Get config..
. ./diff-common.sh

# Get name of database we are diffing..
if [ "$1" != "" ] ; then
  DB=$1
else
  DB=$PROJECT
fi

echo ""
echo "Database Diff for ${PROJECT}"
echo "This script (re-)creates the latest core DB (${DBCORE}) and then produces"
echo "the SQL diff between it and the target database (${DB})."
echo "Target   : $DB"
echo "Reference: $DBCORE"
if [ "$DBHOST" != "" ] ; then
  echo "Remote host: $DBHOST"
fi
if [ "$PGVER" != "" ] ; then
  echo "Database version: $PGVER"
fi

# Re-create reference database.
echo "(Re-)creating ${DBCORE}.."
echo "Dropping any pre-existing $DBCORE (ignore errors).."
psql --host $DBHOST --user $DBUSER template1 -c "DROP DATABASE $DBCORE" >/dev/null 2>&1
psql --host $DBHOST --user $DBUSER template1 -c "CREATE DATABASE $DBCORE WITH ENCODING 'UTF-8'" >/dev/null 2>&1

echo "enabling plpgsql on $DBCORE.."
psql --host $DBHOST --user $DBUSER $DBCORE -c "CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler AS '/usr/lib/postgresql/lib/plpgsql.so', 'plpgsql_call_handler' LANGUAGE c;"  >/dev/null 2>&1
psql --host $DBHOST --user $DBUSER $DBCORE -c "CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler" >/dev/null 2>&1

echo "creating $DBCORE schema.."
CORE_SQL="./${PROJECT}_core.sql"
TRIG_SQL="./${PROJECT}_trig.sql"
psql --host $DBHOST --user $DBUSER $DBCORE -f $CORE_SQL >/dev/null 2>&1
psql --host $DBHOST --user $DBUSER $DBCORE -f $TRIG_SQL >/dev/null 2>&1

# Execute the diff..
$DBDIFF --user=$DBUSER --refver=$PGVER --targver=$PGVER --refhost=$DBHOST --targhost=$DBHOST --ref=$DBCORE --target=$DB $OPTS > $DIFFS

# Display it..
less $DIFFS
