#!/bin/sh

# Creates Axyl core database..
DB=axyl_core
PG_BIN=/usr/lib/postgresql/bin
PG_LANG=${PG_BIN}/createlang
if [ ! -x $PG_LANG ]
then
  PG_LANG=${PG_BIN}/enable_lang
fi

echo "Dropping any pre-existing Axyl core (ignore errors).."
dropdb $DB

createdb --encoding UTF-8 $DB
${PG_LANG} plpgsql ${DB}
psql $DB -f ./axyl_core.sql
psql $DB -f ./axyl_trig.sql
psql $DB -f ./axyl_core_data.sql

echo ""
echo "done."

# ENDS