// created by: Andr Dietisheim (dietisheim@sphere.ch)
// created:	2002-05-11
// modified by: Andr Dietisheim (dietisheim@sphere.ch)
// modified: 2004-01-17
// version: 2.1.0

function Xmenus( sNavigationName, sNavigation )
{
	if( !Xmenus.prototype.instances ) Xmenus.prototype.instances = new Array();
	Xmenus.prototype.instances[ Xmenus.prototype.instances.length ] = this;

	this.index = Xmenus.prototype.instances.length - 1;
	this.bCompatibleBrowser = ( is.iewin5up || is.iemac5up || is.gk || is.sf || is.kq3up || is.nn4up || is.op6up );
	this.iCloseDelay = 1;
	this.xmenus = new Array();

	this.sNavigationName = sNavigationName;
	this.sNavigation = sNavigation;
	this.navigationMenu = null;

	this.lastMenu = null;
	this.timeout = null;
	this.bReopenDisabled = false;
}

Xmenus.prototype.add = function( xmenuConfig )
{
	if ( this.bCompatibleBrowser )
		this.xmenus[ this.xmenus.length ] = new Xmenu( this.sNavigationName, this.sNavigation, xmenuConfig[ 0 ], xmenuConfig[ 1 ], xmenuConfig[ 2 ] );
//	else
//		this.writeDegradationHtml( xmenuConfig );
}

Xmenus.prototype.create = function()
{
	if ( !this.bCompatibleBrowser ) return;

	for ( j = 0; j < this.xmenus.length; j++ )
	{
		this.xmenus[ j ].setOpenListener( this );
		this.xmenus[ j ].setCloseListener( this );
		this.xmenus[ j ].setLinkClickListener( this );
		this.xmenus[ j ].create();
		if ( this.xmenus[ j ].isNavigationNodeFound() )
		{
			this.openNavigationMenu( this.xmenus[ j ] );
		}
	}
}

Xmenus.prototype.openNavigationMenu = function( xmenu )
{
			this.navigationMenu = xmenu;
			this.lastMenu = xmenu;
			xmenu.open();
}

Xmenus.prototype.onMenuOpen = function( xmenu )
{ // fired by Xmenu on menu open
	if ( this.lastMenu != null && this.lastMenu != xmenu )
	{
		this.bReopenDisabled = true;
		this.lastMenu.close();
		this.bReopenDisabled = false;
	}
	this.bOpened = true;
	this.lastMenu = xmenu;
}

Xmenus.prototype.onMenuClose = function( xmenu )
{  // fired by Xmenu on menu close
	if ( !this.bReopenDisabled )
	{
		this.timeout = setTimeout( "Xmenus.prototype.instances[" + this.index + "].reopenAfterClose()", this.iCloseDelay * 1000 );
	}
	this.bOpened = false;
}

Xmenus.prototype.reopenAfterClose = function()
{
	if ( !this.bOpened && this.navigationMenu != null )
	{ //no other menu is opened -> open navigation menu
		this.navigationMenu.open();
	}
}

Xmenus.prototype.onLinkClick = function( xmenu )
{  // fired by Xmenu on click on a link
//	this.navigationMenu.clearHighlightChildren( this.navigationMenu.tree );
	this.openNavigationMenu( xmenu );
}

Xmenus.prototype.writeDegradationHtml = function( xmenuConfig )
{
	var content = xmenuConfig[ 2 ];
	for ( i = 0; i < content.length; i++ )
	{
		if ( content[ i ][ 2 ] == 0 && content[ i ][ 1 ] )
			document.write( '<a href="' + content[ i ][ 1 ].sSrc + '">' + content[ i ][ 0 ] + '</a><br>' );;
	}
}