<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    renderable.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Renderable object definition.                           */
/*                                                                      */
/* ******************************************************************** */
/** @package core */

// BROWSER TYPES
/** Undefined/unknown browser type */
define("BROWSER_TYPE_UNKNOWN",    "");
/** Standard HTML web browser */
define("BROWSER_TYPE_HTML",       "html");
/** XHTML (HTML 5.0) capable web browser, phone, or PDA */
define("BROWSER_TYPE_XHTML",      "xhtml");
/** Standard WAP phone */
define("BROWSER_TYPE_WML",        "wml");
/** WAP phone with Phone.com extensions */
define("BROWSER_TYPE_WMLUP",      "wmlup");
/** XML-only-capable browser, an unlikely beast */
define("BROWSER_TYPE_XML",        "xml");
/** Not really a browser, a command-line script.. */
define("BROWSER_TYPE_CLI",        "cli");
/** Default browser type, in absence of true knowledge.. */
define("BROWSER_TYPE_DEFAULT",    "html");

// -----------------------------------------------------------------------
/**
* RenderableObject class
* This object should be inherited by all classes which are
* intended to output content for the client browser.
* @package core
*/
class RenderableObject {
  /**
  * Constructor
  * Create a renderable object. Any object which you want to
  * be able to deliver content to a device such as a web
  * browser or wap phone etc. should inherit this class.
  */
  function RenderableObject() {
    return true;
  }
  /**
  * Return output suitable for normal wap-capable device. This
  * method must be over-ridden by a method of the same name in
  * the descendant class which renders output to wap devices.
  * @param mixed $parm Optional parameter to pass to method
  */
  function wml($parm="") {
    return "";
  }
  /**
  * Return output suitable for normal wap-capable device which
  * has Phone.com extensions. This method must be over-ridden
  * by a method of the same name in the descendant class which
  * renders output to wap devices.
  * @param mixed $parm Optional parameter to pass to method
  */
  function wmlup($parm="") {
    return $this->wml($parm);
  }
  /**
  * Return output suitable for normal HTML-capable device. This
  * method must be over-ridden by a method of the same name in
  * the descendant class which renders output to web browsers.
  * @param mixed $parm Optional parameter to pass to method
  */
  function html($parm="") {
    return "";
  }
  /**
  * Return output suitable for XML-capable devices or agents.
  * This method must be over-ridden by a method of the same name
  * in the descendant class which renders XML output.
  * @param mixed $parm Optional parameter to pass to method
  */
  function xml($parm="") {
    return "";
  }
  /**
  * Render output
  * Render in the appropriate way for the browser type. In
  * this instance we define the 'type' of the browser based
  * on the kind of content it is expecting back. Note that
  * this does not determine the actual "make" of the browser
  * (Internet Explorer, Netscape etc.) since a given "make"
  * of browser can deal with all sorts of content types..
  * @param mixed $parm Optional parameter to pass to method
  */
  function render($parm="") {
    global $RESPONSE;
    switch ($RESPONSE->browser_type) {
      case BROWSER_TYPE_XHTMLMP:
      case BROWSER_TYPE_WML:
        if ($parm == "") return $this->wml();
        else return $this->wml($parm);
        break;

      case BROWSER_TYPE_WMLUP:
        if ($parm == "") return $this->wmlup();
        else return $this->wmlup($parm);
        break;

      case BROWSER_TYPE_XHTML:
      case BROWSER_TYPE_HTML:
        if ($parm == "") return $this->html();
        else return $this->html($parm);
        break;

      case BROWSER_TYPE_XML:
        if ($parm == "") return $this->xml();
        else return $this->xml($parm);
        break;

      default:
        if ($parm == "") return $this->html();
        else return $this->html($parm);
    } // switch
  } // render

} // RenderableObject

// ......................................................................
/**
* A renderable tag of some kind. Basically a tag is a language construct
* designed to render at least an identifying name and a value. More
* specific variants might add other properties, and control the way
* the tag is actually rendered.
* @package core
*/
class tag extends RenderableObject {
  var $tag_name = "";
  var $tag_value = "";
  var $attributes = array();
  /** Constructor
  * @param string $name The name of this tag
  * @param string $value The value of this tag
  */
  function tag($name, $value="") {
    $this->tag_name = $name;
    $this->tag_value = $value;
  }
  /** Adds an attribute to this tag.
  * @param string $attrname The name of the attribute
  * @param string $attrvalue The value of the attribute
  */
  function add_attribute($attrname, $attrvalue="") {
    $this->attributes[$attrname] = $attrvalue;
  }
} // tag class
// ----------------------------------------------------------------------
?>