//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
//

using System;
using System.Runtime.InteropServices;
using Gtk;
using Pango;

using GLib;

namespace Imendio.Blam {
    public delegate bool ButtonPressHandler (IntPtr evnt);
    public delegate bool KeyPressHandler    (IntPtr evnt);
    public delegate int  SortFunc           (IntPtr a, IntPtr b);
    public delegate void DragDataHandler    (IntPtr context,
					     IntPtr data,
					     string text,
					     uint   time);

    public class Utils {
	[DllImport("libblam.so")]
	    static extern void blam_tree_model_set_default_sort_func (IntPtr w,
								      SortFunc f);
	public static void TreeSetDefaultSortFunc(IntPtr w, SortFunc f)
	{
	    blam_tree_model_set_default_sort_func(w, f);
	}

	[DllImport("libblam.so")]
	    static extern void blam_tree_model_set_sort_func (IntPtr w,
							      int col,
							      SortFunc func);
	public static void TreeSetSortFunc (IntPtr w, int col, SortFunc f)
	{
	    blam_tree_model_set_sort_func (w, col, f);
	}

	[DllImport("libblam.so")]
	    static extern IntPtr blam_ellipsize_and_delimit_string(IntPtr w, string str, int width);
	public static string EllipsizeAndDelimitString(IntPtr w, string str, int width)
	{
	    return Marshaller.PtrToStringGFree(blam_ellipsize_and_delimit_string(w, str, width));
	}
        
        [DllImport("libblam.so")]
            static extern void blam_gecko_utils_init_services ();
        public static void GeckoInit ()
        {
            blam_gecko_utils_init_services ();
        }

        [DllImport("libblam.so")]
            static extern void blam_gecko_utils_set_font (int type, string font);
        public static void GeckoSetFont (int type, string font)
        {
            blam_gecko_utils_set_font (type, font);
        }

        [DllImport("libblam.so")]
            static extern void blam_gecko_utils_set_proxy (bool use_proxy, string host, int port);

        public static void GeckoSetProxy (bool useProxy, string host, int port)
        {
            blam_gecko_utils_set_proxy (useProxy, host, port);
        }
    }

    // Taken from F-Spot
    class GtkUtil {
	public static void AppendMenuItem (Gtk.Menu menu, string l,
					   EventHandler e)
	{
	    AppendMenuItem (menu, l, e, true);
	}

	public static void AppendMenuItem (Gtk.Menu menu, string l,
					   EventHandler e, bool enabled)
        {
                Gtk.MenuItem i;
                Gtk.StockItem item = Gtk.StockItem.Zero;

                if (Gtk.StockManager.Lookup (l, ref item)) {
                        i = new Gtk.ImageMenuItem (l, new Gtk.AccelGroup ());
                } else {
                        i = new Gtk.MenuItem (l);
                }
                i.Activated += e;
                i.Sensitive = enabled;

                menu.Append (i);
                i.Show ();
	}

        public static void AppendMenuItem (Gtk.Menu menu, string label,
					   string image_name, EventHandler e,
					   bool enabled)
        {
                Gtk.ImageMenuItem i = new Gtk.ImageMenuItem (label);
                i.Activated += e;
                i.Sensitive = enabled;
                i.Image = new Gtk.Image (image_name, Gtk.IconSize.Menu);

                menu.Append (i);
                i.Show ();
        }

        public static void AppendMenuSeparator (Gtk.Menu menu)
        {
                Gtk.SeparatorMenuItem i = new Gtk.SeparatorMenuItem ();
                menu.Append (i);
                i.Show ();
        }
    }
}

	
