/**
* This file is a part of the Cairo-Dock project
*
* Copyright : (C) see the 'copyright' file.
* E-mail    : see the 'copyright' file.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 3
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <string.h>
#include <cairo-dock.h>

#include "applet-struct.h"
#include "applet-notifications.h"
#include "applet-draw.h"
#include "applet-session.h"
#include "applet-appli-finder.h"
#include "applet-listing.h"
#include "applet-search.h"
#include "applet-config.h"


//\_________________ Here you have to get all your parameters from the conf file. Use the macros CD_CONFIG_GET_BOOLEAN, CD_CONFIG_GET_INTEGER, CD_CONFIG_GET_STRING, etc. myConfig has been reseted to 0 at this point. This function is called at the beginning of init and reload.
CD_APPLET_GET_CONFIG_BEGIN
	myConfig.cShortkeyNav = CD_CONFIG_GET_STRING ("Configuration", "shortkey");
	myConfig.cShortkeySearch = CD_CONFIG_GET_STRING ("Configuration", "shortkey search");
	myConfig.iAppearanceDuration = CD_CONFIG_GET_INTEGER ("Configuration", "appear duration");
	myConfig.iCloseDuration = CD_CONFIG_GET_INTEGER ("Configuration", "stop duration");
	myConfig.cIconAnimation = CD_CONFIG_GET_STRING ("Configuration", "animation");
	CD_CONFIG_GET_COLOR ("Configuration", "frame color", myConfig.pFrameColor);
	
	myConfig.fFontSizeRatio = CD_CONFIG_GET_DOUBLE ("Configuration", "font size");
	myConfig.bTextOnTop = CD_CONFIG_GET_BOOLEAN_WITH_DEFAULT ("Configuration", "text on top", TRUE);
	myConfig.labelDescription.cFont = CD_CONFIG_GET_STRING ("Configuration", "text font");
	int iWeight = CD_CONFIG_GET_INTEGER ("Configuration", "text weight");
	myConfig.labelDescription.iWeight = cairo_dock_get_pango_weight_from_1_9 (iWeight);
	myConfig.labelDescription.bOutlined = CD_CONFIG_GET_BOOLEAN ("Configuration", "text outlined");
	CD_CONFIG_GET_COLOR_RVB ("Configuration", "text color", myConfig.labelDescription.fColorStart);
	CD_CONFIG_GET_COLOR_RVB ("Configuration", "text color", myConfig.labelDescription.fColorStop);
	myConfig.labelDescription.iStyle = PANGO_STYLE_NORMAL;
	myConfig.labelDescription.iMargin = 2;
	CD_CONFIG_GET_COLOR ("Configuration", "bg color", myConfig.labelDescription.fBackgroundColor);
	if (myConfig.iAppearanceDuration == 0 || ! g_bUseOpenGL)  // si pas d'animation 3D, on ne met pas de fond aux lettres.
	{
		//myConfig.labelDescription.fBackgroundColor[3] = 0;
	}
	
	myConfig.iNbResultMax = CD_CONFIG_GET_INTEGER_WITH_DEFAULT ("Configuration", "nb results", 50);
	myConfig.iNbLinesInListing = CD_CONFIG_GET_INTEGER_WITH_DEFAULT ("Configuration", "nb lines", 10);
	
	myConfig.infoDescription.cFont = "Sans";
	myConfig.infoDescription.iSize = 14;
	myConfig.infoDescription.iWeight = cairo_dock_get_pango_weight_from_1_9 (5);
	myConfig.infoDescription.bOutlined = FALSE;
	myConfig.infoDescription.fColorStart[0] = 1;
	myConfig.infoDescription.fColorStart[1] = 0;
	myConfig.infoDescription.fColorStart[2] = 0;
	myConfig.infoDescription.fColorStop[0] = 1;
	myConfig.infoDescription.fColorStop[1] = 0;
	myConfig.infoDescription.fColorStop[2] = 0;
	myConfig.infoDescription.iStyle = PANGO_STYLE_NORMAL;
	myConfig.infoDescription.fBackgroundColor[3] = 1;
	myConfig.infoDescription.fBackgroundColor[3] = 0;
	myConfig.infoDescription.fBackgroundColor[3] = 0;
	myConfig.infoDescription.fBackgroundColor[3] = 0.33;
	myConfig.infoDescription.iMargin = 8;
CD_APPLET_GET_CONFIG_END


//\_________________ Here you have to free all ressources allocated for myConfig. This one will be reseted to 0 at the end of this function. This function is called right before you get the applet's config, and when your applet is stopped, in the end.
CD_APPLET_RESET_CONFIG_BEGIN
	//g_print ("%s / %s\n", myConfig.cShortkeyNav, myConfig.cShortkeySearch);
	if (myConfig.cShortkeyNav)
		cd_keybinder_unbind (myConfig.cShortkeyNav, (CDBindkeyHandler) cd_do_on_shortkey_nav);
	g_free (myConfig.cShortkeyNav);
	if (myConfig.cShortkeySearch)
		cd_keybinder_unbind (myConfig.cShortkeySearch, (CDBindkeyHandler) cd_do_on_shortkey_search);
	g_free (myConfig.cShortkeySearch);
	g_free (myConfig.cIconAnimation);
	g_free (myConfig.labelDescription.cFont);
CD_APPLET_RESET_CONFIG_END


//\_________________ Here you have to free all ressources allocated for myData. This one will be reseted to 0 at the end of this function. This function is called when your applet is stopped, in the very end.
CD_APPLET_RESET_DATA_BEGIN
	cd_do_close_session ();
	cd_do_exit_session ();
	
	cd_do_stop_all_backends ();
	
	cd_do_reset_applications_list ();
	
	cd_do_destroy_listing (myData.pListing);
	
	if (myData.pPromptSurface != NULL)
		cairo_surface_destroy (myData.pPromptSurface);
	if (myData.iPromptTexture != 0)
		_cairo_dock_delete_texture (myData.iPromptTexture);
	if (myData.pArrowSurface != NULL)
		cairo_surface_destroy (myData.pArrowSurface);
	if (myData.iArrowTexture != 0)
		_cairo_dock_delete_texture (myData.iArrowTexture);
	if (myData.pScoobySurface != NULL)
		cairo_surface_destroy (myData.pScoobySurface);
	if (myData.pActiveButtonSurface != NULL)
		cairo_surface_destroy (myData.pActiveButtonSurface);
	if (myData.pInactiveButtonSurface != NULL)
		cairo_surface_destroy (myData.pInactiveButtonSurface);
CD_APPLET_RESET_DATA_END
