from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestDockMonitor(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestDockMonitor, self).setUp()
        self.dbus_interface = "com.canonical.android.dockmonitor.DockMonitor"
        self.s_DockEvent = "DockEvent"
        self.m_isDocked = "isDocked"

    def tearDown(self):
        super(TestDockMonitor, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_dock.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_dock_s_DockEvent(self):
        item = self.s_DockEvent
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_dock_m_isDocked(self):
        item = self.m_isDocked
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
