// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "webkit/tools/test_shell/drop_delegate.h"

#include "third_party/WebKit/Source/WebKit/chromium/public/platform/WebDragData.h"
#include "third_party/WebKit/Source/WebKit/chromium/public/platform/WebPoint.h"
#include "third_party/WebKit/Source/WebKit/chromium/public/WebView.h"
#include "webkit/glue/webdropdata.h"

using WebKit::WebDragOperation;
using WebKit::WebDragOperationCopy;
using WebKit::WebPoint;
using WebKit::WebView;

TestDropDelegate::TestDropDelegate(HWND source_hwnd, WebKit::WebView* webview)
    : ui::DropTarget(source_hwnd),
      webview_(webview) {
}

DWORD TestDropDelegate::OnDragEnter(IDataObject* data_object,
                                    DWORD key_state,
                                    POINT cursor_position,
                                    DWORD effect) {
  WebDropData drop_data;
  WebDropData::PopulateWebDropData(data_object, &drop_data);

  POINT client_pt = cursor_position;
  ScreenToClient(GetHWND(), &client_pt);
  WebDragOperation op = webview_->dragTargetDragEnter(
      drop_data.ToDragData(),
      WebPoint(client_pt.x, client_pt.y),
      WebPoint(cursor_position.x, cursor_position.y),
      WebDragOperationCopy,
      0);
  // TODO(snej): Pass the real drag operation instead
  return op ? DROPEFFECT_COPY : DROPEFFECT_NONE;
  // TODO(snej): Return the real drop effect constant matching 'op'
}

DWORD TestDropDelegate::OnDragOver(IDataObject* data_object,
                                   DWORD key_state,
                                   POINT cursor_position,
                                   DWORD effect) {
  POINT client_pt = cursor_position;
  ScreenToClient(GetHWND(), &client_pt);
  WebDragOperation op = webview_->dragTargetDragOver(
      WebPoint(client_pt.x, client_pt.y),
      WebPoint(cursor_position.x, cursor_position.y),
      WebDragOperationCopy,
      0);
  // TODO(snej): Pass the real drag operation instead
  return op ? DROPEFFECT_COPY : DROPEFFECT_NONE;
  // TODO(snej): Return the real drop effect constant matching 'op'
}

void TestDropDelegate::OnDragLeave(IDataObject* data_object) {
  webview_->dragTargetDragLeave();
}

DWORD TestDropDelegate::OnDrop(IDataObject* data_object,
                               DWORD key_state,
                               POINT cursor_position,
                               DWORD effect) {
  POINT client_pt = cursor_position;
  ScreenToClient(GetHWND(), &client_pt);
  webview_->dragTargetDrop(
      WebPoint(client_pt.x, client_pt.y),
      WebPoint(cursor_position.x, cursor_position.y),
      0);

  // webkit win port always returns DROPEFFECT_NONE
  return DROPEFFECT_NONE;
}
