/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Mirco Müller <mirco.mueller@canonical.com>
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <clutk/clutk.h>

static void test_menu_expandable (void);

void
test_menu_expandable_create_suite (void)
{
#define DOMAIN "/Menu"

  g_test_add_func (DOMAIN"/MenuExpandable", test_menu_expandable);
}

static void
test_menu_expandable (void)
{
  ClutterActor*      stage;
  CtkMenuExpandable* menu;

  stage = clutter_stage_get_default ();

  menu = ctk_menu_expandable_new ();

  clutter_container_add (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR (menu), NULL);
  clutter_actor_show_all (stage);

  clutter_actor_hide (stage);

  g_assert (CTK_IS_MENU_EXPANDABLE (menu));

  clutter_container_remove_actor (CLUTTER_CONTAINER (stage),
                                  CLUTTER_ACTOR (menu));
}

