/* dconf-update.c generated by valac 0.15.2, the Vala compiler
 * generated from dconf-update.vala, do not modify */

/*
 * Copyright © 2010 Codethink Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include "gvdb-builder.h"
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



GvdbItem* get_parent (GHashTable* table, const gchar* name);
GSList* list_directory (const gchar* dirname, mode_t mode);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
GHashTable* read_locks_directory (const gchar* dirname);
GHashTable* read_directory (const gchar* dirname);
void maybe_update_from_directory (const gchar* dirname);
void update_all (const gchar* dirname);
void dconf_update (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


GvdbItem* get_parent (GHashTable* table, const gchar* name) {
	GvdbItem* result = NULL;
	GvdbItem* parent = NULL;
	gint end;
	gint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* parent_name;
	GHashTable* _tmp14_;
	const gchar* _tmp15_;
	gconstpointer _tmp16_ = NULL;
	GvdbItem* _tmp17_;
	GvdbItem* _tmp25_;
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	end = 0;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				const gchar* _tmp3_;
				gint _tmp4_;
				gchar _tmp5_ = '\0';
				const gchar* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_ = '\0';
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = name;
				_tmp4_ = i;
				_tmp5_ = string_get (_tmp3_, (glong) _tmp4_);
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = name;
				_tmp7_ = i;
				_tmp8_ = string_get (_tmp6_, (glong) (_tmp7_ - 1));
				if (_tmp8_ == '/') {
					gint _tmp9_;
					_tmp9_ = i;
					end = _tmp9_;
				}
			}
		}
	}
	_tmp10_ = end;
	g_assert (_tmp10_ != 0);
	_tmp11_ = name;
	_tmp12_ = end;
	_tmp13_ = string_substring (_tmp11_, (glong) 0, (glong) _tmp12_);
	parent_name = _tmp13_;
	_tmp14_ = table;
	_tmp15_ = parent_name;
	_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
	parent = (GvdbItem*) _tmp16_;
	_tmp17_ = parent;
	if (_tmp17_ == NULL) {
		GHashTable* _tmp18_;
		const gchar* _tmp19_;
		GvdbItem* _tmp20_ = NULL;
		GvdbItem* _tmp21_;
		GHashTable* _tmp22_;
		const gchar* _tmp23_;
		GvdbItem* _tmp24_ = NULL;
		_tmp18_ = table;
		_tmp19_ = parent_name;
		_tmp20_ = gvdb_hash_table_insert (_tmp18_, _tmp19_);
		parent = _tmp20_;
		_tmp21_ = parent;
		_tmp22_ = table;
		_tmp23_ = parent_name;
		_tmp24_ = get_parent (_tmp22_, _tmp23_);
		gvdb_item_set_parent (_tmp21_, _tmp24_);
	}
	_tmp25_ = parent;
	result = _tmp25_;
	_g_free0 (parent_name);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


GSList* list_directory (const gchar* dirname, mode_t mode) {
	GSList* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	{
		GSList* list;
		const gchar* _tmp0_;
		GDir* _tmp1_ = NULL;
		GDir* dir;
		const gchar* name = NULL;
		list = NULL;
		_tmp0_ = dirname;
		_tmp1_ = g_dir_open (_tmp0_, (guint) 0, &_inner_error_);
		dir = _tmp1_;
		if (_inner_error_ != NULL) {
			__g_slist_free__g_free0_0 (list);
			if (g_error_matches (_inner_error_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
				goto __catch1_g_file_error_noent;
			}
			goto __catch1_g_error;
		}
		while (TRUE) {
			GDir* _tmp2_;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_ = NULL;
			gchar* filename;
			struct stat buf = {0};
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp11_;
			struct stat _tmp12_ = {0};
			gint _tmp13_ = 0;
			gboolean _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp2_ = dir;
			_tmp3_ = g_dir_read_name (_tmp2_);
			name = _tmp3_;
			_tmp4_ = name;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = name;
			_tmp6_ = g_str_has_prefix (_tmp5_, ".");
			if (_tmp6_) {
				continue;
			}
			_tmp7_ = dirname;
			_tmp8_ = name;
			_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
			filename = _tmp9_;
			_tmp11_ = filename;
			_tmp13_ = stat (_tmp11_, &_tmp12_);
			buf = _tmp12_;
			if (_tmp13_ < 0) {
				_tmp10_ = TRUE;
			} else {
				struct stat _tmp14_;
				mode_t _tmp15_;
				mode_t _tmp16_;
				_tmp14_ = buf;
				_tmp15_ = _tmp14_.st_mode;
				_tmp16_ = mode;
				_tmp10_ = (_tmp15_ & S_IFMT) != _tmp16_;
			}
			_tmp17_ = _tmp10_;
			if (_tmp17_) {
				_g_free0 (filename);
				continue;
			}
			_tmp18_ = filename;
			_tmp19_ = g_strdup (_tmp18_);
			list = g_slist_prepend (list, _tmp19_);
			_g_free0 (filename);
		}
		result = list;
		_g_dir_close0 (dir);
		return result;
	}
	goto __finally1;
	__catch1_g_file_error_noent:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_printerr ("warning: %s\n", _tmp21_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


GHashTable* read_locks_directory (const gchar* dirname) {
	GHashTable* result = NULL;
	const gchar* _tmp0_;
	GSList* _tmp1_ = NULL;
	GSList* files;
	GSList* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* table;
	GSList* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = dirname;
	_tmp1_ = list_directory (_tmp0_, S_IFREG);
	files = _tmp1_;
	_tmp2_ = files;
	if (_tmp2_ == NULL) {
		result = NULL;
		__g_slist_free__g_free0_0 (files);
		return result;
	}
	_tmp3_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp3_;
	_tmp4_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp4_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp5_;
			gchar* filename = NULL;
			_tmp5_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp5_;
			{
				{
					gchar* contents = NULL;
					const gchar* _tmp6_;
					gchar* _tmp7_ = NULL;
					const gchar* _tmp8_;
					gchar** _tmp9_;
					gchar** _tmp10_ = NULL;
					_tmp6_ = filename;
					g_file_get_contents (_tmp6_, &_tmp7_, NULL, &_inner_error_);
					_g_free0 (contents);
					contents = _tmp7_;
					if (_inner_error_ != NULL) {
						_g_free0 (contents);
						goto __catch2_g_error;
					}
					_tmp8_ = contents;
					_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
					{
						gchar** line_collection = NULL;
						gint line_collection_length1 = 0;
						gint _line_collection_size_ = 0;
						gint line_it = 0;
						line_collection = _tmp10_;
						line_collection_length1 = _vala_array_length (_tmp9_);
						for (line_it = 0; line_it < _vala_array_length (_tmp9_); line_it = line_it + 1) {
							gchar* _tmp11_;
							gchar* line = NULL;
							_tmp11_ = g_strdup (line_collection[line_it]);
							line = _tmp11_;
							{
								const gchar* _tmp12_;
								gboolean _tmp13_ = FALSE;
								_tmp12_ = line;
								_tmp13_ = g_str_has_prefix (_tmp12_, "/");
								if (_tmp13_) {
									GHashTable* _tmp14_;
									const gchar* _tmp15_;
									_tmp14_ = table;
									_tmp15_ = line;
									gvdb_hash_table_insert_string (_tmp14_, _tmp15_, "");
								}
								_g_free0 (line);
							}
						}
						line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
					}
					_g_free0 (contents);
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* e = NULL;
					GError* _tmp16_;
					const gchar* _tmp17_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp16_ = e;
					_tmp17_ = _tmp16_->message;
					g_printerr ("warning: %s\n", _tmp17_);
					_g_error_free0 (e);
				}
				__finally2:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_hash_table_unref0 (table);
					__g_slist_free__g_free0_0 (files);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (filename);
			}
		}
	}
	result = table;
	__g_slist_free__g_free0_0 (files);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GHashTable* read_directory (const gchar* dirname) {
	GHashTable* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* table;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	GSList* _tmp3_ = NULL;
	GSList* files;
	GCompareFunc _tmp4_;
	GSList* _tmp5_;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	GHashTable* _tmp81_ = NULL;
	GHashTable* _tmp82_;
	GHashTable* locks;
	GHashTable* _tmp83_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dirname != NULL, NULL);
	_tmp0_ = gvdb_hash_table_new (NULL, NULL);
	table = _tmp0_;
	_tmp1_ = table;
	gvdb_hash_table_insert (_tmp1_, "/");
	_tmp2_ = dirname;
	_tmp3_ = list_directory (_tmp2_, S_IFREG);
	files = _tmp3_;
	_tmp4_ = g_strcmp0;
	files = g_slist_sort (files, _tmp4_);
	files = g_slist_reverse (files);
	_tmp5_ = files;
	{
		GSList* filename_collection = NULL;
		GSList* filename_it = NULL;
		filename_collection = _tmp5_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp6_;
			gchar* filename = NULL;
			_tmp6_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp6_;
			{
				GKeyFile* _tmp7_;
				GKeyFile* kf;
				_tmp7_ = g_key_file_new ();
				kf = _tmp7_;
				{
					GKeyFile* _tmp8_;
					const gchar* _tmp9_;
					_tmp8_ = kf;
					_tmp9_ = filename;
					g_key_file_load_from_file (_tmp8_, _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch3_g_error;
					}
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* e = NULL;
					FILE* _tmp10_;
					const gchar* _tmp11_;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp10_ = stderr;
					_tmp11_ = filename;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					fprintf (_tmp10_, "warning: Failed to read keyfile '%s': %s\n", _tmp11_, _tmp13_);
					_g_error_free0 (e);
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					continue;
				}
				__finally3:
				if (_inner_error_ != NULL) {
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				{
					GKeyFile* _tmp14_;
					gsize _tmp15_;
					gchar** _tmp16_ = NULL;
					_tmp14_ = kf;
					_tmp16_ = g_key_file_get_groups (_tmp14_, &_tmp15_);
					{
						gchar** group_collection = NULL;
						gint group_collection_length1 = 0;
						gint _group_collection_size_ = 0;
						gint group_it = 0;
						group_collection = _tmp16_;
						group_collection_length1 = _tmp15_;
						for (group_it = 0; group_it < _tmp15_; group_it = group_it + 1) {
							gchar* _tmp17_;
							gchar* group = NULL;
							_tmp17_ = g_strdup (group_collection[group_it]);
							group = _tmp17_;
							{
								gboolean _tmp18_ = FALSE;
								gboolean _tmp19_ = FALSE;
								const gchar* _tmp20_;
								gboolean _tmp21_ = FALSE;
								gboolean _tmp24_;
								gboolean _tmp27_;
								GKeyFile* _tmp31_;
								const gchar* _tmp32_;
								gsize _tmp33_;
								gchar** _tmp34_ = NULL;
								gchar** _tmp35_;
								gint _tmp35__length1;
								gint __tmp35__size_;
								_tmp20_ = group;
								_tmp21_ = g_str_has_prefix (_tmp20_, "/");
								if (_tmp21_) {
									_tmp19_ = TRUE;
								} else {
									const gchar* _tmp22_;
									gboolean _tmp23_ = FALSE;
									_tmp22_ = group;
									_tmp23_ = g_str_has_suffix (_tmp22_, "/");
									_tmp19_ = _tmp23_;
								}
								_tmp24_ = _tmp19_;
								if (_tmp24_) {
									_tmp18_ = TRUE;
								} else {
									const gchar* _tmp25_;
									gboolean _tmp26_ = FALSE;
									_tmp25_ = group;
									_tmp26_ = string_contains (_tmp25_, "//");
									_tmp18_ = _tmp26_;
								}
								_tmp27_ = _tmp18_;
								if (_tmp27_) {
									FILE* _tmp28_;
									const gchar* _tmp29_;
									const gchar* _tmp30_;
									_tmp28_ = stderr;
									_tmp29_ = filename;
									_tmp30_ = group;
									fprintf (_tmp28_, "%s: ignoring invalid group name: %s\n", _tmp29_, _tmp30_);
									_g_free0 (group);
									continue;
								}
								_tmp31_ = kf;
								_tmp32_ = group;
								_tmp34_ = g_key_file_get_keys (_tmp31_, _tmp32_, &_tmp33_, &_inner_error_);
								_tmp35_ = _tmp34_;
								_tmp35__length1 = _tmp33_;
								__tmp35__size_ = _tmp35__length1;
								if (_inner_error_ != NULL) {
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									if (_inner_error_->domain == G_KEY_FILE_ERROR) {
										goto __catch4_g_key_file_error;
									}
									_g_free0 (group);
									group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
									_g_key_file_free0 (kf);
									_g_free0 (filename);
									__g_slist_free__g_free0_0 (files);
									_g_hash_table_unref0 (table);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return NULL;
								}
								{
									gchar** key_collection = NULL;
									gint key_collection_length1 = 0;
									gint _key_collection_size_ = 0;
									gint key_it = 0;
									key_collection = _tmp35_;
									key_collection_length1 = _tmp35__length1;
									for (key_it = 0; key_it < _tmp35__length1; key_it = key_it + 1) {
										gchar* _tmp36_;
										gchar* key = NULL;
										_tmp36_ = g_strdup (key_collection[key_it]);
										key = _tmp36_;
										{
											const gchar* _tmp37_;
											gboolean _tmp38_ = FALSE;
											const gchar* _tmp43_;
											gchar* _tmp44_;
											gchar* _tmp45_;
											gchar* _tmp46_;
											gchar* _tmp47_;
											const gchar* _tmp48_;
											gchar* _tmp49_;
											gchar* _tmp50_;
											gchar* path;
											GHashTable* _tmp51_;
											const gchar* _tmp52_;
											gconstpointer _tmp53_ = NULL;
											GKeyFile* _tmp54_;
											const gchar* _tmp55_;
											const gchar* _tmp56_;
											gchar* _tmp57_ = NULL;
											gchar* text;
											_tmp37_ = key;
											_tmp38_ = string_contains (_tmp37_, "/");
											if (_tmp38_) {
												FILE* _tmp39_;
												const gchar* _tmp40_;
												const gchar* _tmp41_;
												const gchar* _tmp42_;
												_tmp39_ = stderr;
												_tmp40_ = filename;
												_tmp41_ = group;
												_tmp42_ = key;
												fprintf (_tmp39_, "%s: [%s]: ignoring invalid key name: %s\n", _tmp40_, _tmp41_, _tmp42_);
												_g_free0 (key);
												continue;
											}
											_tmp43_ = group;
											_tmp44_ = g_strconcat ("/", _tmp43_, NULL);
											_tmp45_ = _tmp44_;
											_tmp46_ = g_strconcat (_tmp45_, "/", NULL);
											_tmp47_ = _tmp46_;
											_tmp48_ = key;
											_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
											_tmp50_ = _tmp49_;
											_g_free0 (_tmp47_);
											_g_free0 (_tmp45_);
											path = _tmp50_;
											_tmp51_ = table;
											_tmp52_ = path;
											_tmp53_ = g_hash_table_lookup (_tmp51_, _tmp52_);
											if (((GvdbItem*) _tmp53_) != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												continue;
											}
											_tmp54_ = kf;
											_tmp55_ = group;
											_tmp56_ = key;
											_tmp57_ = g_key_file_get_value (_tmp54_, _tmp55_, _tmp56_, &_inner_error_);
											text = _tmp57_;
											if (_inner_error_ != NULL) {
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch4_g_key_file_error;
												}
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											{
												const gchar* _tmp58_;
												GVariant* _tmp59_ = NULL;
												GVariant* value;
												GHashTable* _tmp60_;
												const gchar* _tmp61_;
												GvdbItem* _tmp62_ = NULL;
												GvdbItem* item;
												GvdbItem* _tmp63_;
												GHashTable* _tmp64_;
												const gchar* _tmp65_;
												GvdbItem* _tmp66_ = NULL;
												GvdbItem* _tmp67_;
												GVariant* _tmp68_;
												_tmp58_ = text;
												_tmp59_ = g_variant_parse (NULL, _tmp58_, NULL, NULL, &_inner_error_);
												value = _tmp59_;
												if (_inner_error_ != NULL) {
													if (_inner_error_->domain == G_VARIANT_PARSE_ERROR) {
														goto __catch5_g_variant_parse_error;
													}
													_g_free0 (text);
													_g_free0 (path);
													_g_free0 (key);
													key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (group);
													group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
													_g_key_file_free0 (kf);
													_g_free0 (filename);
													__g_slist_free__g_free0_0 (files);
													_g_hash_table_unref0 (table);
													g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
													g_clear_error (&_inner_error_);
													return NULL;
												}
												_tmp60_ = table;
												_tmp61_ = path;
												_tmp62_ = gvdb_hash_table_insert (_tmp60_, _tmp61_);
												item = _tmp62_;
												_tmp63_ = item;
												_tmp64_ = table;
												_tmp65_ = path;
												_tmp66_ = get_parent (_tmp64_, _tmp65_);
												gvdb_item_set_parent (_tmp63_, _tmp66_);
												_tmp67_ = item;
												_tmp68_ = value;
												gvdb_item_set_value (_tmp67_, _tmp68_);
												_g_variant_unref0 (value);
											}
											goto __finally5;
											__catch5_g_variant_parse_error:
											{
												GError* e = NULL;
												FILE* _tmp69_;
												const gchar* _tmp70_;
												const gchar* _tmp71_;
												const gchar* _tmp72_;
												const gchar* _tmp73_;
												GError* _tmp74_;
												const gchar* _tmp75_;
												e = _inner_error_;
												_inner_error_ = NULL;
												_tmp69_ = stderr;
												_tmp70_ = filename;
												_tmp71_ = group;
												_tmp72_ = key;
												_tmp73_ = text;
												_tmp74_ = e;
												_tmp75_ = _tmp74_->message;
												fprintf (_tmp69_, "%s: [%s]: %s: skipping invalid value: %s (%s)\n", _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp75_);
												_g_error_free0 (e);
											}
											__finally5:
											if (_inner_error_ != NULL) {
												_g_free0 (text);
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												if (_inner_error_->domain == G_KEY_FILE_ERROR) {
													goto __catch4_g_key_file_error;
												}
												_g_free0 (text);
												_g_free0 (path);
												_g_free0 (key);
												key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_free0 (group);
												group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
												_g_key_file_free0 (kf);
												_g_free0 (filename);
												__g_slist_free__g_free0_0 (files);
												_g_hash_table_unref0 (table);
												g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
												g_clear_error (&_inner_error_);
												return NULL;
											}
											_g_free0 (text);
											_g_free0 (path);
											_g_free0 (key);
										}
									}
									key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
								}
								_g_free0 (group);
							}
						}
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				goto __finally4;
				__catch4_g_key_file_error:
				{
					GError* e = NULL;
					GError* _tmp76_;
					const gchar* _tmp77_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp76_ = e;
					_tmp77_ = _tmp76_->message;
					g_warning ("dconf-update.vala:165: unexpected keyfile error: %s.  Please file a bu" \
"g.", _tmp77_);
					_g_error_free0 (e);
				}
				__finally4:
				if (_inner_error_ != NULL) {
					_g_key_file_free0 (kf);
					_g_free0 (filename);
					__g_slist_free__g_free0_0 (files);
					_g_hash_table_unref0 (table);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_key_file_free0 (kf);
				_g_free0 (filename);
			}
		}
	}
	_tmp78_ = dirname;
	_tmp79_ = g_strconcat (_tmp78_, "/locks", NULL);
	_tmp80_ = _tmp79_;
	_tmp81_ = read_locks_directory (_tmp80_);
	_tmp82_ = _tmp81_;
	_g_free0 (_tmp80_);
	locks = _tmp82_;
	_tmp83_ = locks;
	if (_tmp83_ != NULL) {
		GHashTable* _tmp84_;
		GvdbItem* _tmp85_ = NULL;
		GvdbItem* item;
		GvdbItem* _tmp86_;
		GHashTable* _tmp87_;
		_tmp84_ = table;
		_tmp85_ = gvdb_hash_table_insert (_tmp84_, ".locks");
		item = _tmp85_;
		_tmp86_ = item;
		_tmp87_ = locks;
		gvdb_item_set_hash_table (_tmp86_, _tmp87_);
	}
	result = table;
	_g_hash_table_unref0 (locks);
	__g_slist_free__g_free0_0 (files);
	return result;
}


void maybe_update_from_directory (const gchar* dirname) {
	struct stat dir_buf = {0};
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	struct stat _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp1_ = dirname;
	_tmp3_ = stat (_tmp1_, &_tmp2_);
	dir_buf = _tmp2_;
	if (_tmp3_ == 0) {
		struct stat _tmp4_;
		mode_t _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = dir_buf;
		_tmp5_ = _tmp4_.st_mode;
		_tmp6_ = S_ISDIR (_tmp5_);
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		struct stat lockdir_buf = {0};
		struct stat file_buf = {0};
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* filename;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		struct stat _tmp17_ = {0};
		gint _tmp18_ = 0;
		gboolean _tmp19_;
		gboolean _tmp24_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		struct stat _tmp29_ = {0};
		gint _tmp30_ = 0;
		gboolean _tmp35_;
		const gchar* _tmp36_;
		GHashTable* _tmp37_ = NULL;
		GHashTable* table;
		const gchar* _tmp38_;
		gint _tmp39_ = 0;
		gint fd;
		gboolean _tmp40_ = FALSE;
		gint _tmp41_;
		gboolean _tmp43_;
		_tmp8_ = dirname;
		_tmp9_ = dirname;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) 0, (glong) (_tmp11_ - 2));
		filename = _tmp12_;
		_tmp14_ = dirname;
		_tmp15_ = g_strconcat (_tmp14_, "/locks", NULL);
		_tmp16_ = _tmp15_;
		_tmp18_ = stat (_tmp16_, &_tmp17_);
		lockdir_buf = _tmp17_;
		_tmp19_ = _tmp18_ == 0;
		_g_free0 (_tmp16_);
		if (_tmp19_) {
			struct stat _tmp20_;
			time_t _tmp21_;
			struct stat _tmp22_;
			time_t _tmp23_;
			_tmp20_ = lockdir_buf;
			_tmp21_ = _tmp20_.st_mtime;
			_tmp22_ = dir_buf;
			_tmp23_ = _tmp22_.st_mtime;
			_tmp13_ = _tmp21_ > _tmp23_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp24_ = _tmp13_;
		if (_tmp24_) {
			struct stat _tmp25_;
			time_t _tmp26_;
			_tmp25_ = lockdir_buf;
			_tmp26_ = _tmp25_.st_mtime;
			dir_buf.st_mtime = _tmp26_;
		}
		_tmp28_ = filename;
		_tmp30_ = stat (_tmp28_, &_tmp29_);
		file_buf = _tmp29_;
		if (_tmp30_ == 0) {
			struct stat _tmp31_;
			time_t _tmp32_;
			struct stat _tmp33_;
			time_t _tmp34_;
			_tmp31_ = file_buf;
			_tmp32_ = _tmp31_.st_mtime;
			_tmp33_ = dir_buf;
			_tmp34_ = _tmp33_.st_mtime;
			_tmp27_ = _tmp32_ > _tmp34_;
		} else {
			_tmp27_ = FALSE;
		}
		_tmp35_ = _tmp27_;
		if (_tmp35_) {
			_g_free0 (filename);
			return;
		}
		_tmp36_ = dirname;
		_tmp37_ = read_directory (_tmp36_);
		table = _tmp37_;
		_tmp38_ = filename;
		_tmp39_ = open (_tmp38_, O_WRONLY, (mode_t) 0);
		fd = _tmp39_;
		_tmp41_ = fd;
		if (_tmp41_ < 0) {
			gint _tmp42_;
			_tmp42_ = errno;
			_tmp40_ = _tmp42_ != ENOENT;
		} else {
			_tmp40_ = FALSE;
		}
		_tmp43_ = _tmp40_;
		if (_tmp43_) {
			gint _tmp44_;
			gint saved_error;
			const gchar* _tmp45_;
			gint _tmp46_;
			const gchar* _tmp47_ = NULL;
			_tmp44_ = errno;
			saved_error = _tmp44_;
			_tmp45_ = filename;
			_tmp46_ = saved_error;
			_tmp47_ = g_strerror (_tmp46_);
			g_printerr ("warning: Failed to open '%s' for replacement: %s\n", _tmp45_, _tmp47_);
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		{
			GHashTable* _tmp48_;
			const gchar* _tmp49_;
			gint _tmp50_;
			_tmp48_ = table;
			_tmp49_ = filename;
			gvdb_table_write_contents (_tmp48_, _tmp49_, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
			_tmp50_ = fd;
			if (_tmp50_ >= 0) {
				gint _tmp51_;
				_tmp51_ = fd;
				write (_tmp51_, "\0\0\0\0\0\0\0\0", (gsize) 8);
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			GError* _tmp52_;
			const gchar* _tmp53_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp52_ = e;
			_tmp53_ = _tmp52_->message;
			g_printerr ("warning: %s\n", _tmp53_);
			_g_error_free0 (e);
			{
				gint _tmp54_;
				_tmp54_ = fd;
				if (_tmp54_ >= 0) {
					gint _tmp55_;
					_tmp55_ = fd;
					close (_tmp55_);
				}
			}
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			return;
		}
		__finally6:
		{
			gint _tmp56_;
			_tmp56_ = fd;
			if (_tmp56_ >= 0) {
				gint _tmp57_;
				_tmp57_ = fd;
				close (_tmp57_);
			}
		}
		if (_inner_error_ != NULL) {
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		{
			GDBusConnection* _tmp58_ = NULL;
			GDBusConnection* system_bus;
			GDBusConnection* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			GVariant* _tmp65_;
			GVariant* _tmp66_;
			GDBusConnection* _tmp67_;
			_tmp58_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error_);
			system_bus = _tmp58_;
			if (_inner_error_ != NULL) {
				goto __catch7_g_error;
			}
			_tmp59_ = system_bus;
			_tmp60_ = filename;
			_tmp61_ = g_path_get_basename (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strconcat ("/ca/desrt/dconf/Writer/", _tmp62_, NULL);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_variant_new ("(s)", "/", NULL);
			_tmp66_ = g_variant_ref_sink (_tmp65_);
			g_dbus_connection_emit_signal (_tmp59_, NULL, _tmp64_, "ca.desrt.dconf.Writer", "WritabilityNotify", _tmp66_, &_inner_error_);
			_g_variant_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch7_g_error;
			}
			_tmp67_ = system_bus;
			g_dbus_connection_flush_sync (_tmp67_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (system_bus);
				goto __catch7_g_error;
			}
			_g_object_unref0 (system_bus);
		}
		goto __finally7;
		__catch7_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally7:
		if (_inner_error_ != NULL) {
			_g_hash_table_unref0 (table);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_hash_table_unref0 (table);
		_g_free0 (filename);
	}
}


void update_all (const gchar* dirname) {
	const gchar* _tmp0_;
	GSList* _tmp1_ = NULL;
	g_return_if_fail (dirname != NULL);
	_tmp0_ = dirname;
	_tmp1_ = list_directory (_tmp0_, S_IFDIR);
	{
		GSList* name_collection = NULL;
		GSList* name_it = NULL;
		name_collection = _tmp1_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp2_;
			gchar* name = NULL;
			_tmp2_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp2_;
			{
				const gchar* _tmp3_;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = name;
				_tmp4_ = g_str_has_suffix (_tmp3_, ".d");
				if (_tmp4_) {
					const gchar* _tmp5_;
					_tmp5_ = name;
					maybe_update_from_directory (_tmp5_);
				}
				_g_free0 (name);
			}
		}
		__g_slist_free__g_free0_0 (name_collection);
	}
}


void dconf_update (gchar** args, int args_length1) {
	update_all ("/etc/dconf/db");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



