/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCSAPI_H
#define DCSAPI_H

#include "../DCSCommon.h"

#ifdef __cplusplus
extern "C" {
#endif

/** 
 * Initializes the DCS API library. 
 */
DCSAPI DCS_Return_Code DCS_Initialize();

/**
 * Uninitialize the DCS API library. 
 */
DCSAPI DCS_Return_Code DCS_Uninitialize();

/** 
 * Typedef of the callback function to be notified when the classmate 
 * PC changes the clamshell/tablet modes. 
 */
typedef void (CALLBACK *DCS_Abort_Callback) ();

/** 
 * Set the callback handler to be notified when dcs aborts. 
 *
 * @param DCS_Abort_Callback	the pointer to the callback function	 
 */
DCSAPI DCS_Return_Code DCS_SetAbortHandler(DCS_Abort_Callback);

/** 
 * Gets the DCS version. 
 *
 * @param version	the pointer to the version value got
 */
DCSAPI DCS_Return_Code DCS_GetVersion(UINT *version);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DCSAPI_H */
