/*
 * Enhanced Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <wx/string.h>
#include <wx/utils.h>
#include "MeshUtility.h"
#include "ENMUtil.h"
#include <string>

using namespace std;

extern FILE* enm_log;

wxString ENABLE_GATEWAY_SCRIPT = wxT("sh /usr/share/enhanced-easy-network/mesh-tools/enablegateway.sh");
wxString ENABLE_CLIENT_SCRIPT  = wxT("sh /usr/share/enhanced-easy-network/mesh-tools/enableclient.sh");
wxString MESH_ONLY_SCRIPT = wxT("sh /usr/share/enhanced-easy-network/mesh-tools/meshonly.sh");
wxString MESH_ONLY_WIRLESS_SCRIPT = wxT("sh /usr/share/enhanced-easy-network/mesh-tools/meshonly_w.sh");

static const char * RESOLV_PREFIX = "#Modified_by:  mesh-portal\n";
static const char * RESOLV_HEADER = "#Backup: /etc/resolv.conf.saved.by.meshportal\n#Process:  mesh-portal\n";
static const char * RESOLVCONF_PATH = "/etc/resolv.conf";


int MeshUtility::GetMeshNeighbor(char * ifname, PMESH_NEIGHBOR_INFO* nb)
{
    fprintf(enm_log, "get list interface %s \n", ifname);
    fflush(enm_log);

    int     socket_id;
    struct  iwreq wrq;
    int     ret = 0;
    char* data1;

    data1 = (char *)malloc(8192);
    if (data1 == NULL)
    {
        printf("unable to alloc data buffer, size (%d)\n", 8192);
        return -1;
    }

    // open socket based on address family: AF_NET ----------------------------
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        printf("error::Open socket error!\n\n");
        return -1;
    }

    memset(data1, 0, 8192);
    // Get Mesh Neighbor Info
    memset(data1, 0, sizeof(MESH_NEIGHBOR_INFO));

    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = sizeof(MESH_NEIGHBOR_INFO);
    wrq.u.data.pointer = data1;
    wrq.u.data.flags = OID_802_11_MESH_LIST;
    ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);

    if(ret != 0)
    {
        close(socket_id);
        return ret;
    }

    memcpy((char*)*nb, (char*)wrq.u.data.pointer, sizeof(MESH_NEIGHBOR_INFO));

    free(data1);
    close(socket_id);
    return ret;
}

int MeshUtility::GetMeshChannel(const char * ifname, int * channel)
{
    int socket_id;
    struct iwreq wrq;
    unsigned char data[1] = {0xFF};
    int ret = 0;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        return SOCK_FAIL;
    }
    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = sizeof(unsigned char);
    wrq.u.data.pointer = data;
    wrq.u.data.flags = OID_802_11_MESH_CHANNEL;
    if((ret=ioctl(socket_id, RT_PRIV_IOCTL, &wrq)) < 0){
        close(socket_id);
        return ret;
    }else{
        *channel = data[0];
    }
    close(socket_id);
    return ret;
}

int MeshUtility::SetMeshChannel(char * ifname, int channel)
{
    int socket_id, ret=0;
    struct iwreq wrq;

    if (channel > 14)
        return -2;
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        return -1;
    }

    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = sizeof(unsigned char);
    wrq.u.data.pointer = &channel;
    wrq.u.data.flags = RT_OID_802_11_MESH_CHANNEL;
    ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
    close(socket_id);

    SetMeshID("mesh0");
    return ret;
}

int MeshUtility::GetMeshHostname(const char * ifname, char * hostname)
{
    int socket_id, ret = 0;
    struct iwreq wrq;
    if(!hostname){
        return BAD_PARAM;
    }
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        return SOCK_FAIL;
    }
    memset(hostname, 0, 64);
    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = 64;
    wrq.u.data.pointer = hostname;
    wrq.u.data.flags = OID_802_11_MESH_HOSTNAME;
    ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
    close(socket_id);
    return ret;
}

int MeshUtility::SetMeshHostname(char * ifname, char * hn)
{
    char hostname[64];
    int socket_id, ret=0;
    struct iwreq wrq;
    if(!hn){
        return -1;
    }
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        return -1;
    }
    memset(hostname, 0, 64);
    memcpy(hostname, hn, strlen(hn) + 1);
    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = strlen(hn) + 1;
    wrq.u.data.pointer = hostname;
    wrq.u.data.flags = RT_OID_802_11_MESH_HOSTNAME;
    ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
    close(socket_id);
    return ret;
}

int MeshUtility::SwitchMesh(char * ifname, bool flag)
{
    if (flag)
    {
        fprintf(enm_log, "turn on mesh=%s \n", ifname);
        fflush(enm_log);
//        SetNetworkIfAll("eth", 0);
//        SetNetworkIfAll("ra", 0);
        SetNetworkIfAll("mesh", 1);
        wxExecute(MESH_ONLY_SCRIPT);
    }
    else
    {
        fprintf(enm_log, "turn off mesh=%s \n", ifname);
        fflush(enm_log);
//        SetNetworkIfAll("eth", 0);
//        SetNetworkIfAll("ra", 0);
        SetNetworkIfAll("mesh", 0);
    }

    return 1;
}

int MeshUtility::ExecCommand(char *cmd)
{
    if (!cmd)
    {
        return 0;
    }

    system(cmd);
    return 1;
}

int MeshUtility::EnableClient(PMESH_GATEWAY_INFO meshGatewayInfo)
{
    string ip = (char *)meshGatewayInfo->IPAddr;
    string dns1 = (char *)meshGatewayInfo->DNS1;
    string dns2 = (char *)meshGatewayInfo->DNS2;

    UpdateResolvconf((char *)(dns1.c_str()), (char *)(dns2.c_str()));
    SetNetworkIfAll("eth", 0);
    SetNetworkIfAll("ra", 0);
    //SetMeshOnlyMode("mesh0", 1);

    wxString clienCmd = ENABLE_CLIENT_SCRIPT + wxT(" ") + ENMUtil::StringToWxString(ip);

    wxExecute(clienCmd);
    return 1;
}

int MeshUtility::EnableGateway(char * exif)
{
    //SetMeshOnlyMode("mesh0", 0);
//    if (strstr(exif, "ra"))
//    {
//        SetNetworkIfAll("eth", 0);
//    }
//    else if (strstr(exif, "eth"))
//    {
//        system("dhclient -r ra0");
//        SetNetworkIfAll("ra", 0);
//    }
    //system("dhclient -r ra0");
    SetNetworkIfAll(exif, 1);
    fprintf(enm_log, "exif=%s \n", exif);
    wxString cmd = ENABLE_GATEWAY_SCRIPT + wxT(" ") + ENMUtil::StringToWxString(exif) + wxT(" mesh0");
    string tmp = ENMUtil::WxStringToString(cmd);
    fprintf(enm_log, "enable gateway=%s \n", tmp.c_str());
    fflush(enm_log);
    wxExecute(cmd);
    return 1;
}

int MeshUtility::UpdateResolvconf(char *dns1, char *dns2)
{
        char arg[1024] = {'\0'};
        FILE *fp = NULL;
        fp = fopen(RESOLVCONF_PATH, "w+");
        if (fp == NULL)
        {
            return 0;
        }
        sprintf(arg, "%s%s", RESOLV_PREFIX, RESOLV_HEADER);

        fwrite(arg, strlen(arg), 1, fp);

        memset(arg, 0 , 1024);

        sprintf(arg, "domain \nsearch \nnameserver %s\nnameserver %s\n", dns1, dns2);

        fwrite(arg, strlen(arg), 1, fp);

        fclose(fp);
        return 1;
}

int MeshUtility::GetResolvconf(char * dns1, char * dns2)
{
        FILE *fp = NULL;
        int ret = 0;
        char sep[] = " \n";
        int i = 0;
        static char line2[256];
        char *ptr = NULL;
        char *dns = NULL;
        fp = fopen(RESOLVCONF_PATH, "r");
        if (fp == NULL)
                return ret;
        memset(line2, 0, 256);
        while ( fgets(line2, 256, fp) != NULL)
        {
            line2[255] = '\0';
            ptr = strtok(line2, sep);
            if (ptr != NULL)
            {
                if ( !strcmp(ptr, "nameserver") )
                {
                    dns = strtok(NULL, sep);
                    if (dns != NULL)
                    {
                        i ++ ;
                        if (i == 1)
                        {
                                strcpy(dns1, dns);
                                ret = 1;
                        }
                        else
                        {
                                strcpy(dns2, dns);
                                break;
                        }

                    }
                }
            }
            memset(line2, 0, 256);
        }
        fclose(fp);
        return ret;
}

int MeshUtility::GetMeshIp(const char* ifname, char* ip)
{
    //	struct iwreq wrq;
    int socket_id;
    struct if_nameindex *ifnames, *ifnm;
    //    struct ifreq ifr;
    int ret = 0;
    int affect_if = 0;
    if(!ip)
        return BAD_PARAM;
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0){
        return SOCK_FAIL;
    }

    //find all the existing I/F
    ifnames = if_nameindex();
    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++) {
        if(strstr(ifnm->if_name, ifname)){
            ret += GetMeshIpHelper(ifnm->if_name, ip);
            affect_if++;
            break;
        }
    }

    if(!affect_if){
        ret--;
    }

    close(socket_id);
    return ret;
}

int MeshUtility::GetMeshIpHelper(char * ifname, char * ip)
{
    struct ifreq ifr;
    struct sockaddr_in sin;
    int socket_id;
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);

    int ret = 0;

    if(socket_id < 0)
    {
        return SOCK_FAIL;
    }
    memset(ip, 0 ,32);
    strncpy (ifr.ifr_name, ifname, IFNAMSIZ);
    if ( (ret=ioctl (socket_id, SIOCGIFADDR, &ifr)) == 0) {
        memcpy (&sin, &(ifr.ifr_addr), sizeof (sin));
        memcpy(ip, (char*)inet_ntoa (sin.sin_addr), strlen((char*)inet_ntoa (sin.sin_addr)));
    }

    close(socket_id);
    return ret;
}

int MeshUtility::SetNetworkIf(char * ifname, bool uord)
{
    int ret = 0;
    int socket_id;
    struct ifreq ifr;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0){
        return SOCK_FAIL;
    }

    strncpy (ifr.ifr_name, ifname, IFNAMSIZ);
    ret=ioctl(socket_id, SIOCGIFFLAGS, (caddr_t)&ifr);
    if(ret==-1){
        close(socket_id);
        return ret;
    }

    if(uord == false){
        if((ifr.ifr_flags)&IFF_UP){
            ifr.ifr_flags &= ~IFF_UP;
            if((ret = ioctl(socket_id, SIOCSIFFLAGS, (caddr_t)&ifr) )< 0 ){
                close(socket_id);
                return ret;
            }
        }
    }else{
        if((ifr.ifr_flags)&IFF_UP){

        }else{

            ifr.ifr_flags |= IFF_UP;
            if((ret = ioctl(socket_id, SIOCSIFFLAGS, (caddr_t)&ifr) )< 0 ){
                close(socket_id);
                return ret;
            }
        }
    }

    close(socket_id);
    return ret;
}

int MeshUtility::SetNetworkIfAll(const char * ifname, bool uord)
{
    int ret = 0, temp_ret = 0, affect_if =0;
    //	struct iwreq wrq;
    int socket_id;
    struct if_nameindex *ifnames, *ifnm;
    //    struct ifreq ifr;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0){

        return SOCK_FAIL;
    }

    //find all the existing I/F
    ifnames = if_nameindex();
    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++) {
        if(strstr(ifnm->if_name, ifname)){
            temp_ret = SetNetworkIf(ifnm->if_name, uord);
            if(temp_ret<0)
                ret += temp_ret;
            else
                ++affect_if;
        }
    }
    if(!affect_if){
        --ret;
    }
    close(socket_id);
    return ret;
}

int MeshUtility::GetMeshGatewayInfo(PMESH_GATEWAY_INFO meshGatewayInfo)
{
    char dns1[33] = {'\0'};
    char dns2[33] = {'\0'};
    char ip[33] = {'\0'};
    char hostname[33] = {'\0'};
    int channel = 1;
    MeshUtility::GetResolvconf(dns1, dns2);
    strcpy((char *)(meshGatewayInfo->DNS1), dns1);
    strcpy((char *)(meshGatewayInfo->DNS2), dns2);

    MeshUtility::GetMeshIp("mesh0", ip);
    strcpy((char *)(meshGatewayInfo->IPAddr), ip);

    MeshUtility::GetMeshHostname("mesh0", hostname);
    strcpy((char *)(meshGatewayInfo->HostName), hostname);

    MeshUtility::GetMeshChannel("mesh0", &channel);
    meshGatewayInfo->Channel = channel;

    return 1;
}

int MeshUtility::SetMeshOnlyMode(char *ifname, char mode)
{
    int ret = 0;
    struct iwreq wrq;
    int socket_id;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0){
        return SOCK_FAIL;
    }

    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = sizeof(unsigned char);
    wrq.u.data.pointer = (char *)&mode;
    wrq.u.data.flags = RT_OID_802_11_MESH_ONLY_MODE;
    ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
    if(ret != 0){
        close(socket_id);
        return ret;
    }
    close(socket_id);
    return ret;
}

int MeshUtility::SetMeshID(char* ifname, const char *id)
{
    char meshid[64];
    int ret = 0;
    struct iwreq wrq;
    int socket_id;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0){
        return SOCK_FAIL;
    }
    memset(meshid, 0, 64);
    memcpy(meshid, id, strlen(id) + 1);
    strcpy(wrq.ifr_name, ifname);
    wrq.u.data.length = MAX_MESH_ID_LENGTH;
    wrq.u.data.pointer = meshid;
    wrq.u.data.flags = RT_OID_802_11_MESH_ID;
    ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
    close(socket_id);
    return ret;
}

int MeshUtility::SetMeshChannelOFFSET(int nflag)
{
    int ret = 0;
    switch(nflag)
    {
        case 1: //0 down    1 up
            SetNetworkIfAll("eth", 0);
        break;
        case 2:
            SetNetworkIfAll("ra", 0);
        break;
        case 3:
            SetNetworkIfAll("eth", 1);
        break;
        case 4:
            SetNetworkIfAll("ra", 1);
        break;
        case 5:
            SetNetworkIfAll("mesh", 1);
            wxExecute(MESH_ONLY_WIRLESS_SCRIPT);
        break;
        case 6://set meshonly mode=false
        {
            SetMeshOnlyMode("mesh0", 0);
            int socket_id, ret=0;
            struct iwreq wrq;
            socket_id = socket(AF_INET, SOCK_DGRAM, 0);
            if(socket_id < 0)
            {
                return SOCK_FAIL;
            }
            int channel;
            strcpy(wrq.ifr_name, "mesh0");
            wrq.u.data.length = sizeof(unsigned char);
            wrq.u.data.pointer = &channel;
            wrq.u.data.flags = RT_OID_802_11_BSSID_LIST_SCAN;
            ret = ioctl(socket_id, RT_PRIV_IOCTL, &wrq);
            close(socket_id);
            SetMeshID("mesh0");
        }
        break;
        default:
        break;
    }
    return ret;
}
