/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_FNKEY_API_H
#define DCS_FNKEY_API_H

#include "../DCSCommon.h"
#include "../plugins/vkbd/VKbdDef.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Typedef of the callback function for key/button events.
 *
 * @param pData the pointer to the function key data got
 */
typedef void (CALLBACK *DCS_FnKey_Callback) (DCS_VKbd_Data *pData);

/**
 * Registers the notification of the key/button events.
 *
 * @param pCallback the pointer to the function key callback function
 */
DCSAPI DCS_Return_Code DCS_RegisterFnKeyCallback(DCS_FnKey_Callback pCallback);

/**
 * Unregisters the notification of the key/button events.
 */
DCSAPI DCS_Return_Code DCS_UnregisterFnKeyCallback();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DCS_FNKEY_API_H */
