/****************************************************************************

Copyright (c) Intel Corporation (2008).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:          DcsPlugin.cpp

Description:

    This file implements the interface of DcsPlugin.h

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-8-15

  =====================================================================

****************************************************************************/

#include <cstdio>
#include <cassert>
#include "inc/DcsPlugin.h"
#include "inc/PMPlugin.h"
#include "PMPluginAPi.h"
#include <string>
using namespace std;

#include <unistd.h>
#include <pwd.h>

char *uid_to_name( uid_t uid );

PMPlugin g_PMPlugin;
FILE* pm_log = NULL;

/**
 * Gets the module ID.
 */
DCSAPI int DP_GetModuleID()
{
//    if (!pm_log)
//    {
//        pm_log=fopen("/home/pm_log.txt", "w");
//    }
//
//    fprintf(pm_log, "Module is Power Management, and id is 3. \n");
//    fflush(pm_log);

    return DCS_POWER_MANAGER;
}

/**
 * Gets the description of the module.
 */
DCSAPI const char *DP_GetDescription()
{
    return "Power management plug in";
}

/**
 * Initializes the module and passes the host function pointers.
 *
 * @param pFuncs	pointer to the DCS function interface
 */
DCSAPI int DP_Initialize(DCS_Funcs *pFuncs)
{
//	fprintf(pm_log, "Enter DP_Initialize(). \n");
//    fflush(pm_log);


    if (NULL == pFuncs)
    {
        return -1;
    }


    g_PMPlugin.InitializeDCS_Funcs(pFuncs);
//    fprintf(pm_log, "end init. \n");
//    fflush(pm_log);

    return 0;
}

/**
 * Uninitializes the module and cleans up.
 */
DCSAPI int DP_Uninitialize()
{
//    fclose(pm_log);

    return 0;
}

char *uid_to_name( uid_t uid )
{
    struct  passwd *pw_ptr;
    static  char numstr[10];

     if ( ( pw_ptr = getpwuid( uid ) ) == NULL )
     {
//         fprintf(pm_log, "username is %s, uid is %d\n", numstr, uid);
//         fflush(pm_log);
         return numstr;
      }
      else
      {
//         fprintf(pm_log, "user home dir is %s\n", pw_ptr->pw_dir);
//         fflush(pm_log);
          return pw_ptr->pw_dir;
      }
}

/**
 * Handles the function request.
 *
 * @param pRequest	pointer to request data
 */
DCSAPI DCS_Return_Code DP_HandleRequest(DCS_RequestData *pRequest)
{
    //fprintf(pm_log, "Enter DP_HandleRequest() \n");
    //fflush(pm_log);

    if ( NULL == pRequest )
    {
        return DCS_FUNC_NOTEXIST;
    }

    g_PMPlugin.SetUserHomeDir(uid_to_name(pRequest->userId));

    DCS_Return_Code ret = DCS_SUCCESS;

    switch (pRequest->funcId)
    {
    case PM_GET_MAX_LCD_BRIGHTNESS:
        ret = g_PMPlugin.PP_GetLCDMaxBrightness((int *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(int);
        break;

	case PM_GET_LCD_BRIGHTNESS:
	    ret = g_PMPlugin.PP_GetLCDBrightness((int *)(pRequest->pReturnData));
	    pRequest->pReturnDataLen = sizeof(int);
//	    //fprintf(pm_log, "Request DCS_GetLCDBrightness() is %d.\n", *((int *)(pRequest->pReturnData)));
//        //fflush(pm_log);

	    break;

	case PM_SET_LCD_BRIGHTNESS:
        ret = g_PMPlugin.PP_SetLCDBrightness(*(int *)(pRequest->pParams));
//        //fprintf(pm_log, "Request DCS_SetLCDBrightness() to %d. \n", *(int *)(pRequest->pParams));
//        //fflush(pm_log);

	    break;

	case PM_GET_LAN_STATUS:
        ret = g_PMPlugin.PP_GetLANStatus((BOOL *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(BOOL);
//        //fprintf(pm_log, "Request DCS_GetLANStatus() is %d. \n", *((BOOL *)(pRequest->pReturnData)));
//        //fflush(pm_log);

	    break;

	case PM_SET_LAN_STATUS:
        ret = g_PMPlugin.PP_SetLANStatus(*(BOOL *)(pRequest->pParams));
        //fprintf(pm_log, "Request DCS_SetLANStatus() to %d. \n", *(BOOL *)(pRequest->pParams));
        //fflush(pm_log);

	    break;

	case PM_GET_WIRELESS_STATUS:
	    ret = g_PMPlugin.PP_GetWirelessStatus((BOOL *)(pRequest->pReturnData));
	    pRequest->pReturnDataLen = sizeof(BOOL);
        //fprintf(pm_log, "Request DCS_GetWirelessStatus() is %d. \n", *((BOOL *)(pRequest->pReturnData)));
        //fflush(pm_log);

	    break;

	case PM_SET_WIRELESS_STATUS:
	    ret = g_PMPlugin.PP_SetWirelessStatus(*(BOOL *)(pRequest->pParams));
        //fprintf(pm_log, "Request DCS_SetWirelessStatus() to %d. \n", *(BOOL *)(pRequest->pParams));
        //fflush(pm_log);

	    break;

    case PM_GET_LAN_SPEED:
        ret = g_PMPlugin.PP_GetLANSpeed((DCS_Lan_Speed *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(int);

        break;

	case PM_GET_BATTERY_INFO:
        {
            //fprintf(pm_log, "DCS_GetBatteryInfo() is %d. \n", *((int *)(pRequest->pParams)));
            //fflush(pm_log);

            ret = g_PMPlugin.PP_GetBatteryInfo((PDCS_Battery_Info)(pRequest->pReturnData), *((int *)(pRequest->pParams)));
            pRequest->pReturnDataLen = sizeof(DCS_Battery_Info);

            //fprintf(pm_log, "Voltage is %d. \n", ((PDCS_Battery_Info)(pRequest->pReturnData))->Voltage);
            //fflush(pm_log);
        }

	    break;

	case PM_ADD_SCHEME:
        {
            PM_Power_Scheme_Data *scheme = (PM_Power_Scheme_Data *)(pRequest->pParams);

            //fprintf(pm_log, "Request DCS_AddPwrScheme() name is %s.\n", scheme->pName);
            //fflush(pm_log);

            ret = g_PMPlugin.PP_AddPwrScheme(scheme->pName, scheme->pDesc, scheme->copyFrom, &(scheme->schemeId));
            *((int *)(pRequest->pReturnData)) = scheme->schemeId;
            pRequest->pReturnDataLen = sizeof(int);
            //fprintf(pm_log, "Request DCS_AddPwrScheme() id is %d.\n", *((int *)(pRequest->pReturnData)));
            //fflush(pm_log);
        }

	    break;

	case PM_EDIT_SCHEME:
        {
            PM_Variable_Data *variable = (PM_Variable_Data *)(pRequest->pParams);
            //fprintf(pm_log, "Request DCS_SetPwrVariable() id is %d, variable name is %s, variable value is %d.\n",variable->schemeId, variable->pVarName, variable->value);
            //fflush(pm_log);
            ret = g_PMPlugin.PP_SetPwrVariable(variable->schemeId, variable->isAC, variable->pVarName, variable->value);
        }
	    break;

	case PM_DELETE_SCHEME:
        {
            //fprintf(pm_log, "Request DCS_DeletePwrScheme() is %d. \n", *((int *)(pRequest->pParams)));
            //fflush(pm_log);
            ret = g_PMPlugin.PP_DeletePwrScheme(*(int *)(pRequest->pParams));
        }
	    break;

    case PM_QUERY_SCHEME:
        {
            PM_Variable_Data *variable = (PM_Variable_Data *)(pRequest->pParams);

            ret = g_PMPlugin.PP_GetPwrVariable(variable->schemeId, variable->isAC, variable->pVarName, &(variable->value));
            *((int *)(pRequest->pReturnData)) = variable->value;
            pRequest->pReturnDataLen = sizeof(int);


            //fprintf(pm_log, "Request DCS_GetPwrVariable() is %d. \n", *((int *)(pRequest->pReturnData)));
            //fflush(pm_log);
        }

        break;

	case PM_GET_BATTERY_COUNT:
        ret = g_PMPlugin.PP_GetBatteryCount((ULONG *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(ULONG);

        break;

	case PM_GET_SCHEME_NAME:
        {
            string strSchemeName;
            string strSchemeDesc;

            ret = g_PMPlugin.PP_GetPwrSchemeNameDesc(*((int *)(pRequest->pParams)), strSchemeName, strSchemeDesc);

            strncpy(((PM_Power_Scheme_Data *)(pRequest->pReturnData))->pName, strSchemeName.c_str(), strlen(strSchemeName.c_str())+1);
            strncpy(((PM_Power_Scheme_Data *)(pRequest->pReturnData))->pDesc, strSchemeDesc.c_str(), strlen(strSchemeDesc.c_str())+1);

            pRequest->pReturnDataLen = sizeof(PM_Power_Scheme_Data);

            //fprintf(pm_log, "Request DCS_GetPwrSchemeNameDesc() is %s. \n", ((PM_Power_Scheme_Data *)(pRequest->pReturnData))->pName);
            //fflush(pm_log);
        }
        break;
    case PM_POST_DOWN_INTERFACE:
        {
            ret = g_PMPlugin.PP_PostDownInterfaceReq(*((int *)(pRequest->pParams)));
            break;
        }
    case PM_GET_ACTIVE_SCHEME:
        ret = g_PMPlugin.PP_GetActivePwrScheme((int *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(int);
        //fprintf(pm_log, "Request DCS_GetActivePwrScheme() is %d. \n", *((int *)(pRequest->pReturnData)));
        //fflush(pm_log);
        break;

    case PM_LAN_SPEED_CHANGED:
        //fprintf(pm_log, "Request DCS_SetLANSpeed(). \n");
        //fflush(pm_log);
        ret = g_PMPlugin.PP_SetLANSpeed(*(DCS_Lan_Speed *)(pRequest->pParams));

        break;

    case PM_APPLY_SCHEME:
        //fprintf(pm_log, "Request DCS_SetActivePwrScheme() to %d. \n", *((int *)(pRequest->pParams)));
        //fflush(pm_log);
        ret = g_PMPlugin.PP_SetActivePwrScheme(*((int *)(pRequest->pParams)));

        break;

	default:
	   break;
    }

    return ret;
}
/**
 * Destroys data related to a client.
 * DCS will call this function when DCS detects that a client exits.
 *
 * @param cliId	the client process ID
 */
DCSAPI int DP_DestroyClient(int cliId)
{
    return 0;
}

