/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#include "AccelApi.h"
#include "DCSApi.h"
#include "TabletApi.h"
#include "PMApi.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <pthread.h>
#include <X11/Xlib.h>
#include "UserSession.h"

void systemOrientationHandler(DCS_SystemOrientation *pData);
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;
int aborttimes=0;
static BOOL hiddenCursor=TRUE;
static DCS_Tablet_Sensor_Data tabletMode=DCS_CLAMSHELL_MODE;
#ifndef PATH_MAX
#define PATH_MAX 260 
#endif
char g_CfgPath[MAX_PATH];
#define CFG_FILE "/.TSController.cfg"

extern int Ini_WriteString(const char *Section, const char *Ident, const char *Value, const char *FileName);
extern int Ini_ReadString(const char *Section,const char *Ident, const char *Default, char *ret, const char *FileName);
BOOL GetCursorStatus();

char lck[MAX_PATH];
Display *display = NULL;

int SetCfgPath()
{
	memset(g_CfgPath,0,MAX_PATH);
	char* pTmp = NULL;
	pTmp = getenv("HOME");
	//DCS_Tablet_Sensor_Data CurrentMode=DCS_CLAMSHELL_MODE;
	if (NULL != pTmp)
	{
		strcpy(g_CfgPath,pTmp);
		strcat(g_CfgPath,CFG_FILE);
		printf("HOME is %s \n",g_CfgPath);
		
		if ( access(g_CfgPath,0) != 0 )//not exist
		{
			printf("cfg file not exsit \n");

			if ( tabletMode == DCS_TABLET_MODE )			
			{
				FILE* file;
				if ( (file = fopen(g_CfgPath, "w+")) != NULL )	
				{
					printf("cfg file init \n");
					Ini_WriteString("TSController","HideCursor","TRUE",g_CfgPath);
					Ini_WriteString("TSController","CursorStatus","Hide",g_CfgPath);
					Ini_WriteString("TimeSetting","GetDark","20",g_CfgPath);
					Ini_WriteString("TimeSetting","DarkRemain","500",g_CfgPath);
					Ini_WriteString("TimeSetting","GetLight","10",g_CfgPath);

					fclose(file);
				}
			}
			else
			{
				FILE* file;
				if ( (file = fopen(g_CfgPath, "w+")) != NULL )	
				{
					printf("cfg file init \n");
					Ini_WriteString("TSController","HideCursor","TRUE",g_CfgPath);
					Ini_WriteString("TSController","CursorStatus","Show",g_CfgPath);
					Ini_WriteString("TimeSetting","GetDark","20",g_CfgPath);
					Ini_WriteString("TimeSetting","DarkRemain","500",g_CfgPath);
					Ini_WriteString("TimeSetting","GetLight","10",g_CfgPath);

					fclose(file);
				}				
			}
		}
			
		chmod(g_CfgPath,S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IWGRP |S_IXGRP | S_IROTH | S_IWOTH | S_IXOTH );
		return 0;
	}
	
	return -1;
}

int GetSleepTime(int nIndex)
{
	int num;

	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);

	switch (nIndex)
	{
	case 1://get dark
		Ini_ReadString("TimeSetting","GetDark","20",str_tmp,g_CfgPath);
		num = atoi(str_tmp);
		break;
	case 2://dark remain
		Ini_ReadString("TimeSetting","DarkRemain","500",str_tmp,g_CfgPath);
		num = atoi(str_tmp);
		break;
	case 3://get light
		Ini_ReadString("TimeSetting","GetLight","10",str_tmp,g_CfgPath);
		num = atoi(str_tmp);
		break;
	default:
		num = 500;
		break;
	}

	printf("sleep num is %d \n", num);

	return num;
}

BOOL CheckCurrentUser()
{
	UserSessionStatus status = GetUserSessionStatus();
	if (status == USS_ActiveSession) 
		return TRUE;
	return FALSE;
/*	uid_t uid;
	struct passwd *user;
	// get user's home direct 
	uid = getuid();
	user = getpwuid(uid);
	if (NULL == user) {
		printf("can't find the current user!\n");
		return 1;
	}
	system ("sh /usr/bin/dcs/checkcurrentuser.sh");
	system ("chmod 777 /tmp/currentuser");	
	FILE* file;
	size_t n = MAX_PATH;
	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);

	if ( (file = fopen("/tmp/currentuser", "r")) != NULL )	
	{
		fgets( str_tmp, n, file);
		if (strlen(str_tmp) < 7)
			n = strlen(str_tmp) - 1;
		else
			n = 7;
		printf("currentuser: %s, len: %d, tscontroller belongs to user %s \n",str_tmp, n, user->pw_name );

		if (strncmp(user->pw_name, str_tmp, n)!=0)
		{
	
			return FALSE;
		}
	}
*/	
	return TRUE;
}
/*
void RecordCurrentUser()
{
	char strFile[MAX_PATH];	
	memset(strFile,0,MAX_PATH);
	strcpy(strFile,TSC_CFG_PATH);
	strcat(strFile,CFG_FILE);
	
	FILE* file;
	if ( (file = fopen(strFile, "w+")) != NULL )	
	{
		printf("record current user\n");
		Ini_WriteString("Users","Name",user->pw_name,strFile);
		fclose(file);
	}
	return ;
}*/

BOOL CheckMouse()
{//check if the usb mouse is plugined
	int ret = 0;
	ret = system("/usr/bin/dcs/checkmouse.sh");
//	printf("ret = %d\n", ret);
	if (ret > 0)//have mouse
		return TRUE;
	else // no mouse
		return FALSE;

}

void HideCursor()
{
	BOOL ret = CheckMouse();
	if (ret)  //mouse exists, don't hide
		return;
	if (! GetCursorStatus()) //don't hide mouse in configuration file
		return;
	system("/usr/bin/dcs/hidecursor.sh");

	if (access(g_CfgPath,0) ==0 ) //file exist
	{
		Ini_WriteString("TSController","CursorStatus","Hide",g_CfgPath);
	}
}

void ShowCursor()
{
	system("/usr/bin/dcs/showcursor.sh");

	if (access(g_CfgPath,0) ==0 ) //file exist
	{
		Ini_WriteString("TSController","CursorStatus","Show",g_CfgPath);
	}
}
BOOL GetCursorStatus()
{
	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);

	if (access(g_CfgPath,0) ==0 ) //file exist
	{
		Ini_ReadString("TSController","HideCursor","",str_tmp,g_CfgPath);
	}
	
	if (!(strcmp(str_tmp,"FALSE")))
	{
		hiddenCursor = FALSE;
		return FALSE;
	}
	
	hiddenCursor = TRUE;

	return TRUE;
}

int SetCursorStatus(BOOL bStatus)
{
	if (access(g_CfgPath,F_OK) < 0) // dir not exist
	{	
		return -1;
	}
	hiddenCursor = bStatus;


	if (hiddenCursor==TRUE)
		Ini_WriteString("TSController","HideCursor","TRUE",g_CfgPath);
	else
		Ini_WriteString("TSController","HideCursor","FALSE",g_CfgPath);

	return 0;
}

void CALLBACK tabletHandler(DCS_Tablet_Sensor_Data *pData)
{
	if (pData == NULL) return;
	tabletMode = *pData;
	if (!CheckCurrentUser()) return; //if not current user, do nothing
	syslog(LOG_USER|LOG_INFO, "tscontroller: tablet data: %d \n", *pData);
	printf("tablet data: %d \n", *pData);
	
/*
	int nOldBrightness;
	DCS_GetLCDBrightness(&nOldBrightness);
	int nSleepTime;
	nSleepTime = 1000*GetSleepTime(1);
	
	printf("sleeptime 1 = %d \n",nSleepTime);
	if (nOldBrightness>=0 && nOldBrightness<=7)
		for (int i=nOldBrightness;i>=0;i--)
		{
			DCS_SetLCDBrightness(i);
			usleep(nSleepTime);
		}
	else
		for (int i=7;i>=0;i--)
		{
			DCS_SetLCDBrightness(i);
			usleep(nSleepTime);
		}
*/
	if (*pData == DCS_TABLET_MODE)
	{
		printf("go to tablet hide cursor \n");
		system("xrandr --output LVDS --auto --rotate inverted --output VGA --auto --rotate inverted");
		HideCursor();
		//DCS_RegisterSystemOrientationCallback(systemOrientationHandler);
	}
	else
	{
		printf("go to clam shell show cursor \n");
		system("xrandr --output LVDS --auto --rotate normal --output VGA --auto --rotate normal ");
		ShowCursor();
		//DCS_UnregisterSystemOrientationCallback();	
	}
/*
	nSleepTime = 1000*GetSleepTime(2);
	printf("sleeptime 2 = %d \n",nSleepTime);
	usleep(nSleepTime);

	nSleepTime = 1000*GetSleepTime(3);
	printf("sleeptime 3 = %d \n",nSleepTime);
	if (nOldBrightness>=0 && nOldBrightness<=7)
		for (int i=0;i<=nOldBrightness;i++)
		{
			usleep(nSleepTime);
			DCS_SetLCDBrightness(i);
		}
	else
		for (int i=0;i<=7;i++)
		{
			usleep(nSleepTime);
			DCS_SetLCDBrightness(i);
		}*/
}

void CALLBACK abortHandler()
{
	printf("abortHandler\n");
	pthread_mutex_lock(&mutex);
	aborttimes++;	
	pthread_mutex_unlock(&mutex);	

	pthread_mutex_lock(&mutex);
	pthread_cond_signal(&cond);
	pthread_mutex_unlock(&mutex);	
}

void MoveCursor()
{
   char* display_name = getenv("DISPLAY");
   //printf("display name is %s \n",display_name);
    
    Display* display = XOpenDisplay(display_name);

    if (display == NULL)
    {	
	printf("display is null \n");
	return ;
    }
    
    int screen_num = DefaultScreen(display);
    int display_width = DisplayWidth(display,screen_num);
    int display_height = DisplayHeight(display,screen_num);
    
    printf("width is %d, height is %d \n",display_width,display_height);

	Window win;
	Window root;
	Window child;
	int rootx,rooty,winx,winy;
	unsigned int mask;
	
	XQueryPointer(display,DefaultRootWindow(display),
           		  &root,&child,&rootx,&rooty,&winx,&winy,&mask);
	
    
    XWarpPointer(display,None,root,0,0,0,0,display_width,display_height/2);
    
    XFlush(display);
    XCloseDisplay(display);	
}

void CALLBACK systemOrientationHandler (DCS_SystemOrientation *pData)
{
	if (pData == NULL) return;
	printf("tablet data: %d \n", tabletMode);
	if (tabletMode ==  DCS_CLAMSHELL_MODE) return; //only tablet mode need to rotate screen
	if (!CheckCurrentUser()) return; //if not current user, do nothing

	
	printf("SystemOrientation data: %d \n", *pData);
	
/*	int nOldBrightness;
	DCS_GetLCDBrightness(&nOldBrightness);
	int nSleepTime;
	nSleepTime = 1000*GetSleepTime(1);

	if (nOldBrightness>=0 && nOldBrightness<=7)
		for (int i=nOldBrightness;i>=0;i--)
		{
			DCS_SetLCDBrightness(i);
			usleep(nSleepTime);
		}
	else
		for (int i=7;i>=0;i--)
		{
			DCS_SetLCDBrightness(i);
			usleep(nSleepTime);
		}
*/
//	char cmd[20]="xrandr -o ";
	switch (*pData)
	{
	case DCS_SYSTEM_ORIENTATION_NORMAL:
		system("xrandr --output LVDS --auto --rotate inverted --output VGA --rotate inverted");
//		strcat(cmd, "inverted");
		break;
	case DCS_SYSTEM_ORIENTATION_CW90:
//		strcat(cmd, "left");
		system("xrandr --output LVDS --auto --rotate left --output VGA --rotate left ");
		break;
	case DCS_SYSTEM_ORIENTATION_CW180:
//		strcat(cmd,"normal");
		system("xrandr --output LVDS --auto --rotate normal --output VGA --rotate normal ");
		break;
	case DCS_SYSTEM_ORIENTATION_CW270:
//		strcat(cmd, "right");
		system("xrandr --output LVDS --auto --rotate right --output VGA --rotate right ");
		break;
	default:
//		strcat(cmd, "normal");
		system("xrandr --output LVDS --auto --rotate normal --output VGA --rotate normal ");
                break;
	}	

	/*nSleepTime = 1000*GetSleepTime(2);
	usleep(nSleepTime);

	nSleepTime = 1000*GetSleepTime(3);
	if (nOldBrightness>=0 && nOldBrightness<=7)
		for (int i=0;i<=nOldBrightness;i++)
		{
			usleep(nSleepTime);
			DCS_SetLCDBrightness(i);
		}
	else
		for (int i=0;i<=7;i++)
		{
			usleep(nSleepTime);
			DCS_SetLCDBrightness(i);
		}
*/
//	system (cmd);
	if (GetCursorStatus() && !CheckMouse())
		MoveCursor();
	
	HideCursor();

	return;	
}

void* loopCheckMouse(void* )
{
	BOOL ret=FALSE;
	while (1)
	{
		if (tabletMode == DCS_TABLET_MODE )
		{
			ret = CheckMouse();
			if (!ret && GetCursorStatus()) // no usb mouse exist, and config file is true
				HideCursor();
			else
				ShowCursor();
		}
		else
			ShowCursor();
		sleep(5); //sleep 5 second
	}
}

int AfterFunc(Display *)
{
	return 0;
}

int ErrorHandler(Display *, XErrorEvent *)
{
	return 0;
}


void *EventThread(void *)
{
	XEvent event;
	//Window window;
	//char buf[MAX_PATH + 10];
	
	display = XOpenDisplay(NULL);
	XSynchronize(display, TRUE);
	XSetAfterFunction(display, AfterFunc);
	XSetErrorHandler(ErrorHandler);
	
	while (1) {
		XNextEvent(display, &event);
	}
}

void DelPip(int sgn)
{
	XCloseDisplay(display);	

	/* ignore all other signals */
	if ((SIGHUP == sgn) || (SIGINT == sgn) || (SIGQUIT == sgn) ||
		(SIGILL == sgn) || (SIGABRT == sgn) || (SIGSEGV == sgn) ||
		(SIGTERM == sgn) || (SIGTSTP == sgn) || (SIGPIPE == sgn)) {
		char buf[MAX_PATH + 10];
		printf("the process is terminated and delete pipe file\n");
		strcpy(buf, "rm -f ");
		strncat(buf, lck, MAX_PATH + 10);
		system(buf);
		exit(1);
	}
}

int main()
{
	int ret = 0;
	uid_t uid;
	struct passwd *user;

	/* install signal handlers to delete named pipe file */
	if ((SIG_ERR == signal(SIGHUP, DelPip)) ||
		(SIG_ERR == signal(SIGINT, DelPip)) ||
		(SIG_ERR == signal(SIGQUIT, DelPip)) ||
		(SIG_ERR == signal(SIGILL, DelPip)) ||
		(SIG_ERR == signal(SIGABRT, DelPip)) ||
		(SIG_ERR == signal(SIGFPE, DelPip)) ||
		(SIG_ERR == signal(SIGSEGV, DelPip)) ||
		(SIG_ERR == signal(SIGPIPE, DelPip)) ||
		(SIG_ERR == signal(SIGALRM, DelPip)) ||
		(SIG_ERR == signal(SIGTERM, DelPip)) ||
		(SIG_ERR == signal(SIGUSR1, DelPip)) ||
		(SIG_ERR == signal(SIGUSR2, DelPip)) ||
		(SIG_ERR == signal(SIGTSTP, DelPip)) ||
		(SIG_ERR == signal(SIGTTIN, DelPip)) ||
		(SIG_ERR == signal(SIGTTOU, DelPip))) {
		printf("Install signal handlers failed\n");
		return 1;
	}
	
	/* get user's home direct */
	uid = getuid();
	user = getpwuid(uid);
	if (NULL == user) {
		printf("can't find the current user!\n");
		return 1;
	}

	strcpy(lck, "/var/lock/TSController_");
	strncat(lck, user->pw_name, MAX_PATH);

	/* use named pipe to exclude TSController process to one for one user */
	ret = mkfifo(lck, S_IRUSR | S_IWUSR);
	if (0 != ret) {
		printf("the named pipe %s already exists!\n", lck);
		return 1;
	}

	pthread_t thread;
	if (pthread_create(&thread, NULL, EventThread, NULL)) {
		printf("can't create X server event thread!\n");
		return 1;
	}
	
	InitializeUserSessionStatus();
	
	pthread_t checkMouseThread=NULL;
	pthread_attr_t child_thread_attr;
    pthread_attr_init(&child_thread_attr);
    //pthread_attr_setdetachstate(&child_thread_attr,PTHREAD_CREATE_DETACHED);
  	pthread_create(&checkMouseThread,&child_thread_attr,loopCheckMouse, NULL);

DCS_RECONNECT:
	ret = DCS_Initialize();
	printf("dcs initialize return %d \n", ret);
	while (ret) {
		sleep(10);
		ret = DCS_Initialize();
	}

	ret = DCS_GetTabletSensorMode(&tabletMode);
	printf("DCS_GetTabletSensorMode ret is %d\n",tabletMode);
	if (ret)
	{
		tabletMode = DCS_CLAMSHELL_MODE;
	}	

	/* switch to the mode */
	tabletHandler(&tabletMode);

	if ( SetCfgPath() < 0 )
		return -1;
	DCS_RegisterTabletSensorCallback(tabletHandler);
	DCS_RegisterSystemOrientationCallback(systemOrientationHandler);
	DCS_SetAbortHandler(abortHandler);

	pthread_mutex_lock(&mutex);
	while (aborttimes <=0) pthread_cond_wait(&cond, &mutex);
	aborttimes --;	
	pthread_mutex_unlock(&mutex);	
	printf("receive abort signal\n");
	DCS_Uninitialize();
	goto DCS_RECONNECT;

	return 0;
}

