/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_POLICYCONTROL_API_H
#define DCS_POLICYCONTROL_API_H

#include "DCSCommon.h"
#include "PolicyDef.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Adds a new policy rule.
 *
 * @param userGroup	the user group of the new policy
 * @param moduleId	the module ID of the new policy
 * @param opId		the operation ID of the new policy
 * @param access	DCS_POLICY_ALLOWED or DCS_POLICY_REJECTED
 */
DCSAPI DCS_Return_Code DCS_SetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access access);

/**
 * Gets the policy to see if one user group has the right
 * to do the operation in specified module
 *
 * @param userGroup		the user group
 * @param moduleId		the module ID
 * @param opId			the operation ID
 * @param access		DCS_POLICY_ALLOWED or DCS_POLICY_REJECTED
 */
DCSAPI DCS_Return_Code DCS_GetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access* access);

/**
 * remove the policy with specified user group, module id and operation id.
 *
 * @param userGroup		the user group
 * @param moduleId		the module ID
 * @param opId			the operation ID
 */
DCSAPI DCS_Return_Code DCS_RemovePolicy(DCS_UserGroup userGroup, int moduleId, int opId);

/**
 * set the default policy, it's automatically set to the
 * default value if the policy is not set.
 *
 * @param access value to set the default access attribute
 */
DCSAPI DCS_Return_Code DCS_SetDefaultPolicy(DCS_Policy_Access access);

/**
 * save the policies from memory to disk.
 */
DCSAPI DCS_Return_Code DCS_SavePolicy();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* DCS_POLICYCONTROL_API_H */
