/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/
 
#ifndef __CMPC_TABLETSENSOR_DRIVER_H__
#define __CMPC_TABLETSENSOR_DRIVER_H__

#include <linux/ioctl.h>
#define CMPC_CLASS_NAME "cmpc"
#define CMPC_TSD_NAME   "tablet"

#define TABLET_SENSOR_MAGIC 0xfc
#define REGISTER_EVENT_CMD 0x0
#define DBG_SIGNAL_EVENT_CMD 0x01
#define UNREGISTER_EVENT_CMD 0x10

// Tablet sensor status change notification value
#define TSD_DEVICE_INFO_CHANGE     0x81

#define IOCTL_REGISTER_EVENT _IO( TABLET_SENSOR_MAGIC, REGISTER_EVENT_CMD )

#define IOCTL_UNREGISTER_EVENT _IO( TABLET_SENSOR_MAGIC, UNREGISTER_EVENT_CMD )

#define IOCTL_DBG_SIGNAL_EVENT _IOR( TABLET_SENSOR_MAGIC, DBG_SIGNAL_EVENT_CMD, int)


#endif  /*  __CMPC_tsd_H__ */
