/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#include "ENMUtil.h"
#include <string>
#include <wx/msgdlg.h>
#include <vector>
#include <iostream>
#include <fstream>
#include <wx/utils.h>
#if defined(__WXMSW__)
#include <windows.h>
#include <lm.h>
#include <shlobj.h>
#include <wx/msw/registry.h>
#include "NetCon.h"
#endif

#if defined(__UNIX__)
#include <sys/types.h>
#include <errno.h>
#include <stdlib.h>
#endif
#include <wx/buffer.h>
#include <wx/file.h>
#include <fstream>


using namespace std;

const long START_FIREWALL = 1;
const long STOP_FIREWALL = 0;
const size_t REG801X_LENGTH = 104;
#if defined(__WXMSW__)
const unsigned char DISABLE_8021X[REG801X_LENGTH] = {0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x0D, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x0d, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
const unsigned char ENABLE_8021X[REG801X_LENGTH] = {0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x04, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x0d, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif


string ENMUtil::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}

wxString ENMUtil::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}
string& ENMUtil::StringToLowerCase(string& str)
{
    char d = 'a' - 'A';
    for ( string::size_type i = 0; i < str.size(); i++ )
    {
        if ( str[i] >= 'A' && str[i] <= 'Z' )
            str[i] += d;
    }
    return str;
}

int ENMUtil::CheckWep(wxString str)
{
    string s = WxStringToString(str);
    for (int i = 0; i < s.length(); i++)
    {
        if ((s[i] < 48 || s[i] > 57) && (s[i] <65) || (s[i] >80) && (s[i] < 97 || s[i] > 102))
        {
            return 1;
        }
    }
    return 0;
}

int ENMUtil::OnlyLetterAndNum(wxString str)
{
    string s = WxStringToString(str);
    for (int i = 0; i < s.length(); i++)
    {
        if ((s[i] < 48 || s[i] > 57) && (s[i] < 97 || s[i] > 122))
        {
            return 1;
        }
    }
    return 0;
}

int ENMUtil::NoChineseCharacter(wxString str)
{
    string s = WxStringToString(str);
    for (int i = 0; i < s.length(); i++)
    {
        if ( s[i] & 0x80 )
        {
            return 1;
        }
    }
    return 0;
}

bool ENMUtil::IsOnlyNumber(wxString str)
{
    bool bRet = true;
    string s = WxStringToString(str);
    for (int i = 0; i < s.length(); i++)
    {
        if ( (s[i] < 48) || (s[i] > 57) )
        {
            bRet = false;
            break;
        }
    }
    return bRet;
}

int ENMUtil::CheckValide(wxString str)
{
    str.Trim(true).Trim(false);
    if (str.Length() == 0)
    {
        return CHECK_EMPTY;
    }
    if (str.Find('<') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('>') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('"') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('\\') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('\'') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('*') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find(':') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('?') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('|') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('/') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('%') >=0)
    {
        return CHECK_ILLEGAL;
    }
    return CHECK_OK;
}

int ENMUtil::IfIp(wxString ip)
{
    string s = WxStringToString(ip);
    char* str = (char* )s.c_str();

    int iVal = 0;

    int iLength = strlen (str);

    int iFirstDot = 0;

    int iSecondDot = 0;

    int iThirdDot = 0;

    if ( s == "0.0.0.0" )
    {
        return CHECK_ILLEGAL;
    }

    if ( iLength > MAX_IP_ADDRESS )
    {
        return CHECK_ILLEGAL;
    }

    //search the index of three dot in IP address
    //search the first dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iFirstDot =  iVal;
    iVal++;

    //search the second dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iSecondDot = iVal;
    iVal++;

    //search the third dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iThirdDot = iVal;
    iVal++;

    //search the fourth dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    if ( iVal != iLength )
    {
        return CHECK_ILLEGAL;
    }

    iVal = 0;
    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iFirstDot) )
    {
       iVal++;
    }

    if ( iVal != iFirstDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iSecondDot) )
    {
       iVal++;
    }

    if ( iVal != iSecondDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iThirdDot) )
    {
       iVal++;
    }

    if ( iVal != iThirdDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iLength) )
    {
       iVal++;
    }

    if ( iVal != iLength )
    {
        return CHECK_ILLEGAL;
    }

    //check the first part of IP
    wxString strFirst = ip.SubString(0, iFirstDot - 1);
    //check the length of each part is less than 3
    if ( strFirst.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iFirstValue = 0;

    strFirst.ToLong(&iFirstValue);

    if ( (iFirstValue <= 0) || (iFirstValue > 223) || (!strFirst.Cmp(_T("*"))) || (!strFirst.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the second part of IP
    wxString strSecond = ip.SubString(iFirstDot + 1, iSecondDot - 1);
    if ( strSecond.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iSecondValue = 0;

    strSecond.ToLong(&iSecondValue);

    if ( (iSecondValue < 0) || (iSecondValue > 255) || (!strSecond.Cmp(_T("*"))) || (!strSecond.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the third part of IP
    wxString strThird = ip.SubString(iSecondDot + 1, iThirdDot - 1);

    if ( strThird.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iThirdValue = 0;

    strThird.ToLong(&iThirdValue);

    if ( (iThirdValue < 0) || (iThirdValue > 255) || (!strThird.Cmp(_T("*"))) || (!strThird.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the fourth part of IP
    wxString strFourth = ip.SubString(iThirdDot + 1, iLength - 1);

    if ( strFourth.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iFourthValue = 0;

    strFourth.ToLong(&iFourthValue);

    if ( (iFourthValue < 0) || (iFourthValue > 255) || (!strFourth.Cmp(_T("*"))) || (!strFourth.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    return CHECK_OK;
}

int ENMUtil::IfMask(wxString ip)
{
    string s = WxStringToString(ip);
    char* str = (char* )s.c_str();

    int iVal = 0;

    int iLength = strlen (str);

    int iFirstDot = 0;

    int iSecondDot = 0;

    int iThirdDot = 0;

    if ( s == "0.0.0.0" )
    {
        return CHECK_ILLEGAL;
    }

    if ( iLength > MAX_IP_ADDRESS )
    {
        return CHECK_ILLEGAL;
    }

    //search the index of three dot in IP address
    //search the first dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iFirstDot =  iVal;
    iVal++;

    //search the second dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iSecondDot = iVal;
    iVal++;

    //search the third dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    iThirdDot = iVal;
    iVal++;

    //search the fourth dot
    while ( (str[iVal] != '.') && (iVal < iLength) )
    {
        iVal++;
    }

    if ( iVal != iLength )
    {
        return CHECK_ILLEGAL;
    }

    iVal = 0;
    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iFirstDot) )
    {
       iVal++;
    }

    if ( iVal != iFirstDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iSecondDot) )
    {
       iVal++;
    }

    if ( iVal != iSecondDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iThirdDot) )
    {
       iVal++;
    }

    if ( iVal != iThirdDot )
    {
        return CHECK_ILLEGAL;
    }

    iVal++;

    while ( (str[iVal] >= '0') && (str[iVal] <= '9') && (iVal < iLength) )
    {
       iVal++;
    }

    if ( iVal != iLength )
    {
        return CHECK_ILLEGAL;
    }

    //check the first part of IP
    wxString strFirst = ip.SubString(0, iFirstDot - 1);
    //check the length of each part is less than 3
    if ( strFirst.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iFirstValue = 0;

    strFirst.ToLong(&iFirstValue);

    if ( (iFirstValue < 0) || (iFirstValue > 255) || (!strFirst.Cmp(_T("*"))) || (!strFirst.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the second part of IP
    wxString strSecond = ip.SubString(iFirstDot + 1, iSecondDot - 1);
    if ( strSecond.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iSecondValue = 0;

    strSecond.ToLong(&iSecondValue);

    if ( (iSecondValue < 0) || (iSecondValue > 255) || (!strSecond.Cmp(_T("*"))) || (!strSecond.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the third part of IP
    wxString strThird = ip.SubString(iSecondDot + 1, iThirdDot - 1);

    if ( strThird.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iThirdValue = 0;

    strThird.ToLong(&iThirdValue);

    if ( (iThirdValue < 0) || (iThirdValue > 255) || (!strThird.Cmp(_T("*"))) || (!strThird.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    //check the fourth part of IP
    wxString strFourth = ip.SubString(iThirdDot + 1, iLength - 1);

    if ( strFourth.length() > MAX_PART_IP )
    {
        return CHECK_ILLEGAL;
    }

    long iFourthValue = 0;

    strFourth.ToLong(&iFourthValue);

    if ( (iFourthValue < 0) || (iFourthValue > 255) || (!strFourth.Cmp(_T("*"))) || (!strFourth.Cmp(_T(""))) )
    {
        return CHECK_ILLEGAL;
    }

    return CHECK_OK;
}

bool ENMUtil::IsAdministrator()
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

      #if defined(__WXMSW__)
    bool bRet = false;
    LPLOCALGROUP_USERS_INFO_0   pBuf   =   NULL;
	DWORD   dwLevel   =   0;
	DWORD   dwFlags   =   LG_INCLUDE_INDIRECT   ;
	DWORD   dwPrefMaxLen   =   -1;
	DWORD   dwEntriesRead   =   0;
	DWORD   dwTotalEntries   =   0;
	NET_API_STATUS   nStatus;
	wchar_t   wbuf[100];
	unsigned   long   dwlen=100;
	GetUserName(wbuf,&dwlen);
	//
	//   Call   the   NetUserGetLocalGroups   function
	//     specifying   information   level   0.
	//
	//     The   LG_INCLUDE_INDIRECT   flag   specifies   that   the
	//       function   should   also   return   the   names   of   the   local
	//       groups   in   which   the   user   is   indirectly   a   member.
	//
	nStatus  =  NetUserGetLocalGroups(
                NULL,
                wbuf,
                dwLevel,
                dwFlags,
                (LPBYTE   *)   &pBuf,
                dwPrefMaxLen,
                &dwEntriesRead,
                &dwTotalEntries);
	//
	//   If   the   call   succeeds,
	//
	if ( nStatus == NERR_Success )
	{
		LPLOCALGROUP_USERS_INFO_0 pTmpBuf;
		DWORD  i;
		DWORD  dwTotalCount = 0;

		if ( (pTmpBuf = pBuf) != NULL )
		{
			//
			//   Loop   through   the   entries   and
			//     print   the   names   of   the   local   groups
			//     to   which   the   user   belongs.
			//
			for ( i = 0; i < dwEntriesRead; i++ )
			{
				assert(pTmpBuf != NULL);

				if ( pTmpBuf == NULL )
				{
					fprintf(stderr, "An access violation has occurred\n");
					break;
				}

				if ( !wcscmp(pTmpBuf->lgrui0_name, _("Administrators")) )
				{
				    bRet = true;
				    break;
				}

				pTmpBuf++;
				dwTotalCount++;
			}
		}
	}
	else
	{
		fprintf(stderr, "A system error has occurred: %d\n", nStatus);
	}
	//
	//   Free   the   allocated   memory.
	//
	if ( pBuf != NULL )
	{
		NetApiBufferFree(pBuf);
	}

    return bRet;
    #endif

    #if defined(__UNIX__)
    wxString wxs = ::wxGetUserId();
    string s(wxs.mb_str(wxConvUTF8));
    if ( "root" == s )
    {
    return true;
    }
    else
    {
        return false;
    }
    #endif

}

wxString ENMUtil::GetCurrentUserAppDataFolder()
{
#if defined(__WXMSW__)
//    wxString strAppDataFolder = _("");
//    TCHAR szPath[MAX_PATH];
//    if(SUCCEEDED(SHGetFolderPath(NULL,
//                                 CSIDL_APPDATA,
//                                 NULL,
//                                 0,
//                                 szPath)))
//    {
//        strAppDataFolder = szPath;
//    }
    wxString homeDir = ::wxGetHomeDir();
    wxString strAppDataFolder = homeDir + wxString(_T("\\Application Data"));

    return strAppDataFolder;
#endif
#if defined(__UNIX__)
     return ::wxGetHomeDir();;
#endif
}

bool ENMUtil::ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns,const wxString& adpter)
{
#if defined(__UNIX__)
//    vector<string> vInterface;
    vector<string> vDns;
//    ifstream finInterface("/etc/network/interfaces");
//    do
//    {
//        string s;
//        getline(finInterface, s);
//        vInterface.push_back(s);
//    }
//    while ( !finInterface.eof() );
//    finInterface.close();
    ifstream finDns("/etc/resolv.conf");
    do
    {
        string s;
        getline(finDns, s);
        vDns.push_back(s);
    }
    while ( !finDns.eof() );
    finDns.close();

//    ofstream foutInterface("/etc/network/interfaces");
    ofstream foutDns("/etc/resolv.conf");
     vector<string>::size_type i;
//    for ( i = 0; i < vInterface.size(); i++ )
//    {
//        if ( string::npos != vInterface.at(i).find(WxStringToString(DataCenter::GetInstance()->GetUsingAdapterName(ADAPTER_WIRED))) && string::npos != vInterface.at(i).find("iface") )
//        {
//            for (int j = i + 1; j < i + 4; j++)
//            {
//                if ( string::npos != vInterface.at(j).find("address") )
//                {
//                    vInterface.at(j) = "address " + WxStringToString(ip);
//                }
//                else if ( string::npos != vInterface.at(j).find("netmask") )
//                {
//                    vInterface.at(j) = "netmask " + WxStringToString(mask);
//                }
//                else
//                {
//                    vInterface.at(j) = "gateway "  + WxStringToString(gateway);
//                }
//            }
//        }
//        if ( i != vInterface.size() - 1 )
//        {
//            foutInterface << vInterface.at(i) << endl;
//        }
//        else
//        {
//            foutInterface << vInterface.at(i);
//        }
//    }
    bool rep = true;
    for ( i = 0; i < vDns.size(); i++ )
    {
        if ( string::npos != vDns.at(i).find("nameserver") )
        {
            if ( rep )
            {
                vDns.at(i) = "nameserver" + WxStringToString(dns);
                rep = false;
            }
        }
        if ( i != vDns.size() - 1 )
        {
            foutDns << vDns.at(i) << endl;
        }
        else
        {
            foutDns << vDns.at(i);
        }
    }
//    foutInterface.close();
    foutDns.close();
//    system("/etc/init.d/networking restart &");//WxStringToString(DataCenter::GetInstance()->GetUsingAdapterName(ADAPTER_WIRED))
    string strIpAndMask = "ifconfig " + WxStringToString(adpter) + " " + WxStringToString(ip) + " netmask " + WxStringToString(mask);
    system(strIpAndMask.c_str());
    string strGateway = "route add default gw " + WxStringToString(gateway);
    system(strIpAndMask.c_str());

#endif
    return true;
}

#if defined(__WXMSW__)
wxString ENMUtil::GetAllUserAppDataFolder()
{
    wxString strAppDataFolder = _T("C:\\Documents and Settings\\Default User\\Application Data");
//    TCHAR szPath[MAX_PATH];
//    if(SUCCEEDED(SHGetFolderPath(NULL,
//                                 CSIDL_COMMON_APPDATA,
//                                 NULL,
//                                 0,
//                                 szPath)))
//    {
//        strAppDataFolder = szPath;
//    }

    return strAppDataFolder;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::StartupWindowsFirewallService()
{
    ShellExecute(NULL,_T("open"),_T("C:\\WINDOWS\\system32\\cmd.exe"),_T("/c   net start \"Windows Firewall/Internet Connection Sharing (ICS)\""),_T(""),SW_HIDE);
    return true;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::StartupWindowsFirewall()
{
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }

    if ( !IsAdministrator() )
        return false;
    static const wxString KEY = _T("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SharedAccess\\Parameters\\FirewallPolicy\\StandardProfile\\");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
    {
//        wxMessageDialog msg(NULL, _("ERROR: key can't be opened!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    reg.SetValue(_T("EnableFirewall"), START_FIREWALL);
    return true;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::StopWindowsFirewall()
{
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }

    if ( !IsAdministrator() )
        return false;
    static const wxString KEY = _T("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\SharedAccess\\Parameters\\FirewallPolicy\\StandardProfile\\");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
    {
//        wxMessageDialog msg(NULL, _("ERROR: key can't be opened!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    reg.SetValue(_T("EnableFirewall"), STOP_FIREWALL);
    return true;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::DisableFileAndPrint()
{
    ShellExecute(NULL,_T("open"),_T("C:\\WINDOWS\\system32\\cmd.exe"),_T("/c   netsh firewall set service type = FILEANDPRINT mode = DISABLE"),_T(""),SW_HIDE);
    return true;
}
#endif

#if defined(__WXMSW__)
bool ENMUtil::EnableFileAndPrint()
{
    ShellExecute(NULL,_T("open"),_T("C:\\WINDOWS\\system32\\cmd.exe"),_T("/c   netsh firewall set service type = FILEANDPRINT mode = ENABLE"),_T(""),SW_HIDE);
    return true;
}
#endif

bool ENMUtil::DisableInternetSharing()
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

    #if defined(__WXMSW__)
    INetSharingManager * pNSM = NULL;
    HRESULT hr = ::CoCreateInstance (__uuidof(NetSharingManager),
    NULL,
    CLSCTX_ALL,
    __uuidof(INetSharingManager),
    (void**)&pNSM);

    // PART 1: find a valid connection
    INetConnection * pNC = NULL; // fill this out for part 2 below

    INetSharingEveryConnectionCollection * pNSECC = NULL;
    hr = pNSM->get_EnumEveryConnection (&pNSECC);
    if (!pNSECC)
    {
//        wxMessageDialog msg(NULL, _("Failed to get EveryConnectionCollection!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
    }
    else
    {
        // enumerate connections
        IEnumVARIANT * pEV = NULL;
        IUnknown * pUnk = NULL;
        hr = pNSECC->get__NewEnum (&pUnk);
        if (pUnk)
        {
            hr = pUnk->QueryInterface (__uuidof(IEnumVARIANT),
            (void**)&pEV);
            pUnk->Release();
        }
        if (pEV)
        {
            VARIANT v;
            VariantInit (&v);
            BOOL bFoundIt = FALSE;
            while (S_OK == pEV->Next (1, &v, NULL))
            {
                if (V_VT (&v) == VT_UNKNOWN)
                {
                    V_UNKNOWN (&v)->QueryInterface (__uuidof(INetConnection),(void**)&pNC);
                    if (pNC)
                    {
                        INetConnectionProps * pNCP = NULL;
                        pNSM->get_NetConnectionProps (pNC, &pNCP);
                        if (!pNCP)
                        {
//                            wxMessageDialog msg(NULL, _("Failed to get NetConnectionProps!"), _("Message!"), wxOK | wxICON_INFORMATION);
//                            msg.ShowModal();
                        }
                        else
                        {
                            // check properties for firewalled or shared connection
                            DWORD dwCharacteristics = 0;
                            pNCP->get_Characteristics (&dwCharacteristics);
                            if (dwCharacteristics & (NCCF_SHARED | NCCF_FIREWALLED))
                            {
                                NETCON_MEDIATYPE MediaType = NCM_NONE;
                                pNCP->get_MediaType (&MediaType);
                                BSTR pbstrName;
                                pNCP->get_DeviceName(&pbstrName);
//                                if ((MediaType != NCM_SHAREDACCESSHOST_LAN) && (MediaType != NCM_SHAREDACCESSHOST_RAS) )
//                                {
//                                    // got a shared/firewalled connection
//                                    bFoundIt = TRUE;
//                                }
                                wxString strName(pbstrName);
                                if ( strName.Contains(_T("Wireless")) || strName.Contains(_T("wireless")) )
                                {
                                    bFoundIt = TRUE;
                                }
                            }
                            pNCP->Release();
                        }
                        if (bFoundIt == FALSE)
                        {
                            pNC->Release();
                            pNC = NULL;
                        }
                    }
                }
                VariantClear (&v);
                if (bFoundIt == TRUE)
                {
                    break;
                }
            }
            pEV->Release();
        }
        pNSECC->Release();
    }
    if (pNC == NULL)
    {
//        wxMessageDialog msg(NULL, _("Failed to find a valid connection!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    INetSharingConfiguration * pNSC = NULL;
    hr = pNSM->get_INetSharingConfigurationForINetConnection (pNC, &pNSC);
    pNC->Release(); // don\'t need this anymore
    if (!pNSC)
    {
//        wxMessageDialog msg(NULL, _("Cannot make INetSharingConfiguration object!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }

    pNSC->DisableSharing();
    pNSC->Release();
    CoUninitialize ();
    return true;
    #endif

    #if defined(__UNIX__)
    return true;
    #endif
}


bool ENMUtil::EnableInternetSharing()
{

    #if defined(__WXMSW__)
    INetSharingManager * pNSM = NULL;
    HRESULT hr = ::CoCreateInstance (__uuidof(NetSharingManager),
    NULL,
    CLSCTX_ALL,
    __uuidof(INetSharingManager),
    (void**)&pNSM);

    // PART 1: find a valid connection
    INetConnection * pNC = NULL; // fill this out for part 2 below

    INetSharingEveryConnectionCollection * pNSECC = NULL;
    hr = pNSM->get_EnumEveryConnection (&pNSECC);
    if (!pNSECC)
    {
//        wxMessageDialog msg(NULL, _("Failed to get EveryConnectionCollection!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
    }
    else
    {
        // enumerate connections
        IEnumVARIANT * pEV = NULL;
        IUnknown * pUnk = NULL;
        hr = pNSECC->get__NewEnum (&pUnk);
        if (pUnk)
        {
            hr = pUnk->QueryInterface (__uuidof(IEnumVARIANT),
            (void**)&pEV);
            pUnk->Release();
        }
        if (pEV)
        {
            VARIANT v;
            VariantInit (&v);
            BOOL bFoundIt = FALSE;
            while (S_OK == pEV->Next (1, &v, NULL))
            {
                if (V_VT (&v) == VT_UNKNOWN)
                {
                    V_UNKNOWN (&v)->QueryInterface (__uuidof(INetConnection),(void**)&pNC);
                    if (pNC)
                    {
                        INetConnectionProps * pNCP = NULL;
                        pNSM->get_NetConnectionProps (pNC, &pNCP);
                        if (!pNCP)
                        {
//                            wxMessageDialog msg(NULL, _("Failed to get NetConnectionProps!"), _("Message!"), wxOK | wxICON_INFORMATION);
//                            msg.ShowModal();
                        }
                        else
                        {
                            // check properties for firewalled or shared connection
                            DWORD dwCharacteristics = 0;
                            pNCP->get_Characteristics (&dwCharacteristics);
                            if (dwCharacteristics & (NCCF_SHARED | NCCF_FIREWALLED))
                            {
                                NETCON_MEDIATYPE MediaType = NCM_NONE;
                                pNCP->get_MediaType (&MediaType);
                                BSTR pbstrName;
                                pNCP->get_DeviceName(&pbstrName);
//                                if ((MediaType != NCM_SHAREDACCESSHOST_LAN) && (MediaType != NCM_SHAREDACCESSHOST_RAS) )
//                                {
//                                    // got a shared/firewalled connection
//                                    bFoundIt = TRUE;
//                                }
                                wxString strName(pbstrName);
                                if ( strName.Contains(_T("Wireless")) || strName.Contains(_T("wireless")) )
                                {
                                    bFoundIt = TRUE;
                                }
                            }
                            pNCP->Release();
                        }
                        if (bFoundIt == FALSE)
                        {
                            pNC->Release();
                            pNC = NULL;
                        }
                    }
                }
                VariantClear (&v);
                if (bFoundIt == TRUE)
                {
                    break;
                }
            }
            pEV->Release();
        }
        pNSECC->Release();
    }
    if (pNC == NULL)
    {
//        wxMessageDialog msg(NULL, _("Failed to find a valid connection!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    INetSharingConfiguration * pNSC = NULL;
    hr = pNSM->get_INetSharingConfigurationForINetConnection (pNC, &pNSC);
    pNC->Release(); // don\'t need this anymore
    if (!pNSC)
    {
//        wxMessageDialog msg(NULL, _("Cannot make INetSharingConfiguration object!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }

    pNSC->EnableSharing(ICSSHARINGTYPE_PUBLIC);
    pNSC->Release();
    CoUninitialize ();
    return true;
    #endif

    #if defined(__UNIX__)
    return true;
    #endif
}

bool ENMUtil::AutoRunApp(string strAppPath)
{
#if defined(__WXMSW__)
    ShellExecute(NULL, _T("open"), wxString::FromUTF8(strAppPath.c_str()), _T(""), _T(""), SW_SHOWNORMAL);
#endif
#if defined(__UNIX__)
    string s = strAppPath + " &";
    system(s.c_str());
#endif
    return true;
}

bool ENMUtil::OverwriteHomePage(string strHomePage)
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

#if defined(__WXMSW__)
//    if ( !IsAdministrator() )
//        return false;
    static const wxString KEY = _T("HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Main");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
    {
//        wxMessageDialog msg(NULL, _("ERROR: key can't be opened!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    reg.SetValue(_T("Start Page"), wxString::FromUTF8(strHomePage.c_str()));
    return true;
#endif

#if defined(__UNIX__)
    wxString wxstrHomePage = wxString::FromUTF8(strHomePage.c_str());
    int confirm = wxID_YES;
    while ( IsFirefoxRunning() && confirm == wxID_YES )
    {
        wxMessageDialog msg(NULL, _("Firefox is running. \nPlease shut down Firefox and press OK.!"), _("Confirm!"), wxYES_NO | wxICON_QUESTION);
        confirm = msg.ShowModal();
    }
    if ( confirm != wxID_YES )
        return false;

    wxString prefsFile = GetFirefoxConfigFile();
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
    const char* fileName = WxStringToString(prefsFile).c_str();
    ifstream fin(fileName);
    while ( !fin.eof() )
    {
        char buf[1024] = { 0 };
        fin.getline(buf, 1024);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"browser.startup.homepage\", \"")) )
        {
            s = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        }
        arrayString.Add(s);
    }
    fin.close();
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.Count() - 1; i++ )
    {
        fout << WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
#endif
}

bool ENMUtil::OverwriteProxy(string strProxy, string strPort)
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

#if defined(__WXMSW__)
//    if ( !IsAdministrator() )
//        return false;
    static const wxString KEY = _T("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
    {
//        wxMessageDialog msg(NULL, _("ERROR: key can't be opened!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    reg.SetValue(_T("ProxyServer"), wxString::FromUTF8(strProxy.c_str()) + _T(":") + wxString::FromUTF8(strPort.c_str()));
    return true;
#endif

#if defined(__UNIX__)
    wxString wxstrProxy = wxString::FromUTF8(strProxy.c_str());
    wxString wxstrPort = wxString::FromUTF8(strPort.c_str());
    int confirm = wxID_YES;
    while ( IsFirefoxRunning() && confirm == wxID_YES )
    {
        wxMessageDialog msg(NULL, _("Firefox is running. \nPlease shut down Firefox and press OK.!"), _("Confirm!"), wxYES_NO | wxICON_QUESTION);
        confirm = msg.ShowModal();
    }
    if ( confirm != wxID_YES )
        return false;

    wxString prefsFile = GetFirefoxConfigFile();
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
    const char* fileName = WxStringToString(prefsFile).c_str();
    ifstream fin(fileName);
    while ( !fin.eof() )
    {
        char buf[1024] = { 0 };
        fin.getline(buf, 1024);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"network.proxy.http\", \"")) )
        {
            s = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        }
        else if ( s.StartsWith(_T("user_pref(\"network.proxy.http_port\", ")) )
        {
            s = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        }
        arrayString.Add(s);
    }
    fin.close();
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.Count() - 1; i++ )
    {
        fout << WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
#endif
}


bool ENMUtil::Enable8021xAuthentication(bool isEnable)
{
    #if defined(__WXMSW__)
    wxLocale m_locale;
    m_locale.AddCatalogLookupPathPrefix(wxT("resource"));
    if (true == wxFileExists(::wxGetApp().strAppPath + wxT("resource\\resource.mo")))
    {
       m_locale.AddCatalog(wxT("resource"));
    }
    #endif

#if defined(__WXMSW__)
    if ( !IsAdministrator() )
        return false;
    static const wxString KEY = _T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\NetworkCards\\");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
    {
//        wxMessageDialog msg(NULL, _("ERROR: key can't be opened!"), _("Message!"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    size_t nSubKeys, nValues;
    if ( reg.GetKeyInfo(&nSubKeys, NULL, &nValues, NULL) )
    {
        wxPrintf(_T("It has %u subkeys and %u values.\n"), nSubKeys, nValues);
    }
    long dummy = 1;
    wxString value;
    bool cont = reg.GetFirstKey(value, dummy);
    while ( cont )
    {
        wxRegKey key(KEY + value);
        if ( !key.Exists() )
        {
            cont = reg.GetNextKey(value, dummy);
            continue;
        }

        if ( !key.HasValue(_T("ServiceName")) )
        {
            cont = reg.GetNextKey(value, dummy);
            continue;
        }

        if ( !key.HasValue(_T("Description")) )
        {
            cont = reg.GetNextKey(value, dummy);
            continue;
        }
        wxString keyServName;
        wxString keyDescription;

        key.QueryValue(_T("ServiceName"),keyServName);
        key.QueryValue(_T("Description"),keyDescription);

        if ( !keyDescription.Contains(_T("Wireless")) && !keyDescription.Contains(_T("wireless")) )
        {
            wxRegKey keyConn(_T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\EAPOL\\Parameters\\Interfaces\\") + keyServName);
            if ( !keyConn.Exists() )
            {
                keyConn.Create();
            }
            if ( keyConn.Open(wxRegKey::Read) )
            {
                wxMemoryBuffer buffer(REG801X_LENGTH);

                if ( isEnable )
                {
                    buffer.AppendData(ENABLE_8021X, REG801X_LENGTH);
                    keyConn.SetValue(_T("1"), buffer);
                }
                else
                {
                    buffer.AppendData(DISABLE_8021X, REG801X_LENGTH);
                    keyConn.SetValue(_T("1"), buffer);
                }
            }

        }
        cont = reg.GetNextKey(value, dummy);
    }
    return true;
#endif

#if defined(__UNIX__)
    vector<string> vInit;
    vector<string> vDefault;
    wxString wxStr = _T("/usr/sbin/xsupplicant");
    if ( !wxFile::Exists(wxStr) )
    {
        return false;
    }
    ifstream finInit("/etc/init.d/xsupplicant");
    do
    {
        string s;
        getline(finInit, s);
        vInit.push_back(s);
    }
    while ( !finInit.eof() );
    finInit.close();

    ifstream finDefault("/etc/default/xsupplicant");
    do
    {
        string s;
        getline(finDefault, s);
        vDefault.push_back(s);
    }
    while ( !finDefault.eof() );
    finDefault.close();

    ofstream foutInit("/etc/init.d/xsupplicant");
    ofstream foutDefault("/etc/default/xsupplicant");
    vector<string>::size_type i;
    for ( i = 0; i < vInit.size(); i++ )
    {
        if ( string::npos != vInit.at(i).find("ENABLED=") )
        {
            if ( isEnable )
            {
                vInit.at(i) = "ENABLED=1";
            }
            else
            {
                vInit.at(i) = "ENABLED=0";
            }

        }
        if ( i != vInit.size() - 1 )
        {
            foutInit << vInit.at(i) << endl;
        }
        else
        {
            foutInit << vInit.at(i);
        }
    }
    for ( i = 0; i < vDefault.size(); i++ )
    {
        if ( string::npos != vDefault.at(i).find("ENABLED=") )
        {
            if ( isEnable )
            {
                vDefault.at(i) = "ENABLED=1";
            }
            else
            {
                vDefault.at(i) = "ENABLED=0";
            }
        }
        if ( i != vDefault.size() - 1 )
        {
            foutDefault << vDefault.at(i) << endl;
        }
        else
        {
            foutDefault << vDefault.at(i);
        }
    }
    finInit.close();
    foutDefault.close();
    if ( isEnable )
    {
        system("gksu /etc/init.d/xsupplicant start");
    }
    else
    {
        system("gksu /etc/init.d/xsupplicant stop");
    }

#endif
}

#if defined(__UNIX__)
wxString ENMUtil::GetFirefoxConfigFile()
{
    wxString firefoxDir = ::wxGetHomeDir() + _T("/.mozilla/firefox");
    wxString profile = firefoxDir + _T("/profiles.ini");
    if ( !wxFile::Exists(profile) )
        return _T("");

    ifstream fin(WxStringToString(profile).c_str());
    wxArrayString arrayString;
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
    //    getline(fin, buf);
        fin.getline(buf, 256);
        arrayString.Add(wxString::FromUTF8(buf));
    }
    fin.close();
    wxString pref;
    for ( size_t i = 0; i < arrayString.Count(); i++ )
    {
        wxString s = arrayString.Item(i);
        if ( s.StartsWith(_T("Path=")) )
        {
            pref = s.Mid(s.Find('=', false) + 1);
        }
    }
    return ::wxGetHomeDir() + _T("/.mozilla/firefox/") + pref + _T("/prefs.js");
}

bool ENMUtil::IsFirefoxRunning()
{
    system("ps -A|grep \"firefox\" > /tmp/_firefox.tmp");
    wxString tmpFile = _T("/tmp/_firefox.tmp");
    if ( !wxFile::Exists(tmpFile) )
        return false;

    wxFile file(tmpFile);
    bool result = file.Length() > 0;
    file.Close();
    return result;
}
#endif


bool ENMUtil::IsGuest()
{
    #if defined(__WXMSW__)
    bool bRet = false;
    wchar_t   wbuf[100];
	unsigned   long   dwlen=100;
	GetUserName(wbuf,&dwlen);
	wxString strUserName = wxString(wbuf, wxConvUTF8);
	if ( !strUserName.Cmp(_T("Guest")) )
	{
	    bRet = true;
	}

	return bRet;
    #endif

    #if defined(__UNIX__)
    return false;
    #endif
}

void ENMUtil::Log(const wxString& file, const wxString& log)
{
#if defined(__WXDEBUG__)
    wxFile f(file, wxFile::write_append);
    f.Write(log + wxT("\n"));
    f.Close();
#endif
}
