/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef GAUGEDIALOG_H
#define GAUGEDIALOG_H

#include "BitmapDialog.h"
#include <wx/stattext.h>
#include <wx/gauge.h>
#include <wx/timer.h>

class GaugeDialog: public wxBitmapDialog
{
public:
    //ctor
    GaugeDialog(wxWindow* parent, wxWindowID id = wxID_ANY);
    //dtor
    virtual ~GaugeDialog();
    //set label
    void SetProcessLabel(const wxString& label);
    //overwrite show function
    virtual bool Show(bool show = true);

private:
    static wxBitmap m_bgBitmap;
    wxStaticText* m_stxLabel;
    wxGauge* m_gauge;
    wxTimer m_timer;

    static const long ID_GAUGE;
    static const long ID_STATICTEXT_LABEL;
    static const int ID_TIMER;
    //init
    void OnInit(wxInitDialogEvent& event);
    //timer call
    void OnTimer(wxTimerEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif
