/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "SchoolSettingImporter.h"
#include "FileTar.h"
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/timer.h>
#if defined(__WXMSW__)
#include <ENM/ENMApi.h>
#else
#include <sdk/ENMApi.h>
#include <ENMDef.h>
#endif

#if defined(__WXMSW__)
const wxString SchoolSettingImporter::destDir = _T("C:\\Documents and Settings\\Default User\\Application Data\\Network Neighborhood");
#else
const wxString SchoolSettingImporter::destDir = _T("/etc/Network Neighborhood");
#endif

BEGIN_EVENT_TABLE(SchoolSettingImporter, wxEvtHandler)
END_EVENT_TABLE()

SchoolSettingImporter::SchoolSettingImporter()
        : wxEvtHandler(), m_iCount(::wxGetUTCTime())
{
    m_strTempDir = wxFileName::GetTempDir() + wxFileName::GetPathSeparator() + _T("enm");
    wxFileName::Mkdir(m_strTempDir, 0755, wxPATH_MKDIR_FULL);
}

SchoolSettingImporter::~SchoolSettingImporter()
{
    ClearTempDir(m_strTempDir);
}

void SchoolSettingImporter::ClearTempDir(const wxString& dir)
{
    if ( !wxFileName::DirExists(dir) )
        return;

    // remove all files
    wxArrayString as;
    size_t nCount = wxDir::GetAllFiles(dir, &as, wxEmptyString, wxDIR_FILES | wxDIR_HIDDEN);
    if ( nCount != (size_t)-1 )
    {
        for ( size_t i = 0; i < nCount; i++ )
        {
            ::wxRemoveFile(as.Item(i));
        }
    }

    // remove all subdirectories
    wxDir tempDir(dir);
    wxString subDir;
    bool found = tempDir.GetFirst(&subDir, wxEmptyString, wxDIR_DIRS);
    while ( found )
    {
        ClearTempDir(dir + wxFileName::GetPathSeparator() + subDir);
        found = tempDir.GetNext(&subDir);
    }

    // remove this directory
    wxFileName::Rmdir(dir);
}

int SchoolSettingImporter::ConfirmOverwrite(const wxString& strFileName)
{
    wxString suffix(_T(".profile"));
    if ( strFileName.Find(suffix) + suffix.Length() != strFileName.Length() )
        return wxID_YES;

    wxString message = strFileName + _(" already exists. \n\nAre you sure you want to overwrite it?");
    wxMessageDialog dlg(NULL, message, wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_EXCLAMATION);
    return dlg.ShowModal();
}

bool SchoolSettingImporter::ImportSchoolSetting(const wxString& strTarFile, wxArrayString* pasFailed)
{
    bool result = false;
    // depress the tar file to a temp directory
    wxString strImportDir = m_strTempDir + wxFileName::GetPathSeparator() + wxString::Format(_T("%d"), m_iCount++);
    wxString strDirWithSep = strImportDir + wxFileName::GetPathSeparator();
    wxFileName::Mkdir(strImportDir, 0777, wxPATH_MKDIR_FULL);
    if ( FileTar::UnTar(strTarFile, strDirWithSep) == 0 )
    {
        result = true;
        // copy files from temp directory to the directory of global profiles
        wxArrayString as;
        wxDir::GetAllFiles(strImportDir, &as, wxEmptyString, wxDIR_FILES | wxDIR_HIDDEN);
        for ( size_t i = 0; i < as.Count(); i++ )
        {
            wxString name, ext;
            wxFileName::SplitPath(as.Item(i), NULL, NULL, &name, &ext);
            wxString file = name + _T(".") + ext;
            if ( !wxFileName::FileExists(destDir + wxFileName::GetPathSeparator() + file) || ConfirmOverwrite(file) == wxID_YES )
            {
                ENM_String srcFile;
                memset(&srcFile, 0, sizeof(ENM_String));
                strcpy((char*)srcFile.dcsString, wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(as.Item(i).c_str())));
                DCS_Return_Code dcsRet = DCS_WriteFile(&srcFile);
                if ( dcsRet != DCS_SUCCESS )
                {
                    result = false;
                    if ( pasFailed != NULL )
                        pasFailed->Add(file);
                }
//                result &= ::wxCopyFile(as.Item(i), destDir + wxFileName::GetPathSeparator() + file, true);
            }
        }
    }
    ClearTempDir(strImportDir);
    return result;
}
