# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Guido Amoruso <guidonte@fluendo.com>


from storm.locals import Unicode, Int, DateTime

from elisa.core.media_uri import MediaUri, quote
from elisa.core.common import application


# FIXME: the actual schema description was put into the file
# elisa/plugins/database/media_scanner.py, because we needed a mechanism to do
# changes to the database schema: as we didn't find a better solution, we
# preferred to put all the ugly stuff together.

class FavoritesItem(object):
    """Favorites item"""

    __storm_table__ = "favorites"

    id = Int(primary=True)
    added_time = DateTime()
    section = Unicode() # music / video / pictures
    title = Unicode() # short description
    subtitle = Unicode() # description details

    foreign_id = Unicode()
    foreign_class = Unicode()
    uri = Unicode ()
    # music_album, music_track, photo_album, photo, and maybe other needed
    # values
    type = Unicode ()


if __name__ == '__main__':
    """Quick testing"""
    from elisa.core.application import CONFIG_DIR
    from elisa.plugins.database.models import *
    from elisa.plugins.database.media_scanner import SCHEMA
    from storm.locals import *
    import sys
    import os.path

    if '--elisa' in sys.argv[1:]:
        dbfile = os.path.join(CONFIG_DIR, 'elisa.db').replace('\\', '/')
        database = create_database("sqlite:" + dbfile)
    else:
        database = create_database("sqlite:")

    store = Store(database)

    if '--overwrite' in sys.argv[1:]:
        store.execute("DROP TABLE IF EXISTS favorites;")
        store.commit()

    for stmt in SCHEMA:
        try:
            store.execute(stmt)
        except Exception, e:
            print "Error executing statement '%s': %s" % (stmt, e)

    store.commit()

    import IPython
    IPython.Shell.IPShellGTK([], locals()).mainloop()

