# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
On-screen keyboard widget.
"""

from pgm.timing import implicit

from elisa.plugins.pigment.widgets.theme import Theme

from elisa.plugins.pigment.widgets.osk import OnScreenKeyboard, Key
from elisa.plugins.poblesec.widgets.sliced_image import SlicedImageHorizontal


class OSK(OnScreenKeyboard):

    """
    On-screen keyboard widget.
    """

    def set_selector(self):
        # Fancy selector
        self._selector = SlicedImageHorizontal()
        self.add(self._selector)
        theme = Theme.get_default()
        left_cap = theme.get_resource('elisa.plugins.poblesec.selector_left_cap')
        right_cap = theme.get_resource('elisa.plugins.poblesec.selector_right_cap')
        body = theme.get_resource('elisa.plugins.poblesec.selector_body')
        self._selector.left_cap.set_from_file(left_cap)
        self._selector.right_cap.set_from_file(right_cap)
        self._selector.body.set_from_file(body)
        self._selector.position = self.current_key.widget.position
        self._selector.size = self.current_key.widget.size
        self._animated_selector = implicit.AnimatedObject(self._selector)
        settings = {'duration': 300,
                    'transformation': implicit.DECELERATE,
                    'resolution': 5}
        self._animated_selector.setup_next_animations(**settings)
