# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.media_uri import MediaUri
from elisa.core.common import application
from elisa.core.resource_manager import NoMatchingResourceProvider

from elisa.core.utils.i18n import install_translation

from twisted.internet import defer
from elisa.plugins.poblesec.link import Link
from elisa.plugins.poblesec.actions import GoToNode, GoToAction

_ = install_translation('poblesec')


def try_login(username, password):
    uri = MediaUri('http://api.yes.fm/v1/auth/login')
    try:
        dfr = application.resource_manager.post(uri, user=username, password=password)
    except NoMatchingResourceProvider:
        return defer.fail()

    def check_login(result):
        if result.success:
            uri = MediaUri('http://api.yes.fm/')
            userkey = result.userkey
            sessionkey = result.sessionkey
            # loosing a deferred we don't care
            application.resource_manager.post(uri, userkey=userkey, sessionkey=sessionkey)
        return result.success

    dfr.addCallback(check_login)

    return dfr


def yesfm_settings_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/settings/yesfm/username"
    link.label = _("Yes.fm Account")
    link.icon = "elisa.plugins.yesfm.logo"

    login_actions = []

    music_section_action = GoToAction(controller)
    music_section_action.label = _("Go To Music Section")
    music_section_node = GoToNode()
    music_section_node.path = '/poblesec/music_menu'
    music_section_node.title = _("Music")
    music_section_action.nodes.append(music_section_node)
    login_actions.append(music_section_action)

    search_music_action = GoToAction(controller)
    search_music_action.label = _('Search Music')
    search_music_node = GoToNode()
    search_music_node.path = '/poblesec/search/music'
    search_music_node.args = {'mediatype': 'music'}
    search_music_node.title = _('Search')
    search_music_action.nodes.append(search_music_node)
    login_actions.append(search_music_action)

    link.controller_args = {
        'service': 'YesFM',
        'password_controller': '/poblesec/settings/yesfm/password',
        'login_result_controller': '/poblesec/settings/yesfm/login_result',
        'try_login': try_login,
        'login_actions': login_actions}

    controller.model.append(link)

    return defer.succeed(None)
