# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph.image import Image

from elisa.plugins.poblesec.widgets.loadable_mixin import LoadableMixin

import pgm
import gobject


class MenuItemWidget(Widget, LoadableMixin):

    loading_attribute = 'icon'

    def __init__(self):
        super(MenuItemWidget, self).__init__()
        self._create_widgets()
        self._update_style_properties(self._style.get_items())

    def _create_widgets(self):
        label = Text()
        self.label = label
        self.add(label)
        label.weight = pgm.TEXT_WEIGHT_BOLD
        label.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        label.bg_a = 0

        icon = Image()
        self.icon = icon
        self.add(icon)
        icon.bg_a = 0

        label.visible = True
        icon.visible = True

    def _update_style_properties(self, props=None):
        super(MenuItemWidget, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'font-family':
                self.label.font_family = value
            elif key == 'label-x':
                self.label.x = value
            elif key == 'label-y':
                self.label.y = value
            elif key == 'label-width':
                self.label.width = value
            elif key == 'label-height':
                self.label.height = value
            elif key == 'icon-x':
                self.icon.x = value
            elif key == 'icon-y':
                self.icon.y = value
            elif key == 'icon-width':
                self.icon.width = value
            elif key == 'icon-height':
                self.icon.height = value


class MenuItemWidgetWithAction(MenuItemWidget):

    __gsignals__ = {
        'action': (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        }

    def _create_widgets(self):
        super(MenuItemWidgetWithAction, self)._create_widgets()

        #FIXME use a button instead of two drawable
        self.action_image = Image()
        self.action_image.bg_a = 0
        self.action_image.connect('clicked', self._action_clicked)
        self.add(self.action_image, forward_signals=False)

        self.action_image.visible = True

    def _action_clicked(self, *args):
        self.emit('action', None)

    def _update_style_properties(self, props=None):
        super(MenuItemWidgetWithAction, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'action-x':
                self.action_image.x = value
            elif key == 'action-y':
                self.action_image.y = value
            elif key == 'action-width':
                self.action_image.width = value
            elif key == 'action-height':
                self.action_image.height = value


class DoubleLineMenuItemWidget(MenuItemWidget):

    def _create_widgets(self):
        super(DoubleLineMenuItemWidget, self)._create_widgets()
        sublabel = Text()
        self.sublabel = sublabel
        self.add(sublabel)
        sublabel.weight = pgm.TEXT_WEIGHT_NORMAL
        sublabel.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        sublabel.bg_a = 0
        sublabel.fg_color = (195, 194, 194, 255)
        sublabel.visible = True


    def _update_style_properties(self, props=None):
        super(DoubleLineMenuItemWidget, self)._update_style_properties(props)

        if props is None:
            return

        for key, value in props.iteritems():
            if key == 'font-family':
                self.label.font_family = value
            elif key == 'label-x':
                self.label.x = value
            elif key == 'label-y':
                self.label.y = value
            elif key == 'label-width':
                self.label.width = value
            elif key == 'label-height':
                self.label.height = value
            elif key == 'sublabel-x':
                self.sublabel.x = value
            elif key == 'sublabel-y':
                self.sublabel.y = value
            elif key == 'sbutitle-width':
                self.sublabel.width = value
            elif key == 'sublabel-height':
                self.sublabel.height = value
            elif key == 'icon-x':
                self.icon.x = value
            elif key == 'icon-y':
                self.icon.y = value
            elif key == 'icon-width':
                self.icon.width = value
            elif key == 'icon-height':
                self.icon.height = value
