# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Capabilities are additional services built on top of resource providers.
"""

__maintainer__ = 'Olivier Tilloy <olivier@fluendo.com>'
__maintainer2__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.core.component import Component

class Capability(Component):

    """
    A capability is an additional service built on top of a resource provider,
    such as metadata retrieval or advanced search facilities. Because of this
    a capability always has a reference to a
    L{elisa.core.components.resource_provider.ResourceProvider}.

    Each capability's API is tailored for specific needs.
    That API is used by a corresponding L{elisa.core.manager.Manager} that
    decides on the capabilities to forward the request to.
    A capability translates such a request into a call to its provider's API.

    @ivar provider: the provider this capability belongs to
    @type provider: L{elisa.core.components.resource_provider.ResourceProvider}
    """

    # When writing a new capability, don't forget that the provider needs to be
    # set manually in the initialize() method.
