/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "WlanScanner.h"
#include "ProfileManagementControl.h"
#include "ProfileManagerDlg.h"
#include "PolicyManager.h"
#include "DataCenter.h"
#include "MeshUseOthersInternetDlg.h"
#include "MeshShareMyInternetDlg.h"
#include "MeshConfigurationDlg.h"
#include "MeshInfoManager.h"
#include "ViewMeshNeighborsDlg.h"

#if defined(__UNIX__)
#include "DataCenterLinux.h"
#endif

DataCenter* DataCenter::m_pDataCenter = NULL;

BEGIN_EVENT_TABLE(DataCenter, wxEvtHandler)
END_EVENT_TABLE()

DataCenter::DataCenter()
{
    m_pNetworkManagerDlg = NULL;
    m_pScanNetworkDlg = NULL;
    m_pProfileController = NULL;
    m_pProfileManagerDlg = NULL;
    m_pPolicyManager = NULL;
    m_pMeshUseOthersInternetDlg = NULL;
    m_pMeshShareMyInternetDlg = NULL;
    m_pMeshConfigurationDlg = NULL;
    m_pViewMeshNeighborsDlg = NULL;
    m_isSessionLocked = false;

}

DataCenter::~DataCenter()
{
    DestroyData();
}

DataCenter* DataCenter::GetInstance()
{
    if ( m_pDataCenter == NULL )
    {
#if defined(__UNIX__)
        m_pDataCenter = new DataCenterLinux();
#endif
    }
    return m_pDataCenter;
}

void DataCenter::InitData()
{
    CreateWnd();
}

void DataCenter::DestroyData()
{
    if ( NULL != m_pNetworkManagerDlg )
    {
        delete m_pNetworkManagerDlg ;
        m_pNetworkManagerDlg = NULL;
    }
    if ( NULL !=  m_pScanNetworkDlg )
    {
        delete m_pScanNetworkDlg ;
        m_pScanNetworkDlg = NULL;
    }
    if ( NULL !=  m_pProfileManagerDlg )
    {
        delete m_pProfileManagerDlg ;
        m_pProfileManagerDlg = NULL;
    }
    if ( NULL !=  m_pProfileController )
    {
        delete m_pProfileController ;
        m_pProfileController = NULL;
    }
    if ( NULL !=  m_pPolicyManager )
    {
        delete m_pPolicyManager ;
        m_pPolicyManager = NULL;
    }
    if ( NULL != m_pMeshUseOthersInternetDlg)
    {
        delete m_pMeshUseOthersInternetDlg;
        m_pMeshUseOthersInternetDlg = NULL;
    }
    if ( NULL != m_pMeshShareMyInternetDlg )
    {
        delete m_pMeshShareMyInternetDlg;
        m_pMeshShareMyInternetDlg = NULL;
    }
    if ( NULL != m_pMeshConfigurationDlg )
    {
        delete m_pMeshConfigurationDlg;
        m_pMeshConfigurationDlg = NULL;
    }
    if ( NULL != m_pViewMeshNeighborsDlg )
    {
        delete m_pViewMeshNeighborsDlg;
        m_pViewMeshNeighborsDlg = NULL;
    }
}

void DataCenter::CreateWnd()
{
    if ( NULL == m_pNetworkManagerDlg )
    {
        m_pNetworkManagerDlg = new NetworkManagerDlg(NULL);
    }
    if ( NULL == m_pScanNetworkDlg )
    {
        m_pScanNetworkDlg = new ScanNetworkDlg(NULL);
    }
    if ( NULL == m_pProfileManagerDlg )
    {
        m_pProfileManagerDlg = new ProfileManagerDlg(NULL);
    }
    if ( NULL == m_pProfileController )
    {
        m_pProfileController = new ProfileManagementControl();
    }
    if ( NULL == m_pPolicyManager )
    {
        m_pPolicyManager = new PolicyManager();
        m_pPolicyManager->ReloadPolicy();
    }
    if ( NULL == m_pMeshUseOthersInternetDlg )
    {
        m_pMeshUseOthersInternetDlg = new MeshUseOthersInternetDlg(NULL);
    }
    if ( NULL == m_pMeshShareMyInternetDlg )
    {
        m_pMeshShareMyInternetDlg = new MeshShareMyInternetDlg(NULL);
    }
    if ( NULL == m_pMeshConfigurationDlg )
    {
        m_pMeshConfigurationDlg = new MeshConfigurationDlg(NULL);
    }
    if ( NULL == m_pViewMeshNeighborsDlg )
    {
        m_pViewMeshNeighborsDlg = new ViewMeshNeighborsDlg(NULL);
    }
}

void DataCenter::SessionLock()
{
    if ( !m_isSessionLocked )
    {
        m_isSessionLocked = true;
        StopGlobalTimer();
    }
}

void DataCenter::SessionUnlock(bool disconnect)
{
    if ( m_isSessionLocked == disconnect )
    {
        m_isSessionLocked = false;
        ProfileEvent event(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
        ::wxPostEvent(GetNetworkManagerDlgHandle(), event);
    }
}

void DataCenter::ReloadSchoolPolicy()
{
    if ( m_pPolicyManager != NULL )
    {
        m_pPolicyManager->ReloadPolicy();
    }
}
