/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "DeployThread.h"
#include <ace/Event_Handler.h>
#include <ace/Log_Msg.h>
#include <ace/OS.h>
#include <ace/Reactor.h>
#include <ace/Signal.h>
#include <ace/streams.h>
#include <ace/Thread_Manager.h>
#include <ace/TP_Reactor.h>

#include <ace/SOCK_Acceptor.h>
#include <ace/SOCK_Connector.h>
#include <ace/SOCK_Stream.h>
#include <ace/streams.h>
#include <ace/Auto_Ptr.h>
#include <ace/INET_Addr.h>
#include <ace/SSL/SSL_SOCK_Connector.h>
#include <string>
using namespace std;
#include "AcceptHandler.h"
#include "ENMApp.h"
#include "ENMUtil.h"

static wxString dcLogFileDeployThread(_T("C:\\DeployThread.log"));

ACE_THR_FUNC_RETURN threadFunc(void *arg) {
    ACE_TRACE("threadFunc(void *)");

    ACE_Reactor *reactor = (ACE_Reactor *) arg;
    reactor->run_reactor_event_loop();

    return 0;
}

int RunServer(){
     ENMUtil::Log(dcLogFileDeployThread, _T("RunServer() in;"));

    // create a reactor from a TP reactor
    ACE_TP_Reactor tpReactor;
    ACE_Reactor reactor(&tpReactor);

    // create a new accept handler using that reactor
    AcceptHandler *acceptHandler = 0;
    ACE_NEW_NORETURN (acceptHandler, AcceptHandler(&reactor));
    if (acceptHandler == 0)
      ACE_ERROR_RETURN((LM_ERROR, ACE_TEXT("%N:%l: Failed to allocate ")
                        ACE_TEXT ("accept handler. (errno = %i: %m)\n"), errno), -1);

    // open the accept handler
    if (acceptHandler->open() == -1) {
        delete acceptHandler;
        ACE_ERROR_RETURN((LM_ERROR, ACE_TEXT("%N:%l: Failed to open accept ")
                          ACE_TEXT ("handler. Exiting.\n")), -1);
    }

    ENMUtil::Log(dcLogFileDeployThread, _T("acceptHandler->open()"));
    // spawn some threads which run the reactor event loop(s)
    ACE_Thread_Manager::instance()->spawn_n(1, threadFunc, &reactor);

    ENMUtil::Log(dcLogFileDeployThread, _T("ACE_Thread_Manager::instance()->spawn_n"));
    // let the thread manager wait for all threads
    ACE_Thread_Manager::instance()->wait();

    ACE_DEBUG((LM_DEBUG, ACE_TEXT("Bye. Bye.\n")));
    ENMUtil::Log(dcLogFileDeployThread, _T("RunServer() end;"));
    return 0;
}

DeployThread::DeployThread():wxThread(wxTHREAD_JOINABLE)
{

}

void *DeployThread::Entry()
{
    ENMUtil::Log(dcLogFileDeployThread, _T("DeployThread::Entry()"));
    ACE::init();
    RunServer();
    ENMUtil::Log(dcLogFileDeployThread, _T("RunServer();"));
    return NULL;
}

void DeployThread::OnExit()
{
    printf("m_critsectDeploy.Leave \n");
}

