/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "MeshInfoManager.h"
#include "ENMUtil.h"
#include "ENMApp.h"
#include "DataCenterLinux.h"
#include <string.h>
#include <net/if.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include "ipv4.h"
#include <sys/socket.h>
#include <arpa/inet.h>/*inet_ntoa() to format IP address */
#include <netinet/in.h>/* in_addr structure */
#include <sys/ioctl.h>
MeshInfoManager* MeshInfoManager::m_pMeshInfoManager = NULL;


/*=================================================================
 Function Name  : ClientPCInfoManager::GetInstance
 Description    : Return instance
 Date           : 2008-9-16 17:22:47
 Return Code    : ClientPCInfoManager*
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager* MeshInfoManager::GetInstance()
{
    if( NULL == m_pMeshInfoManager)
       m_pMeshInfoManager  = new MeshInfoManager();

    return m_pMeshInfoManager;
}

/*=================================================================
 Function Name  : ClientPCInfoManager::ClientPCInfoManager
 Description    :
 Date           : 2008-9-16 17:22:47
 Return Code    :
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager::MeshInfoManager()
{
    //ctor
    m_bIsMeshClient = false;
    m_bIsMeshServer = false;
}


/*=================================================================
 Function Name  : ClientPCInfoManager::~ClientPCInfoManager
 Description    :
 Date           : 2008-9-16 17:22:50
 Return Code    :
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager::~MeshInfoManager()
{
    //dtor
}



void MeshInfoManager::ChangeMeshClientMode(bool bIsMeshClient)
{
    m_bIsMeshClient = bIsMeshClient;
}

bool MeshInfoManager::GetMeshMode()
{
    return m_bIsMeshClient;
}

void MeshInfoManager::ChangeMeshServerMode(bool bIsMeshServer)
{
    m_bIsMeshServer = bIsMeshServer;
}

bool MeshInfoManager::GetMeshServerMode()
{
    return m_bIsMeshServer;
}


void MeshInfoManager::GetInternetStateList(InternetStateList& internetStateList)
{
    struct if_nameindex *ifnames, *ifnm;
    struct ifreq ifr;

    ifnames = if_nameindex();
    char ip[33] = {'\0'};
    int socket_id;
    int ret = 0;
    InternetStateEntity internetStateEntity;

    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++)
    {
        if(strstr(ifnm->if_name, "eth") || strstr(ifnm->if_name, "ra"))
        {
            memset(ip, 0, 32);
            internetStateEntity.SetInterface(ENMUtil::StringToWxString(ifnm->if_name));
            DataCenterLinux::GetMeshIp(ifnm->if_name, ip);
            internetStateEntity.SetIPAddress(ENMUtil::StringToWxString(ip));
            socket_id = socket(AF_INET, SOCK_DGRAM, 0);
            if(socket_id < 0)
            {
                internetStateEntity.SetState(_("Disabled"));
            }
            else
            {
                strncpy (ifr.ifr_name, ifnm->if_name, IFNAMSIZ);
                ret=ioctl(socket_id, SIOCGIFFLAGS, (caddr_t)&ifr);
                if(ret == -1)
                {
                    close(socket_id);
                    internetStateEntity.SetState(_("Disabled"));
                    continue;
                }
                if ((ifr.ifr_flags)&IFF_UP)
                {
                    internetStateEntity.SetState(_("Enabled"));
                }
                else
                {
                    internetStateEntity.SetState(_("Disabled"));
                }
            }
            internetStateList.push_back(internetStateEntity);
        }
    }
}

void MeshInfoManager::SetHostNameToServer()
{
	MESH_GATEWAY_INFO meshGatewayInfo;
	memset(&meshGatewayInfo, 0, sizeof(MESH_GATEWAY_INFO));
	DCS_GetMeshGatewayInfo(&meshGatewayInfo);
	char shHostName[64] = {'\0'};

	Inetv4Address ip;
	if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.IPAddr, &ip) != INET_OK )
    {
        memcpy(shHostName, "0000", 4);
    }
    else
    {
        memcpy(shHostName, &ip, 4);
    }


    Inetv4Address DNS1;
    char* tempHostName = shHostName;
    tempHostName += 4;
    if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.DNS1, &DNS1) != INET_OK )
        memcpy(tempHostName, "0000", 4);
    else
    {
        memcpy(tempHostName, &DNS1, 4);
    }

    Inetv4Address DNS2;
    tempHostName += 4;
    if ( IPv4AddressUtil::StringToInetAddress((char *)meshGatewayInfo.DNS2, &DNS2) != INET_OK )
        memcpy(tempHostName, "0000", 4);
    else
    {
        memcpy(tempHostName, &DNS2, 4);
    }

    //just for unexpected situation
    char* strServerNameAll = (char*)(meshGatewayInfo.HostName);
    int iNameLen = strlen(strServerNameAll);
    if ( strServerNameAll[iNameLen-1] == '?')
    {
        strServerNameAll += 12;
        strcat(shHostName, strServerNameAll);
    }

    else
    {
        strcat(shHostName, (strServerNameAll));
        strcat(shHostName, "?");
    }
	ENM_String* sHostName = new ENM_String();
	memset(sHostName, 0, sizeof(ENM_String));
	memcpy((char*)sHostName->dcsString, shHostName, sizeof(shHostName));
	int ret = DCS_SetMeshHostName(sHostName);
	printf("set hostname result = %d\n", ret);
	printf("[MeshShareMyInternet]dcs set HostName: %s\n", (char*)sHostName->dcsString);
}

void MeshInfoManager::SetHostNameToClient()
{
    //change mesh hostname
    MESH_GATEWAY_INFO meshGatewayInfo;
    memset(&meshGatewayInfo, 0, sizeof(MESH_GATEWAY_INFO));
    DCS_GetMeshGatewayInfo(&meshGatewayInfo);
    char* strHostNameAll = (char *)meshGatewayInfo.HostName;
    strHostNameAll += 12;
    wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
    if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
    {
        wxString wxHostName = wxTemp.Left(wxTemp.Length()-1);
        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(wxHostName).c_str());
        DCS_SetMeshHostName(sHostName);
        printf("[SetHostnameToClient]ChangeHostName: %s\n", ENMUtil::WxStringToString(wxHostName).c_str());
    }
}
bool MeshInfoManager::MeshHaveOpen()
{
    bool bResult = false;
    // ifconfig
    system("ifconfig  > /tmp/meshhaveopen.txt");
    wxSleep(1);
    wxTextFile file(_T("/tmp/meshhaveopen.txt"));
    if ( file.Open() )
    {
        //printf("Number of lines: %u\n", file.GetLineCount());
        //printf("Last line: '%s'\n", file.GetLastLine().c_str());
        wxString s;

        for ( s = file.GetFirstLine(); !file.Eof(); s = file.GetNextLine() )
        {
            //printf("%d: %s\n", file.GetCurrentLine() + 1, s.c_str());
            if(wxNOT_FOUND  != s.Find(wxT("mesh0")))
            {
                printf("has mesh0\n");
                bResult = true;
            }
        }
    }
    else
    {
        printf("ERROR: can't open '%s'\n", file.GetName());
    }
    file.Close();
    system("rm /tmp/meshhaveopen.txt");
    return bResult;
}


wxString MeshInfoManager::GetEthName()
{
    struct if_nameindex *ifnames, *ifnm;
    wxString strEthName;
    strEthName = wxT("eth0");
    ifnames = if_nameindex();
    char ip[33] = {'\0'};
    int socket_id;
    int ret = 0;
    InternetStateEntity internetStateEntity;

    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++)
    {
        if(strstr(ifnm->if_name, "eth"))
        {
            strEthName = ENMUtil::StringToWxString(ifnm->if_name);
        }
    }
    return strEthName;
}

bool MeshInfoManager::CheckWirelessLink()
{
    FILE* fp;
    char buffer[128];
    fp = popen("iwpriv ra0 connStatus", "r");
    fgets(buffer, sizeof(buffer), fp);
    pclose(fp);
    const char* searchStr = "Disconnected";
    char* p;
    p = strstr(buffer, searchStr);
    return NULL == p;
}

bool MeshInfoManager::IsAdapterConnect(ENM_ADAPTER_TYPE AdpaterType)
{
    BOOL ifUp;
    DCS_IsExistUpAdapter(AdpaterType, &ifUp);
    if ( !ifUp )
        return false;

    BOOL existAdapter;
    DCS_IsExistAdapter(AdpaterType, &existAdapter);
    if ( existAdapter )
    {
        printf("adapter exists \n ");
        BOOL bIfConnect;
        DCS_IsExistConnectAdapter(AdpaterType, &bIfConnect);
        if (!bIfConnect)
        {
            printf("adpater not connecct. \n");
            return false;
        }
//        DCS_UpAdapter(AdpaterType);
//        ENM_String* IP = new ENM_String();
//        memset(IP, 0, sizeof(ENM_String));
//        DCS_GetIPAddressHLAN(IP);
        char strIP[33] = {'\0'};
        if ( AdpaterType == DCS_ADAPTER_WIRED )
        {
            wxString WiredAdapterName = GetEthName();
            printf("eth name = %s \n", ENMUtil::WxStringToString(WiredAdapterName).c_str());
            GetAdapterIP(ENMUtil::WxStringToString(WiredAdapterName).c_str(), strIP);
        }
        else
        {
            GetAdapterIP("ra0", strIP);
        }

//        string strIP((const char*)IP->dcsString);
//        delete IP;
        printf("IP = %s \n", strIP);
        string IPAddr(strIP);
        if ( IPAddr == "127.0.0.1" || IPAddr.empty() )
        {
            return false;
        }
        else
        {
            return true;
        }
    }

}

void MeshInfoManager::TurnOffMesh()
{
    DCS_TurnOnMesh(FALSE);
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLOSE;
    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->m_menuMeshDC->Enable(false);
}

int MeshInfoManager::GetAdapterIP(const char* ifname, char* ip)
{
   struct ifreq ifr;

    struct sockaddr_in sin;

    int socket_id;

    socket_id = socket(AF_INET, SOCK_DGRAM, 0);

    int ret = 0;

    if(socket_id < 0)

    {

        return 0;

    }

    memset(ip, 0 ,32);

    strncpy (ifr.ifr_name, ifname, IFNAMSIZ);

    if ( (ret=ioctl (socket_id, SIOCGIFADDR, &ifr)) == 0) {

        memcpy (&sin, &(ifr.ifr_addr), sizeof (sin));

        memcpy(ip, (char*)inet_ntoa (sin.sin_addr), strlen((char*)inet_ntoa (sin.sin_addr)));

        //Need check the IP address...

        return ret;

    }

    close(socket_id);

    return ret;
}
