/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef MESHUSEOTHERSINTERNETDLG_H
#define MESHUSEOTHERSINTERNETDLG_H

//(*Headers(MeshUseOthersInternetDlg)
#include <wx/listctrl.h>
#include <wx/stattext.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)
#include "MeshServerEntity.h"
#include <vector>
#include "GaugeDialog.h"
using namespace std;
typedef vector<MeshServerEntity> MeshServerInfoList;

class MeshUseOthersInternetDlg: public wxDialog
{
	public:

		MeshUseOthersInternetDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~MeshUseOthersInternetDlg();
//        void DrawList();
//        void ModifyList(int dChangeMode, const MeshServerEntity& meshserverentity, int &itemCount);
//        void ClearList();
		//(*Declarations(MeshUseOthersInternetDlg)
		wxButton* ButtonRefresh;
		wxStaticBitmap* StaticBitmap1;
		wxButton* ButtonOK;
		wxListCtrl* m_list;
		wxStaticText* StaticText1;
		wxButton* ButtonCancel;
		//*)
        bool Show(bool ifShow);

	protected:

		//(*Identifiers(MeshUseOthersInternetDlg)
		static const long ID_STATICTEXT1;
		static const long ID_LISTCTRL1;
		static const long ID_BUTTON_REFRESH;
		static const long ID_BUTTON_OK;
		static const long ID_BUTTON_CANCEL;
		static const long ID_STATICBITMAP1;
		//*)
        static const long ID_TIMER_SEARCH;
	private:
        void OnCloseClicked(wxCloseEvent& event);
		//(*Handlers(MeshUseOthersInternetDlg)
		void OnButtonRefreshClick(wxCommandEvent& event);
		void OnButtonCancelClick(wxCommandEvent& event);
		void OnButtonOKClick(wxCommandEvent& event);
		//*)
		void RefreshList();
        MeshServerInfoList m_MeshServerInfoList;
        static wxCriticalSection m_critsectUseOthers;

        void OnTimer(wxTimerEvent& event);
        void BeginSearch();
        GaugeDialog* m_pGaugeDialog;
        wxTimer m_searchTimer;
		DECLARE_EVENT_TABLE()
};

#endif
