/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "PopupConfirmDialog.h"
#include <wx/bitmap.h>
#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/dcclient.h>
#include <wx/frame.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"

const long TIMER_INTERVAL = 10000;

const long PopupConfirmDialog::ID_BTN_OK = wxNewId();
const long PopupConfirmDialog::ID_TIMER_TICK = wxNewId();

const int ADJUST_HEIGHT = 30;

BEGIN_EVENT_TABLE(PopupConfirmDialog, wxDialog)
    EVT_PAINT(PopupConfirmDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(PopupConfirmDialog::OnWindowCreate)
#endif
    EVT_BUTTON(ID_BTN_OK, PopupConfirmDialog::OnButtonClick)
    EVT_TIMER(ID_TIMER_TICK, PopupConfirmDialog::OnTimerTick)
    EVT_INIT_DIALOG(PopupConfirmDialog::OnInit)
END_EVENT_TABLE()

PopupConfirmDialog::PopupConfirmDialog(wxWindow* parent, const wxBitmap& bitmap, wxWindowID id)
        : wxDialog(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP | wxFRAME_SHAPED | wxNO_BORDER | wxFRAME_NO_TASKBAR)
        , m_bitmap(bitmap), m_bmpMute(79, 27)
        , m_Timer(this, ID_TIMER_TICK)
{
    m_hasShape = false;
    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));
	wxStaticBitmap* pBackground = new wxStaticBitmap(this, wxID_ANY, m_bitmap);

    int margin = 16;
    int stxWidth = m_bitmap.GetWidth() - margin * 2;
#if defined(__UNIX__)
	m_pTitle = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, margin), wxSize(stxWidth, 20), wxTRANSPARENT_WINDOW);
	m_pContentLine1= new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 40), wxSize(stxWidth, 16), wxTRANSPARENT_WINDOW);
	m_pContentLine2= new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 60), wxSize(stxWidth, 16), wxTRANSPARENT_WINDOW);
	m_pContentLine3= new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 80), wxSize(stxWidth, 16), wxTRANSPARENT_WINDOW);
#endif
	m_pTitle->SetForegroundColour(wxColor(0, 0, 255));
    wxFont font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_pTitle->SetFont(font);
	m_pContentLine1->SetForegroundColour(wxColor(0, 0, 255));
	m_pContentLine2->SetForegroundColour(wxColor(0, 0, 255));
	m_pContentLine3->SetForegroundColour(wxColor(0, 0, 255));

    int btnPosX = m_bitmap.GetWidth() - m_bmpMute.GetWidth() - margin;
#if defined(__UNIX__)
    m_bmpNormal.LoadFile(::wxGetApp().strAppPath + _T("pic/button_normal.png"), wxBITMAP_TYPE_PNG);
    m_bmpOver.LoadFile(::wxGetApp().strAppPath + _T("pic/button_over.png"), wxBITMAP_TYPE_PNG);
    m_bmpDown.LoadFile(::wxGetApp().strAppPath + _T("pic/button_down.png"), wxBITMAP_TYPE_PNG);
    m_bmpDisable.LoadFile(::wxGetApp().strAppPath + _T("pic/button_disable.png"), wxBITMAP_TYPE_PNG);

    m_btnOK = new wxBitmapButton(this, ID_BTN_OK, m_bmpNormal, wxPoint(170, 104), wxDefaultSize, wxBU_AUTODRAW | wxNO_BORDER);
    m_btnOK->SetBitmapDisabled(m_bmpDisable);
    m_btnOK->SetBitmapSelected(m_bmpDown);
    m_btnOK->SetBitmapHover(m_bmpOver);
    wxSize btnSize = m_btnOK->GetSize();
    m_pBtnOK = new wxStaticText(this, wxID_ANY, _("OK"), wxPoint(170, 115), btnSize, wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);
#endif

#ifndef __WXGTK__
    SetWindowShape();
#endif
}

PopupConfirmDialog::~PopupConfirmDialog()
{
}

void PopupConfirmDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

void PopupConfirmDialog::OnEraseBkgnd(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if ( pDC != NULL )
    {
        if ( m_bitmap.Ok() )
        {
            pDC->DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if ( m_bitmap.Ok() )
        {
            dc.DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
}

void PopupConfirmDialog::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);
}

void PopupConfirmDialog::OnWindowCreate(wxWindowCreateEvent& evt)
{
    SetWindowShape();
}

void PopupConfirmDialog::OnButtonClick(wxCommandEvent& event)
{
    if ( IsModal() )
    {
        if ( event.GetId() == ID_BTN_OK )
        {
            EndModal(wxID_OK);
        }
        else
        {
            EndModal(wxID_CANCEL);
        }
    }
    else
    {
        m_Timer.Stop();
        Close();
    }
}


void PopupConfirmDialog::RedrawBitmapBtn(const wxString& text, wxBitmapButton* pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC)
{
    if ( NULL == pDC )
    {
        return;
    }
    ButtonState(text, pBitmap, &m_bmpNormal, pDC);
    pBitmapBtn->SetBitmapLabel(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpOver, pDC);
    pBitmapBtn->SetBitmapHover(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpDown, pDC);
    pBitmapBtn->SetBitmapSelected(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpDisable, pDC);
    pBitmapBtn->SetBitmapDisabled(*pBitmap);
}


void PopupConfirmDialog::ButtonState(const wxString& text, wxBitmap* pBitmap, wxBitmap* bg, wxMemoryDC* pDC)
{
    if ( (NULL == pDC) || (NULL == pBitmap) || (NULL == bg) )
    {
        return;
    }
    pDC->Clear();
    pDC->SelectObject(*pBitmap);
    pDC->SetTextForeground(wxColour(71,83,107));
    pDC->SetTextBackground(*wxWHITE);
    pDC->DrawBitmap(*bg, 0, 0, TRUE);
    if ( text.Length() > 0 )
    {
        wxFont BtnFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
        pDC->SetFont(BtnFont);
        pDC->DrawLabel(wxStripMenuCodes(text), wxRect(0, 0, pBitmap->GetWidth(), pBitmap->GetHeight()), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);
    }
    pDC->SelectObject(wxNullBitmap);
}

void PopupConfirmDialog::OnInit(wxInitDialogEvent& event)
{
    m_Timer.Start(TIMER_INTERVAL, wxTIMER_ONE_SHOT);
    wxPoint finalPos;
    wxRect clientRect = ::wxGetClientDisplayRect();
#if defined(__UNIX__)
    finalPos = wxPoint(clientRect.GetWidth() - this->GetSize().GetWidth(), 0);
#endif

	this->Move(finalPos);
}

void PopupConfirmDialog::SetTitle(wxString strTitle)
{
    m_pTitle->SetLabel(strTitle);
}

void PopupConfirmDialog::SetContentLine1(wxString strContent)
{
    m_pContentLine1->SetLabel(strContent);
}

void PopupConfirmDialog::SetContentLine2(wxString strContent)
{
    m_pContentLine2->SetLabel(strContent);
}

int PopupConfirmDialog::ShowModal()
{
    return wxDialog::ShowModal();
}

void PopupConfirmDialog::EndModal(int retCode)
{
    m_Timer.Stop();
    wxDialog::EndModal(retCode);
}

void PopupConfirmDialog::OnTimerTick(wxTimerEvent & event)
{
    if ( IsModal() )
        EndModal(wxID_CANCEL);
    else
        Close();
}

void PopupConfirmDialog::SetContentLine3(wxString strContent)
{
    m_pContentLine3->SetLabel(strContent);
}
