/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "AutoRunSettings.h"
#include <wx/intl.h>
#include <wx/string.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>

const long AutoRunSettings::ID_LIST_APP = wxNewId();
const long AutoRunSettings::ID_BTN_ADD = wxNewId();
const long AutoRunSettings::ID_BTN_DELETE = wxNewId();
const long AutoRunSettings::ID_BTN_OK = wxNewId();
const long AutoRunSettings::ID_BTN_CANCEL = wxNewId();

BEGIN_EVENT_TABLE(AutoRunSettings,wxDialog)
	EVT_BUTTON(ID_BTN_ADD, AutoRunSettings::OnButtonAdd)
	EVT_BUTTON(ID_BTN_DELETE, AutoRunSettings::OnButtonDelete)
	EVT_BUTTON(ID_BTN_OK, AutoRunSettings::OnButtonOK)
	EVT_BUTTON(ID_BTN_CANCEL, AutoRunSettings::OnButtonCancel)
	EVT_INIT_DIALOG(AutoRunSettings::OnInit)
	EVT_LISTBOX(ID_LIST_APP, AutoRunSettings::OnListApplicationSelected)
END_EVENT_TABLE()

AutoRunSettings::AutoRunSettings(wxWindow* parent, wxWindowID id)
        : wxDialog(parent, id, _("Enable Applications"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"))
{
    int width = 410;
    int height = 300;
	int margin = 10;
	SetClientSize(wxSize(width,height));
	wxSize buttonSize(80, 30);
	wxSize listSize(width - 2 * margin, height - buttonSize.GetHeight() - 3 * margin);
	m_listApp = new wxListBox(this, ID_LIST_APP, wxPoint(margin,margin), listSize, 0, NULL, wxLB_EXTENDED | wxLB_HSCROLL);

	int x = margin;
	int y = height - buttonSize.GetHeight() - margin;
	m_btnAdd = new wxButton(this, ID_BTN_ADD, _("Add"), wxPoint(x, y), buttonSize);

	x += buttonSize.GetWidth() + margin;
	m_btnDelete = new wxButton(this, ID_BTN_DELETE, _("Delete"), wxPoint(x, y), buttonSize);

	x = width - buttonSize.GetWidth() * 2 - margin * 2;
	m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(x, y), buttonSize);

	x += buttonSize.GetWidth() + margin;
	m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(x, y), buttonSize);

	m_btnOK->SetDefault();
	m_btnDelete->Enable(false);
}

/**************************************************************************************************
* Function Name : ~AutoRunSettings                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
AutoRunSettings::~AutoRunSettings()
{
}

void AutoRunSettings::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_listApp->SetFocus();
}
void AutoRunSettings::SetApplications(const wxArrayString& apps)
{
    m_listApp->Clear();
    m_listApp->InsertItems(apps, 0);
}

/**************************************************************************************************
* Function Name : GetApplications                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
wxArrayString AutoRunSettings::GetApplications() const
{
    return m_arrayApps;
}

/**************************************************************************************************
* Function Name : OnButtonAdd                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::OnButtonAdd(wxCommandEvent& event)
{
#if defined(__UNIX__)
    wxString wildcard = _T("*");
#endif

    wxFileDialog dialog(this, _("Choose an application"), ::wxGetHomeDir(), wxEmptyString, wildcard, wxOPEN);
    if ( dialog.ShowModal() != wxID_OK )
        return;

    wxString path = dialog.GetPath();
    if ( m_listApp->FindString(path, true) != wxNOT_FOUND )
    {
        wxMessageDialog msgdlg(this, _("This application is already in the list.\n\nPlease choose another one."), _("Message"), wxOK | wxICON_INFORMATION);
        msgdlg.ShowModal();
    }
    else
    {
        m_listApp->Append(path);
    }
}

/**************************************************************************************************
* Function Name : OnButtonDelete                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::OnButtonDelete(wxCommandEvent& event)
{
    wxArrayInt arraySelected;
    int selectedCount = m_listApp->GetSelections(arraySelected);
    if ( selectedCount <= 0 )
        return;

    wxString message;
    if ( selectedCount > 1 )
        message = _("Are you sure you want to delete these items?");
    else
        message = _("Are you sure you want to delete this item?");
    wxMessageDialog dlg(this, message, wxEmptyString, wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
    if ( dlg.ShowModal() != wxID_YES )
        return;

    while ( selectedCount > 0 )
    {
        m_listApp->Delete(arraySelected[--selectedCount]);
    }
    m_btnDelete->Enable(false);
    if ( m_listApp->IsEmpty() )
    {
        delete m_listApp;
        m_listApp = new wxListBox(this, ID_LIST_APP, wxPoint(15,15), wxSize(380,230), 0, NULL, wxLB_EXTENDED | wxLB_HSCROLL);
    }
}

/**************************************************************************************************
* Function Name : OnButtonOK                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::OnButtonOK(wxCommandEvent& event)
{
    m_arrayApps.Empty();
    m_arrayApps = m_listApp->GetStrings();
    CloseDialog(wxID_OK);
}

/**************************************************************************************************
* Function Name : OnButtonCancel                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::OnButtonCancel(wxCommandEvent& event)
{
    CloseDialog(wxID_CANCEL);
}

/**************************************************************************************************
* Function Name : OnListApplicationSelected                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::OnListApplicationSelected(wxCommandEvent& event)
{
    wxArrayInt selections;
    int selectCount = m_listApp->GetSelections(selections);
    m_btnDelete->Enable(selectCount > 0);
}

/**************************************************************************************************
* Function Name : CloseDialog                                                                    *
* Description  :                                   *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AutoRunSettings::CloseDialog(int retCode)
{
    if ( IsModal() )
    {
        EndModal(retCode);
    }
    else
    {
        Close();
    }
}
