/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "PopupDialog.h"
#include <wx/bitmap.h>
#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/dcclient.h>
#include <wx/frame.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"

const long TIMER_INTERVAL = 10000;

const long PopupDialog::ID_BTN_OK = wxNewId();
const long PopupDialog::ID_BTN_CANCEL = wxNewId();
const long PopupDialog::ID_TIMER_TICK = wxNewId();

const int ADJUST_HEIGHT = 30;

BEGIN_EVENT_TABLE(PopupDialog,wxDialog)
    EVT_PAINT(PopupDialog::OnPaint)
#ifdef __WXGTK__
    EVT_WINDOW_CREATE(PopupDialog::OnWindowCreate)
#endif
    EVT_BUTTON(ID_BTN_CANCEL, PopupDialog::OnButtonClick)
    EVT_BUTTON(ID_BTN_OK, PopupDialog::OnButtonClick)
    EVT_TIMER(ID_TIMER_TICK,PopupDialog::OnTimerTick)
    EVT_INIT_DIALOG(PopupDialog::OnInit)
END_EVENT_TABLE()

PopupDialog::PopupDialog(wxWindow* parent, const wxBitmap& bitmap, wxWindowID id)
        : wxDialog(parent, id, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxSTAY_ON_TOP | wxFRAME_SHAPED | wxNO_BORDER | wxFRAME_NO_TASKBAR)
        , m_bitmap(bitmap), m_bmpMute(79, 27)
        , m_Timer(this, ID_TIMER_TICK)
{
    m_hasShape = false;
    SetSize(wxSize(m_bitmap.GetWidth(), m_bitmap.GetHeight()));
	wxStaticBitmap* pBackground = new wxStaticBitmap(this, wxID_ANY, m_bitmap);

    int margin = 12;
    m_stxWidth = m_bitmap.GetWidth() - margin * 2;
#if defined(__UNIX__)
	m_pTitle = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, margin), wxSize(m_stxWidth, 20));
	m_pContent = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 40), wxSize(m_stxWidth, 80));
	m_pContent->SetForegroundColour(wxColor(0, 0, 255));
//	m_pContentLine2= new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 60), wxDefaultSize, wxTRANSPARENT_WINDOW);
//	m_pContentLine3= new wxStaticText(this, wxID_ANY, _T(""), wxPoint(margin, 80), wxDefaultSize, wxTRANSPARENT_WINDOW);
#endif
	m_pTitle->SetForegroundColour(wxColor(0, 0, 255));
    wxFont font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_pTitle->SetFont(font);

//    wxSize btnSize(m_bmpMute.GetWidth(), m_bmpMute.GetHeight());
//    int x1 = m_bitmap.GetWidth() / 2 - btnSize.GetWidth() - margin / 2;
//    int x2 = x1 + btnSize.GetWidth() + margin;
//    int y = m_bitmap.GetHeight() - btnSize.GetHeight() - margin;

    m_bmpNormal.LoadFile(::wxGetApp().strImagePath + _T("button_normal.png"), wxBITMAP_TYPE_PNG);
    m_bmpOver.LoadFile(::wxGetApp().strImagePath + _T("button_over.png"), wxBITMAP_TYPE_PNG);
    m_bmpDown.LoadFile(::wxGetApp().strImagePath + _T("button_down.png"), wxBITMAP_TYPE_PNG);
    m_bmpDisable.LoadFile(::wxGetApp().strImagePath + _T("button_disable.png"), wxBITMAP_TYPE_PNG);

#if defined(__UNIX__)
    m_btnYes = new wxBitmapButton(this, ID_BTN_OK, m_bmpNormal, wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW | wxNO_BORDER);
    m_btnNo = new wxBitmapButton(this, ID_BTN_CANCEL, m_bmpNormal, wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW | wxNO_BORDER);

    wxSize btnSize = m_btnYes->GetSize();
    int x1 = m_bitmap.GetWidth() / 2 - btnSize.GetWidth() - margin / 2;
    int x2 = x1 + btnSize.GetWidth() + margin;
    int y = m_bitmap.GetHeight() - btnSize.GetHeight() - margin / 2;
    m_btnYes->Move(x1, y);
    m_btnNo->Move(x2, y);

    m_btnYes->SetBitmapDisabled(m_bmpDisable);
    m_btnYes->SetBitmapSelected(m_bmpDown);
    m_btnYes->SetBitmapHover(m_bmpOver);
    m_stxYes = new wxStaticText(this, wxID_ANY, _("Yes"), wxPoint(x1, y + 11), btnSize, wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);
    m_btnNo->SetBitmapDisabled(m_bmpDisable);
    m_btnNo->SetBitmapSelected(m_bmpDown);
    m_btnNo->SetBitmapHover(m_bmpOver);
    m_stxNo = new wxStaticText(this, wxID_ANY, _("No"), wxPoint(x2, y + 11), btnSize, wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);

#endif

#ifndef __WXGTK__
    SetWindowShape();
#endif

}

PopupDialog::~PopupDialog()
{
}

void PopupDialog::SetWindowShape()
{
    wxRegion region(m_bitmap, *wxBLACK);
    m_hasShape = SetShape(region);
}

void PopupDialog::OnEraseBkgnd(wxEraseEvent&  event)
{
    wxDC* pDC = event.GetDC();
    if ( pDC != NULL )
    {
        if (m_bitmap.Ok())
        {
            pDC->DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
    else
    {
        wxClientDC dc(this);
        if ( m_bitmap.Ok() )
        {
            dc.DrawBitmap(m_bitmap, 0, 0, true);
        }
    }
}

void PopupDialog::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    dc.DrawBitmap(m_bitmap, 0, 0, TRUE);
}

void PopupDialog::OnWindowCreate(wxWindowCreateEvent& evt)
{
    SetWindowShape();
}

void PopupDialog::OnButtonClick(wxCommandEvent& event)
{
    int id = event.GetId();
    if ( id == ID_BTN_CANCEL )
    {
        EndModal(wxID_CANCEL);
    }
    else if ( id == ID_BTN_OK )
    {
        EndModal(wxID_OK);
    }
}

void PopupDialog::RedrawBitmapBtn(const wxString& text, wxBitmapButton* pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC)
{
    if ( NULL == pDC )
    {
        return;
    }
    ButtonState(text, pBitmap, &m_bmpNormal, pDC);
    pBitmapBtn->SetBitmapLabel(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpOver, pDC);
    pBitmapBtn->SetBitmapHover(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpDown, pDC);
    pBitmapBtn->SetBitmapSelected(*pBitmap);

    ButtonState(text, pBitmap, &m_bmpDisable, pDC);
    pBitmapBtn->SetBitmapDisabled(*pBitmap);
}

void PopupDialog::ButtonState(const wxString& text, wxBitmap* pBitmap, wxBitmap* bg, wxMemoryDC* pDC)
{
    if ( (NULL == pDC) || (NULL == pBitmap) || (NULL == bg) )
    {
        return;
    }
    pDC->Clear();
    pDC->SelectObject(*pBitmap);
    pDC->SetTextForeground(wxColour(71,83,107));
    pDC->SetTextBackground(*wxWHITE);
    pDC->DrawBitmap(*bg, 0, 0, TRUE);
    if ( text.Length() > 0 )
    {
        wxFont BtnFont(10, wxDEFAULT, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
        pDC->SetFont(BtnFont);
        pDC->DrawLabel(wxStripMenuCodes(text), wxRect(0, 0, pBitmap->GetWidth(), pBitmap->GetHeight()), wxALIGN_CENTER_VERTICAL | wxALIGN_CENTRE);
    }
    pDC->SelectObject(wxNullBitmap);
}

void PopupDialog::OnInit(wxInitDialogEvent& event)
{
    wxPoint finalPos;
    wxRect clientRect = ::wxGetClientDisplayRect();
#if defined(__UNIX__)
    finalPos = wxPoint(clientRect.GetWidth() - this->GetSize().GetWidth(), 0);
#endif

	this->Move(finalPos);
}

void PopupDialog::SetTitle(wxString strTitle)
{
    m_pTitle->SetLabel(strTitle);
}

void PopupDialog::SetContent(const wxString& strContent)
{
    m_pContent->SetLabel(strContent);
	m_pContent->Wrap(m_stxWidth);
}

int PopupDialog::ShowModal()
{
    m_Timer.Start(TIMER_INTERVAL, wxTIMER_ONE_SHOT);
    return wxDialog::ShowModal();
}

void PopupDialog::EndModal(int retCode)
{
    m_Timer.Stop();
    wxDialog::EndModal(retCode);
}

void PopupDialog::OnTimerTick(wxTimerEvent & event)
{
    EndModal(wxID_CANCEL);
}
