#!/usr/bin/python

import sys, os, subprocess
from optparse import OptionParser


class LocalizeXhtml():
    def __init__(self, options):
        self.pot = "po/welcome.pot"
        return

    def run(self):
        self.clean_build(options.build_dir)
        self.linguas = self.get_list_from_filelines(options.linguas)
        if options.updatepot:
            self.update_pot(self.get_xhtmls())
        if options.updatepos:
            self.update_pos(self.linguas, options.build_dir)
        if options.generate:
            self.generate(options.build_dir, self.linguas, self.get_xhtmls())
            self.copy_src_dirs_to_build(options.build_dir)

    def copy_src_dirs_to_build(self, build_dir):
        try:
            cmd = "cp -r src/images src/resources " + build_dir        
            res = subprocess.Popen(cmd, shell=True, cwd=".", stdout=subprocess.PIPE ).communicate()
        except:
            print "Could not cp src/images/ and/or src/resources to " + build_dir + ". Stopping."
            sys.ext(1)
        return

    def generate(self, build_dir, linguas, xhtmls):
        for lingua in linguas:
            self.die_if_po_not_exists(lingua)
            output_dir = os.path.join(build_dir, lingua)
            if not os.path.exists(output_dir):
                os.system("mkdir " + output_dir)
            for xhtml in xhtmls:
                f_name = xhtml[xhtml.rfind(os.sep)+1:]
                cmd = "xml2po -p po/" + lingua + ".po -o " + os.path.join(build_dir, lingua, f_name) + " " + xhtml
                try:
                    res = subprocess.Popen(cmd, shell=True, cwd=".", stdout=subprocess.PIPE ).communicate()
                except:
                    print "Could not localize " + os.path.join(build_dir, lingua, f_name) + ". Stopping"
        return


    def clean_build(self,build):
        if os.path.exists(build):
            try:
                os.system("rm -rf " + build + "/*")
            except:
                print "Unable to delete the contents of the build directory: " + build
                print "Stopping."
                sys.exit(1)
        return

    def update_pot(self, xhtmls):
        files =""
        for f in xhtmls:
            files += " " + f 
        cmd = ["xml2po -o " + self.pot + files ]
        try:
            res = subprocess.Popen(cmd, shell=True, cwd=".", stdout=subprocess.PIPE ).communicate()
        except:
            print "could not update " + pot + ". Stopping"
            sys.exit(1)
        return 

    def die_if_po_not_exists(self, lingua):
        po = "po/" + lingua + ".po"
        if not os.path.exists(po):
            print po + " does not exist but is listed in LINGUAS. Make it first. Stopping."
            sys.exit(1)
        return


    def update_pos(self, linguas, build_dir):
        #os.chdir("po")
        for lingua in linguas:
            po = "po/" + lingua + ".po"
            self.die_if_po_not_exists(lingua)
            print "Updating " + po
            cmd = "msgmerge -U " + po + " " + self.pot
            print "cmd: " + cmd 
            try:
                res = subprocess.Popen(cmd, shell=True, cwd=".", stdout=subprocess.PIPE).communicate()
            except:
                print "Could not update po file: " + po + " from pot file: " + self.pot + ". Stopping."
                sys.exit(1)
        os.chdir("..")
        return

    def get_xhtmls(self):
        files = os.listdir("src")
        xhtmls = []
        for f in files:
            if f.endswith("xhtml"):
                xhtmls.append(os.path.join(os.getcwd(), "src", f))
        return xhtmls


    def get_list_from_filelines(self, f_):
        """Returns a list where each item is a line in a file 
        (without the terminating newline) where the complete path
        to the file is passed as an argument. If the file argument
        doesn't point to a file that can be opened, program terminates"""
        try:
            lines = open(f_, 'r').readlines()
        except:
            print (('Cannot open ' + f_) + '. Stopped.')
            sys.exit(1)
        lines_cleaned = []
        for line in lines:
            lines_cleaned.append(line[:line.find('\n')])

        return lines_cleaned




if __name__ == "__main__":
    import optparse
    parser = optparse.OptionParser()
    parser.add_option('-g', '--generate', type='string', dest='generate', default='', help='Use this option (-g go) to generate localized xhtml files in (default) build/<lang>/, where lang must be in LINGUAS and for which there must be a po file: po/<langL.po')
    parser.add_option('-b', '--build-dir', type='string', dest='build_dir', default='build', help='directory into which localized output is built.')
    parser.add_option('-l', '--linguas', type='string', dest='linguas', default='LINGUAS', help='path to file with linguas, one per line.')
    parser.add_option('-t', '--update-pot', type='string', dest='updatepot', default='', help='Use this option (-t go) to update po/welcome.pot file from src/*xhtml.')
    parser.add_option('-u', '--update-pos', type='string', dest='updatepos', default='', help='Use this option (-p go) to update po files from po/welcome.pot and src/*xhtml.')
    (options, args,) = parser.parse_args()
    app = LocalizeXhtml(options) 
    app.run()

