/* $Id: sig_boolean.h,v 1.19 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_BOOLEAN_H_INCLUDED
#define __SIG_BOOLEAN_H_INCLUDED

#include "sig_gen.h"

struct sig_boolean_funcs {
	void (*set)(void *s, unsigned int val);
	void (*set_ext)(void *s, unsigned int val);
};

struct sig_boolean {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_boolean_funcs *f;
		unsigned int in;
	} in[64];
	int in_count;

	struct {
		void *s;
		unsigned int out;
	} out[64];
	int out_count;
};

struct sig_boolean_merge {
	struct sig_boolean *s0;
	struct sig_boolean *s1;
};

extern void
sig_boolean_set(struct sig_boolean *b, void *s, unsigned int val);

extern void
sig_boolean_connect_in(struct sig_boolean *b,
		void *s, const struct sig_boolean_funcs *f);
extern void
sig_boolean_connect_out(struct sig_boolean *b,
		void *s, unsigned int val);

extern struct sig_boolean *
sig_boolean_init(const char *name, int nr);

extern struct sig_boolean_merge *
sig_boolean_merge(struct sig_boolean *s0, struct sig_boolean *s1);
extern void
sig_boolean_split(struct sig_boolean_merge *m);

extern void
sig_boolean_create(const char *name, int nr);
extern void
sig_boolean_destroy(const char *name, int nr);

#endif /* __SIG_BOOLEAN_H_INCLUDED */
