/*
 * $Id: setup.c,v 1.74 2009-03-01 11:57:21 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include "build_config.h"

#include "setup.h"
#include "cmos.h"
#include "video.h"
#include "video.h"
#include "stdio.h"
#include "cmos.h"
#include "kbd.h"
#include "debug.h"
#include "pci.h"
#include "segment.h"
#include "const.h"

/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

CODE16;

#include "setup_inc.c"

static inline unsigned int
abs(int x)
{
	if (x < 0) {
		return -x;
	} else {
		return x;
	}
}

static unsigned int
var_get(unsigned int entry)
{
	uint8_t mask;
	uint8_t byte;
	uint8_t val;

	mask = (1 << (data[entry].bit_first - data[entry].bit_last + 1)) - 1;

	byte = cmos_readb(data[entry].cmos_reg);
	val = byte;
	val >>= data[entry].bit_last;
	val &= mask;

	return val;
}

static void
var_set(unsigned int entry, unsigned int val)
{
	uint8_t mask;
	uint8_t byte;

	mask = (1 << (data[entry].bit_first - data[entry].bit_last + 1)) - 1;

	byte = cmos_readb(data[entry].cmos_reg);
	byte &= ~(mask << data[entry].bit_last);
	byte |= val << data[entry].bit_last;
	cmos_writeb(data[entry].cmos_reg, byte);
}

void
setup_defaults(void)
{
	unsigned int var;
	unsigned short i;
	
	for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
		if (data[var].choice_count == 1) {
			continue;
		}
		var_set(var, choice[data[var].choice_nr].val);
	}

	/* clear old values */
	for (i = 0; i < 128; i++) {
		cmos_ext_write(i, 0);
	}

	cmos_ext_put(initialized, 1);
	cmos_ext_put(apm, 0);		/* don't show advanced power management by default */
}

static void
show(unsigned int y, unsigned int x, char c, int mode)
{
	uint8_t attr;

	if (mode == 0) {
		/* Entry */
		attr = 0x1e; /* Yellow/Blue */

	} else if (mode == 1) {
		/* Selected Entry */
		attr = 0x4f; /* White/Red */

	} else { assert(mode == 2);
		/* Mask */
		attr = 0x1f; /* White/Blue */
	}

	put_byte(0xb800, (y * 80 + x) * 2 + 0, c);
	put_byte(0xb800, (y * 80 + x) * 2 + 1, attr);
}

void
setup_init(void)
{
	unsigned int m;
	unsigned int entry;
	unsigned int best;
	unsigned int var;
	unsigned int x;
	unsigned int y;
	unsigned short key;

	/* Turn off cursor. */
	/* FIXME */

	m = 0;
new_menu:;
	/* Lookup top/left entry. */
	entry = 0xffff;
	for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
		if (data[var].menu_nr != m) {
			continue;
		}
		if (entry == 0xffff
		 || data[var].pos_y < data[entry].pos_y
		 || (data[var].pos_y == data[entry].pos_y
		  && data[var].pos_x < data[entry].pos_x)) {
			entry = var;
		}
	}

	/* Print menu mask. */
	for (y = 0; y < 25; y++) {
		for (x = 0; x < 80; x++) {
			const char *page_str;

			page_str = string[page[m][y]];
			show(y, x, const_get(page_str[x]), 2);
		}
	}

	while (1) {
		/* Print menu entries. */
		for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
			const char *choice_str;
			unsigned int val;
			unsigned int c;

			if (data[var].menu_nr != m) {
				continue;
			}

			if (2 <= data[var].choice_count) {
				val = var_get(var);
			} else {
				val = 0;
			}

			for (c = 0; ; c++) {
				if (c == data[var].choice_nr) {
					/* Not found. */
					c = 0;
					break;
				}
				if (choice[data[var].choice_nr + c].val == val) {
					/* Found */
					break;
				}
			}

			choice_str = string[choice[data[var].choice_nr + c].str];

			for (x = 0; choice_str[x]; x++) {
				show(data[var].pos_y, data[var].pos_x + x,
						const_get(choice_str[x]),
						var == entry);
			}
		}
	
		while (! kbd_keyavailable()) {
		}

		key = kbd_getkey(1);

		if (key == 0x4800) {
			/* Cursor Up */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || data[var].menu_nr != m
				 || data[entry].pos_y <= data[var].pos_y) {
					continue;
				}
				if (best == 0xffff
				 || data[best].pos_y < data[var].pos_y
				 || (data[best].pos_y == data[var].pos_y
				  && abs(data[var].pos_x - data[entry].pos_x)
				   < abs(data[best].pos_x - data[entry].pos_x))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x5000) {
			/* Cursor Down */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || data[var].menu_nr != m
				 || data[var].pos_y <= data[entry].pos_y) {
					continue;
				}
				if (best == 0xffff
				 || data[var].pos_y < data[best].pos_y
				 || (data[var].pos_y == data[best].pos_y
				  && abs(data[var].pos_x - data[entry].pos_x)
				   < abs(data[best].pos_x - data[entry].pos_x))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4B00) {
			/* Cursor Left */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || data[var].menu_nr != m
				 || data[entry].pos_x <= data[var].pos_x) {
					continue;
				}
				if (best == 0xffff
				 || data[best].pos_x < data[var].pos_x
				 || (data[best].pos_x == data[var].pos_x
				  && abs(data[var].pos_y - data[entry].pos_y)
				   < abs(data[best].pos_y - data[entry].pos_y))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4d00) {
			/* Cursor Right */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || data[var].menu_nr != m
				 || data[var].pos_x <= data[entry].pos_x) {
					continue;
				}
				if (best == 0xffff
				 || data[var].pos_x < data[best].pos_x
				 || (data[var].pos_x == data[best].pos_x
				  && abs(data[var].pos_y - data[entry].pos_y)
				   < abs(data[best].pos_y - data[entry].pos_y))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4900
			|| key == 0x0d2b) {
			/* Page Up / + */
			unsigned int val;

			/* Get value. */
			val = var_get(entry);

			/* Lookup choice. */
			for (var = 0; ; var++) {
				if (var == data[entry].choice_count) {
					/* Not found. */
					var = 0;
					break;
				}
				if (choice[data[entry].choice_nr + var].val == val) {
					/* Found */
					break;
				}
			}

			assert(0 <= var && var < data[entry].choice_count);

			/* Select previous choice. */
			if (0 < var) {
				var--;
			} else {
				var = data[entry].choice_count - 1;
			}

			/* Set value. */
			var_set(entry, choice[data[entry].choice_nr + var].val);

		} else if (key == 0x5100
			|| key == 0x0c2d) {
			/* Page Down / - */
			unsigned int val;

			/* Get value. */
			val = var_get(entry);

			/* Lookup choice. */
			for (var = 0; ; var++) {
				if (var == data[entry].choice_count) {
					/* Not found. */
					var = 0;
					break;
				}
				if (choice[data[entry].choice_nr + var].val == val) {
					/* Found */
					break;
				}
			}

			assert(0 <= var && var < data[entry].choice_count);

			/* Select next choice. */
			if (var < data[entry].choice_count - 1) {
				var++;
			} else {
				var = 0;
			}

			/* Set value. */
			var_set(entry, choice[data[entry].choice_nr + var].val);

		} else if (key == 0x3b00) {
			/* F1 */

		} else if (key == 0x3c00) {
			/* F2 */

		} else if (key == 0x3f00) {
			/* F5 */

		} else if (key == 0x4100) {
			/* F7 */

		} else if (key == 0x4400) {
			/* F10 */

		} else if (key == 0x1c0d) {
			/* Return */
			if (data[entry].choice_count == 1) {
				if (data[entry].bit_last == 0) {
					/* New Menu */
					m = data[entry].bit_first;
					goto new_menu;
				} else {
					/* Do Dialog */
					/* FIXME */
					return;
				}
			}

		} else if (key == 0x011b) {
			/* Escape */
			m = 0;
			goto new_menu;

		} else {
			dprintf("Key 0x%04x pressed.\n", key);
		}
	}
}

#endif /* INIT_RM */
