/* $Id: var.h,v 1.51 2009-02-25 20:54:30 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __VAR_H_INCLUDED
#define __VAR_H_INCLUDED

#include <stddef.h>
#include "compiler.h"
#include "segment.h"

struct var {
		/* PC Intern, pp. 107 */
		/* PC Profibuch, pp. 41 */
		/* PC Hardware, pp. 1028 */
/* 00 */ unsigned short addr_ser[4];	/* IO address serial 0-3 */
/* 08 */ unsigned short addr_par[3];	/* IO address parallel 3 */
/* 0E */ unsigned short ebda_seg;	/* EBDA segment */
/* 10 */ unsigned short sys_conf;	/* system configuration */
					/* Bit0: 1 or more disk drives */
					/* Bit1: math coprocessor */
					/* non PS/2: */
					/* Bit2-3: RAM on board */
						/* 00 = 16 KByte */
						/* 01 = 32 KByte */
						/* 10 = 48 KByte */
						/* 11 = 64 KByte */
					/* PS/2: */
					/* Bit2: mouse installed */
					/* Bit3: not used */
					/* Bit4-5: Video mode on startup */
						/* 00 = unused */
						/* 01 = 40x25 Color */
						/* 10 = 80x25 Color */
						/* 11 = 80x25 Mono */
					/* Bit6-7: # of drives (if bit0 set) */
						/* 00 = 1 */
						/* 01 = 2 */
						/* 10 = 3 */
						/* 11 = 4 */
					/* Bit8: no DMA controller if set */
					/* Bit9-11: # of serial ports */
					/* Bit12: gameport available */
					/* Bit14-15: # of parallel ports */
/* 12 */ unsigned char post_state;	/* used during POST */
/* 13 */ unsigned short mem_total;	/* memory <= 640kB in kB*/
/* 15 */ unsigned short mem_extra;	/* extra memory */
/* 17 */ unsigned char kbd_shift0;	/* KBD: shift state 0 */
					/* Bit0: Right shift key pressed */
					/* Bit1: Left shift key pressed */
					/* Bit2: Ctrl shift key pressed */
					/* Bit3: Alt shift key pressed */
					/* Bit4: ScrollLock mode active */
					/* Bit5: NumLock mode active */
					/* Bit6: CapsLock mode active */
					/* Bit7: Insert mode active */
/* 18 */ unsigned char kbd_shift1;	/* KBD: shift state 1 */
					/* Bit0: Left Ctrl key pressed */
					/* Bit1: Left Alt key pressed */
					/* Bit2: SysReq key pressed */
					/* Bit3: Pause mode active */
					/* Bit4: ScrollLock key pressed */
					/* Bit5: NumLock key pressed */
					/* Bit6: CapsLock key pressed */
					/* Bit7: Insert key pressed */
/* 19 */ unsigned char kbd_numpad;	/* KBD: code entered on numpad */
/* 1a */ unsigned short kbd_tail;	/* KBD: read pointer */
/* 1c */ unsigned short kbd_head;	/* KBD: write pointer */
/* 1e */ unsigned char kbd_buf[32];	/* KBD: buffer */
/* 3e */ unsigned char f_recal;		/* Floppy: recalibration */
						/* Bit 7: working interrupt */
						/* Bit 6-4: reserved */
						/* Bit 3: drive 3 calibrated */
						/* Bit 2: drive 2 calibrated */
						/* Bit 1: drive 1 calibrated */
						/* Bit 0: drive 0 calibrated */
/* 3f */ unsigned char fmot_flag;	/* Floppy: motor flag */
						/* Bit 7: 0=read or write */
						/*        1=write or format */
						/* Bit 6: not used */
						/* Bit 5-4: drive select */
						/* Bit 3: motor drive 3 */
						/* Bit 2: motor drive 2 */
						/* Bit 1: motor drive 1 */
						/* Bit 0: motor drive 0 */
/* 40 */ unsigned char fmot_tmout;	/* Floppy: motor timeout */
/* 41 */ unsigned char fd_res;		/* Floppy: Result of last op */
						/* Bit 7: 0=drive ready */
						/*        1=timeout occured */
						/* Bit 6: 0=no seek error */
						/*        1=seek error */
						/* Bit 5: 0=controller passed */
						/*        1=controller failed */
						/* Bit 4-0: error code */
						/*        00=no errors */
						/*        01=illegal func */
						/*        02=addr not found */
						/*        03=write protect */
						/*        04=sector not found */
						/*        05=? */
						/*        06=disk changed */
						/*        07=? */
						/*        08=DMA overrun */
						/*        09=DMA boundary err */
						/*        0A=? */
						/*        0B=? */
						/*        0C=unknown media */
						/*        0D=? */
						/*        0E=? */
						/*        0F=? */
						/*        10=CRC error */
/* 42 */ unsigned char f_stat[7];	/* Floppy: controller status */
					/* Status returned by ops */

/* 49 */ unsigned char reserved1[0x67-0x49]; /* Video stuff */

/* 67 */ uint16_t reset_ip;		/* Reset Vector (IP) */
/* 69 */ uint16_t reset_cs;		/* Reset Vector (CS) */
/* 6b */ unsigned char reserved2;	/* FIXME MARCEL */
/* 6c */ unsigned short ticks_low;	/* Time: 16HZ ticks (lsw)*/
/* 6e */ unsigned short ticks_high;	/* Time: 16HZ ticks (msw)*/
/* 70 */ unsigned char time_24h;	/* Time: 24h flag */
/* 71 */ unsigned char ctrlbrk;		/* Bit7: set if ctrl-brk */
/* 72 */ unsigned short reset;		/* != 0x1234 on cold start */
/* 74 */ unsigned char hd_res;		/* HD: Result of last operation */
/* 75 */ unsigned char hd_num;		/* HD: Number of drives */
/* 76 */ unsigned char hd_ctrl;		/* HD: Control byte ??? */
/* 77 */ unsigned char hd_port;		/* HD: Base address of controller */
/* 78 */ unsigned char par_tmout[4];	/* Parallel port timeouts */
/* 7C */ unsigned char ser_tmout[4];	/* Serial port timeouts */
/* 80 */ unsigned short kbd_bstart;	/* KBD: buffer start offset = 0x1E */
/* 82 */ unsigned short kbd_bend;	/* KBD: buffer start end */

/* 84 */ unsigned char reserved3[0x8b-0x84]; /* Video stuff */

/* 8b */ unsigned char f_config;	/* Floppy config */
					/* Bit 7-6: data rate sent */
					/*          00=500Kbit/sec */
					/*          01=300Kbit/sec */
					/*          10=250Kbit/sec */
					/*          11=1Mbit/sec */
					/* Bit 5-4: step rate */
					/*          00=8ms */
					/*          01=7ms */
					/*          10=6ms */
					/*          11=5ms */
					/* Bit 3-2: data rate at start */
					/*          00=500Kbit/sec */
					/*          01=300Kbit/sec */
					/*          10=250Kbit/sec */
					/*          11=1Mbit/sec */
					/* Bit 1-0: unused */
/* 8c */ unsigned char ps2_par1[2];	/* PS2: floppy & hd parameters */
/* 8e */ unsigned char hd_irq;		/* HD interrupt flag */
/* 8f */ unsigned char ps2_par2[0x94-0x8f]; /* PS2: floppy & hd parameters */
/* 94 */ unsigned char f_track[2];	/* Floppy current cylinder */
/* 96 */ unsigned char mf2_state;	/* KBD: MF II status */
/* 97 */ unsigned char led_stat;	/* KBD: LED status */
/* 98 */ unsigned long wf_ptr;		/* Wait-Flag pointer */
/* 9c */ unsigned long timectr;		/* time counter */
/* a0 */ unsigned char wait_stat;	/* wait status */
/* a1 */
		/* 95 bytes for general BIOS stuff */
	 unsigned long mem_size;
	 unsigned char console_type;
} PACKED;

#define VAR_SEG	0x0040
#define VAR	((struct var *) 0)


/*
 * 1K of base memory used for Extended Bios Data Area (EBDA)
 * EBDA is used for PS/2 mouse support, and IDE BIOS, etc.
 */
#define MAX_BIOS_FDS 2
#define MAX_BIOS_HDS 12


struct ebda {
/*0x00*/unsigned char size;		/* Size of EBDA struct in Kb. */
/*0x01*/uint8_t unknown1[0x17-0x01];
/*0x17*/uint8_t post_error_entries;	/* Number of POST entries below. */
/*0x18*/uint8_t post_error[10];		/* POST error codes. */
/*0x22*/uint16_t mouse_driver_offset;	/* Offset mouse handler. */
/*0x24*/uint16_t mouse_driver_seg;	/* Segment mouse handler. */
/*0x26*/uint8_t mouse_flags_1;
					/* Bit0-2: # of bytes in buffer */
					/* Bit3: Reserved */
					/* Bit4: Error */
					/* Bit5: Acknowlodge */
					/* Bit6: Resend */
					/* Bit7: Busy */
/*0x27*/uint8_t mouse_flags_2;
					/* Bit0-2: Max # of bytes in buffer. */
					/* Bit3-6: Reserved. */
					/* Bit7: Far routine installed. */
/*0x28*/uint8_t mouse_data[8];		/* Mouse data buffer. */
/*0x30*/unsigned char unknown2[0x39 - 0x30];
/*0x39*/uint8_t watchdog_timer[2];	/* Watch Dog Timer */
/*0x3b*/unsigned char unknown3[0x3d - 0x3b];
/*0x3d*/struct {
		uint16_t cyls;		/* Number of Cylinders */
		uint8_t heads;		/* Number of Heads */
		uint16_t reserved0;
		uint16_t precomp;	/* Write Precomp Cylinder */
		uint8_t reserved1;
		uint8_t control;	/* Bit3: More than 8 Heads */
		uint8_t reserved2;
		uint8_t reserved3;
		uint8_t reserved4;
		uint16_t landing;	/* Landing Cylinder */
		uint8_t secs;		/* Number of Sectors per Track */
		uint8_t reserved5;
	} PACKED hdpt[2];
/*0x5d*/unsigned char unknown4[0x68 - 0x5d];
/*0x68*/uint8_t cache_control;		/* Cache Control */
/*0x69*/unsigned char unknown5[0x6e - 0x69];
/*0x6e*/uint8_t kbd_repeat_rate;	/* Keyboard Repeat Rate */
/*0x6f*/uint8_t kbd_delay;		/* Delay Until Keyboard Repeats */
/*0x70*/uint8_t harddrives;		/* Number of Harddrives */
/*0x71*/uint8_t harddrive_dma_channel;	/* DMA Channel Harddrive */
/*0x72*/uint8_t harddrive_irq_status;	/* Harddrive's IRQ Status */
/*0x73*/uint8_t harddrive_op_flags;	/* Harddrive's Operation Flags */
/*0x74*/uint16_t old_int76_offset;	/* Old INT 0x76 Vector Offset */
/*0x76*/uint16_t old_int76_segment;	/* Old INT 0x76 Vector Segment */
/*0x78*/uint8_t harddrive_dma_type;	/* Harddrive's DMA Type */
/*0x79*/uint8_t harddrive_status;	/* Harddrive's Last Status */
/*0x7a*/uint8_t harddrive_timeout;	/* Harddrive's Timeout Value */
/*0x7b*/uint8_t unknown6[0x7e - 0x7b];
/*0x7e*/uint16_t harddrive_controller_status[8]; /* Harddrive's Controller Status */
/*0x8e*/uint8_t unknown7[0xe7 - 0x8e];
/*0xe7*/uint8_t disk_drive_type;	/* Diskette Drive Type */
/*0xe8*/uint8_t unknown8[0xec - 0xe8];
/*0xec*/uint8_t harddrive_loaded;	/* Harddrive's Parameters Loaded */
/*0xed*/uint8_t unknown9[0xee - 0xed];
/*0xee*/uint8_t cpu_family;		/* CPU Family */
/*0xef*/uint8_t cpu_stepping;		/* CPU Stepping */
/*0xf0*/uint8_t unknown10[0x117 - 0xf0];
/*0x117*/uint8_t keyboard_id[2];	/* Keyboard ID */
/*0x119*/uint8_t unknown11[0x11a - 0x119];
/*0x11a*/uint8_t irq18_flag;		/* Non-BIOS Interrupt 18h Flag */
/*0x11b*/uint8_t unknown12[0x11d - 0x11b];
/*0x11d*/uint16_t irq18_offset;		/* User Interrupt 0x18 Offset */
/*0x11f*/uint16_t irq18_segment;	/* User Interrupt 0x18 Segment */
#if 0
/*0x121*/uint8_t unknown13[735];
#else
	struct {
		unsigned char drive;
		unsigned char type;
		unsigned short lchs_heads;	/* Logical CHS. */
		unsigned short lchs_cylinders;
		unsigned short lchs_spt;
#if 0
		unsigned short pchs_heads;	/* Physical CHS. */
		unsigned short pchs_cylinders;
		unsigned short pchs_spt;
#else
#define pchs_heads lchs_heads
#define pchs_cylinders lchs_cylinders
#define pchs_spt lchs_spt
#endif
		unsigned long sectors;	/* Total sectors count. */
	} PACKED devices[MAX_BIOS_HDS];
	unsigned char hdidmap[MAX_BIOS_HDS];
	unsigned char cdcount;
	unsigned char cdidmap[MAX_BIOS_HDS];
	struct {
		unsigned char active;
		unsigned char media;
		unsigned char emulated_drive;
		unsigned char controller_index;
		unsigned short device_spec;
		unsigned long ilba;
		unsigned short buffer_segment;
		unsigned short load_segment;
		unsigned short sector_count;
		struct {
			unsigned short heads;
			unsigned short cylinders;
			unsigned short spt;
		} PACKED vdevice;
	} PACKED cdemu;
#endif
} PACKED;

#define EBDA_SEG	0x9fc0
#define EBDA		((struct ebda *) 0)

/* ==================== REAL-MODE ==================== */
#if defined(RUNTIME_RM) || defined(INIT_RM) 

#define var_put(mem, value) \
	if (sizeof(VAR->mem) == 1) { \
		put_byte(VAR_SEG, (uint16_t) offsetof(struct var, mem), (uint8_t) value); \
	} else if (sizeof(VAR->mem) == 2) { \
		put_word(VAR_SEG, (uint16_t) offsetof(struct var, mem), (uint16_t) value); \
	} else if (sizeof(VAR->mem) == 4) { \
		put_long(VAR_SEG, (uint16_t) offsetof(struct var, mem), (uint32_t) value); \
	} else { \
		assert(0); \
	}

#define var_get(mem) \
	( \
		(sizeof(VAR->mem) == 1) ? \
			get_byte(VAR_SEG, (uint16_t) offsetof(struct var, mem)) \
		: (sizeof(VAR->mem) == 2) ? \
			get_word(VAR_SEG, (uint16_t) offsetof(struct var, mem)) \
		: (sizeof(VAR->mem) == 4) ? \
			get_long(VAR_SEG, (uint16_t) offsetof(struct var, mem)) \
		: \
			-1 \
	)

#define ebda_put(mem, value) \
	if (sizeof(EBDA->mem) == 1) { \
		put_byte(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem), (uint8_t) value); \
	} else if (sizeof(EBDA->mem) == 2) { \
		put_word(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem), (uint16_t) value); \
	} else if (sizeof(EBDA->mem) == 4) { \
		put_long(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem), (uint32_t) value); \
	} else { \
		assert(0); \
	}

#define ebda_get(mem) \
	( \
		(sizeof(EBDA->mem) == 1) ? \
			get_byte(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem)) \
		: (sizeof(EBDA->mem) == 2) ? \
			get_word(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem)) \
		: (sizeof(EBDA->mem) == 4) ? \
			get_long(var_get(ebda_seg), (uint16_t) offsetof(struct ebda, mem)) \
		: \
			-1 \
	)
#endif /* REAL-MODE */

#endif /* __VAR_H_INCLUDED */
