/* $Id: glue-gui-gtk-change.c,v 1.2 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk-change.h"

typedef struct {
	GtkHBoxClass parent_class;

	void (*change_inserted) (GuiGtkChange *change);
	void (*change_removed) (GuiGtkChange *change);
} GuiGtkChangeClass;

enum {
	CHANGE_INSERTED,
	CHANGE_REMOVED,
	GUI_GTK_CHANGE_LAST_SIGNAL
};

static guint gui_gtk_change_signals[GUI_GTK_CHANGE_LAST_SIGNAL] = { 0, 0 };

static void
gui_gtk_change_class_init(GuiGtkChangeClass *class)
{
	gui_gtk_change_signals[CHANGE_INSERTED] =
		g_signal_new("change-inserted",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkChangeClass, change_inserted),
			NULL, NULL,
			g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE,
			1, G_TYPE_POINTER);
	gui_gtk_change_signals[CHANGE_REMOVED] =
		g_signal_new("change-removed",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkChangeClass, change_removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gui_gtk_change_insert_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_show(change->selector);
}

static void
gui_gtk_change_remove_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_show(change->insert);
	gtk_widget_hide(change->remove);

	g_signal_emit(G_OBJECT(change),
			gui_gtk_change_signals[CHANGE_REMOVED], 0);
}

static void
gui_gtk_change_ok_button_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;
	const char *file;

	gtk_widget_hide(change->insert);
	gtk_widget_show(change->remove);
	gtk_widget_hide(change->selector);

	file = gtk_file_selection_get_filename(
			GTK_FILE_SELECTION(change->selector));

	g_signal_emit(G_OBJECT(change),
			gui_gtk_change_signals[CHANGE_INSERTED], 0, file);
}

static void
gui_gtk_change_cancel_button_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_hide(change->selector);
}

static gboolean
gui_gtk_change_delete_event(GtkWidget *w, GdkEvent *event, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_hide(change->selector);

	return TRUE;
}

static void
gui_gtk_change_init(GuiGtkChange *change)
{
	/* Insert Button */
	change->insert = gtk_button_new_with_label("Insert");
	GTK_WIDGET_UNSET_FLAGS(change->insert, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(change->insert), "clicked",
			  G_CALLBACK(gui_gtk_change_insert_event), change);
	gtk_widget_show(change->insert);
	gtk_box_pack_start(GTK_BOX(change), change->insert,
			FALSE, FALSE, 1);

	/* Remove Button */
	change->remove = gtk_button_new_with_label("Remove");
	GTK_WIDGET_UNSET_FLAGS(change->remove, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(change->remove), "clicked",
			  G_CALLBACK(gui_gtk_change_remove_event), change);
	gtk_widget_hide(change->remove);
	gtk_box_pack_start(GTK_BOX(change), change->remove,
			FALSE, FALSE, 1);

	/* File Selection Dialog */
	change->selector = gtk_file_selection_new("Insert");
	g_signal_connect(GTK_FILE_SELECTION(change->selector)->ok_button,
			"clicked",
			G_CALLBACK(gui_gtk_change_ok_button_event), change);
	g_signal_connect(GTK_FILE_SELECTION(change->selector)->cancel_button,
			"clicked",
			G_CALLBACK(gui_gtk_change_cancel_button_event), change);
	g_signal_connect(change->selector,
			"delete-event",
			G_CALLBACK(gui_gtk_change_delete_event), change);
	gtk_widget_hide(change->selector);
}

GType
gui_gtk_change_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkChangeClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_change_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkChange),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_change_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"Change", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKCHANGE_TYPE	gui_gtk_change_get_type()

GtkWidget *
gui_gtk_change_new(const char *type)
{
	GuiGtkChange *change;
	const char *icon;
	GtkWidget *icon0;
	GtkWidget *icon1;

	change = GUI_GTK_CHANGE(g_object_new(GUIGTKCHANGE_TYPE, NULL));
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(change), GTK_CAN_FOCUS);

	if (strcmp(type, "CD") == 0
	 || strcmp(type, "DVD") == 0) {
		icon = "gtk-cdrom";
	} else if (strcmp(type, "Floppy") == 0) {
		icon = "gtk-floppy";
	} else {
		icon = NULL;
	}
	if (icon) {
		icon0 = gtk_image_new_from_stock(icon, GTK_ICON_SIZE_BUTTON);
		icon1 = gtk_image_new_from_stock(icon, GTK_ICON_SIZE_BUTTON);
		gtk_button_set_image(GTK_BUTTON(change->insert), icon0);
		gtk_button_set_image(GTK_BUTTON(change->remove), icon1);
	}

	return GTK_WIDGET(change);
}

void
gui_gtk_change_set(GuiGtkChange *change, const char *string)
{
	if (*string) {
		gtk_widget_hide(change->insert);
		gtk_widget_show(change->remove);
	} else {
		gtk_widget_show(change->insert);
		gtk_widget_hide(change->remove);
	}
}
