
/*****************************************************************************
 *
 * Motorola Inc.
 * (c) Copyright 2005 Motorola, Inc.
 * ALL RIGHTS RESERVED.
 * *****************************************************************************
 ************************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ************************************************************************
 *****************************************************************************
 * File Name: aacplus_main.h
 *
 * Description: header file for aacplus_main.c .
 *
 ****************************** Change History********************************
 *
 *    DD/MM/YYYY     Code Ver     Description                   Author
 *   -----------     --------     -----------                   ------
 *    28/06/2005      01          File  Created                 Webber Wang
 *    09/07/2007      02          Implement recursive DST-IV    Bing Song
 *
 ******************************************************************************/

#ifndef _AACPLUS_MAIN_H
#define _AACPLUS_MAIN_H

#include "aacplus_dec_interface.h"

#define BS_BUF_SIZE              AACPD_INPUT_BUFFER_SIZE
#define MAX_ENC_BUF_SIZE         400*BS_BUF_SIZE*24
#define AACPD_PATH_LEN           128
#define LONG_BOUNDARY             4

void  myexit(int errornum);
void* aacd_alloc_fast (int size);
void* aacd_alloc_slow (int size);
void aacd_free(void* mem);
void update_bitstream_status(int bytes_used);
int    prepare_bitstream(void);
void App_display_error_message(AACPD_RET_TYPE rc);

extern int App_get_adts_header(AACPD_Block_Params * params);
extern int App_init_raw(AACPD_Block_Params * params,int,int);
extern int ADTSBitrate(AACPD_Decoder_Config *dec_config, AACPD_Decoder_info *dec_info);
extern unsigned long App_bs_look_bits (int nbits);
extern int App_bs_read_bits (int nbits);
extern void          App_bs_readinit(char *buf, int bytes);
extern int           App_FindFileType(int val);
extern int           App_get_adif_header(AACPD_Block_Params * params);

#endif /*_AACPLUS_MAIN_H */
