
 /************************************************************************
  * Copyright 2005-2010 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************


    Module Name:            porting.h

    General Description:    contains porting related structure .

===============================================================================
                           Freescale Confidential Proprietary
                                   WMSG - Multimedia
                   (c) Copyright Freescale 2007, All Rights Reserved
===============================================================================*/
#ifndef _PORTING__
#define _PORTING__

#include<stdio.h>


typedef unsigned long       DWORD;
typedef unsigned short      WORD;
typedef long LONG;

#define MEMORY_ALIGNMENT 4


#include "asf_api.h"

typedef enum {
    WMPERR_OK = 0,				
    WMPERR_FAIL,				
	WMPERR_INVALIDARG,			
    WMPERR_OUTOFMEMORY,			
	WMPERR_BADDATA,
	WMPERR_BADHEADER,			
    WMPERR_INVALIDHANDLE,		
    WMPERR_INVALIDPOINTER, 
	WMPERR_UNINITIALIZED,  
	WMPERR_INITERR,
	WMPERR_INVALIDHEADER,  
    WMPERR_INVALIDPROPERTIES,
	WMPERR_INVALIDOBJECT,
	WMPERR_INVALIDENCRYPT,
	WMPERR_AUDIODECINITFAIL,
	WMPERR_DRMFAIL,
	WMPERR_DRMINITFAIL,
	WMPERR_PACKETSIZE,
	WMPERR_AUDIOINFO,
	WMPERR_TIMEOFFSET,
	WMPERR_LASTPACKET,
	WMPERR_FRAMERATE,
	WMPERR_BISIZE,
	WMPERR_BIWIDTH,
	WMPERR_BIHEIGHT,
	WMPERR_BICOMPRESSION,
	WMPERR_BISIZEIMAZE,
	WMPERR_EOF,            
    WMPERR_FILEREAD,       

    WMPERR_BUFTOOSMALL,    
    WMPERR_BUFTOOLARGE,    
    WMPERR_DECODER_ERROR,  
    WMPERR_VIDEO_DECODER_ERROR,   
    WMPERR_DECODE_COMPLETE,
    WMPERR_DRMNOTSUPPORTED,
    WMPERR_DEMOEXPIRED,
	WMPERR_NOTSUPPORTED,
	WMPERR_NEED_MORE_DATA = 300
} WMPERR;

void Wchar_to_ascii(char *s_ascii,unsigned short *s_wchar,int length);
WMPERR audio_write(void *Buffer, size_t length, int Pres_time, void *decoder);
WMPERR video_write(void *Buffer, size_t length, int Pres_time,int isKeyframe, void *decoder);
void *set_mem(void *dest, int c, size_t count);
void *copy_mem( void *dest, const void *src, size_t count );







void free_mem( void *memblock );
void *allocate_mem(size_t size);


#endif



