
 ;***********************************************************************
 ;* Copyright 2005-2008 by Freescale Semiconductor, Inc.
 ;* All modifications are confidential and proprietary information
 ;* of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
 ;***********************************************************************


	CODE32

	AREA text, CODE, READONLY


	EXPORT CONTROL_REG_READ [FUNC]
	EXPORT CONTROL_REG_SET [FUNC]

	EXPORT INTERRUPTS_SET [FUNC]
	EXPORT INTERRUPTS_ON  [FUNC]
	EXPORT INTERRUPTS_OFF [FUNC]
	EXPORT INTERRUPTS_STATE [FUNC]
       EXPORT GET_SP [FUNC]

GET_SP FUNCTION  
  	mov r0, sp
  	bx lr
  	ENDFUNC     

INTERRUPTS_SET FUNCTION		
		STMFD	sp!,{r4,r14}
		MSR		cpsr_c,r0		;set I,F
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC

INTERRUPTS_ON FUNCTION		
		STMFD	sp!,{r4,r14}
		MRS		r4,cpsr		;r4=cpsr
		BIC		r4,r4,#0xC0	;I,F clear 0
		MSR		cpsr_c,r4		;enable I,F
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC

INTERRUPTS_OFF FUNCTION		
		STMFD	sp!,{r4,r14}
		MRS		r4,cpsr		;r4=cpsr
		ORR		r4,r4,#0xC0	;I,F set 1
		MSR		cpsr_c,r4		;disable I,F
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC

INTERRUPTS_STATE FUNCTION		
		STMFD	sp!,{r4,r14}
		MRS		r0,cpsr		;r0=cpsr		
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC


CONTROL_REG_READ FUNCTION		
		STMFD	sp!,{r4,r14}
		MRC p15,0,r0,c1,c0,0		; r0=cp15
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC

CONTROL_REG_SET FUNCTION		
		STMFD	sp!,{r4,r14}
		MCR p15,0,r0,c1,c0,0		; cp15=r0
		LDMFD 	sp!,{r4,pc} 
		ENDFUNC

	END

