/* ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************/

#ifdef UNDER_CE
#include <windows.h>
#endif //UNDER_CE


#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <stdlib.h>

#include "wmatypes.h"
#include "wmaprodecS_api.h"

#define WMA_OK                   0x00000000

typedef unsigned char       WMAD_UINT8;
typedef char                WMAD_INT8;
typedef unsigned short      WMAD_UINT16;
typedef short               WMAD_INT16;
typedef unsigned int        WMAD_UINT32;
typedef int	                WMAD_INT32;
typedef WMAD_UINT32         WMAD_Bool;
#define WMAD_TRUE               1
#define WMAD_FALSE              0
#if _WIN32
typedef unsigned __int64        WMAD_UINT64;
typedef __int64                 WMAD_INT64;
#else
typedef unsigned long long      WMAD_UINT64;
typedef long long               WMAD_INT64;
#endif


FILE * fpInput;
FILE * fpOutput;
#define MAX_PERFORM_BUFFER_SIZE 5*1024*1024

//WMA_U8 gInputBuf[15*1024*1024];
unsigned char *g_pBuffer = NULL;
WMA_U32 g_cbBuffer = 0;
WMA_U8 gOututBuf[16*1024];

#ifdef UNICODE
int __cdecl wmain(int argc, LPCTSTR argv[])
#elif UNDER_CE
//Int MSVC_CDECL main(Int argc, __in_ecount(argc) LPCTSTR argv[])
Int MSVC_CDECL main(Int argc, LPCTSTR argv[])
#else
Int MSVC_CDECL main(Int argc, char * argv[])
#endif
{
#ifdef UNDER_CE
    LPCTSTR szInputName     = NULL;
    LPCTSTR szOutputName    = NULL;
#else
    char * szInputName     = NULL;
    char * szOutputName    = NULL;
#endif
    int inputFilesize, iBytesRead;

 /* global stucture */
    WMARESULT hr;
    WMAProRawDecHandle phWMAProRawDec = NULL;
    WMAFormat  WMA_Format;
    PCMFormat  PCM_Format;
    WMAProRawDecState WMADecState;
    WMAProRawDecInitParams WMAInitParams;
    WMAPlayerInfo  WMA_playerInfo;

    WMA_Bool fNewPacket; WMA_Bool fNoMoreInput; WMA_Bool fTime;
    WMA_U32 cSamplesReady, cSamplesReturned, cFetchedSamples;
    WMA_U32 cbDstUsed, packet_length; //produced data in bytes
    WMA_I64 rtTime; //time stamp (in 100ns) of 1st sample returned
    WMA_U32 cbDstLength = 16*1024; //output buffer size

    //WMA_U8 *pInputBuf = gInputBuf;
    if(argc != 3) {
      printf("app.exe <input_file> <output_file>");
      return 0;
    }
    szInputName = argv[1];
    szOutputName  = argv[2];
    fpInput = _tfopen(szInputName, TEXT("rb"));
    if(NULL==fpInput){
      printf("Can't open input file !\n");
      return 0;
    }
    fpOutput = _tfopen(szOutputName, TEXT("wb+"));
    if(NULL==fpOutput){
      printf("Can't open output file !\n");
      return 0;
    }
    fseek(fpInput, 0, SEEK_END);   //end of the file
    inputFilesize = ftell(fpInput);
    //pCallbackStruct->input_data->buff_head = pCallbackStruct->input_data->buff;
    fseek(fpInput,SEEK_SET,0);
    g_pBuffer = (unsigned char *)malloc(MAX_PERFORM_BUFFER_SIZE);
    if(NULL==g_pBuffer){
      printf("Malloc fail !\n");
      return 0;
    }

	//inputFilesize = 0x32cb6; // file size
    iBytesRead = fread(g_pBuffer, 1, inputFilesize, fpInput);
	if (iBytesRead != inputFilesize){
        printf("File read fail ! byteread=%d\n", iBytesRead);
		return 0;
    }
    memset(&WMA_Format, 0, sizeof(WMAFormat));
    memset(&PCM_Format, 0, sizeof(WMAFormat));
    memset(&WMAInitParams, 0, sizeof(WMAProRawDecInitParams));
    memset(&WMA_playerInfo, 0, sizeof(WMAPlayerInfo));

/* wma information got from asf parser */
    WMA_Format.nChannels =  2;
    WMA_Format.nSamplesPerSec = 0xac44;
    WMA_Format.dwAdvancedEncodeOpt2 = 0;
    WMA_Format.nAvgBytesPerSec = 0x9c41;
    WMA_Format.nBlockAlign = 0x3a0d; //packet_length
    WMA_Format.nChannelMask = 0x0;
    WMA_Format.nValidBitsPerSample = 0x10;
    WMA_Format.wAdvancedEncodeOpt = 0;
    WMA_Format.wEncodeOpt = 0xf;
    WMA_Format.wFormatTag = 0x161;
/*************************/
    packet_length = WMA_Format.nBlockAlign;
    fNewPacket = 1;   //input data is new packet/frame in asf/SPDIF mode
    fNoMoreInput = 0;
    fTime = 0;
    rtTime = 0;
    cSamplesReady = 0;
    cSamplesReturned =0;
    cFetchedSamples = 0;
    WMAProWMAFormat2PCMFormat(&WMA_Format, &PCM_Format);

    /*callbackless mode */

    /* creat a WMAProrawDec handle*/
	hr = WMAProRawDecNew(&phWMAProRawDec, NULL, 0);
    if (hr != WMA_OK)
        goto lexit;

#if 1 // callbackless/normal mode
    g_cbBuffer = iBytesRead;
    /*initilize WMAProRawDec decoder*/
    hr = WMAProRawDecInit(phWMAProRawDec, &WMA_Format, &PCM_Format, NULL, &WMADecState, NULL);
    if (hr != WMA_OK){
        printf("Init error! hr=%d\n", hr);
        goto lexit;
    }

    while (WMAProRawDecStateDone != WMADecState){
        switch(WMADecState){
            case WMAProRawDecStateInput:
                   hr = WMAProRawDecInput(phWMAProRawDec, g_pBuffer, packet_length, fNewPacket, fNoMoreInput, fTime, rtTime, &WMADecState, NULL);
                g_pBuffer += packet_length;
                g_cbBuffer -= packet_length;
                if(g_cbBuffer <= 0)
                    fNoMoreInput = 1;
                break;
            case WMAProRawDecStateDecode:
                hr = WMAProRawDecDecode(phWMAProRawDec, &cSamplesReady, &WMADecState, NULL /* * pParams (only for SPDIF)*/ );
                break;
            case WMAProRawDecStateGetPCM:
                hr = WMAProRawDecGetPCM(phWMAProRawDec, cSamplesReady, &cSamplesReturned,
                                        gOututBuf, cbDstLength, &cbDstUsed, &rtTime,
                                        &WMADecState, &WMA_playerInfo, NULL);
                fwrite(gOututBuf, WMA_Format.nValidBitsPerSample/8,
                       cSamplesReturned * WMA_Format.nChannels, fpOutput);
				printf("0x%x samples is written out. \n",cSamplesReturned);
                break;
        }
    }
#endif

#if 0 // callback mode
    WMAInitParams.pfnGetMoreData =
    WMAInitParams.iMemBufUsed =

    hr = WMAProRawDecInit(phWMAProRawDec, &WMA_Format, &PCM_Format, NULL, &WMADecState, &WMAInitParams);
    if (hr != WMA_OK)
        goto lexit;
    do {
        //for callbackless input
        //hr = WMAProRawDecInput(phWMAProRawDec, g_pBuffer, packet_length, 1, 0, 0, 0, &WMADecState, NULL);
        //    if (hr != WMA_OK)
        //        goto lexit;
        //g_pBuffer += packet_length;
        //g_cbBuffer -= packet_length;
        //if(iBytesRead <=0 )
        //    break;
        /*Decode inupt data*/
        hr = WMAProRawDecDecode(phWMAProRawDec,&cSamplesReady,
                    &WMADecState,NULL /*&WMAInitParams*/);
        if (hr != WMA_OK)
            goto lexit;

        if (cSamplesReady > 0){
            cFetchedSamples = 0;
            do {
                /*Get PCM output sample*/
                hr = WMAProRawDecGetPCM(phWMAProRawDec, cSamplesReady, &cSamplesReturned,
                                        gOututBuf, cbDstLength, &cbDstUsed, &rtTime ,
                                        &WMADecState, &WMA_playerInfo, NULL);
                if (hr != WMA_OK)
                    goto lexit;
            if (cSamplesReturned == 0)
            {
                /* no more, so on with the decoding... */
                break;
            }
                fwrite(gOututBuf, WMA_Format.nValidBitsPerSample/8,
                    cSamplesReturned * WMA_Format.nChannels, fpOutput);
                cFetchedSamples += cSamplesReturned;
            }while(cFetchedSamples < cSamplesReady);
        }
    } while(1);
#endif // callback mode
	printf("end of decoding\n");
lexit:
	printf("lexit hr=%d\n", hr);
    WMAProRawDecDelete(phWMAProRawDec);
    fclose(fpInput);
    fclose(fpOutput);
    return 1;



}
