//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
#include <stdlib.h>
#include "rawio.h"
//#include "preset.h"




RawFileIO * rfioNew()
{
    RawFileIO *prfio = (RawFileIO *)malloc(sizeof(RawFileIO));
    if(prfio == NULL)
        return NULL;

    prfio->m_mode = rfioModeRead;
    prfio->m_fpRaw = NULL;

    prfio->m_sizeData = 0;

    return prfio;
}


void rfioDelete(RawFileIO *prfio)
{
    rfioClose(prfio);
    free(prfio);
}


RAW_INT32 rfioOpen(RawFileIO *prfio,
         const TCHAR *szFile,
         RAW_INT32 mode)
{
    RAW_INT32 lr;

    if(prfio == NULL)
        return MMSYSERR_ERROR;

    //    if(prfio->m_fpRaw)
    //  return MMSYSERR_ERROR;

    prfio->m_mode = mode;

    if(prfio->m_mode == rfioModeWrite)
    {
        /* open the file for writing */
        prfio->m_fpRaw = _tfopen(szFile, _T("wb") );
        if(prfio->m_fpRaw == NULL)
        {
            lr = MMSYSERR_ERROR;
            goto lerror;
        }

    }
    else
    {
        /* open the file for reading */
        prfio->m_fpRaw = _tfopen(szFile, _T("rb") );
        if(prfio->m_fpRaw == NULL)
        {
            lr = MMSYSERR_ERROR;
            goto lerror;
        }


        /* seek to the beginning */
        rfioSeek(prfio, 0, SEEK_CUR);
    }

  return MMSYSERR_NOERROR;

lerror:
  rfioClose(prfio);
  return lr;
}


void rfioClose(RawFileIO *prfio)
{
    if(prfio == NULL)
        return;

    if(prfio->m_fpRaw)
    {
        fclose(prfio->m_fpRaw);
        prfio->m_fpRaw = NULL;
    }


    prfio->m_sizeData = 0;

}


RAW_INT32 rfioSeek(RawFileIO *prfio,
         RAW_INT32 position,
         RAW_INT32 origin)
{
    if(prfio == NULL)
        return -1;

        switch(origin)
    {
    case SEEK_SET:
        return fseek(prfio->m_fpRaw, position, SEEK_SET);
    case SEEK_CUR:
        return fseek(prfio->m_fpRaw, position, SEEK_CUR);

    }
  return -1;
}

RAW_INT32 rfioWrite(RawFileIO *prfio,
          RAW_UINT8 *pBuf,
          RAW_INT32 cbBuf)
{


    size_t ret;

    if(prfio == NULL)
        return (RAW_INT32)-1;

    if(prfio->m_fpRaw == NULL
       || prfio->m_mode != rfioModeWrite
       || pBuf == NULL)
        return (RAW_INT32)-1;

    ret = fwrite(pBuf, 1, cbBuf, prfio->m_fpRaw);
    if(ret != cbBuf)
        return (RAW_INT32)-1;

    prfio->m_sizeData += ret;

    return ret;
}

RAW_INT64 rfioTell(RawFileIO *prfio )
{
   return ftell(prfio->m_fpRaw);
}

RAW_INT32 rfioRead(RawFileIO *prfio,
         RAW_UINT8 *pBuf,
         RAW_INT32 cbBuf)
{
     size_t ret;

    if(prfio == NULL)
        return (RAW_INT32)-1;

    if(prfio->m_fpRaw == NULL
       || prfio->m_mode != rfioModeRead
       || pBuf == NULL)
        return (RAW_INT32)-1;

    ret = fread(pBuf, 1, cbBuf, prfio->m_fpRaw);
    prfio->m_sizeData += ret;
    if(ret != cbBuf)
        return (RAW_INT32)-1;

    return (RAW_INT32)ret;

}









