//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

#ifndef _SINCOS_ORIG_TBL_H_
#define _SINCOS_ORIG_TBL_H_


/***Following are the tables in this file *****
1..5 twid_table_1024 ... twid_table_64
6..10 pre_twid_table_1024 ... pre_twid_table_


***********************************************/
// factor for finding 1024 point FFT
I32 twid_table_1024[1024]= {
0x7fffffff,
0x00000000,
0x7fff61ff,
0xff36f079,
0x7ffd887f,
0xfe6de2e1,
0x7ffa72ff,
0xfda4d929,
0x7ff6217f,
0xfcdbd541,
0x7ff0947f,
0xfc12d919,
0x7fe9cb7f,
0xfb49e6a1,
0x7fe1c77f,
0xfa80ffc9,
0x7fd8877f,
0xf9b82681,
0x7fce0bff,
0xf8ef5cb9,
0x7fc2557f,
0xf826a461,
0x7fb5637f,
0xf75dff61,
0x7fa7367f,
0xf6956fb1,
0x7f97ce7f,
0xf5ccf741,
0x7f872bff,
0xf5049801,
0x7f754e7f,
0xf43c53d1,
0x7f62367f,
0xf3742ca1,
0x7f4de47f,
0xf2ac2471,
0x7f3857ff,
0xf1e43d21,
0x7f21917f,
0xf11c78a1,
0x7f0991ff,
0xf054d8d1,
0x7ef0587f,
0xef8d5fc1,
0x7ed5e5ff,
0xeec60f41,
0x7eba39ff,
0xedfee921,
0x7e9d55ff,
0xed37efa1,
0x7e7f397f,
0xec712441,
0x7e5fe47f,
0xebaa8941,
0x7e3f57ff,
0xeae42081,
0x7e1d93ff,
0xea1debc1,
0x7dfa987f,
0xe957ed01,
0x7dd6667f,
0xe8922621,
0x7db0fdff,
0xe7cc9921,
0x7d8a5eff,
0xe70747c1,
0x7d628aff,
0xe6423401,
0x7d3980ff,
0xe57d5fe1,
0x7d0f41ff,
0xe4b8cd21,
0x7ce3ce7f,
0xe3f47da1,
0x7cb726ff,
0xe3307341,
0x7c894bff,
0xe26cb021,
0x7c5a3d7f,
0xe1a935e1,
0x7c29fbff,
0xe0e60681,
0x7bf887ff,
0xe02323e1,
0x7bc5e27f,
0xdf609001,
0x7b920b7f,
0xde9e4c81,
0x7b5d037f,
0xdddc5b41,
0x7b26cb7f,
0xdd1abe41,
0x7aef62ff,
0xdc597781,
0x7ab6cb7f,
0xdb9888c1,
0x7a7d057f,
0xdad7f3c1,
0x7a4210ff,
0xda17ba41,
0x7a05ee7f,
0xd957de81,
0x79c89f7f,
0xd8986201,
0x798a237f,
0xd7d946c1,
0x794a7bff,
0xd71a8ec1,
0x7909a8ff,
0xd65c3b81,
0x78c7ab7f,
0xd59e4f01,
0x788483ff,
0xd4e0cb01,
0x784032ff,
0xd423b181,
0x77fab97f,
0xd3670441,
0x77b417ff,
0xd2aac501,
0x776c4eff,
0xd1eef581,
0x77235eff,
0xd1339801,
0x76d9497f,
0xd078ad81,
0x768e0e7f,
0xcfbe3881,
0x7641aeff,
0xcf043ac1,
0x75f42bff,
0xce4ab5c1,
0x75a585ff,
0xcd91ab41,
0x7555bd7f,
0xccd91d41,
0x7504d37f,
0xcc210d81,
0x74b2c87f,
0xcb697dc1,
0x745f9dff,
0xcab26fc1,
0x740b53ff,
0xc9fbe541,
0x73b5ebff,
0xc945e001,
0x735f65ff,
0xc89061c1,
0x7307c3ff,
0xc7db6c41,
0x72af057f,
0xc7270181,
0x72552c7f,
0xc67322c1,
0x71fa397f,
0xc5bfd241,
0x719e2cff,
0xc50d1141,
0x714107ff,
0xc45ae1c1,
0x70e2cbff,
0xc3a94581,
0x708378ff,
0xc2f83e41,
0x7023107f,
0xc247cd41,
0x6fc1937f,
0xc197f4c1,
0x6f5f027f,
0xc0e8b641,
0x6efb5eff,
0xc03a1381,
0x6e96a97f,
0xbf8c0e01,
0x6e30e37f,
0xbedea781,
0x6dca0cff,
0xbe31e181,
0x6d6227ff,
0xbd85be01,
0x6cf934ff,
0xbcda3f01,
0x6c8f34ff,
0xbc2f6501,
0x6c24297f,
0xbb853281,
0x6bb812ff,
0xbadba981,
0x6b4af27f,
0xba32ca81,
0x6adcc97f,
0xb98a9801,
0x6a6d987f,
0xb8e31301,
0x69fd617f,
0xb83c3e01,
0x698c247f,
0xb7961981,
0x6919e2ff,
0xb6f0a801,
0x68a69e7f,
0xb64beb01,
0x6832577f,
0xb5a7e381,
0x67bd0f7f,
0xb5049381,
0x6746c7ff,
0xb461fc81,
0x66cf80ff,
0xb3c02001,
0x66573c7f,
0xb31f0001,
0x65ddfbff,
0xb27e9d01,
0x6563bf7f,
0xb1defa01,
0x64e888ff,
0xb1401781,
0x646c597f,
0xb0a1f701,
0x63ef327f,
0xb0049a81,
0x637114ff,
0xaf680381,
0x62f2017f,
0xaecc3381,
0x6271fa7f,
0xae312b81,
0x61f0ffff,
0xad96ed81,
0x616f147f,
0xacfd7b01,
0x60ec37ff,
0xac64d501,
0x60686cff,
0xabccfd81,
0x5fe3b37f,
0xab35f581,
0x5f5e0d7f,
0xaa9fbf01,
0x5ed77c7f,
0xaa0a5b01,
0x5e50017f,
0xa975cb81,
0x5dc79d7f,
0xa8e21101,
0x5d3e51ff,
0xa84f2d81,
0x5cb420ff,
0xa7bd2281,
0x5c290aff,
0xa72bf181,
0x5b9d117f,
0xa69b9b81,
0x5b1035ff,
0xa60c2201,
0x5a82797f,
0xa57d8681,
0x59f3ddff,
0xa4efca01,
0x5964647f,
0xa462ee81,
0x58d40e7f,
0xa3d6f501,
0x5842dd7f,
0xa34bdf01,
0x57b0d27f,
0xa2c1ae01,
0x571deeff,
0xa2386281,
0x568a347f,
0xa1affe81,
0x55f5a4ff,
0xa1288381,
0x556040ff,
0xa0a1f281,
0x54ca0a7f,
0xa01c4c81,
0x5433027f,
0x9f979301,
0x539b2aff,
0x9f13c801,
0x530284ff,
0x9e90eb81,
0x5269127f,
0x9e0f0001,
0x51ced47f,
0x9d8e0581,
0x5133cc7f,
0x9d0dfe81,
0x5097fc7f,
0x9c8eeb01,
0x4ffb657f,
0x9c10cd81,
0x4f5e08ff,
0x9b93a681,
0x4ebfe87f,
0x9b177701,
0x4e2105ff,
0x9a9c4081,
0x4d8162ff,
0x9a220401,
0x4ce0ffff,
0x99a8c381,
0x4c3fdfff,
0x99307f01,
0x4b9e037f,
0x98b93801,
0x4afb6c7f,
0x9842f081,
0x4a581c7f,
0x97cda881,
0x49b414ff,
0x97596181,
0x490f57ff,
0x96e61d01,
0x4869e67f,
0x9673db81,
0x47c3c1ff,
0x96029e81,
0x471cecff,
0x95926781,
0x467567ff,
0x95233681,
0x45cd357f,
0x94b50d81,
0x4524567f,
0x9447ed01,
0x447acd7f,
0x93dbd681,
0x43d09aff,
0x9370cb01,
0x4325c0ff,
0x9306cb01,
0x427a41ff,
0x929dd801,
0x41ce1e7f,
0x9235f301,
0x4121587f,
0x91cf1c81,
0x4073f1ff,
0x91695681,
0x3fc5ec7f,
0x9104a101,
0x3f1749bf,
0x90a0fd81,
0x3e680b3f,
0x903e6c81,
0x3db832bf,
0x8fdcef81,
0x3d07c1bf,
0x8f7c8701,
0x3c56ba7f,
0x8f1d3401,
0x3ba51e3f,
0x8ebef801,
0x3af2eebf,
0x8e61d301,
0x3a402dbf,
0x8e05c681,
0x398cdd3f,
0x8daad381,
0x38d8fe7f,
0x8d50fa81,
0x382493bf,
0x8cf83c01,
0x376f9e3f,
0x8ca09a01,
0x36ba1fff,
0x8c4a1401,
0x36041abf,
0x8bf4ac01,
0x354d903f,
0x8ba06201,
0x3496823f,
0x8b4d3781,
0x33def27f,
0x8afb2c81,
0x3326e2bf,
0x8aaa4281,
0x326e54bf,
0x8a5a7a01,
0x31b54a3f,
0x8a0bd401,
0x30fbc53f,
0x89be5101,
0x3041c77f,
0x8971f181,
0x2f87527f,
0x8926b681,
0x2ecc67ff,
0x88dca101,
0x2e110a7f,
0x8893b101,
0x2d553aff,
0x884be801,
0x2c98fbbf,
0x88054681,
0x2bdc4e7f,
0x87bfcd01,
0x2b1f34ff,
0x877b7c01,
0x2a61b0ff,
0x87385481,
0x29a3c47f,
0x86f65701,
0x28e5713f,
0x86b58401,
0x2826b93f,
0x8675dc81,
0x27679dff,
0x86376081,
0x26a8217f,
0x85fa1181,
0x25e845bf,
0x85bdef01,
0x25280c3f,
0x8582fa81,
0x2467773f,
0x85493481,
0x23a6887f,
0x85109d01,
0x22e541bf,
0x84d93481,
0x2223a4bf,
0x84a2fc81,
0x2161b37f,
0x846df481,
0x209f6fff,
0x843a1d81,
0x1fdcdc1f,
0x84077801,
0x1f19f97f,
0x83d60401,
0x1e56ca1f,
0x83a5c281,
0x1d934fdf,
0x8376b401,
0x1ccf8cbf,
0x8348d901,
0x1c0b825f,
0x831c3181,
0x1b4732df,
0x82f0be01,
0x1a82a01f,
0x82c67f01,
0x19bdcbff,
0x829d7501,
0x18f8b83f,
0x8275a101,
0x183366df,
0x824f0201,
0x176dd9df,
0x82299981,
0x16a812ff,
0x82056781,
0x15e2143f,
0x81e26c01,
0x151bdf7f,
0x81c0a801,
0x145576bf,
0x81a01b81,
0x138edbbf,
0x8180c681,
0x12c8105f,
0x8162aa01,
0x120116df,
0x8145c601,
0x1139f0bf,
0x812a1a01,
0x1072a03f,
0x810fa781,
0x0fab272f,
0x80f66e01,
0x0ee3875f,
0x80de6e81,
0x0e1bc2df,
0x80c7a801,
0x0d53db8f,
0x80b21b81,
0x0c8bd35f,
0x809dc981,
0x0bc3ac2f,
0x808ab181,
0x0afb67ff,
0x8078d401,
0x0a3308bf,
0x80683181,
0x096a904f,
0x8058c981,
0x08a2009f,
0x804a9c81,
0x07d95b9f,
0x803daa81,
0x0710a347,
0x8031f401,
0x0647d97f,
0x80277881,
0x057f0037,
0x801e3881,
0x04b6195f,
0x80163481,
0x03ed26e7,
0x800f6b81,
0x03242abf,
0x8009de81,
0x025b26d7,
0x80058d01,
0x01921d1f,
0x80027781,
0x00c90f87,
0x80009e01,
0x00000000,
0x80000001,
0xff36f079,
0x80009e01,
0xfe6de2e1,
0x80027781,
0xfda4d929,
0x80058d01,
0xfcdbd541,
0x8009de81,
0xfc12d919,
0x800f6b81,
0xfb49e6a1,
0x80163481,
0xfa80ffc9,
0x801e3881,
0xf9b82681,
0x80277881,
0xf8ef5cb9,
0x8031f401,
0xf826a461,
0x803daa81,
0xf75dff61,
0x804a9c81,
0xf6956fb1,
0x8058c981,
0xf5ccf741,
0x80683181,
0xf5049801,
0x8078d401,
0xf43c53d1,
0x808ab181,
0xf3742ca1,
0x809dc981,
0xf2ac2471,
0x80b21b81,
0xf1e43d21,
0x80c7a801,
0xf11c78a1,
0x80de6e81,
0xf054d8d1,
0x80f66e01,
0xef8d5fc1,
0x810fa781,
0xeec60f41,
0x812a1a01,
0xedfee921,
0x8145c601,
0xed37efa1,
0x8162aa01,
0xec712441,
0x8180c681,
0xebaa8941,
0x81a01b81,
0xeae42081,
0x81c0a801,
0xea1debc1,
0x81e26c01,
0xe957ed01,
0x82056781,
0xe8922621,
0x82299981,
0xe7cc9921,
0x824f0201,
0xe70747c1,
0x8275a101,
0xe6423401,
0x829d7501,
0xe57d5fe1,
0x82c67f01,
0xe4b8cd21,
0x82f0be01,
0xe3f47da1,
0x831c3181,
0xe3307341,
0x8348d901,
0xe26cb021,
0x8376b401,
0xe1a935e1,
0x83a5c281,
0xe0e60681,
0x83d60401,
0xe02323e1,
0x84077801,
0xdf609001,
0x843a1d81,
0xde9e4c81,
0x846df481,
0xdddc5b41,
0x84a2fc81,
0xdd1abe41,
0x84d93481,
0xdc597781,
0x85109d01,
0xdb9888c1,
0x85493481,
0xdad7f3c1,
0x8582fa81,
0xda17ba41,
0x85bdef01,
0xd957de81,
0x85fa1181,
0xd8986201,
0x86376081,
0xd7d946c1,
0x8675dc81,
0xd71a8ec1,
0x86b58401,
0xd65c3b81,
0x86f65701,
0xd59e4f01,
0x87385481,
0xd4e0cb01,
0x877b7c01,
0xd423b181,
0x87bfcd01,
0xd3670441,
0x88054681,
0xd2aac501,
0x884be801,
0xd1eef581,
0x8893b101,
0xd1339801,
0x88dca101,
0xd078ad81,
0x8926b681,
0xcfbe3881,
0x8971f181,
0xcf043ac1,
0x89be5101,
0xce4ab5c1,
0x8a0bd401,
0xcd91ab41,
0x8a5a7a01,
0xccd91d41,
0x8aaa4281,
0xcc210d81,
0x8afb2c81,
0xcb697dc1,
0x8b4d3781,
0xcab26fc1,
0x8ba06201,
0xc9fbe541,
0x8bf4ac01,
0xc945e001,
0x8c4a1401,
0xc89061c1,
0x8ca09a01,
0xc7db6c41,
0x8cf83c01,
0xc7270181,
0x8d50fa81,
0xc67322c1,
0x8daad381,
0xc5bfd241,
0x8e05c681,
0xc50d1141,
0x8e61d301,
0xc45ae1c1,
0x8ebef801,
0xc3a94581,
0x8f1d3401,
0xc2f83e41,
0x8f7c8701,
0xc247cd41,
0x8fdcef81,
0xc197f4c1,
0x903e6c81,
0xc0e8b641,
0x90a0fd81,
0xc03a1381,
0x9104a101,
0xbf8c0e01,
0x91695681,
0xbedea781,
0x91cf1c81,
0xbe31e181,
0x9235f301,
0xbd85be01,
0x929dd801,
0xbcda3f01,
0x9306cb01,
0xbc2f6501,
0x9370cb01,
0xbb853281,
0x93dbd681,
0xbadba981,
0x9447ed01,
0xba32ca81,
0x94b50d81,
0xb98a9801,
0x95233681,
0xb8e31301,
0x95926781,
0xb83c3e01,
0x96029e81,
0xb7961981,
0x9673db81,
0xb6f0a801,
0x96e61d01,
0xb64beb01,
0x97596181,
0xb5a7e381,
0x97cda881,
0xb5049381,
0x9842f081,
0xb461fc81,
0x98b93801,
0xb3c02001,
0x99307f01,
0xb31f0001,
0x99a8c381,
0xb27e9d01,
0x9a220401,
0xb1defa01,
0x9a9c4081,
0xb1401781,
0x9b177701,
0xb0a1f701,
0x9b93a681,
0xb0049a81,
0x9c10cd81,
0xaf680381,
0x9c8eeb01,
0xaecc3381,
0x9d0dfe81,
0xae312b81,
0x9d8e0581,
0xad96ed81,
0x9e0f0001,
0xacfd7b01,
0x9e90eb81,
0xac64d501,
0x9f13c801,
0xabccfd81,
0x9f979301,
0xab35f581,
0xa01c4c81,
0xaa9fbf01,
0xa0a1f281,
0xaa0a5b01,
0xa1288381,
0xa975cb81,
0xa1affe81,
0xa8e21101,
0xa2386281,
0xa84f2d81,
0xa2c1ae01,
0xa7bd2281,
0xa34bdf01,
0xa72bf181,
0xa3d6f501,
0xa69b9b81,
0xa462ee81,
0xa60c2201,
0xa4efca01,
0xa57d8681,
0xa57d8681,
0xa4efca01,
0xa60c2201,
0xa462ee81,
0xa69b9b81,
0xa3d6f501,
0xa72bf181,
0xa34bdf01,
0xa7bd2281,
0xa2c1ae01,
0xa84f2d81,
0xa2386281,
0xa8e21101,
0xa1affe81,
0xa975cb81,
0xa1288381,
0xaa0a5b01,
0xa0a1f281,
0xaa9fbf01,
0xa01c4c81,
0xab35f581,
0x9f979301,
0xabccfd81,
0x9f13c801,
0xac64d501,
0x9e90eb81,
0xacfd7b01,
0x9e0f0001,
0xad96ed81,
0x9d8e0581,
0xae312b81,
0x9d0dfe81,
0xaecc3381,
0x9c8eeb01,
0xaf680381,
0x9c10cd81,
0xb0049a81,
0x9b93a681,
0xb0a1f701,
0x9b177701,
0xb1401781,
0x9a9c4081,
0xb1defa01,
0x9a220401,
0xb27e9d01,
0x99a8c381,
0xb31f0001,
0x99307f01,
0xb3c02001,
0x98b93801,
0xb461fc81,
0x9842f081,
0xb5049381,
0x97cda881,
0xb5a7e381,
0x97596181,
0xb64beb01,
0x96e61d01,
0xb6f0a801,
0x9673db81,
0xb7961981,
0x96029e81,
0xb83c3e01,
0x95926781,
0xb8e31301,
0x95233681,
0xb98a9801,
0x94b50d81,
0xba32ca81,
0x9447ed01,
0xbadba981,
0x93dbd681,
0xbb853281,
0x9370cb01,
0xbc2f6501,
0x9306cb01,
0xbcda3f01,
0x929dd801,
0xbd85be01,
0x9235f301,
0xbe31e181,
0x91cf1c81,
0xbedea781,
0x91695681,
0xbf8c0e01,
0x9104a101,
0xc03a1381,
0x90a0fd81,
0xc0e8b641,
0x903e6c81,
0xc197f4c1,
0x8fdcef81,
0xc247cd41,
0x8f7c8701,
0xc2f83e41,
0x8f1d3401,
0xc3a94581,
0x8ebef801,
0xc45ae1c1,
0x8e61d301,
0xc50d1141,
0x8e05c681,
0xc5bfd241,
0x8daad381,
0xc67322c1,
0x8d50fa81,
0xc7270181,
0x8cf83c01,
0xc7db6c41,
0x8ca09a01,
0xc89061c1,
0x8c4a1401,
0xc945e001,
0x8bf4ac01,
0xc9fbe541,
0x8ba06201,
0xcab26fc1,
0x8b4d3781,
0xcb697dc1,
0x8afb2c81,
0xcc210d81,
0x8aaa4281,
0xccd91d41,
0x8a5a7a01,
0xcd91ab41,
0x8a0bd401,
0xce4ab5c1,
0x89be5101,
0xcf043ac1,
0x8971f181,
0xcfbe3881,
0x8926b681,
0xd078ad81,
0x88dca101,
0xd1339801,
0x8893b101,
0xd1eef581,
0x884be801,
0xd2aac501,
0x88054681,
0xd3670441,
0x87bfcd01,
0xd423b181,
0x877b7c01,
0xd4e0cb01,
0x87385481,
0xd59e4f01,
0x86f65701,
0xd65c3b81,
0x86b58401,
0xd71a8ec1,
0x8675dc81,
0xd7d946c1,
0x86376081,
0xd8986201,
0x85fa1181,
0xd957de81,
0x85bdef01,
0xda17ba41,
0x8582fa81,
0xdad7f3c1,
0x85493481,
0xdb9888c1,
0x85109d01,
0xdc597781,
0x84d93481,
0xdd1abe41,
0x84a2fc81,
0xdddc5b41,
0x846df481,
0xde9e4c81,
0x843a1d81,
0xdf609001,
0x84077801,
0xe02323e1,
0x83d60401,
0xe0e60681,
0x83a5c281,
0xe1a935e1,
0x8376b401,
0xe26cb021,
0x8348d901,
0xe3307341,
0x831c3181,
0xe3f47da1,
0x82f0be01,
0xe4b8cd21,
0x82c67f01,
0xe57d5fe1,
0x829d7501,
0xe6423401,
0x8275a101,
0xe70747c1,
0x824f0201,
0xe7cc9921,
0x82299981,
0xe8922621,
0x82056781,
0xe957ed01,
0x81e26c01,
0xea1debc1,
0x81c0a801,
0xeae42081,
0x81a01b81,
0xebaa8941,
0x8180c681,
0xec712441,
0x8162aa01,
0xed37efa1,
0x8145c601,
0xedfee921,
0x812a1a01,
0xeec60f41,
0x810fa781,
0xef8d5fc1,
0x80f66e01,
0xf054d8d1,
0x80de6e81,
0xf11c78a1,
0x80c7a801,
0xf1e43d21,
0x80b21b81,
0xf2ac2471,
0x809dc981,
0xf3742ca1,
0x808ab181,
0xf43c53d1,
0x8078d401,
0xf5049801,
0x80683181,
0xf5ccf741,
0x8058c981,
0xf6956fb1,
0x804a9c81,
0xf75dff61,
0x803daa81,
0xf826a461,
0x8031f401,
0xf8ef5cb9,
0x80277881,
0xf9b82681,
0x801e3881,
0xfa80ffc9,
0x80163481,
0xfb49e6a1,
0x800f6b81,
0xfc12d919,
0x8009de81,
0xfcdbd541,
0x80058d01,
0xfda4d929,
0x80027781,
0xfe6de2e1,
0x80009e01,
0xff36f079
};

I32 twid_table_512[512]= {
0x7fffffff,
0x00000000,
0x7ffd887f,
0xfe6de2e1,
0x7ff6217f,
0xfcdbd541,
0x7fe9cb7f,
0xfb49e6a1,
0x7fd8877f,
0xf9b82681,
0x7fc2557f,
0xf826a461,
0x7fa7367f,
0xf6956fb1,
0x7f872bff,
0xf5049801,
0x7f62367f,
0xf3742ca1,
0x7f3857ff,
0xf1e43d21,
0x7f0991ff,
0xf054d8d1,
0x7ed5e5ff,
0xeec60f41,
0x7e9d55ff,
0xed37efa1,
0x7e5fe47f,
0xebaa8941,
0x7e1d93ff,
0xea1debc1,
0x7dd6667f,
0xe8922621,
0x7d8a5eff,
0xe70747c1,
0x7d3980ff,
0xe57d5fe1,
0x7ce3ce7f,
0xe3f47da1,
0x7c894bff,
0xe26cb021,
0x7c29fbff,
0xe0e60681,
0x7bc5e27f,
0xdf609001,
0x7b5d037f,
0xdddc5b41,
0x7aef62ff,
0xdc597781,
0x7a7d057f,
0xdad7f3c1,
0x7a05ee7f,
0xd957de81,
0x798a237f,
0xd7d946c1,
0x7909a8ff,
0xd65c3b81,
0x788483ff,
0xd4e0cb01,
0x77fab97f,
0xd3670441,
0x776c4eff,
0xd1eef581,
0x76d9497f,
0xd078ad81,
0x7641aeff,
0xcf043ac1,
0x75a585ff,
0xcd91ab41,
0x7504d37f,
0xcc210d81,
0x745f9dff,
0xcab26fc1,
0x73b5ebff,
0xc945e001,
0x7307c3ff,
0xc7db6c41,
0x72552c7f,
0xc67322c1,
0x719e2cff,
0xc50d1141,
0x70e2cbff,
0xc3a94581,
0x7023107f,
0xc247cd41,
0x6f5f027f,
0xc0e8b641,
0x6e96a97f,
0xbf8c0e01,
0x6dca0cff,
0xbe31e181,
0x6cf934ff,
0xbcda3f01,
0x6c24297f,
0xbb853281,
0x6b4af27f,
0xba32ca81,
0x6a6d987f,
0xb8e31301,
0x698c247f,
0xb7961981,
0x68a69e7f,
0xb64beb01,
0x67bd0f7f,
0xb5049381,
0x66cf80ff,
0xb3c02001,
0x65ddfbff,
0xb27e9d01,
0x64e888ff,
0xb1401781,
0x63ef327f,
0xb0049a81,
0x62f2017f,
0xaecc3381,
0x61f0ffff,
0xad96ed81,
0x60ec37ff,
0xac64d501,
0x5fe3b37f,
0xab35f581,
0x5ed77c7f,
0xaa0a5b01,
0x5dc79d7f,
0xa8e21101,
0x5cb420ff,
0xa7bd2281,
0x5b9d117f,
0xa69b9b81,
0x5a82797f,
0xa57d8681,
0x5964647f,
0xa462ee81,
0x5842dd7f,
0xa34bdf01,
0x571deeff,
0xa2386281,
0x55f5a4ff,
0xa1288381,
0x54ca0a7f,
0xa01c4c81,
0x539b2aff,
0x9f13c801,
0x5269127f,
0x9e0f0001,
0x5133cc7f,
0x9d0dfe81,
0x4ffb657f,
0x9c10cd81,
0x4ebfe87f,
0x9b177701,
0x4d8162ff,
0x9a220401,
0x4c3fdfff,
0x99307f01,
0x4afb6c7f,
0x9842f081,
0x49b414ff,
0x97596181,
0x4869e67f,
0x9673db81,
0x471cecff,
0x95926781,
0x45cd357f,
0x94b50d81,
0x447acd7f,
0x93dbd681,
0x4325c0ff,
0x9306cb01,
0x41ce1e7f,
0x9235f301,
0x4073f1ff,
0x91695681,
0x3f1749bf,
0x90a0fd81,
0x3db832bf,
0x8fdcef81,
0x3c56ba7f,
0x8f1d3401,
0x3af2eebf,
0x8e61d301,
0x398cdd3f,
0x8daad381,
0x382493bf,
0x8cf83c01,
0x36ba1fff,
0x8c4a1401,
0x354d903f,
0x8ba06201,
0x33def27f,
0x8afb2c81,
0x326e54bf,
0x8a5a7a01,
0x30fbc53f,
0x89be5101,
0x2f87527f,
0x8926b681,
0x2e110a7f,
0x8893b101,
0x2c98fbbf,
0x88054681,
0x2b1f34ff,
0x877b7c01,
0x29a3c47f,
0x86f65701,
0x2826b93f,
0x8675dc81,
0x26a8217f,
0x85fa1181,
0x25280c3f,
0x8582fa81,
0x23a6887f,
0x85109d01,
0x2223a4bf,
0x84a2fc81,
0x209f6fff,
0x843a1d81,
0x1f19f97f,
0x83d60401,
0x1d934fdf,
0x8376b401,
0x1c0b825f,
0x831c3181,
0x1a82a01f,
0x82c67f01,
0x18f8b83f,
0x8275a101,
0x176dd9df,
0x82299981,
0x15e2143f,
0x81e26c01,
0x145576bf,
0x81a01b81,
0x12c8105f,
0x8162aa01,
0x1139f0bf,
0x812a1a01,
0x0fab272f,
0x80f66e01,
0x0e1bc2df,
0x80c7a801,
0x0c8bd35f,
0x809dc981,
0x0afb67ff,
0x8078d401,
0x096a904f,
0x8058c981,
0x07d95b9f,
0x803daa81,
0x0647d97f,
0x80277881,
0x04b6195f,
0x80163481,
0x03242abf,
0x8009de81,
0x01921d1f,
0x80027781,
0x00000000,
0x80000001,
0xfe6de2e1,
0x80027781,
0xfcdbd541,
0x8009de81,
0xfb49e6a1,
0x80163481,
0xf9b82681,
0x80277881,
0xf826a461,
0x803daa81,
0xf6956fb1,
0x8058c981,
0xf5049801,
0x8078d401,
0xf3742ca1,
0x809dc981,
0xf1e43d21,
0x80c7a801,
0xf054d8d1,
0x80f66e01,
0xeec60f41,
0x812a1a01,
0xed37efa1,
0x8162aa01,
0xebaa8941,
0x81a01b81,
0xea1debc1,
0x81e26c01,
0xe8922621,
0x82299981,
0xe70747c1,
0x8275a101,
0xe57d5fe1,
0x82c67f01,
0xe3f47da1,
0x831c3181,
0xe26cb021,
0x8376b401,
0xe0e60681,
0x83d60401,
0xdf609001,
0x843a1d81,
0xdddc5b41,
0x84a2fc81,
0xdc597781,
0x85109d01,
0xdad7f3c1,
0x8582fa81,
0xd957de81,
0x85fa1181,
0xd7d946c1,
0x8675dc81,
0xd65c3b81,
0x86f65701,
0xd4e0cb01,
0x877b7c01,
0xd3670441,
0x88054681,
0xd1eef581,
0x8893b101,
0xd078ad81,
0x8926b681,
0xcf043ac1,
0x89be5101,
0xcd91ab41,
0x8a5a7a01,
0xcc210d81,
0x8afb2c81,
0xcab26fc1,
0x8ba06201,
0xc945e001,
0x8c4a1401,
0xc7db6c41,
0x8cf83c01,
0xc67322c1,
0x8daad381,
0xc50d1141,
0x8e61d301,
0xc3a94581,
0x8f1d3401,
0xc247cd41,
0x8fdcef81,
0xc0e8b641,
0x90a0fd81,
0xbf8c0e01,
0x91695681,
0xbe31e181,
0x9235f301,
0xbcda3f01,
0x9306cb01,
0xbb853281,
0x93dbd681,
0xba32ca81,
0x94b50d81,
0xb8e31301,
0x95926781,
0xb7961981,
0x9673db81,
0xb64beb01,
0x97596181,
0xb5049381,
0x9842f081,
0xb3c02001,
0x99307f01,
0xb27e9d01,
0x9a220401,
0xb1401781,
0x9b177701,
0xb0049a81,
0x9c10cd81,
0xaecc3381,
0x9d0dfe81,
0xad96ed81,
0x9e0f0001,
0xac64d501,
0x9f13c801,
0xab35f581,
0xa01c4c81,
0xaa0a5b01,
0xa1288381,
0xa8e21101,
0xa2386281,
0xa7bd2281,
0xa34bdf01,
0xa69b9b81,
0xa462ee81,
0xa57d8681,
0xa57d8681,
0xa462ee81,
0xa69b9b81,
0xa34bdf01,
0xa7bd2281,
0xa2386281,
0xa8e21101,
0xa1288381,
0xaa0a5b01,
0xa01c4c81,
0xab35f581,
0x9f13c801,
0xac64d501,
0x9e0f0001,
0xad96ed81,
0x9d0dfe81,
0xaecc3381,
0x9c10cd81,
0xb0049a81,
0x9b177701,
0xb1401781,
0x9a220401,
0xb27e9d01,
0x99307f01,
0xb3c02001,
0x9842f081,
0xb5049381,
0x97596181,
0xb64beb01,
0x9673db81,
0xb7961981,
0x95926781,
0xb8e31301,
0x94b50d81,
0xba32ca81,
0x93dbd681,
0xbb853281,
0x9306cb01,
0xbcda3f01,
0x9235f301,
0xbe31e181,
0x91695681,
0xbf8c0e01,
0x90a0fd81,
0xc0e8b641,
0x8fdcef81,
0xc247cd41,
0x8f1d3401,
0xc3a94581,
0x8e61d301,
0xc50d1141,
0x8daad381,
0xc67322c1,
0x8cf83c01,
0xc7db6c41,
0x8c4a1401,
0xc945e001,
0x8ba06201,
0xcab26fc1,
0x8afb2c81,
0xcc210d81,
0x8a5a7a01,
0xcd91ab41,
0x89be5101,
0xcf043ac1,
0x8926b681,
0xd078ad81,
0x8893b101,
0xd1eef581,
0x88054681,
0xd3670441,
0x877b7c01,
0xd4e0cb01,
0x86f65701,
0xd65c3b81,
0x8675dc81,
0xd7d946c1,
0x85fa1181,
0xd957de81,
0x8582fa81,
0xdad7f3c1,
0x85109d01,
0xdc597781,
0x84a2fc81,
0xdddc5b41,
0x843a1d81,
0xdf609001,
0x83d60401,
0xe0e60681,
0x8376b401,
0xe26cb021,
0x831c3181,
0xe3f47da1,
0x82c67f01,
0xe57d5fe1,
0x8275a101,
0xe70747c1,
0x82299981,
0xe8922621,
0x81e26c01,
0xea1debc1,
0x81a01b81,
0xebaa8941,
0x8162aa01,
0xed37efa1,
0x812a1a01,
0xeec60f41,
0x80f66e01,
0xf054d8d1,
0x80c7a801,
0xf1e43d21,
0x809dc981,
0xf3742ca1,
0x8078d401,
0xf5049801,
0x8058c981,
0xf6956fb1,
0x803daa81,
0xf826a461,
0x80277881,
0xf9b82681,
0x80163481,
0xfb49e6a1,
0x8009de81,
0xfcdbd541,
0x80027781,
0xfe6de2e1
};

I32 twid_table_256[256]= {
0x7fffffff,
0x00000000,
0x7ff6217f,
0xfcdbd541,
0x7fd8877f,
0xf9b82681,
0x7fa7367f,
0xf6956fb1,
0x7f62367f,
0xf3742ca1,
0x7f0991ff,
0xf054d8d1,
0x7e9d55ff,
0xed37efa1,
0x7e1d93ff,
0xea1debc1,
0x7d8a5eff,
0xe70747c1,
0x7ce3ce7f,
0xe3f47da1,
0x7c29fbff,
0xe0e60681,
0x7b5d037f,
0xdddc5b41,
0x7a7d057f,
0xdad7f3c1,
0x798a237f,
0xd7d946c1,
0x788483ff,
0xd4e0cb01,
0x776c4eff,
0xd1eef581,
0x7641aeff,
0xcf043ac1,
0x7504d37f,
0xcc210d81,
0x73b5ebff,
0xc945e001,
0x72552c7f,
0xc67322c1,
0x70e2cbff,
0xc3a94581,
0x6f5f027f,
0xc0e8b641,
0x6dca0cff,
0xbe31e181,
0x6c24297f,
0xbb853281,
0x6a6d987f,
0xb8e31301,
0x68a69e7f,
0xb64beb01,
0x66cf80ff,
0xb3c02001,
0x64e888ff,
0xb1401781,
0x62f2017f,
0xaecc3381,
0x60ec37ff,
0xac64d501,
0x5ed77c7f,
0xaa0a5b01,
0x5cb420ff,
0xa7bd2281,
0x5a82797f,
0xa57d8681,
0x5842dd7f,
0xa34bdf01,
0x55f5a4ff,
0xa1288381,
0x539b2aff,
0x9f13c801,
0x5133cc7f,
0x9d0dfe81,
0x4ebfe87f,
0x9b177701,
0x4c3fdfff,
0x99307f01,
0x49b414ff,
0x97596181,
0x471cecff,
0x95926781,
0x447acd7f,
0x93dbd681,
0x41ce1e7f,
0x9235f301,
0x3f1749bf,
0x90a0fd81,
0x3c56ba7f,
0x8f1d3401,
0x398cdd3f,
0x8daad381,
0x36ba1fff,
0x8c4a1401,
0x33def27f,
0x8afb2c81,
0x30fbc53f,
0x89be5101,
0x2e110a7f,
0x8893b101,
0x2b1f34ff,
0x877b7c01,
0x2826b93f,
0x8675dc81,
0x25280c3f,
0x8582fa81,
0x2223a4bf,
0x84a2fc81,
0x1f19f97f,
0x83d60401,
0x1c0b825f,
0x831c3181,
0x18f8b83f,
0x8275a101,
0x15e2143f,
0x81e26c01,
0x12c8105f,
0x8162aa01,
0x0fab272f,
0x80f66e01,
0x0c8bd35f,
0x809dc981,
0x096a904f,
0x8058c981,
0x0647d97f,
0x80277881,
0x03242abf,
0x8009de81,
0x00000000,
0x80000001,
0xfcdbd541,
0x8009de81,
0xf9b82681,
0x80277881,
0xf6956fb1,
0x8058c981,
0xf3742ca1,
0x809dc981,
0xf054d8d1,
0x80f66e01,
0xed37efa1,
0x8162aa01,
0xea1debc1,
0x81e26c01,
0xe70747c1,
0x8275a101,
0xe3f47da1,
0x831c3181,
0xe0e60681,
0x83d60401,
0xdddc5b41,
0x84a2fc81,
0xdad7f3c1,
0x8582fa81,
0xd7d946c1,
0x8675dc81,
0xd4e0cb01,
0x877b7c01,
0xd1eef581,
0x8893b101,
0xcf043ac1,
0x89be5101,
0xcc210d81,
0x8afb2c81,
0xc945e001,
0x8c4a1401,
0xc67322c1,
0x8daad381,
0xc3a94581,
0x8f1d3401,
0xc0e8b641,
0x90a0fd81,
0xbe31e181,
0x9235f301,
0xbb853281,
0x93dbd681,
0xb8e31301,
0x95926781,
0xb64beb01,
0x97596181,
0xb3c02001,
0x99307f01,
0xb1401781,
0x9b177701,
0xaecc3381,
0x9d0dfe81,
0xac64d501,
0x9f13c801,
0xaa0a5b01,
0xa1288381,
0xa7bd2281,
0xa34bdf01,
0xa57d8681,
0xa57d8681,
0xa34bdf01,
0xa7bd2281,
0xa1288381,
0xaa0a5b01,
0x9f13c801,
0xac64d501,
0x9d0dfe81,
0xaecc3381,
0x9b177701,
0xb1401781,
0x99307f01,
0xb3c02001,
0x97596181,
0xb64beb01,
0x95926781,
0xb8e31301,
0x93dbd681,
0xbb853281,
0x9235f301,
0xbe31e181,
0x90a0fd81,
0xc0e8b641,
0x8f1d3401,
0xc3a94581,
0x8daad381,
0xc67322c1,
0x8c4a1401,
0xc945e001,
0x8afb2c81,
0xcc210d81,
0x89be5101,
0xcf043ac1,
0x8893b101,
0xd1eef581,
0x877b7c01,
0xd4e0cb01,
0x8675dc81,
0xd7d946c1,
0x8582fa81,
0xdad7f3c1,
0x84a2fc81,
0xdddc5b41,
0x83d60401,
0xe0e60681,
0x831c3181,
0xe3f47da1,
0x8275a101,
0xe70747c1,
0x81e26c01,
0xea1debc1,
0x8162aa01,
0xed37efa1,
0x80f66e01,
0xf054d8d1,
0x809dc981,
0xf3742ca1,
0x8058c981,
0xf6956fb1,
0x80277881,
0xf9b82681,
0x8009de81,
0xfcdbd541

};

I32 twid_table_128[128]= {
0x7fffffff,
0x00000000,
0x7fd8877f,
0xf9b82681,
0x7f62367f,
0xf3742ca1,
0x7e9d55ff,
0xed37efa1,
0x7d8a5eff,
0xe70747c1,
0x7c29fbff,
0xe0e60681,
0x7a7d057f,
0xdad7f3c1,
0x788483ff,
0xd4e0cb01,
0x7641aeff,
0xcf043ac1,
0x73b5ebff,
0xc945e001,
0x70e2cbff,
0xc3a94581,
0x6dca0cff,
0xbe31e181,
0x6a6d987f,
0xb8e31301,
0x66cf80ff,
0xb3c02001,
0x62f2017f,
0xaecc3381,
0x5ed77c7f,
0xaa0a5b01,
0x5a82797f,
0xa57d8681,
0x55f5a4ff,
0xa1288381,
0x5133cc7f,
0x9d0dfe81,
0x4c3fdfff,
0x99307f01,
0x471cecff,
0x95926781,
0x41ce1e7f,
0x9235f301,
0x3c56ba7f,
0x8f1d3401,
0x36ba1fff,
0x8c4a1401,
0x30fbc53f,
0x89be5101,
0x2b1f34ff,
0x877b7c01,
0x25280c3f,
0x8582fa81,
0x1f19f97f,
0x83d60401,
0x18f8b83f,
0x8275a101,
0x12c8105f,
0x8162aa01,
0x0c8bd35f,
0x809dc981,
0x0647d97f,
0x80277881,
0x00000000,
0x80000001,
0xf9b82681,
0x80277881,
0xf3742ca1,
0x809dc981,
0xed37efa1,
0x8162aa01,
0xe70747c1,
0x8275a101,
0xe0e60681,
0x83d60401,
0xdad7f3c1,
0x8582fa81,
0xd4e0cb01,
0x877b7c01,
0xcf043ac1,
0x89be5101,
0xc945e001,
0x8c4a1401,
0xc3a94581,
0x8f1d3401,
0xbe31e181,
0x9235f301,
0xb8e31301,
0x95926781,
0xb3c02001,
0x99307f01,
0xaecc3381,
0x9d0dfe81,
0xaa0a5b01,
0xa1288381,
0xa57d8681,
0xa57d8681,
0xa1288381,
0xaa0a5b01,
0x9d0dfe81,
0xaecc3381,
0x99307f01,
0xb3c02001,
0x95926781,
0xb8e31301,
0x9235f301,
0xbe31e181,
0x8f1d3401,
0xc3a94581,
0x8c4a1401,
0xc945e001,
0x89be5101,
0xcf043ac1,
0x877b7c01,
0xd4e0cb01,
0x8582fa81,
0xdad7f3c1,
0x83d60401,
0xe0e60681,
0x8275a101,
0xe70747c1,
0x8162aa01,
0xed37efa1,
0x809dc981,
0xf3742ca1,
0x80277881,
0xf9b82681

};

 I32 twid_table_64[64]= {
0x7fffffff,
0x00000000,
0x7f62367f,
0xf3742ca1,
0x7d8a5eff,
0xe70747c1,
0x7a7d057f,
0xdad7f3c1,
0x7641aeff,
0xcf043ac1,
0x70e2cbff,
0xc3a94581,
0x6a6d987f,
0xb8e31301,
0x62f2017f,
0xaecc3381,
0x5a82797f,
0xa57d8681,
0x5133cc7f,
0x9d0dfe81,
0x471cecff,
0x95926781,
0x3c56ba7f,
0x8f1d3401,
0x30fbc53f,
0x89be5101,
0x25280c3f,
0x8582fa81,
0x18f8b83f,
0x8275a101,
0x0c8bd35f,
0x809dc981,
0x00000000,
0x80000001,
0xf3742ca1,
0x809dc981,
0xe70747c1,
0x8275a101,
0xdad7f3c1,
0x8582fa81,
0xcf043ac1,
0x89be5101,
0xc3a94581,
0x8f1d3401,
0xb8e31301,
0x95926781,
0xaecc3381,
0x9d0dfe81,
0xa57d8681,
0xa57d8681,
0x9d0dfe81,
0xaecc3381,
0x95926781,
0xb8e31301,
0x8f1d3401,
0xc3a94581,
0x89be5101,
0xcf043ac1,
0x8582fa81,
0xdad7f3c1,
0x8275a101,
0xe70747c1,
0x809dc981,
0xf3742ca1

};

I32 pre_twid_table_1024[2048]={
0x7fffff6c,
0x000c90fd,
0x7fffefcc,
0x003ed4f2,
0x7fffce98,
0x007118dc,
0x7fff97e8,
0x00a35cb5,
0x7fff4db0,
0x00d5a075,
0x7ffeeff0,
0x0107e414,
0x7ffe7ea8,
0x013a278a,
0x7ffdf9d8,
0x016c6ad0,
0x7ffd5f8c,
0x019eaddd,
0x7ffcb3ac,
0x01d0f0ab,
0x7ffbf250,
0x02033331,
0x7ffb1f60,
0x02357567,
0x7ffa36f4,
0x0267b746,
0x7ff93b00,
0x0299f8c7,
0x7ff82b84,
0x02cc39e0,
0x7ff70880,
0x02fe7a8b,
0x7ff5d1f4,
0x0330bac0,
0x7ff487e0,
0x0362fa77,
0x7ff32850,
0x039539a9,
0x7ff1b72c,
0x03c7784d,
0x7ff0308c,
0x03f9b65b,
0x7fee9858,
0x042bf3cd,
0x7feceaa8,
0x045e309a,
0x7feb2970,
0x04906cbb,
0x7fe954b0,
0x04c2a827,
0x7fe76c68,
0x04f4e2d7,
0x7fe57098,
0x05271cc4,
0x7fe35f4c,
0x055955e6,
0x7fe13c6c,
0x058b8e34,
0x7fdf0604,
0x05bdc5a7,
0x7fdcba20,
0x05effc38,
0x7fda5ab4,
0x062231de,
0x7fd7e9b4,
0x06546692,
0x7fd56338,
0x06869a4c,
0x7fd2c934,
0x06b8cd05,
0x7fd01ba8,
0x06eafeb4,
0x7fcd5a94,
0x071d2f52,
0x7fca85f8,
0x074f5ed7,
0x7fc79be0,
0x07818d3c,
0x7fc4a034,
0x07b3ba78,
0x7fc18f0c,
0x07e5e684,
0x7fbe6c50,
0x08181159,
0x7fbb3418,
0x084a3aee,
0x7fb7e858,
0x087c633b,
0x7fb48b04,
0x08ae8a3a,
0x7fb11834,
0x08e0afe2,
0x7fad91dc,
0x0912d42b,
0x7fa9f7fc,
0x0944f70e,
0x7fa648a0,
0x09771884,
0x7fa287b0,
0x09a93883,
0x7f9eb338,
0x09db5706,
0x7f9ac944,
0x0a0d7403,
0x7f96cdbc,
0x0a3f8f73,
0x7f92bcb8,
0x0a71a94e,
0x7f8e9a20,
0x0aa3c18e,
0x7f8a620c,
0x0ad5d829,
0x7f861670,
0x0b07ed18,
0x7f81b940,
0x0b3a0054,
0x7f7d4694,
0x0b6c11d5,
0x7f78c060,
0x0b9e2193,
0x7f7426a4,
0x0bd02f86,
0x7f6f7960,
0x0c023ba7,
0x7f6ab894,
0x0c3445ee,
0x7f65e24c,
0x0c664e53,
0x7f60fa70,
0x0c9854ce,
0x7f5bff0c,
0x0cca5959,
0x7f56ee2c,
0x0cfc5bea,
0x7f51cbb8,
0x0d2e5c7a,
0x7f4c93c8,
0x0d605b03,
0x7f474a44,
0x0d92577b,
0x7f41eb44,
0x0dc451db,
0x7f3c7ab0,
0x0df64a1c,
0x7f36f4a0,
0x0e284036,
0x7f315b08,
0x0e5a3421,
0x7f2bafdc,
0x0e8c25d5,
0x7f25ef34,
0x0ebe154b,
0x7f201b04,
0x0ef0027b,
0x7f1a334c,
0x0f21ed5d,
0x7f14380c,
0x0f53d5e9,
0x7f0e2944,
0x0f85bc19,
0x7f0806f4,
0x0fb79fe4,
0x7f01d11c,
0x0fe98142,
0x7efb87bc,
0x101b602c,
0x7ef52ad4,
0x104d3c9b,
0x7eeeba64,
0x107f1685,
0x7ee8366c,
0x10b0ede5,
0x7ee19eec,
0x10e2c2b1,
0x7edaf3e4,
0x111494e3,
0x7ed43360,
0x11466473,
0x7ecd6148,
0x11783158,
0x7ec67ba8,
0x11a9fb8c,
0x7ebf8280,
0x11dbc307,
0x7eb875d0,
0x120d87c1,
0x7eb153a4,
0x123f49b1,
0x7eaa1fe4,
0x127108d2,
0x7ea2d89c,
0x12a2c51a,
0x7e9b7dcc,
0x12d47e83,
0x7e940f74,
0x13063504,
0x7e8c8ba0,
0x1337e897,
0x7e84f638,
0x13699932,
0x7e7d4d48,
0x139b46d0,
0x7e7590d0,
0x13ccf167,
0x7e6dc0d0,
0x13fe98f0,
0x7e65db54,
0x14303d64,
0x7e5de444,
0x1461debc,
0x7e55d9ac,
0x14937cee,
0x7e4dbb8c,
0x14c517f4,
0x7e4589e4,
0x14f6afc6,
0x7e3d44b4,
0x1528445d,
0x7e34ebfc,
0x1559d5b0,
0x7e2c7fbc,
0x158b63b9,
0x7e23fff4,
0x15bcee6f,
0x7e1b6ca4,
0x15ee75ca,
0x7e12c7c0,
0x161ff9c4,
0x7e0a0d60,
0x16517a55,
0x7e013f78,
0x1682f774,
0x7df85e08,
0x16b4711b,
0x7def6b04,
0x16e5e741,
0x7de66284,
0x171759df,
0x7ddd4870,
0x1748c8ee,
0x7dd418e0,
0x177a3465,
0x7dcad7bc,
0x17ab9c3e,
0x7dc1811c,
0x17dd0070,
0x7db818e8,
0x180e60f4,
0x7dae9d2c,
0x183fbdc2,
0x7da50de8,
0x187116d4,
0x7d9b6b1c,
0x18a26c20,
0x7d91b4c8,
0x18d3bd9f,
0x7d87eaec,
0x19050b4b,
0x7d7e0d88,
0x1936551a,
0x7d741e90,
0x19679b07,
0x7d6a1a1c,
0x1998dd08,
0x7d600414,
0x19ca1b17,
0x7d55d890,
0x19fb552c,
0x7d4b9b78,
0x1a2c8b3f,
0x7d414ad8,
0x1a5dbd49,
0x7d36e6b0,
0x1a8eeb42,
0x7d2c6f00,
0x1ac01522,
0x7d21e3c8,
0x1af13ae2,
0x7d174508,
0x1b225c7b,
0x7d0c94b4,
0x1b5379e5,
0x7d01cee4,
0x1b849317,
0x7cf6f780,
0x1bb5a80c,
0x7cec0c94,
0x1be6b8ba,
0x7ce10e20,
0x1c17c51b,
0x7cd5fc24,
0x1c48cd27,
0x7ccad6a0,
0x1c79d0d6,
0x7cbf9d94,
0x1caad021,
0x7cb452f4,
0x1cdbcb00,
0x7ca8f2d8,
0x1d0cc16c,
0x7c9d8128,
0x1d3db35d,
0x7c91fbf0,
0x1d6ea0cc,
0x7c866330,
0x1d9f89b1,
0x7c7ab8dc,
0x1dd06e04,
0x7c6ef90c,
0x1e014dbf,
0x7c6327a8,
0x1e3228d8,
0x7c5742bc,
0x1e62ff4a,
0x7c4b4a48,
0x1e93d10c,
0x7c3f3e4c,
0x1ec49e17,
0x7c331ec8,
0x1ef56663,
0x7c26edb0,
0x1f2629e9,
0x7c1aa910,
0x1f56e8a2,
0x7c0e50e8,
0x1f87a285,
0x7c01e538,
0x1fb8578b,
0x7bf56600,
0x1fe907ad,
0x7be8d534,
0x2019b2e4,
0x7bdc30e0,
0x204a5927,
0x7bcf7904,
0x207afa6f,
0x7bc2ada0,
0x20ab96b5,
0x7bb5d0a8,
0x20dc2df1,
0x7ba8de34,
0x210cc01c,
0x7b9bda2c,
0x213d4d2f,
0x7b8ec490,
0x216dd521,
0x7b819978,
0x219e57eb,
0x7b745ccc,
0x21ced586,
0x7b670c98,
0x21ff4dea,
0x7b59a8dc,
0x222fc110,
0x7b4c338c,
0x22602ef1,
0x7b3ea8c0,
0x22909785,
0x7b310c60,
0x22c0fac3,
0x7b235e6c,
0x22f158a6,
0x7b159afc,
0x2321b126,
0x7b07c5f8,
0x2352043a,
0x7af9dd6c,
0x238251dc,
0x7aebe34c,
0x23b29a05,
0x7addd3b0,
0x23e2dcac,
0x7acfb280,
0x241319ca,
0x7ac17fbc,
0x24435158,
0x7ab3377c,
0x2473834e,
0x7aa4dda8,
0x24a3afa6,
0x7a967240,
0x24d3d657,
0x7a87f15c,
0x2503f75a,
0x7a795ee4,
0x253412a7,
0x7a6ab8e4,
0x25642838,
0x7a5c0150,
0x25943805,
0x7a4d3634,
0x25c44207,
0x7a3e5790,
0x25f44635,
0x7a2f6758,
0x26244489,
0x7a206398,
0x26543cfb,
0x7a114c50,
0x26842f84,
0x7a022374,
0x26b41c1d,
0x79f2e710,
0x26e402bd,
0x79e39724,
0x2713e35e,
0x79d435a4,
0x2743bdf9,
0x79c4c09c,
0x27739285,
0x79b5380c,
0x27a360fc,
0x79a59de8,
0x27d32956,
0x7995f230,
0x2802eb8c,
0x798632f0,
0x2832a796,
0x79766028,
0x28625d6d,
0x796679d8,
0x28920d0a,
0x795681f4,
0x28c1b665,
0x7946787c,
0x28f15978,
0x79365988,
0x2920f63a,
0x79262af4,
0x29508ca4,
0x7915e6e4,
0x29801caf,
0x79059140,
0x29afa654,
0x78f52a08,
0x29df298b,
0x78e4af48,
0x2a0ea64d,
0x78d42100,
0x2a3e1c93,
0x78c38124,
0x2a6d8c55,
0x78b2cfb4,
0x2a9cf58c,
0x78a20abc,
0x2acc5831,
0x7891323c,
0x2afbb43c,
0x78804828,
0x2b2b09a6,
0x786f4a8c,
0x2b5a5868,
0x785e3b5c,
0x2b89a07b,
0x784d18a4,
0x2bb8e1d7,
0x783be458,
0x2be81c74,
0x782a9c84,
0x2c17504c,
0x7819431c,
0x2c467d58,
0x7807d62c,
0x2c75a390,
0x77f657a8,
0x2ca4c2ec,
0x77e4c790,
0x2cd3db67,
0x77d323f0,
0x2d02ecf7,
0x77c16cc8,
0x2d31f796,
0x77afa40c,
0x2d60fb3d,
0x779dc7c8,
0x2d8ff7e5,
0x778bdbe4,
0x2dbeed86,
0x7779da84,
0x2deddc19,
0x7767c790,
0x2e1cc397,
0x7755a308,
0x2e4ba3f8,
0x77436cec,
0x2e7a7d36,
0x77312348,
0x2ea94f48,
0x771ec61c,
0x2ed81a29,
0x770c575c,
0x2f06ddd0,
0x76f9d708,
0x2f359a37,
0x76e7432c,
0x2f644f56,
0x76d49dbc,
0x2f92fd26,
0x76c1e6b8,
0x2fc1a3a0,
0x76af1c2c,
0x2ff042bd,
0x769c400c,
0x301eda75,
0x76895064,
0x304d6ac1,
0x7676511c,
0x307bf39a,
0x76633c58,
0x30aa74fa,
0x765017f4,
0x30d8eed8,
0x763ce008,
0x3107612d,
0x76299494,
0x3135cbf3,
0x76163980,
0x31642f23,
0x7602cae4,
0x31928ab4,
0x75ef4ab4,
0x31c0dea1,
0x75dbb6fc,
0x31ef2ae1,
0x75c811b0,
0x321d6f6e,
0x75b45ad0,
0x324bac40,
0x75a0925c,
0x3279e151,
0x758cb660,
0x32a80e99,
0x7578c8d0,
0x32d63411,
0x7564c9ac,
0x330451b3,
0x7550b700,
0x33326776,
0x753c92c0,
0x33607554,
0x75285cec,
0x338e7b46,
0x75141584,
0x33bc7944,
0x74ffba94,
0x33ea6f48,
0x74eb4e10,
0x34185d4b,
0x74d6cff8,
0x34464344,
0x74c2404c,
0x3474212e,
0x74ad9f0c,
0x34a1f702,
0x7498ea44,
0x34cfc4b7,
0x748423e8,
0x34fd8a48,
0x746f4bf8,
0x352b47ac,
0x745a6274,
0x3558fcde,
0x74456568,
0x3586a9d5,
0x743056c8,
0x35b44e8c,
0x741b3888,
0x35e1eafa,
0x740606c0,
0x360f7f19,
0x73f0c170,
0x363d0ae1,
0x73db6c80,
0x366a8e4d,
0x73c605fc,
0x36980954,
0x73b08bf0,
0x36c57bf0,
0x739b0050,
0x36f2e61a,
0x7385631c,
0x372047ca,
0x736fb454,
0x374da0fa,
0x7359f3f8,
0x377af1a3,
0x73442208,
0x37a839bd,
0x732e3e84,
0x37d57943,
0x73184778,
0x3802b02c,
0x730240cc,
0x382fde72,
0x72ec2698,
0x385d040d,
0x72d5fad0,
0x388a20f8,
0x72bfbf68,
0x38b7352a,
0x72a97078,
0x38e4409d,
0x72930ff4,
0x3911434b,
0x727c9ddc,
0x393e3d2b,
0x72661a30,
0x396b2e38,
0x724f84f0,
0x3998166a,
0x7238de1c,
0x39c4f5ba,
0x722225b4,
0x39f1cc21,
0x720b5bb8,
0x3a1e9999,
0x71f48028,
0x3a4b5e1a,
0x71dd9304,
0x3a78199e,
0x71c6944c,
0x3aa4cc1e,
0x71af8400,
0x3ad17593,
0x71986220,
0x3afe15f5,
0x71812eac,
0x3b2aad3f,
0x7169e9a4,
0x3b573b69,
0x715294fc,
0x3b83c06c,
0x713b2ccc,
0x3bb03c42,
0x7123b308,
0x3bdcaee3,
0x710c27b0,
0x3c091849,
0x70f48cb8,
0x3c35786c,
0x70dcde38,
0x3c61cf47,
0x70c52018,
0x3c8e1cd2,
0x70ad5064,
0x3cba6107,
0x70956d28,
0x3ce69bde,
0x707d7a4c,
0x3d12cd51,
0x706575dc,
0x3d3ef558,
0x704d5fd8,
0x3d6b13ee,
0x70353a34,
0x3d97290b,
0x701d0108,
0x3dc334a9,
0x7004b648,
0x3def36c0,
0x6fec5be8,
0x3e1b2f4a,
0x6fd3eff4,
0x3e471e41,
0x6fbb726c,
0x3e73039c,
0x6fa2e350,
0x3e9edf57,
0x6f8a4494,
0x3ecab169,
0x6f719250,
0x3ef679cc,
0x6f58d06c,
0x3f22387a,
0x6f3ffcf4,
0x3f4ded6b,
0x6f2717e8,
0x3f799899,
0x6f0e233c,
0x3fa539fd,
0x6ef51b08,
0x3fd0d191,
0x6edc0334,
0x3ffc5f4d,
0x6ec2d9cc,
0x4027e3a0,
0x6ea9a0c4,
0x40535c88,
0x6e905628,
0x407ecda0,
0x6e76f804,
0x40aa3300,
0x6e5d8c34,
0x40d58e9c,
0x6e440cdc,
0x4100e268,
0x6e2a7de4,
0x412c2a7c,
0x6e10dd58,
0x415766d8,
0x6df72b38,
0x41829b64,
0x6ddd6978,
0x41adc62c,
0x6dc39624,
0x41d8e53c,
0x6da9b330,
0x4203fa88,
0x6d8fbcb4,
0x422f0610,
0x6d75b698,
0x425a07d4,
0x6d5ba0dc,
0x4284fde0,
0x6d41798c,
0x42afec1c,
0x6d2740a8,
0x42dacea0,
0x6d0cf630,
0x4305a56c,
0x6cf29c18,
0x43307468,
0x6cd83260,
0x435b37ac,
0x6cbdb520,
0x4385ef38,
0x6ca32a34,
0x43b09ef4,
0x6c888bc0,
0x43db42f8,
0x6c6dddac,
0x4405dd38,
0x6c531ff8,
0x44306bc0,
0x6c3850b0,
0x445af084,
0x6c1d6fd4,
0x44856b84,
0x6c027f58,
0x44afdacc,
0x6be77d48,
0x44da4050,
0x6bcc6b98,
0x45049a1c,
0x6bb14854,
0x452eea24,
0x6b961570,
0x45592e74,
0x6b7ad0f8,
0x45836900,
0x6b5f7ce0,
0x45ad99c8,
0x6b441734,
0x45d7bce4,
0x6b28a1e8,
0x4601d830,
0x6b0d1b08,
0x462be7c4,
0x6af18488,
0x4655eba0,
0x6ad5de68,
0x467fe5b8,
0x6aba26b4,
0x46a9d418,
0x6a9e5d6c,
0x46d3b8b4,
0x6a828678,
0x46fd9198,
0x6a669bfc,
0x47275ec4,
0x6a4aa3d4,
0x4751222c,
0x6a2e9a18,
0x477ad9dc,
0x6a127ec8,
0x47a487c8,
0x69f655cc,
0x47ce29fc,
0x69da1b3c,
0x47f7c078,
0x69bdcf18,
0x48214d30,
0x69a17354,
0x484acc3c,
0x698507f0,
0x48744378,
0x69688af8,
0x489dad08,
0x694c0054,
0x48c70cd4,
0x692f641c,
0x48f060e8,
0x6912b650,
0x4919a944,
0x68f5f8e4,
0x4942e5e8,
0x68d92bd8,
0x496c18c8,
0x68bc4f2c,
0x49953ff0,
0x689f60ec,
0x49be5b60,
0x68826500,
0x49e76b18,
0x6865558c,
0x4a106f18,
0x6848386c,
0x4a396954,
0x682b09b8,
0x4a6257d8,
0x680dcd58,
0x4a8b38b0,
0x67f07f64,
0x4ab40fc4,
0x67d31fdc,
0x4adcdb20,
0x67b5b2a8,
0x4b059ac4,
0x679833e0,
0x4b2e50a4,
0x677aa76c,
0x4b56f8d8,
0x675d0964,
0x4b7f9554,
0x673f5bbc,
0x4ba82618,
0x67219c80,
0x4bd0ad18,
0x6703cf98,
0x4bf9266c,
0x66e5f11c,
0x4c219408,
0x66c804f4,
0x4c49f7e0,
0x66aa0738,
0x4c724e0c,
0x668bf9dc,
0x4c9a9880,
0x666ddce0,
0x4cc2d930,
0x664fb044,
0x4ceb0c34,
0x66317408,
0x4d133380,
0x6613282c,
0x4d3b4f14,
0x65f4cabc,
0x4d635ef0,
0x65d65fa0,
0x4d8b6314,
0x65b7e4e4,
0x4db3598c,
0x65995894,
0x4ddb4640,
0x657abe98,
0x4e032548,
0x655c1308,
0x4e2afa8c,
0x653d59cc,
0x4e52c224,
0x651e8efc,
0x4e7a7e04,
0x64ffb680,
0x4ea22c38,
0x64e0ce64,
0x4ec9d0a8,
0x64c1d4b4,
0x4ef1676c,
0x64a2cd58,
0x4f18f278,
0x6483b65c,
0x4f4071cc,
0x64648dcc,
0x4f67e374,
0x64455790,
0x4f8f4b58,
0x642611b4,
0x4fb6a590,
0x6406bc38,
0x4fddf21c,
0x63e7571c,
0x500534e4,
0x63c7e454,
0x502c6a00,
0x63a85ff8,
0x50539364,
0x6388cdf0,
0x507aaf1c,
0x63692a54,
0x50a1bf1c,
0x6349790c,
0x50c8c364,
0x6329b824,
0x50efba00,
0x6309e79c,
0x5116a4e4,
0x62ea0774,
0x513d821c,
0x62ca19a0,
0x51645590,
0x62aa1c2c,
0x518b1964,
0x628a0f18,
0x51b1d180,
0x6269f264,
0x51d87de4,
0x6249c610,
0x51ff1c9c,
0x62298c10,
0x5225af9c,
0x62094270,
0x524c36e4,
0x61e8e930,
0x5272b080,
0x61c88050,
0x52991c70,
0x61a809c4,
0x52bf7ca8,
0x61878398,
0x52e5cf34,
0x6166edcc,
0x530c1608,
0x61464a54,
0x53324f30,
0x61259548,
0x53587ca0,
0x6104d484,
0x537e9c64,
0x60e4022c,
0x53a4ae7c,
0x60c32228,
0x53cab4dc,
0x60a23284,
0x53f0ad90,
0x60813534,
0x54169a8c,
0x60602844,
0x543c79dc,
0x603f0bb4,
0x54624b80,
0x601de178,
0x5488116c,
0x5ffca79c,
0x54adc9ac,
0x5fdb6014,
0x54d37440,
0x5fba08ec,
0x54f91128,
0x5f98a418,
0x551ea258,
0x5f772fa4,
0x554425dc,
0x5f55ab90,
0x55699da8,
0x5f3419d0,
0x558f07c8,
0x5f127870,
0x55b46248,
0x5ef0c964,
0x55d9b304,
0x5ecf0ab8,
0x55fef420,
0x5ead3e60,
0x56242984,
0x5e8b645c,
0x56494f48,
0x5e697ab8,
0x566e6954,
0x5e478174,
0x569375b4,
0x5e257a84,
0x56b8765c,
0x5e0365e8,
0x56dd6764,
0x5de141ac,
0x57024cb4,
0x5dbf0fc4,
0x57272458,
0x5d9cce3c,
0x574bec5c,
0x5d7a7f08,
0x5770a8a8,
0x5d582228,
0x57955748,
0x5d35b5a8,
0x57b9fa30,
0x5d133b7c,
0x57de8d78,
0x5cf0b3a4,
0x58031314,
0x5cce1c2c,
0x58278b04,
0x5cab7708,
0x584bf73c,
0x5c88c244,
0x587053d4,
0x5c65ffd4,
0x5894a4b4,
0x5c432fb8,
0x58b8e5f4,
0x5c2051f0,
0x58dd1988,
0x5bfd6488,
0x59014164,
0x5bda6974,
0x592559a0,
0x5bb760b4,
0x59496624,
0x5b944a48,
0x596d6308,
0x5b71243c,
0x59915240,
0x5b4df278,
0x59b533cc,
0x5b2ab114,
0x59d907ac,
0x5b076010,
0x59fccde0,
0x5ae40354,
0x5a208668,
0x5ac096f8,
0x5a443144,
0x5a9d1ee4,
0x5a67cc80,
0x5a799730,
0x5a8b5c04,
0x5a5601d0,
0x5aaedbe8,
0x5a325cd0,
0x5ad24e20,
0x5a0eac18,
0x5af5b2ac,
0x59eaedb4,
0x5b19098c,
0x59c71fb0,
0x5b3c52c0,
0x59a34400,
0x5b5f8c54,
0x597f5c98,
0x5b82ba30,
0x595b6590,
0x5ba5d86c,
0x593760dc,
0x5bc8e708,
0x59134e7c,
0x5bebe9ec,
0x58ef3064,
0x5c0edd30,
0x58cb02ac,
0x5c31c2c8,
0x58a6c748,
0x5c549ab4,
0x58827e38,
0x5c776300,
0x585e277c,
0x5c9a1da0,
0x5839c314,
0x5cbcca94,
0x58155100,
0x5cdf69dc,
0x57f0d140,
0x5d01f984,
0x57cc45c8,
0x5d24798c,
0x57a7aab0,
0x5d46eddc,
0x578301ec,
0x5d69528c,
0x575e4d70,
0x5d8ba990,
0x57398954,
0x5dadf0f4,
0x5714b980,
0x5dd02aac,
0x56efdc00,
0x5df254c4,
0x56caf0d4,
0x5e147324,
0x56a5f7fc,
0x5e367ff0,
0x5680f178,
0x5e587f10,
0x565bdf3c,
0x5e7a7084,
0x5636bd60,
0x5e9c544c,
0x56118fcc,
0x5ebe2680,
0x55ec548c,
0x5edfecfc,
0x55c70ba0,
0x5f01a3d8,
0x55a1b6fc,
0x5f234b14,
0x557c54ac,
0x5f44e4a4,
0x5556e2bc,
0x5f666e94,
0x55316708,
0x5f87ead8,
0x550bdbb4,
0x5fa9577c,
0x54e644a8,
0x5fcab674,
0x54c09ff0,
0x5fec05cc,
0x549aed8c,
0x600d4778,
0x54752f70,
0x602e7984,
0x544f63a8,
0x604f9bf0,
0x54298a34,
0x6070b0b0,
0x5403a508,
0x6091b5d0,
0x53ddb230,
0x60b2ad44,
0x53b7b3a0,
0x60d39518,
0x5391a764,
0x60f46d4c,
0x536b8d7c,
0x611535e0,
0x534567dc,
0x6135f0c8,
0x531f3490,
0x61569e04,
0x52f8f398,
0x617739ac,
0x52d2a6e8,
0x6197c7a8,
0x52ac4e80,
0x61b84604,
0x5285e86c,
0x61d8b6b4,
0x525f74ac,
0x61f917c4,
0x5238f534,
0x62196934,
0x52126810,
0x6239ab04,
0x51ebcf34,
0x6259dd34,
0x51c52aa0,
0x627a01b8,
0x519e7860,
0x629a169c,
0x5177b874,
0x62ba1be0,
0x5150ecd0,
0x62da1378,
0x512a1574,
0x62f9f97c,
0x5103306c,
0x6319d1d4,
0x50dc3fac,
0x63399a8c,
0x50b54334,
0x635953a4,
0x508e3910,
0x6378fd1c,
0x50672334,
0x639898e8,
0x503fffac,
0x63b82320,
0x5018d06c,
0x63d79fac,
0x4ff19574,
0x63f70c98,
0x4fca4cd0,
0x641669e4,
0x4fa2fa68,
0x6435b790,
0x4f7b9860,
0x6454f59c,
0x4f542c94,
0x64742408,
0x4f2cb31c,
0x649342d4,
0x4f052dec,
0x64b253f4,
0x4edd9d04,
0x64d15380,
0x4eb60064,
0x64f0436c,
0x4e8e5618,
0x650f25ac,
0x4e66a014,
0x652df658,
0x4e3ede58,
0x654cb958,
0x4e1710e4,
0x656b6ac4,
0x4def37b8,
0x658a0c90,
0x4dc750e0,
0x65a8a0b0,
0x4d9f6044,
0x65c7233c,
0x4d7761fc,
0x65e5981c,
0x4d4f57fc,
0x6603fb68,
0x4d274244,
0x66224f14,
0x4cff20d4,
0x66409320,
0x4cd6f3ac,
0x665ec78c,
0x4caebacc,
0x667cec58,
0x4c867634,
0x669b0184,
0x4c5e23f0,
0x66b90710,
0x4c35c7e8,
0x66d6fcfc,
0x4c0d6028,
0x66f4e348,
0x4be4eabc,
0x6712b800,
0x4bbc6b8c,
0x67307d18,
0x4b93deb0,
0x674e3484,
0x4b6b4810,
0x676bda5c,
0x4b42a5b8,
0x67897094,
0x4b19f7a8,
0x67a6f538,
0x4af13de0,
0x67c46c30,
0x4ac87860,
0x67e1d194,
0x4a9fa728,
0x67ff2758,
0x4a76ca38,
0x681c6d7c,
0x4a4de190,
0x6839a400,
0x4a24ed30,
0x6856c8f0,
0x49fbef0c,
0x6873de40,
0x49d2e530,
0x6890e3f0,
0x49a9cf9c,
0x68adda00,
0x4980ae50,
0x68cac070,
0x4957814c,
0x68e7954c,
0x492e4890,
0x69045a88,
0x49050610,
0x69210e30,
0x48dbb7d8,
0x693db42c,
0x48b25de8,
0x695a4894,
0x4888fa34,
0x6976cb68,
0x485f88d4,
0x69934090,
0x48360db0,
0x69afa424,
0x480c88c8,
0x69cbf624,
0x47e2f634,
0x69e83a78,
0x47b959dc,
0x6a046d38,
0x478fb1cc,
0x6a208e64,
0x4765fff8,
0x6a3c9ff0,
0x473c426c,
0x6a58a1dc,
0x47127928,
0x6a749428,
0x46e8a620,
0x6a9074e0,
0x46bec760,
0x6aac4404,
0x4694dedc,
0x6ac80388,
0x466aeaa0,
0x6ae3b36c,
0x4640eaac,
0x6aff51bc,
0x4616e0f4,
0x6b1ae06c,
0x45eccb84,
0x6b365f7c,
0x45c2ac50,
0x6b51ccf8,
0x45988164,
0x6b6d28e0,
0x456e4cb4,
0x6b887528,
0x45440e40,
0x6ba3b1d0,
0x4519c414,
0x6bbedce4,
0x44ef6e30,
0x6bd9f664,
0x44c50e88,
0x6bf50044,
0x449aa328,
0x6c0ff890,
0x44702ff8,
0x6c2ae13c,
0x4445af1c,
0x6c45ba48,
0x441b2670,
0x6c6081c0,
0x43f0920c,
0x6c7b37a4,
0x43c5f1f0,
0x6c95dde8,
0x439b4810,
0x6cb07298,
0x4370946c,
0x6ccaf5b4,
0x4345d704,
0x6ce56930,
0x431b0de4,
0x6cffcb18,
0x42f03b00,
0x6d1a1d60,
0x42c55e58,
0x6d345e14,
0x429a75f8,
0x6d4e8f28,
0x426f83d4,
0x6d68aea8,
0x424487ec,
0x6d82bc94,
0x42198240,
0x6d9cbae0,
0x41ee70dc,
0x6db6a798,
0x41c357a8,
0x6dd082bc,
0x419832bc,
0x6dea4c4c,
0x416d0218,
0x6e04063c,
0x4141c9a4,
0x6e1db08c,
0x4116876c,
0x6e374754,
0x40eb397c,
0x6e50ce7c,
0x40bfe1c8,
0x6e6a4410,
0x40948244,
0x6e83aa04,
0x40691708,
0x6e9cfc70,
0x403da208,
0x6eb63f3c,
0x40122344,
0x6ecf7074,
0x3fe699aa,
0x6ee8920c,
0x3fbb0701,
0x6f01a210,
0x3f8f6a85,
0x6f1aa080,
0x3f63c43b,
0x6f338d5c,
0x3f38142a,
0x6f4c68a4,
0x3f0c5a5a,
0x6f65344c,
0x3ee096d1,
0x6f7dee60,
0x3eb4c995,
0x6f9696e0,
0x3e88f2ae,
0x6faf2dcc,
0x3e5d1222,
0x6fc7b324,
0x3e3127f8,
0x6fe028dc,
0x3e053437,
0x6ff88b0c,
0x3dd936e6,
0x7010dd9c,
0x3dad300a,
0x70291e98,
0x3d811fac,
0x70414ff4,
0x3d5505d2,
0x70596dc8,
0x3d28e282,
0x70717a08,
0x3cfcb5c4,
0x708976a8,
0x3cd07f9e,
0x70a161b4,
0x3ca44018,
0x70b93938,
0x3c77f737,
0x70d1011c,
0x3c4ba503,
0x70e8b76c,
0x3c1f4983,
0x71005c28,
0x3bf2e4bd,
0x7117ef50,
0x3bc676b9,
0x712f72d8,
0x3b99ff7d,
0x7146e2d8,
0x3b6d7f10,
0x715e4144,
0x3b40f578,
0x71759010,
0x3b1462be,
0x718ccb54,
0x3ae7c6e7,
0x71a3f504,
0x3abb21fa,
0x71bb0f14,
0x3a8e73ff,
0x71d2159c,
0x3a61bcfd,
0x71e90c84,
0x3a34fcf9,
0x71ffefe4,
0x3a0833fb,
0x7216c3a4,
0x39db620b,
0x722d83dc,
0x39ae872e,
0x72443474,
0x3981a36d,
0x725ad184,
0x3954b6cd,
0x72715ef4,
0x3927c155,
0x7287d8dc,
0x38fac30d,
0x729e4324,
0x38cdbbfc,
0x72b499e4,
0x38a0ac28,
0x72cadf10,
0x38739399,
0x72e112a8,
0x38467255,
0x72f736a0,
0x38194863,
0x730d4710,
0x37ec15cb,
0x732345ec,
0x37beda93,
0x73393140,
0x379196c2,
0x734f0cf4,
0x37644a60,
0x7364d714,
0x3736f573,
0x737a8dac,
0x37099801,
0x739034a4,
0x36dc3214,
0x73a5c814,
0x36aec3b0,
0x73bb49f0,
0x36814cdd,
0x73d0ba38,
0x3653cda3,
0x73e618ec,
0x36264608,
0x73fb660c,
0x35f8b614,
0x7410a198,
0x35cb1dcc,
0x7425c99c,
0x359d7d39,
0x743ae00c,
0x356fd461,
0x744fe4e8,
0x3542234c,
0x7464d830,
0x35146a00,
0x7479b9e4,
0x34e6a885,
0x748e8a04,
0x34b8dee1,
0x74a3469c,
0x348b0d1b,
0x74b7f1a0,
0x345d333c,
0x74cc8b10,
0x342f5149,
0x74e112ec,
0x3401674a,
0x74f58740,
0x33d37546,
0x7509ea00,
0x33a57b44,
0x751e3b2c,
0x3377794b,
0x75327ac4,
0x33496f62,
0x7546a6d4,
0x331b5d90,
0x755ac344,
0x32ed43dd,
0x756eca38,
0x32bf2250,
0x7582c18c,
0x3290f8ee,
0x7596a558,
0x3262c7c1,
0x75aa7984,
0x32348ecf,
0x75be3834,
0x32064e1e,
0x75d1e744,
0x31d805b7,
0x75e582cc,
0x31a9b59f,
0x75f90cc0,
0x317b5de0,
0x760c8520,
0x314cfe7e,
0x761fe9f8,
0x311e9783,
0x76333d3c,
0x30f028f4,
0x76467cf8,
0x30c1b2d9,
0x7659ad14,
0x3093353a,
0x766cc9a8,
0x3064b01c,
0x767fd2b4,
0x30362389,
0x7692ca2c,
0x30078f86,
0x76a5b010,
0x2fd8f41a,
0x76b88460,
0x2faa514e,
0x76cb4528,
0x2f7ba728,
0x76ddf45c,
0x2f4cf5b0,
0x76f09008,
0x2f1e3cec,
0x77031a20,
0x2eef7ce4,
0x771590b0,
0x2ec0b59f,
0x7727f7a0,
0x2e91e725,
0x773a4914,
0x2e63117c,
0x774c8ae8,
0x2e3434ab,
0x775eb934,
0x2e0550bb,
0x7770d3f8,
0x2dd665b2,
0x7782dd28,
0x2da77397,
0x7794d4c4,
0x2d787a72,
0x77a6b8d8,
0x2d497a49,
0x77b88b58,
0x2d1a7325,
0x77ca4a50,
0x2ceb650c,
0x77dbf7b4,
0x2cbc5006,
0x77ed9190,
0x2c8d341a,
0x77ff19d8,
0x2c5e114f,
0x78108e98,
0x2c2ee7ac,
0x7821f1c4,
0x2bffb739,
0x7833435c,
0x2bd07ffe,
0x7844816c,
0x2ba14200,
0x7855abf4,
0x2b71fd48,
0x7866c4e8,
0x2b42b1dd,
0x7877cc48,
0x2b135fc6,
0x7888c020,
0x2ae4070a,
0x7899a070,
0x2ab4a7b1,
0x78aa6f2c,
0x2a8541c2,
0x78bb2a60,
0x2a55d545,
0x78cbd400,
0x2a266240,
0x78dc6a18,
0x29f6e8bb,
0x78ecee9c,
0x29c768be,
0x78fd5f98,
0x2997e24f,
0x790dbf00,
0x29685576,
0x791e0ae0,
0x2938c23a,
0x792e452c,
0x290928a3,
0x793e6bf0,
0x28d988b8,
0x794e7f2c,
0x28a9e280,
0x795e80d4,
0x287a3603,
0x796e6ef4,
0x284a8348,
0x797e4b80,
0x281aca57,
0x798e1484,
0x27eb0b36,
0x799dca00,
0x27bb45ed,
0x79ad6de8,
0x278b7a84,
0x79bcfe48,
0x275ba901,
0x79cc7d14,
0x272bd16d,
0x79dbe858,
0x26fbf3ce,
0x79eb4014,
0x26cc102c,
0x79fa863c,
0x269c268f,
0x7a09b8dc,
0x266c36fd,
0x7a18d9e8,
0x263c417f,
0x7a27e76c,
0x260c461b,
0x7a36e168,
0x25dc44d9,
0x7a45c9d0,
0x25ac3dc0,
0x7a549cbc,
0x257c30d8,
0x7a636008,
0x254c1e28,
0x7a720dd8,
0x251c05b8,
0x7a80aa14,
0x24ebe78e,
0x7a8f34bc,
0x24bbc3b3,
0x7a9da9e8,
0x248b9a2e,
0x7aac0d80,
0x245b6b06,
0x7aba5d90,
0x242b3643,
0x7ac89c0c,
0x23fafbec,
0x7ad6c700,
0x23cabc09,
0x7ae4de6c,
0x239a76a0,
0x7af2e250,
0x236a2bba,
0x7b00d4a0,
0x2339db5e,
0x7b0eb368,
0x23098593,
0x7b1c7ea8,
0x22d92a61,
0x7b2a3854,
0x22a8c9cf,
0x7b37de78,
0x227863e5,
0x7b457114,
0x2247f8aa,
0x7b52f028,
0x22178826,
0x7b605da8,
0x21e7125f,
0x7b6db7a0,
0x21b6975f,
0x7b7afe10,
0x2186172b,
0x7b8830f8,
0x215591cc,
0x7b95524c,
0x21250749,
0x7ba26018,
0x20f477a9,
0x7baf5a5c,
0x20c3e2f5,
0x7bbc4118,
0x20934933,
0x7bc91640,
0x2062aa6b,
0x7bd5d7e0,
0x203206a4,
0x7be285f8,
0x20015de6,
0x7bef2088,
0x1fd0b039,
0x7bfba790,
0x1f9ffda4,
0x7c081d04,
0x1f6f462e,
0x7c147ef0,
0x1f3e89e0,
0x7c20cd54,
0x1f0dc8c0,
0x7c2d0830,
0x1edd02d6,
0x7c393178,
0x1eac3829,
0x7c454738,
0x1e7b68c2,
0x7c51477c,
0x1e4a94a7,
0x7c5d3820,
0x1e19bbe0,
0x7c691348,
0x1de8de75,
0x7c74dae8,
0x1db7fc6d,
0x7c8090f4,
0x1d8715d0,
0x7c8c3378,
0x1d562aa5,
0x7c97c080,
0x1d253af5,
0x7ca33de8,
0x1cf446c5,
0x7caea5d4,
0x1cc34e1e,
0x7cb9fa38,
0x1c925108,
0x7cc53d08,
0x1c614f8a,
0x7cd06a5c,
0x1c3049ac,
0x7cdb861c,
0x1bff3f75,
0x7ce68e54,
0x1bce30ec,
0x7cf18304,
0x1b9d1e1a,
0x7cfc6620,
0x1b6c0705,
0x7d0733c0,
0x1b3aebb6,
0x7d11efcc,
0x1b09cc34,
0x7d1c965c,
0x1ad8a887,
0x7d272b58,
0x1aa780b5,
0x7d31accc,
0x1a7654c8,
0x7d3c1ab8,
0x1a4524c6,
0x7d46751c,
0x1a13f0b6,
0x7d50bbf8,
0x19e2b8a1,
0x7d5af140,
0x19b17c8f,
0x7d65110c,
0x19803c85,
0x7d6f1f44,
0x194ef88e,
0x7d791800,
0x191db0af,
0x7d82ff28,
0x18ec64f0,
0x7d8cd2c8,
0x18bb155a,
0x7d9692e0,
0x1889c1f3,
0x7da03f70,
0x18586ac3,
0x7da9d878,
0x18270fd3,
0x7db35df8,
0x17f5b128,
0x7dbccff0,
0x17c44ecc,
0x7dc62e60,
0x1792e8c6,
0x7dcf7b3c,
0x17617f1d,
0x7dd8b29c,
0x173011d9,
0x7de1d868,
0x16fea102,
0x7deae8b8,
0x16cd2c9e,
0x7df3e774,
0x169bb4b7,
0x7dfcd0b4,
0x166a3953,
0x7e05a860,
0x1638ba7a,
0x7e0e6c84,
0x16073834,
0x7e171d20,
0x15d5b288,
0x7e1fba34,
0x15a4297e,
0x7e2841cc,
0x15729d1e,
0x7e30b7d0,
0x15410d70,
0x7e391a4c,
0x150f7a7a,
0x7e416940,
0x14dde444,
0x7e49a4ac,
0x14ac4ad7,
0x7e51cc90,
0x147aae3a,
0x7e59e2e0,
0x14490e74,
0x7e61e3b4,
0x14176b8d,
0x7e69d100,
0x13e5c58e,
0x7e71aac4,
0x13b41c7c,
0x7e797100,
0x13827061,
0x7e8123b4,
0x1350c144,
0x7e88c2e0,
0x131f0f2c,
0x7e905078,
0x12ed5a21,
0x7e97c894,
0x12bba22b,
0x7e9f2d28,
0x1289e752,
0x7ea67e34,
0x1258299c,
0x7eadbdac,
0x12266913,
0x7eb4e7a8,
0x11f4a5bc,
0x7ebbfe1c,
0x11c2dfa1,
0x7ec30108,
0x119116c9,
0x7ec9f06c,
0x115f4b3b,
0x7ed0ce3c,
0x112d7d00,
0x7ed79690,
0x10fbac1e,
0x7ede4b5c,
0x10c9d89e,
0x7ee4eca0,
0x10980287,
0x7eeb7a5c,
0x106629e1,
0x7ef1f490,
0x10344eb4,
0x7ef85b3c,
0x10027106,
0x7efeae60,
0x0fd090e1,
0x7f04edfc,
0x0f9eae4c,
0x7f0b1a10,
0x0f6cc94d,
0x7f11329c,
0x0f3ae1ee,
0x7f1737a0,
0x0f08f836,
0x7f1d291c,
0x0ed70c2c,
0x7f230710,
0x0ea51dd8,
0x7f28d17c,
0x0e732d42,
0x7f2e8860,
0x0e413a72,
0x7f3429c8,
0x0e0f456e,
0x7f39b99c,
0x0ddd4e40,
0x7f3f35e8,
0x0dab54ef,
0x7f449cb8,
0x0d795981,
0x7f49f1f4,
0x0d475c00,
0x7f4f31b4,
0x0d155c73,
0x7f545fe0,
0x0ce35ae1,
0x7f597890,
0x0cb15752,
0x7f5e7fac,
0x0c7f51ce,
0x7f63714c,
0x0c4d4a5d,
0x7f684f64,
0x0c1b4106,
0x7f6d19f4,
0x0be935d2,
0x7f71d2f0,
0x0bb728c7,
0x7f767670,
0x0b8519ed,
0x7f7b0668,
0x0b53094d,
0x7f7f80e4,
0x0b20f6ed,
0x7f83e9cc,
0x0aeee2d7,
0x7f883f2c,
0x0abccd10,
0x7f8c8104,
0x0a8ab5a2,
0x7f90ad60,
0x0a589c94,
0x7f94c828,
0x0a2681ed,
0x7f98cf68,
0x09f465b5,
0x7f9cc12c,
0x09c247f5,
0x7fa09f68,
0x099028b3,
0x7fa46c10,
0x095e07f7,
0x7fa8233c,
0x092be5ca,
0x7fabc6e0,
0x08f9c233,
0x7faf56fc,
0x08c79d39,
0x7fb2d390,
0x089576e5,
0x7fb63c9c,
0x08634f3e,
0x7fb9902c,
0x0831264c,
0x7fbcd228,
0x07fefc16,
0x7fc0009c,
0x07ccd0a5,
0x7fc31994,
0x079aa3ff,
0x7fc620f8,
0x0768762e,
0x7fc912e0,
0x07364738,
0x7fcbf140,
0x07041726,
0x7fcebe0c,
0x06d1e5fe,
0x7fd1755c,
0x069fb3c9,
0x7fd41924,
0x066d808f,
0x7fd6a964,
0x063b4c57,
0x7fd92428,
0x06091729,
0x7fdb8d58,
0x05d6e10c,
0x7fdde300,
0x05a4aa09,
0x7fe0232c,
0x05727228,
0x7fe251c4,
0x0540396f,
0x7fe46ae0,
0x050dffe7,
0x7fe67074,
0x04dbc597,
0x7fe86280,
0x04a98a88,
0x7fea4104,
0x04774ec0,
0x7fec0c00,
0x04451249,
0x7fedc374,
0x0412d528,
0x7fef6760,
0x03e09767,
0x7ff0f5d0,
0x03ae590d,
0x7ff272ac,
0x037c1a21,
0x7ff3da0c,
0x0349daac,
0x7ff52fd8,
0x03179ab5,
0x7ff67028,
0x02e55a44,
0x7ff79cf0,
0x02b31961,
0x7ff8b630,
0x0280d813,
0x7ff9bbe8,
0x024e9662,
0x7ffaae18,
0x021c5456,
0x7ffb8acc,
0x01ea11f7,
0x7ffc55ec,
0x01b7cf4d,
0x7ffd0b90,
0x01858c5e,
0x7ffdafa0,
0x01534933,
0x7ffe3e34,
0x012105d4,
0x7ffeb940,
0x00eec249,
0x7fff20c4,
0x00bc7e99,
0x7fff74c0,
0x008a3acb,
0x7fffb534,
0x0057f6e8,
0x7fffe220,
0x0025b2f8,
0x7ffff990,
};


I32 pre_twid_table_512[1024]={

0x7ffffd78,
0x001921fb,
0x7fffc2e0,
0x007da9d4,
0x7fff3834,
0x00e23160,
0x7ffe5f68,
0x0146b860,
0x7ffd3688,
0x01ab3e97,
0x7ffbbf88,
0x020fc3c6,
0x7ff9fa68,
0x027447b0,
0x7ff7e534,
0x02d8ca16,
0x7ff581e0,
0x033d4aba,
0x7ff2ce78,
0x03a1c95f,
0x7fefccf0,
0x040645c7,
0x7fec7b54,
0x046abfb3,
0x7fe8db98,
0x04cf36e5,
0x7fe4edbc,
0x0533ab20,
0x7fe0afcc,
0x05981c25,
0x7fdc23bc,
0x05fc89b7,
0x7fd7498c,
0x0660f398,
0x7fd21f48,
0x06c5598a,
0x7fcca6e4,
0x0729bb4e,
0x7fc6de6c,
0x078e18a7,
0x7fc0c7d4,
0x07f27157,
0x7fba631c,
0x0856c520,
0x7fb3b044,
0x08bb13c4,
0x7facad58,
0x091f5d06,
0x7fa55a58,
0x0983a0a7,
0x7f9dbb2c,
0x09e7de6a,
0x7f95cbec,
0x0a4c1610,
0x7f8d8e8c,
0x0ab0475c,
0x7f850118,
0x0b147211,
0x7f7c2584,
0x0b7895ef,
0x7f72fbd0,
0x0bdcb2bb,
0x7f6983fc,
0x0c40c835,
0x7f5fbe08,
0x0ca4d620,
0x7f55a800,
0x0d08dc3e,
0x7f4b43d8,
0x0d6cda53,
0x7f409190,
0x0dd0d01f,
0x7f359128,
0x0e34bd65,
0x7f2a40ac,
0x0e98a1e8,
0x7f1ea210,
0x0efc7d6b,
0x7f12b748,
0x0f604fae,
0x7f067c6c,
0x0fc41876,
0x7ef9f370,
0x1027d784,
0x7eed1a60,
0x108b8c9b,
0x7edff524,
0x10ef377d,
0x7ed281c8,
0x1152d7ed,
0x7ec4be58,
0x11b66dad,
0x7eb6aebc,
0x1219f880,
0x7ea85100,
0x127d7829,
0x7e99a330,
0x12e0ec69,
0x7e8aa934,
0x13445505,
0x7e7b5f24,
0x13a7b1be,
0x7e6bc8e8,
0x140b0258,
0x7e5be48c,
0x146e4694,
0x7e4bb210,
0x14d17e36,
0x7e3b3174,
0x1534a900,
0x7e2a62b8,
0x1597c6b6,
0x7e1945dc,
0x15fad71a,
0x7e07dae0,
0x165dd9ef,
0x7df623b8,
0x16c0cef9,
0x7de41e70,
0x1723b5f9,
0x7dd1cb08,
0x17868eb3,
0x7dbf2980,
0x17e958ea,
0x7dac3bcc,
0x184c1461,
0x7d98fff8,
0x18aec0db,
0x7d857604,
0x19115e1c,
0x7d719df0,
0x1973ebe6,
0x7d5d79b0,
0x19d669fc,
0x7d490944,
0x1a38d823,
0x7d344ab8,
0x1a9b361c,
0x7d1f3e0c,
0x1afd83ad,
0x7d09e534,
0x1b5fc097,
0x7cf43e3c,
0x1bc1ec9e,
0x7cde4b18,
0x1c240786,
0x7cc809d4,
0x1c861112,
0x7cb17c64,
0x1ce80906,
0x7c9aa2c8,
0x1d49ef25,
0x7c837b0c,
0x1dabc334,
0x7c6c0724,
0x1e0d84f4,
0x7c54451c,
0x1e6f342b,
0x7c3c38dc,
0x1ed0d09c,
0x7c23de7c,
0x1f325a0b,
0x7c0b37f0,
0x1f93d03b,
0x7bf24344,
0x1ff532f1,
0x7bd90460,
0x205681f1,
0x7bbf7950,
0x20b7bcfd,
0x7ba5a020,
0x2118e3db,
0x7b8b7ac4,
0x2179f64f,
0x7b710b30,
0x21daf41c,
0x7b564d7c,
0x223bdd07,
0x7b3b439c,
0x229cb0d4,
0x7b1fef84,
0x22fd6f48,
0x7b044d4c,
0x235e1826,
0x7ae860dc,
0x23beab33,
0x7acc2840,
0x241f2833,
0x7aafa378,
0x247f8eeb,
0x7a92d284,
0x24dfdf20,
0x7a75b758,
0x25401896,
0x7a585000,
0x25a03b11,
0x7a3a9c7c,
0x26004657,
0x7a1c9ec0,
0x26603a2c,
0x79fe54d8,
0x26c01654,
0x79dfc0b8,
0x271fda96,
0x79c0e06c,
0x277f86b5,
0x79a1b5e8,
0x27df1a77,
0x79823f38,
0x283e95a1,
0x79627e50,
0x289df7f7,
0x7942713c,
0x28fd4140,
0x79221be4,
0x295c7140,
0x79017a60,
0x29bb87bc,
0x78e08ea4,
0x2a1a847a,
0x78bf56bc,
0x2a796740,
0x789dd690,
0x2ad82fd2,
0x787c0a38,
0x2b36ddf7,
0x7859f3a8,
0x2b957173,
0x783794d4,
0x2bf3ea0d,
0x7814e9d4,
0x2c52478a,
0x77f1f49c,
0x2cb089b0,
0x77ceb720,
0x2d0eb046,
0x77ab2f6c,
0x2d6cbb10,
0x77875d80,
0x2dcaa9d4,
0x7763415c,
0x2e287c5a,
0x773edb00,
0x2e863267,
0x771a2c60,
0x2ee3cbc1,
0x76f53388,
0x2f41482e,
0x76cff26c,
0x2f9ea775,
0x76aa6718,
0x2ffbe95c,
0x76849380,
0x30590daa,
0x765e75b0,
0x30b61426,
0x76380f9c,
0x3112fc95,
0x76115f50,
0x316fc6be,
0x75ea66c0,
0x31cc7269,
0x75c325ec,
0x3228ff5c,
0x759b9cd4,
0x32856d5e,
0x7573c984,
0x32e1bc36,
0x754bafe4,
0x333debab,
0x75234c0c,
0x3399fb84,
0x74faa1e4,
0x33f5eb89,
0x74d1ad84,
0x3451bb81,
0x74a872d4,
0x34ad6b32,
0x747eefe0,
0x3508fa65,
0x745524a8,
0x356468e1,
0x742b112c,
0x35bfb66e,
0x7400b760,
0x361ae2d3,
0x73d61550,
0x3675edd8,
0x73ab2afc,
0x36d0d745,
0x737ffa58,
0x372b9ee2,
0x73548170,
0x37864477,
0x7328c238,
0x37e0c7cc,
0x72fcbabc,
0x383b28a9,
0x72d06ee4,
0x389566d6,
0x72a3dac8,
0x38ef821c,
0x7276fe68,
0x39497a43,
0x7249ddac,
0x39a34f13,
0x721c74ac,
0x39fd0056,
0x71eec750,
0x3a568dd3,
0x71c0d1b0,
0x3aaff755,
0x719297b4,
0x3b093ca2,
0x71641768,
0x3b625d85,
0x71354ed8,
0x3bbb59c7,
0x710643e0,
0x3c143130,
0x70d6f0a4,
0x3c6ce38a,
0x70a7590c,
0x3cc5709e,
0x70777b24,
0x3d1dd835,
0x704758e0,
0x3d761a19,
0x7016f04c,
0x3dce3613,
0x6fe6435c,
0x3e262bee,
0x6fb5501c,
0x3e7dfb72,
0x6f841880,
0x3ed5a46a,
0x6f529c88,
0x3f2d26a0,
0x6f20dc34,
0x3f8481dd,
0x6eeed784,
0x3fdbb5ec,
0x6ebc8e78,
0x4032c2d4,
0x6e89ff1c,
0x4089a6f8,
0x6e572d58,
0x40e0640c,
0x6e241738,
0x4136fa10,
0x6df0bcbc,
0x418d6710,
0x6dbd1fd8,
0x41e3ab0c,
0x6d893ca4,
0x4239c7f8,
0x6d5518fc,
0x428fb9ec,
0x6d20af04,
0x42e584d0,
0x6cec0498,
0x433b24bc,
0x6cb713dc,
0x43909d98,
0x6c81e2ac,
0x43e5e988,
0x6c4c6d20,
0x443b0e68,
0x6c16b52c,
0x44900850,
0x6be0bad0,
0x44e4d740,
0x6baa7e0c,
0x45397b38,
0x6b73fcec,
0x458df62c,
0x6b3d3b58,
0x45e24628,
0x6b06375c,
0x46366938,
0x6acef0f8,
0x468a6344,
0x6a976a20,
0x46de3064,
0x6a5fa0e0,
0x4731d098,
0x6a279538,
0x478547c8,
0x69ef4728,
0x47d89018,
0x69b6ba98,
0x482bad70,
0x697de9ac,
0x487e9ddc,
0x6944da40,
0x48d16350,
0x690b886c,
0x4923f9e4,
0x68d1f624,
0x4976638c,
0x68982368,
0x49c8a048,
0x685e1038,
0x4a1ab018,
0x6823bc94,
0x4a6c9108,
0x67e9287c,
0x4abe450c,
0x67ae53f0,
0x4b0fca30,
0x677340e4,
0x4b612074,
0x6737ed64,
0x4bb249cc,
0x66fc5970,
0x4c034250,
0x66c086fc,
0x4c540de8,
0x66847414,
0x4ca4aaa0,
0x664822ac,
0x4cf51684,
0x660b90d0,
0x4d455388,
0x65cec268,
0x4d9561ac,
0x6591b38c,
0x4de53efc,
0x65546630,
0x4e34ed6c,
0x6516da54,
0x4e846b08,
0x64d90ff8,
0x4ed3b7d0,
0x649b0910,
0x4f22d3c4,
0x645cc1b4,
0x4f71bee4,
0x641e3dcc,
0x4fc07930,
0x63df7b64,
0x500f02a8,
0x63a07c70,
0x505d5b4c,
0x63613efc,
0x50ab8128,
0x6321c4fc,
0x50f97630,
0x62e20e70,
0x51473870,
0x62a21964,
0x5194c9dc,
0x6261e7cc,
0x51e2268c,
0x622179a8,
0x522f5268,
0x61e0d0ec,
0x527c4b7c,
0x619fe9b0,
0x52c911c8,
0x615ec5e8,
0x5315a54c,
0x611d6788,
0x53620414,
0x60dbcc9c,
0x53ae3208,
0x6099f524,
0x53fa294c,
0x6057e314,
0x5445efbc,
0x60159478,
0x54917f7c,
0x5fd30b44,
0x54dcdc74,
0x5f904778,
0x552804b0,
0x5f4d4914,
0x5572f830,
0x5f0a0e24,
0x55bdb8e8,
0x5ec69a90,
0x560842f0,
0x5e82ea70,
0x5652983c,
0x5e3f01ac,
0x569cb6d8,
0x5dfade50,
0x56e6a2ac,
0x5db6805c,
0x573057d0,
0x5d71e9c4,
0x5779d644,
0x5d2d1894,
0x57c31ffc,
0x5ce80ec0,
0x580c3304,
0x5ca2ca54,
0x58550f5c,
0x5c5d4d44,
0x589db504,
0x5c179790,
0x58e625f0,
0x5bd1a938,
0x592e5e38,
0x5b8b823c,
0x59765fd0,
0x5b45229c,
0x59be2ab8,
0x5afe8a58,
0x5a05bcfc,
0x5ab7bb64,
0x5a4d1890,
0x5a70b1d8,
0x5a943d74,
0x5a29719c,
0x5adb29b4,
0x59e1fab0,
0x5b21dd50,
0x599a4b20,
0x5b685a3c,
0x595266d4,
0x5bae9c90,
0x590a47f0,
0x5bf4a834,
0x58c1f450,
0x5c3a7940,
0x58796a00,
0x5c80139c,
0x5830a70c,
0x5cc57360,
0x57e7af5c,
0x5d0a9a80,
0x579e80fc,
0x5d4f88fc,
0x57551de0,
0x5d943ce0,
0x570b8414,
0x5dd8b62c,
0x56c1b398,
0x5e1cf6d4,
0x5677ae60,
0x5e60fce4,
0x562d746c,
0x5ea4ca50,
0x55e303c8,
0x5ee85b30,
0x55985e68,
0x5f2bb36c,
0x554d8640,
0x5f6ecf1c,
0x55027768,
0x5fb1b034,
0x54b733d4,
0x5ff456b4,
0x546bbd78,
0x6036c29c,
0x54201260,
0x6078f3ec,
0x53d43480,
0x60bae8b0,
0x538821e4,
0x60fca0e8,
0x533bda8c,
0x613e1e88,
0x52ef6260,
0x617f5f9c,
0x52a2b578,
0x61c06424,
0x5255d5c8,
0x62012c20,
0x5208c350,
0x6241b984,
0x51bb7e10,
0x62820868,
0x516e07fc,
0x62c21ac0,
0x51205d2c,
0x6301f08c,
0x50d28188,
0x634189cc,
0x50847510,
0x6380e680,
0x503635d0,
0x63c004b4,
0x4fe7c3c8,
0x63fee468,
0x4f9922e0,
0x643d8790,
0x4f4a4f30,
0x647bee2c,
0x4efb4aac,
0x64ba1454,
0x4eac1748,
0x64f7fdf0,
0x4e5cb11c,
0x6535a90c,
0x4e0d1c10,
0x657315a8,
0x4dbd5630,
0x65b041d0,
0x4d6d6170,
0x65ed316c,
0x4d1d3bdc,
0x6629e288,
0x4ccce768,
0x66665330,
0x4c7c6220,
0x66a28558,
0x4c2badf8,
0x66de770c,
0x4bdacce4,
0x671a2a40,
0x4b89bafc,
0x67559ef4,
0x4b387a34,
0x6790d334,
0x4ae70c80,
0x67cbc700,
0x4a956fec,
0x68067a58,
0x4a43a66c,
0x6840ef30,
0x49f1ae0c,
0x687b21a0,
0x499f86cc,
0x68b51590,
0x494d3494,
0x68eec718,
0x48fab37c,
0x69283a20,
0x48a80578,
0x69616ac0,
0x48552c7c,
0x699a5aec,
0x480224a0,
0x69d308b0,
0x47aef1cc,
0x6a0b7600,
0x475b920c,
0x6a43a2dc,
0x47080560,
0x6a7b8d50,
0x46b44dbc,
0x6ab3355c,
0x46606b20,
0x6aea9cf4,
0x460c5d8c,
0x6b21c224,
0x45b8230c,
0x6b58a4ec,
0x4563bd94,
0x6b8f454c,
0x450f2f18,
0x6bc5a344,
0x44ba75a4,
0x6bfbc0c8,
0x44658f44,
0x6c3199f0,
0x441081d4,
0x6c6730b0,
0x43bb496c,
0x6c9c8314,
0x4365e60c,
0x6cd19504,
0x431059a8,
0x6d066298,
0x42baa440,
0x6d3aebd0,
0x4264c5d4,
0x6d6f32a0,
0x420ebe64,
0x6da33708,
0x41b88df0,
0x6dd6f714,
0x4162366c,
0x6e0a72c4,
0x410bb3f0,
0x6e3daa18,
0x40b50a64,
0x6e709f04,
0x405e39c8,
0x6ea34f94,
0x4007421c,
0x6ed5bbc8,
0x3fb020ce,
0x6f07e1ac,
0x3f58d921,
0x6f39c528,
0x3f016a61,
0x6f6b6448,
0x3ea9d4c3,
0x6f9cbd18,
0x3e52187e,
0x6fcdd18c,
0x3dfa35c8,
0x6ffea1a4,
0x3da22cd7,
0x702f2d60,
0x3d49fde1,
0x705f72cc,
0x3cf1a91c,
0x708f71e8,
0x3c992ec0,
0x70bf2ca8,
0x3c408f02,
0x70eea30c,
0x3be7ca1a,
0x711dd12c,
0x3b8ee03e,
0x714cbce4,
0x3b35d1a5,
0x717b6058,
0x3adc9e85,
0x71a9bd7c,
0x3a834717,
0x71d7d644,
0x3a29cb91,
0x7205a6c8,
0x39d02c2a,
0x723332f0,
0x39766919,
0x726076d4,
0x391c8296,
0x728d7468,
0x38c278d9,
0x72ba2da0,
0x38684c19,
0x72e69e94,
0x380dfc8d,
0x7312c744,
0x37b38a6d,
0x733ea9a4,
0x3758f5f1,
0x736a45b4,
0x36fe3f51,
0x73959b74,
0x36a366c5,
0x73c0a8f0,
0x36486c85,
0x73eb6e28,
0x35ed50c9,
0x7415ed10,
0x359213c9,
0x744023b4,
0x3536b5be,
0x746a1214,
0x34db36df,
0x7493ba24,
0x347f9766,
0x74bd19f0,
0x3423d78a,
0x74e63178,
0x33c7f785,
0x750f00bc,
0x336bf78f,
0x753787bc,
0x330fd7e1,
0x755fc678,
0x32b398b3,
0x7587bcf0,
0x32573a3f,
0x75af6b24,
0x31fabcbd,
0x75d6cf20,
0x319e2067,
0x75fdeccc,
0x31416576,
0x7624c040,
0x30e48c22,
0x764b4b70,
0x308794a6,
0x76718c68,
0x302a7f3a,
0x7697851c,
0x2fcd4c18,
0x76bd358c,
0x2f6ffb7a,
0x76e29bc4,
0x2f128d98,
0x7707b9b8,
0x2eb502ae,
0x772c8d74,
0x2e575af3,
0x775116f8,
0x2df996a3,
0x77755838,
0x2d9bb5f6,
0x77994f40,
0x2d3db928,
0x77bcfc10,
0x2cdfa071,
0x77e05ea8,
0x2c816c0c,
0x780378fc,
0x2c231c33,
0x78264918,
0x2bc4b120,
0x7848cd08,
0x2b662b0e,
0x786b08b4,
0x2b078a36,
0x788cfa28,
0x2aa8ced3,
0x78ae9f70,
0x2a49f920,
0x78cffc74,
0x29eb0957,
0x78f10d4c,
0x298bffb2,
0x7911d3ec,
0x292cdc6d,
0x79325054,
0x28cd9fc1,
0x79528090,
0x286e49ea,
0x79726888,
0x280edb23,
0x79920454,
0x27af53a5,
0x79b153f4,
0x274fb3ad,
0x79d0595c,
0x26effb76,
0x79ef148c,
0x26902b39,
0x7a0d8390,
0x26304333,
0x7a2ba668,
0x25d0439e,
0x7a497f08,
0x25702cb6,
0x7a670d70,
0x250ffeb6,
0x7a844db8,
0x24afb9da,
0x7aa143c8,
0x244f5e5c,
0x7abdefa0,
0x23eeec78,
0x7ada4d58,
0x238e646a,
0x7af660d8,
0x232dc66d,
0x7b12282c,
0x22cd12bd,
0x7b2da354,
0x226c4995,
0x7b48d250,
0x220b6b32,
0x7b63b520,
0x21aa77ce,
0x7b7e4bc4,
0x21496fa6,
0x7b98963c,
0x20e852f6,
0x7bb2967c,
0x208721f9,
0x7bcc489c,
0x2025dcec,
0x7be5ae90,
0x1fc48409,
0x7bfec858,
0x1f63178f,
0x7c179400,
0x1f0197b8,
0x7c301570,
0x1ea004c0,
0x7c4848c0,
0x1e3e5ee5,
0x7c602fe4,
0x1ddca661,
0x7c77cadc,
0x1d7adb72,
0x7c8f17b4,
0x1d18fe54,
0x7ca61860,
0x1cb70f43,
0x7cbccce0,
0x1c550e7b,
0x7cd33340,
0x1bf2fc3a,
0x7ce94d74,
0x1b90d8ba,
0x7cff1b7c,
0x1b2ea43a,
0x7d149b64,
0x1acc5ef5,
0x7d29cd2c,
0x1a6a0929,
0x7d3eb2c8,
0x1a07a311,
0x7d534c38,
0x19a52ceb,
0x7d679594,
0x1942a6f3,
0x7d7b94b8,
0x18e01166,
0x7d8f43c8,
0x187d6c81,
0x7da2a6ac,
0x181ab881,
0x7db5bb70,
0x17b7f5a2,
0x7dc88408,
0x17552422,
0x7ddafe80,
0x16f2443e,
0x7ded2ad8,
0x168f5631,
0x7dff0910,
0x162c5a3b,
0x7e109b1c,
0x15c95096,
0x7e21dd14,
0x15663982,
0x7e32d2e0,
0x1503153a,
0x7e437a8c,
0x149fe3fc,
0x7e53d418,
0x143ca605,
0x7e63df84,
0x13d95b93,
0x7e739ec4,
0x137604e2,
0x7e830df0,
0x1312a230,
0x7e922efc,
0x12af33ba,
0x7ea103dc,
0x124bb9bd,
0x7eaf88a8,
0x11e83478,
0x7ebdc148,
0x1184a426,
0x7ecba9d4,
0x11210907,
0x7ed94440,
0x10bd6356,
0x7ee69280,
0x1059b352,
0x7ef390ac,
0x0ff5f938,
0x7f0040b8,
0x0f923546,
0x7f0ca2a4,
0x0f2e67b8,
0x7f18b670,
0x0eca90ce,
0x7f247c1c,
0x0e66b0c3,
0x7f2ff1b4,
0x0e02c7d7,
0x7f3b1b20,
0x0d9ed646,
0x7f45f478,
0x0d3adc4e,
0x7f507fb0,
0x0cd6da2d,
0x7f5abcc8,
0x0c72d020,
0x7f64a9cc,
0x0c0ebe66,
0x7f6e4aa4,
0x0baaa53b,
0x7f779b68,
0x0b4684de,
0x7f809e0c,
0x0ae25d8d,
0x7f89509c,
0x0a7e2f85,
0x7f91b700,
0x0a19fb04,
0x7f99cd50,
0x09b5c048,
0x7fa19580,
0x09517f8e,
0x7fa90d9c,
0x08ed3915,
0x7fb03798,
0x0888ed1b,
0x7fb71374,
0x08249bdc,
0x7fbd9f3c,
0x07c04598,
0x7fc3dce4,
0x075bea8c,
0x7fc9cc6c,
0x06f78af5,
0x7fcf6dd4,
0x06932713,
0x7fd4bf28,
0x062ebf22,
0x7fd9c068,
0x05ca5361,
0x7fde7388,
0x0565e40d,
0x7fe2d888,
0x05017165,
0x7fe6ef68,
0x049cfba7,
0x7feab634,
0x04388310,
0x7fee2ee0,
0x03d407df,
0x7ff15778,
0x036f8a51,
0x7ff431f0,
0x030b0aa4,
0x7ff6bc54,
0x02a68917,
0x7ff8f898,
0x024205e7,
0x7ffae6bc,
0x01dd8153,
0x7ffc84cc,
0x0178fb99,
0x7ffdd4bc,
0x011474f5,
0x7ffed498,
0x00afeda8,
0x7fff8654,
0x004b65ed,
0x7fffe9f0,
};

 I32 pre_twid_table_256[512]={

0x7ffff5a8,
0x003243f5,
0x7fff0954,
0x00fb5330,
0x7ffce098,
0x01c45ffe,
0x7ff97b74,
0x028d6870,
0x7ff4dbdc,
0x03566a96,
0x7feeffdc,
0x041f6480,
0x7fe7e774,
0x04e8543d,
0x7fdf9498,
0x05b137df,
0x7fd60554,
0x067a0d75,
0x7fcb3b9c,
0x0742d311,
0x7fbf3770,
0x080b86c1,
0x7fb1f6dc,
0x08d42698,
0x7fa379e0,
0x099cb0a7,
0x7f93c464,
0x0a6522fe,
0x7f82d280,
0x0b2d7baf,
0x7f70a628,
0x0bf5b8cb,
0x7f5d3f5c,
0x0cbdd865,
0x7f489e1c,
0x0d85d88f,
0x7f32c45c,
0x0e4db75b,
0x7f1bae34,
0x0f1572dc,
0x7f036180,
0x0fdd0925,
0x7ee9d864,
0x10a4784a,
0x7ecf18bc,
0x116bbe5f,
0x7eb31ea0,
0x1232d978,
0x7e95ec04,
0x12f9c7aa,
0x7e7780e8,
0x13c0870a,
0x7e57df40,
0x148715ad,
0x7e370518,
0x154d71aa,
0x7e14f270,
0x16139917,
0x7df1a93c,
0x16d98a0c,
0x7dcd297c,
0x179f429f,
0x7da77330,
0x1864c0e9,
0x7d808658,
0x192a0304,
0x7d5864e8,
0x19ef0707,
0x7d2f0ee0,
0x1ab3cb0d,
0x7d04824c,
0x1b784d30,
0x7cd8c120,
0x1c3c8b8c,
0x7cabcd50,
0x1d00843c,
0x7c7da4e8,
0x1dc4355d,
0x7c4e49dc,
0x1e879d0d,
0x7c1dbc2c,
0x1f4ab967,
0x7bebfbd8,
0x200d888d,
0x7bb908e0,
0x20d0089c,
0x7b84e538,
0x219237b4,
0x7b4f92d4,
0x225413f8,
0x7b190dcc,
0x23159b88,
0x7ae15a08,
0x23d6cc86,
0x7aa87594,
0x2497a517,
0x7a6e6458,
0x2558235e,
0x7a332460,
0x26184581,
0x79f6b7a0,
0x26d809a5,
0x79b91c24,
0x27976df1,
0x797a55d4,
0x2856708d,
0x793a62bc,
0x29150fa1,
0x78f944d0,
0x29d34958,
0x78b6fe04,
0x2a911bdc,
0x78738c64,
0x2b4e8558,
0x782eeff0,
0x2c0b83f9,
0x77e92c90,
0x2cc815ee,
0x77a24050,
0x2d843964,
0x775a2f18,
0x2e3fec8b,
0x7710f500,
0x2efb2d94,
0x76c695f0,
0x2fb5fab2,
0x767b11e8,
0x30705217,
0x762e68e8,
0x312a31f8,
0x75e09ce4,
0x31e39889,
0x7591afd0,
0x329c8402,
0x75419dc4,
0x3354f29a,
0x74f06aa8,
0x340ce28b,
0x749e1870,
0x34c4520d,
0x744aa71c,
0x357b3f5d,
0x73f614b8,
0x3631a8b8,
0x73a0652c,
0x36e78c5a,
0x73499878,
0x379ce885,
0x72f1ae9c,
0x3851bb77,
0x7298a98c,
0x39060372,
0x723e8948,
0x39b9bebb,
0x71e34fc4,
0x3a6ceb96,
0x7186fd00,
0x3b1f8847,
0x712992f0,
0x3bd19318,
0x70cb1194,
0x3c830a4f,
0x706b78ec,
0x3d33ec39,
0x700acaec,
0x3de4371f,
0x6fa90988,
0x3e93e950,
0x6f4632cc,
0x3f430119,
0x6ee24aa0,
0x3ff17cca,
0x6e7d5104,
0x409f5b9c,
0x6e1747ec,
0x414c9938,
0x6db02d64,
0x41f936ac,
0x6d480554,
0x42a53204,
0x6cdecdc8,
0x43508758,
0x6c748aa8,
0x43fb36a8,
0x6c093bf4,
0x44a53ff4,
0x6b9ce3a0,
0x454e9f54,
0x6b2f81ac,
0x45f752d4,
0x6ac11618,
0x469f5a74,
0x6a51a2d8,
0x4746b24c,
0x69e129e0,
0x47ed5c50,
0x696fad24,
0x489352a4,
0x68fd2ab0,
0x49389930,
0x6889a478,
0x49dd2824,
0x68151e64,
0x4a810174,
0x679f9680,
0x4b24232c,
0x67290ec0,
0x4bc68b58,
0x66b18724,
0x4c6839f8,
0x66390394,
0x4d092b24,
0x65bf8410,
0x4da95ce8,
0x65450898,
0x4e48d138,
0x64c99514,
0x4ee78238,
0x644d2790,
0x4f8571dc,
0x63cfc200,
0x50229e30,
0x63516658,
0x50bf034c,
0x62d2168c,
0x515aa130,
0x6251d29c,
0x51f577dc,
0x61d09c7c,
0x528f8174,
0x614e742c,
0x5328c1e0,
0x60cb5ba0,
0x53c13344,
0x604754cc,
0x5458d794,
0x5fc25fb0,
0x54efaae8,
0x5f3c8034,
0x5585ad40,
0x5eb5b464,
0x561adca8,
0x5e2dfe34,
0x56af372c,
0x5da55f98,
0x5742bccc,
0x5d1bda84,
0x57d569a0,
0x5c9170ec,
0x58673da8,
0x5c0620dc,
0x58f838e4,
0x5b79f030,
0x5988576c,
0x5aecdb00,
0x5a179940,
0x5a5ee728,
0x5aa5fe60,
0x59d014a8,
0x5b3380f0,
0x59406380,
0x5bc024d8,
0x58afd798,
0x5c4be630,
0x581e6efc,
0x5cd6c304,
0x578c2d94,
0x5d60bb54,
0x56f91554,
0x5de9cd2c,
0x56652448,
0x5e71f698,
0x55d0604c,
0x5ef93798,
0x553ac76c,
0x5f7f8e38,
0x54a45b9c,
0x6004f884,
0x540d20c4,
0x6089767c,
0x537514f0,
0x610d062c,
0x52dc3c08,
0x618fa5a0,
0x5242960c,
0x621154d8,
0x51a824f0,
0x629213d4,
0x510ceaa8,
0x6311dcb8,
0x5070e928,
0x6390b36c,
0x4fd42070,
0x640e9408,
0x4f369274,
0x648b7c98,
0x4e98431c,
0x65076f10,
0x4df92e80,
0x65826594,
0x4d595c70,
0x65fc640c,
0x4cb8c904,
0x6675649c,
0x4c177a18,
0x66ed6b2c,
0x4b756fac,
0x676471e0,
0x4ad2a9c0,
0x67da7aac,
0x4a2f2c3c,
0x684f81a8,
0x498af720,
0x68c388c8,
0x48e60c60,
0x69368c24,
0x48406df0,
0x69a88bbc,
0x479a1dc4,
0x6a198790,
0x46f31bdc,
0x6a897dac,
0x464b6c20,
0x6af86c1c,
0x45a30e90,
0x6b6652e0,
0x44fa0520,
0x6bd331f8,
0x44504fd0,
0x6c3f057c,
0x43a5f47c,
0x6ca9cd6c,
0x42faf130,
0x6d138bbc,
0x424f47e0,
0x6d7c3a90,
0x41a2fc74,
0x6de3dbdc,
0x40f60eec,
0x6e4a6dac,
0x40487f48,
0x6eaff000,
0x3f9a528f,
0x6f1460e4,
0x3eeb889c,
0x6f77c058,
0x3e3c2369,
0x6fda0c68,
0x3d8c24a8,
0x703b4514,
0x3cdb8e09,
0x709b6868,
0x3c2a6142,
0x70fa7470,
0x3b78a007,
0x71586b20,
0x3ac64c0f,
0x71b54a84,
0x3a136712,
0x721110a8,
0x395ff2c9,
0x726bbd8c,
0x38abf0ef,
0x72c54f3c,
0x37f76340,
0x731dc7ac,
0x37424b7b,
0x737522f4,
0x368cab5c,
0x73cb6114,
0x35d684a5,
0x7420820c,
0x351fd918,
0x747483e8,
0x3468aa76,
0x74c766a8,
0x33b0fa84,
0x75192858,
0x32f8cb07,
0x7569caec,
0x32401dc5,
0x75b94a7c,
0x3186f487,
0x7607a8fc,
0x30cd5115,
0x7654e284,
0x30133538,
0x76a0f908,
0x2f58a2be,
0x76ebea94,
0x2e9d9b70,
0x7735b728,
0x2de2211e,
0x777e5cd0,
0x2d263595,
0x77c5db8c,
0x2c69daa6,
0x780c335c,
0x2bad1221,
0x7851624c,
0x2aefddd8,
0x78956a50,
0x2a323f9d,
0x78d84780,
0x29743946,
0x7919f9dc,
0x28b5cca5,
0x795a8164,
0x27f6fb92,
0x7999de18,
0x2737c7e3,
0x79d80ff8,
0x26783370,
0x7a15131c,
0x25b84012,
0x7a50e978,
0x24f7efa2,
0x7a8b930c,
0x243743fa,
0x7ac50de4,
0x23763ef7,
0x7afd5a00,
0x22b4e274,
0x7b34756c,
0x21f3304f,
0x7b6a621c,
0x21312a65,
0x7b9f1e1c,
0x206ed295,
0x7bd2a96c,
0x1fac2abf,
0x7c050218,
0x1ee934c3,
0x7c362820,
0x1e25f281,
0x7c661d78,
0x1d6265dd,
0x7c94e02c,
0x1c9e90b8,
0x7cc26e48,
0x1bda74f5,
0x7ceec7cc,
0x1b161479,
0x7d19eeac,
0x1a517128,
0x7d43e0f4,
0x198c8ce6,
0x7d6c9cb0,
0x18c7699b,
0x7d9423d4,
0x1802092c,
0x7dba746c,
0x173c6d80,
0x7ddf906c,
0x1676987f,
0x7e0373ec,
0x15b08c11,
0x7e2622d4,
0x14ea4a1f,
0x7e47993c,
0x1423d492,
0x7e67d724,
0x135d2d53,
0x7e86de80,
0x1296564d,
0x7ea4ab68,
0x11cf516a,
0x7ec141c4,
0x11082096,
0x7edc9fa0,
0x1040c5bb,
0x7ef6c4fc,
0x0f7942c6,
0x7f0fafe4,
0x0eb199a4,
0x7f276058,
0x0de9cc3f,
0x7f3dd84c,
0x0d21dc87,
0x7f5315cc,
0x0c59cc67,
0x7f671acc,
0x0b919dce,
0x7f79e364,
0x0ac952aa,
0x7f8b7188,
0x0a00ece8,
0x7f9bc72c,
0x09386e78,
0x7faae068,
0x086fd947,
0x7fb8bd3c,
0x07a72f45,
0x7fc56190,
0x06de7261,
0x7fd0c97c,
0x0615a48b,
0x7fdaf500,
0x054cc7b1,
0x7fe3e610,
0x0483ddc3,
0x7feb9ab8,
0x03bae8b1,
0x7ff214ec,
0x02f1ea6b,
0x7ff752b8,
0x0228e4e1,
0x7ffb5610,
0x015fda03,
0x7ffe1d00,
0x0096cbc1,
0x7fffa788,
};

 I32 pre_twid_table_128[256]={

0x7fffd85c,
0x006487e3,
0x7ffc2518,
0x01f6a296,
0x7ff38228,
0x0388a9e9,
0x7fe5f180,
0x051a8e5c,
0x7fd3712c,
0x06ac406f,
0x7fbc0320,
0x083db0a7,
0x7f9fa950,
0x09cecf89,
0x7f7e63bc,
0x0b5f8d9f,
0x7f583458,
0x0cefdb75,
0x7f2d1b24,
0x0e7fa99d,
0x7efd1c08,
0x100ee8ad,
0x7ec83704,
0x119d8940,
0x7e8e6e0c,
0x132b7bf9,
0x7e4fc508,
0x14b8b17f,
0x7e0c3dec,
0x16451a83,
0x7dc3d8b8,
0x17d0a7bc,
0x7d769b48,
0x195b49e9,
0x7d248790,
0x1ae4f1d6,
0x7ccda178,
0x1c6d9053,
0x7c71eaf4,
0x1df5163f,
0x7c1167ec,
0x1f7b7480,
0x7bac1c48,
0x21009c0c,
0x7b420de4,
0x22847ddf,
0x7ad33cc0,
0x24070b07,
0x7a5fb0ac,
0x2588349d,
0x79e76d90,
0x2707ebc6,
0x796a7560,
0x288621b9,
0x78e8cfec,
0x2a02c7b8,
0x7862811c,
0x2b7dcf17,
0x77d78cd8,
0x2cf72939,
0x7747faf0,
0x2e6ec792,
0x76b3d140,
0x2fe49ba7,
0x761b11bc,
0x3158970d,
0x757dc628,
0x32caab6f,
0x74dbf26c,
0x343aca87,
0x74359c64,
0x35a8e624,
0x738acbe0,
0x3714f02a,
0x72db88b0,
0x387eda8e,
0x7227d6bc,
0x39e6975e,
0x716fbdd4,
0x3b4c18ba,
0x70b345c8,
0x3caf50da,
0x6ff27474,
0x3e10320d,
0x6f2d539c,
0x3f6eaeb8,
0x6e63e91c,
0x40cab92c,
0x6d963cc4,
0x42244428,
0x6cc45664,
0x437b42cc,
0x6bee3fc0,
0x44cfa76c,
0x6b13feb4,
0x4621645c,
0x6a359d04,
0x47706de4,
0x69532474,
0x48bcb658,
0x686c9ae0,
0x4a06300c,
0x67820c00,
0x4b4ccf48,
0x66937db0,
0x4c908854,
0x65a0fd9c,
0x4dd14b90,
0x64aa8fac,
0x4f0f112c,
0x63b0418c,
0x5049c988,
0x62b21d00,
0x518168ec,
0x61b027e4,
0x52b5e594,
0x60aa6fe4,
0x53e72fe0,
0x5fa0fec4,
0x55154000,
0x5e93dc54,
0x56400848,
0x5d83144c,
0x57677b0c,
0x5c6eb264,
0x588b907c,
0x5b56c060,
0x59ac3ce0,
0x5a3b4804,
0x5ac97480,
0x591c5508,
0x5be329b0,
0x57f9f324,
0x5cf95694,
0x56d42c1c,
0x5e0beb8c,
0x55ab0d9c,
0x5f1ae2bc,
0x547ea168,
0x60262e78,
0x534ef144,
0x612dc4fc,
0x521c0cd0,
0x62319c84,
0x50e5fdd0,
0x6331a958,
0x4faccffc,
0x642de59c,
0x4e708f0c,
0x652643a4,
0x4d3148ac,
0x661abba0,
0x4bef0894,
0x670b43cc,
0x4aa9dc70,
0x67f7d458,
0x4961ce04,
0x68e0618c,
0x4816eafc,
0x69c4e398,
0x46c94104,
0x6aa552ac,
0x4578dbd4,
0x6b81a310,
0x4425c918,
0x6c59d0dc,
0x42d0167c,
0x6d2dd058,
0x4177cfb8,
0x6dfd99b4,
0x401d0278,
0x6ec92714,
0x3ebfbdcc,
0x6f906cc0,
0x3d600d2c,
0x705366d0,
0x3bfdfecd,
0x71120d74,
0x3a99a057,
0x71cc56e8,
0x3932ff87,
0x72823d50,
0x37ca2a30,
0x7333b8dc,
0x365f2e3b,
0x73e0c3b0,
0x34f219a7,
0x748957f0,
0x3382fa88,
0x752d6bd8,
0x3211df04,
0x75ccfd74,
0x309ed556,
0x76680300,
0x2f29ebcc,
0x76fe7894,
0x2db330c7,
0x77905854,
0x2c3ab2b9,
0x781d9a70,
0x2ac08026,
0x78a63cf4,
0x2944a7a2,
0x792a3810,
0x27c737d3,
0x79a987dc,
0x26483f6c,
0x7a242488,
0x24c7cd32,
0x7a9a0e14,
0x2345eff8,
0x7b0b3cb0,
0x21c2b69c,
0x7b77ae68,
0x203e300d,
0x7bdf5b6c,
0x1eb86b46,
0x7c4243bc,
0x1d31774d,
0x7ca05f88,
0x1ba96335,
0x7cf9aed0,
0x1a203e1b,
0x7d4e2bb8,
0x18961728,
0x7d9dd640,
0x170afd8d,
0x7de8a698,
0x157f0086,
0x7e2e9cc0,
0x13f22f58,
0x7e6fb6c4,
0x1264994e,
0x7eabeec8,
0x10d64dbc,
0x7ee346c0,
0x0f475bff,
0x7f15b8d0,
0x0db7d376,
0x7f4344f8,
0x0c27c389,
0x7f6be944,
0x0a973ba5,
0x7f8fa3c0,
0x09064b3a,
0x7fae746c,
0x077501be,
0x7fc85760,
0x05e36ea9,
0x7fdd4e90,
0x0451a177,
0x7fed5808,
0x02bfa9a4,
0x7ff871d4,
0x012d96b1,
0x7ffe9bf4,
};

I32 pre_twid_table_64 [128]={

0x7fff6138,
0x00c90f88,
0x7ff09428,
0x03ed26e6,
0x7fce0c50,
0x0710a344,
0x7f97cf8c,
0x0a3308bc,
0x7f4de3b8,
0x0d53db92,
0x7ef05874,
0x1072a047,
0x7e7f3978,
0x138edbb1,
0x7dfa9858,
0x16a81305,
0x7d628a90,
0x19bdcbf3,
0x7cb72790,
0x1ccf8cb3,
0x7bf888bc,
0x1fdcdc1b,
0x7b26cb60,
0x22e541af,
0x7a4210b0,
0x25e845b6,
0x794a7bd4,
0x28e5714a,
0x784033dc,
0x2bdc4e6f,
0x77235fd8,
0x2ecc681e,
0x75f42cb4,
0x31b54a5d,
0x74b2c950,
0x3496824f,
0x735f6680,
0x376f9e46,
0x71fa3900,
0x3a402dd2,
0x70837974,
0x3d07c1d6,
0x6efb5e8c,
0x3fc5ec98,
0x6d6228bc,
0x427a41d4,
0x6bb8129c,
0x4524571c,
0x69fd6088,
0x47c3c1ec,
0x683256dc,
0x4a581cb4,
0x66573be8,
0x4ce0fff0,
0x646c59e4,
0x4f5e0804,
0x6271fb08,
0x51ced53c,
0x60686d74,
0x54330208,
0x5e50013c,
0x568a3490,
0x5c290a5c,
0x58d40f14,
0x59f3dec4,
0x5b1035c8,
0x57b0d270,
0x5d3e52bc,
0x5560412c,
0x5f5e0e0c,
0x530284d0,
0x616f13bc,
0x5097fd10,
0x637115ac,
0x4e2105b8,
0x6563bfe0,
0x4b9e0458,
0x6746c820,
0x490f58a4,
0x6919e240,
0x4675682c,
0x6adcc9e4,
0x43d09a74,
0x6c8f34d4,
0x412158f4,
0x6e30e29c,
0x3e680b2c,
0x6fc192c8,
0x3ba51e29,
0x714108cc,
0x38d8fe93,
0x72af0628,
0x36041ad9,
0x740b542c,
0x3326e2c2,
0x7555be1c,
0x3041c760,
0x768e0f3c,
0x2d553afb,
0x77b418ac,
0x2a61b101,
0x78c7ab8c,
0x27679df4,
0x79c89ed8,
0x24677757,
0x7ab6cb80,
0x2161b39f,
0x7b920c68,
0x1e56ca1e,
0x7c5a3c74,
0x1b4732ef,
0x7d0f4240,
0x183366e8,
0x7db0fe8c,
0x151bdf85,
0x7e3f57f4,
0x120116d5,
0x7eba3af0,
0x0ee38766,
0x7f219204,
0x0bc3ac35,
0x7f754d90,
0x08a2009a,
0x7fb563d0,
0x057f0034,
0x7fe1c718,
0x025b26d7,
0x7ffa7380,
};

I32 post_twid_table_1024[1026]={
0x7fffffff,
0x00000000,
0x7ffff600,
0xffcdbc0b,
0x7fffd880,
0xff9b781d,
0x7fffa700,
0xff69343f,
0x7fff6200,
0xff36f079,
0x7fff0900,
0xff04acd1,
0x7ffe9c80,
0xfed26950,
0x7ffe1c00,
0xfea025fe,
0x7ffd8800,
0xfe6de2e2,
0x7ffce000,
0xfe3ba004,
0x7ffc2480,
0xfe095d6c,
0x7ffb5500,
0xfdd71b20,
0x7ffa7280,
0xfda4d92c,
0x7ff97b80,
0xfd729790,
0x7ff87180,
0xfd405660,
0x7ff75300,
0xfd0e1594,
0x7ff62180,
0xfcdbd544,
0x7ff4db80,
0xfca99568,
0x7ff38280,
0xfc775618,
0x7ff21500,
0xfc45174c,
0x7ff09480,
0xfc12d91c,
0x7feeff80,
0xfbe09b80,
0x7fed5780,
0xfbae5e88,
0x7feb9b00,
0xfb7c2240,
0x7fe9cb80,
0xfb49e6a0,
0x7fe7e780,
0xfb17abc8,
0x7fe5f100,
0xfae571a0,
0x7fe3e580,
0xfab33858,
0x7fe1c780,
0xfa80ffc8,
0x7fdf9480,
0xfa4ec828,
0x7fdd4f00,
0xfa1c9150,
0x7fdaf480,
0xf9ea5b80,
0x7fd88780,
0xf9b82680,
0x7fd60580,
0xf985f298,
0x7fd37180,
0xf953bf90,
0x7fd0c800,
0xf9218db0,
0x7fce0c80,
0xf8ef5cb8,
0x7fcb3b80,
0xf8bd2d00,
0x7fc85880,
0xf88afe40,
0x7fc56000,
0xf858d0c8,
0x7fc25600,
0xf826a460,
0x7fbf3600,
0xf7f47950,
0x7fbc0480,
0xf7c24f60,
0x7fb8bd00,
0xf79026d0,
0x7fb56400,
0xf75dff70,
0x7fb1f580,
0xf72bd980,
0x7fae7500,
0xf6f9b4d0,
0x7faadf00,
0xf6c791a0,
0x7fa73700,
0xf6956fc0,
0x7fa37980,
0xf6634f70,
0x7f9faa80,
0xf6313080,
0x7f9bc580,
0xf5ff1330,
0x7f97cf00,
0xf5ccf750,
0x7f93c300,
0xf59add20,
0x7f8fa500,
0xf568c470,
0x7f8b7180,
0xf536ad70,
0x7f872c80,
0xf5049810,
0x7f82d180,
0xf4d28470,
0x7f7e6500,
0xf4a07270,
0x7f79e300,
0xf46e6250,
0x7f754f00,
0xf43c53e0,
0x7f70a580,
0xf40a4750,
0x7f6bea80,
0xf3d83c90,
0x7f671980,
0xf3a633b0,
0x7f623700,
0xf3742cc0,
0x7f5d3f00,
0xf34227b0,
0x7f583500,
0xf31024b0,
0x7f531600,
0xf2de2390,
0x7f4de480,
0xf2ac2490,
0x7f489e80,
0xf27a2790,
0x7f434580,
0xf2482cb0,
0x7f3dd880,
0xf21633e0,
0x7f385800,
0xf1e43d40,
0x7f32c400,
0xf1b248c0,
0x7f2d1c00,
0xf1805680,
0x7f276100,
0xf14e6670,
0x7f219180,
0xf11c78b0,
0x7f1baf80,
0xf0ea8d40,
0x7f15b880,
0xf0b8a410,
0x7f0faf80,
0xf086bd50,
0x7f099180,
0xf054d8e0,
0x7f036100,
0xf022f6f0,
0x7efd1c00,
0xeff11760,
0x7ef6c480,
0xefbf3a60,
0x7ef05800,
0xef8d5fc0,
0x7ee9d980,
0xef5b87e0,
0x7ee34600,
0xef29b240,
0x7edca000,
0xeef7dfa0,
0x7ed5e580,
0xeec60f20,
0x7ecf1880,
0xee9441e0,
0x7ec83700,
0xee6276a0,
0x7ec14280,
0xee30aee0,
0x7eba3a00,
0xedfee900,
0x7eb31e80,
0xedcd26e0,
0x7eabef00,
0xed9b6680,
0x7ea4ac80,
0xed69aa00,
0x7e9d5600,
0xed37ef60,
0x7e95ec80,
0xed0638a0,
0x7e8e6e80,
0xecd483e0,
0x7e86de00,
0xeca2d300,
0x7e7f3900,
0xec712420,
0x7e778180,
0xec3f7940,
0x7e6fb580,
0xec0dd080,
0x7e67d700,
0xebdc2bc0,
0x7e5fe400,
0xebaa8920,
0x7e57de80,
0xeb78eaa0,
0x7e4fc480,
0xeb474e60,
0x7e479800,
0xeb15b620,
0x7e3f5780,
0xeae42060,
0x7e370400,
0xeab28ea0,
0x7e2e9c80,
0xea80ff60,
0x7e262200,
0xea4f7440,
0x7e1d9380,
0xea1deba0,
0x7e14f200,
0xe9ec6740,
0x7e0c3c80,
0xe9bae560,
0x7e037480,
0xe98967e0,
0x7dfa9800,
0xe957ece0,
0x7df1a900,
0xe9267660,
0x7de8a600,
0xe8f50260,
0x7ddf9000,
0xe8c392e0,
0x7dd66600,
0xe8922600,
0x7dcd2980,
0xe860bdc0,
0x7dc3d880,
0xe82f5820,
0x7dba7500,
0xe7fdf740,
0x7db0fd80,
0xe7cc9900,
0x7da77300,
0xe79b3f80,
0x7d9dd500,
0xe769e8c0,
0x7d942380,
0xe73896c0,
0x7d8a5f00,
0xe70747a0,
0x7d808680,
0xe6d5fd60,
0x7d769b80,
0xe6a4b600,
0x7d6c9c80,
0xe6737380,
0x7d628a80,
0xe6423400,
0x7d586500,
0xe610f960,
0x7d4e2c00,
0xe5dfc1e0,
0x7d43e000,
0xe5ae8f40,
0x7d398080,
0xe57d5fe0,
0x7d2f0e00,
0xe54c3560,
0x7d248780,
0xe51b0e40,
0x7d19ee80,
0xe4e9ec00,
0x7d0f4180,
0xe4b8cd20,
0x7d048200,
0xe487b340,
0x7cf9ae80,
0xe4569ce0,
0x7ceec880,
0xe4258b80,
0x7ce3ce80,
0xe3f47da0,
0x7cd8c180,
0xe3c374e0,
0x7ccda100,
0xe3926fc0,
0x7cc26d80,
0xe3616fc0,
0x7cb72680,
0xe3307360,
0x7cabcd00,
0xe2ff7c40,
0x7ca05f80,
0xe2ce88c0,
0x7c94df80,
0xe29d9aa0,
0x7c894b80,
0xe26cb020,
0x7c7da500,
0xe23bcb20,
0x7c71ea80,
0xe20ae9c0,
0x7c661d80,
0xe1da0e00,
0x7c5a3d00,
0xe1a935e0,
0x7c4e4980,
0xe1786380,
0x7c424280,
0xe14794c0,
0x7c362900,
0xe116cbc0,
0x7c29fb80,
0xe0e60680,
0x7c1dbb80,
0xe0b54720,
0x7c116800,
0xe0848b80,
0x7c050180,
0xe053d5c0,
0x7bf88800,
0xe02323e0,
0x7bebfb00,
0xdff27800,
0x7bdf5b80,
0xdfc1d000,
0x7bd2a800,
0xdf912e00,
0x7bc5e280,
0xdf609000,
0x7bb90900,
0xdf2ff800,
0x7bac1d00,
0xdeff6400,
0x7b9f1d80,
0xdeced640,
0x7b920b80,
0xde9e4c80,
0x7b84e580,
0xde6dc900,
0x7b77ad80,
0xde3d4980,
0x7b6a6180,
0xde0cd080,
0x7b5d0380,
0xdddc5b40,
0x7b4f9180,
0xddabecc0,
0x7b420d80,
0xdd7b8240,
0x7b347580,
0xdd4b1e40,
0x7b26cb80,
0xdd1abe80,
0x7b190d80,
0xdcea6540,
0x7b0b3d80,
0xdcba1040,
0x7afd5980,
0xdc89c1c0,
0x7aef6380,
0xdc5977c0,
0x7ae15980,
0xdc293440,
0x7ad33d80,
0xdbf8f540,
0x7ac50d80,
0xdbc8bcc0,
0x7ab6cc00,
0xdb988900,
0x7aa87600,
0xdb685bc0,
0x7a9a0e80,
0xdb383340,
0x7a8b9300,
0xdb081140,
0x7a7d0580,
0xdad7f400,
0x7a6e6480,
0xdaa7dd80,
0x7a5fb100,
0xda77cbc0,
0x7a50ea00,
0xda47c0c0,
0x7a421100,
0xda17bac0,
0x7a332480,
0xd9e7bb40,
0x7a242580,
0xd9b7c100,
0x7a151380,
0xd987cd40,
0x7a05ee80,
0xd957df00,
0x79f6b700,
0xd927f700,
0x79e76c80,
0xd8f814c0,
0x79d80f80,
0xd8c838c0,
0x79c89f80,
0xd8986280,
0x79b91c80,
0xd86892c0,
0x79a98700,
0xd838c8c0,
0x7999de80,
0xd8090500,
0x798a2380,
0xd7d94780,
0x797a5580,
0xd7a99000,
0x796a7500,
0xd779df00,
0x795a8180,
0xd74a3400,
0x794a7b80,
0xd71a8f80,
0x793a6300,
0xd6eaf100,
0x792a3780,
0xd6bb5940,
0x7919f980,
0xd68bc740,
0x7909a880,
0xd65c3c40,
0x78f94580,
0xd62cb740,
0x78e8cf00,
0xd5fd3900,
0x78d84680,
0xd5cdc100,
0x78c7ab00,
0xd59e4fc0,
0x78b6fd00,
0xd56ee4c0,
0x78a63c80,
0xd53f8080,
0x78956900,
0xd51022c0,
0x78848380,
0xd4e0cbc0,
0x78738b00,
0xd4b17b40,
0x78628000,
0xd4823180,
0x78516280,
0xd452ee80,
0x78403280,
0xd423b240,
0x782ef000,
0xd3f47cc0,
0x781d9a80,
0xd3c54e00,
0x780c3300,
0xd3962600,
0x77fab880,
0xd3670500,
0x77e92c00,
0xd337eac0,
0x77d78c80,
0xd308d780,
0x77c5db00,
0xd2d9cb00,
0x77b41680,
0xd2aac5c0,
0x77a24080,
0xd27bc740,
0x77905700,
0xd24cd000,
0x777e5c00,
0xd21ddf80,
0x776c4d80,
0xd1eef680,
0x775a2e00,
0xd1c01400,
0x7747fa80,
0xd1913940,
0x7735b600,
0xd1626500,
0x77235e00,
0xd13398c0,
0x7710f480,
0xd104d2c0,
0x76fe7800,
0xd0d61500,
0x76ebe980,
0xd0a75d80,
0x76d94880,
0xd078ae80,
0x76c69580,
0xd04a0580,
0x76b3cf80,
0xd01b6540,
0x76a0f800,
0xcfeccb00,
0x768e0d80,
0xcfbe3980,
0x767b1180,
0xcf8fae40,
0x76680280,
0xcf612b80,
0x7654e200,
0xcf32af40,
0x7641ae80,
0xcf043b80,
0x762e6980,
0xced5ce40,
0x761b1180,
0xcea769c0,
0x7607a800,
0xce790bc0,
0x75f42b80,
0xce4ab680,
0x75e09d80,
0xce1c67c0,
0x75ccfc80,
0xcdee21c0,
0x75b94a80,
0xcdbfe280,
0x75a58500,
0xcd91ac00,
0x7591af00,
0xcd637c40,
0x757dc500,
0xcd355540,
0x7569ca80,
0xcd073540,
0x7555bc80,
0xccd91e00,
0x75419e00,
0xccab0dc0,
0x752d6b80,
0xcc7d0640,
0x75192900,
0xcc4f05c0,
0x7504d280,
0xcc210e40,
0x74f06b80,
0xcbf31dc0,
0x74dbf100,
0xcbc53640,
0x74c76600,
0xcb9755c0,
0x74b2c780,
0xcb697e80,
0x749e1880,
0xcb3bae40,
0x74895600,
0xcb0de740,
0x74748300,
0xcae02740,
0x745f9c80,
0xcab27080,
0x744aa600,
0xca84c100,
0x74359b80,
0xca571ac0,
0x74208100,
0xca297bc0,
0x740b5280,
0xc9fbe600,
0x73f61480,
0xc9ce57c0,
0x73e0c200,
0xc9a0d280,
0x73cb6080,
0xc9735500,
0x73b5ea00,
0xc945e0c0,
0x73a06500,
0xc9187400,
0x738acb00,
0xc8eb10c0,
0x73752200,
0xc8bdb500,
0x735f6480,
0xc89062c0,
0x73499800,
0xc8631800,
0x7333b700,
0xc835d6c0,
0x731dc700,
0xc8089d40,
0x7307c280,
0xc7db6d40,
0x72f1af00,
0xc7ae4500,
0x72db8700,
0xc7812680,
0x72c55000,
0xc7540f80,
0x72af0480,
0xc7270280,
0x7298aa00,
0xc6f9fd00,
0x72823b80,
0xc6cd0180,
0x726bbd80,
0xc6a00dc0,
0x72552b80,
0xc67323c0,
0x723e8a80,
0xc64641c0,
0x7227d500,
0xc6196980,
0x72111100,
0xc5ec9980,
0x71fa3800,
0xc5bfd300,
0x71e35100,
0xc5931500,
0x71cc5500,
0xc5666080,
0x71b54b00,
0xc539b480,
0x719e2b80,
0xc50d1200,
0x7186fe80,
0xc4e07840,
0x716fbc00,
0xc4b3e800,
0x71586c00,
0xc4876080,
0x71410680,
0xc45ae280,
0x71299380,
0xc42e6d80,
0x71120b80,
0xc40201c0,
0x70fa7580,
0xc3d59f40,
0x70e2ca80,
0xc3a94600,
0x70cb1180,
0xc37cf640,
0x70b34400,
0xc350af80,
0x709b6800,
0xc3247280,
0x70837800,
0xc2f83e80,
0x706b7900,
0xc2cc1440,
0x70536680,
0xc29ff340,
0x703b4500,
0xc273dbc0,
0x70230f80,
0xc247cdc0,
0x700acb80,
0xc21bc940,
0x6ff27380,
0xc1efce40,
0x6fda0d00,
0xc1c3dd00,
0x6fc19280,
0xc197f540,
0x6fa90980,
0xc16c1700,
0x6f906c80,
0xc1404280,
0x6f77c100,
0xc11477c0,
0x6f5f0180,
0xc0e8b680,
0x6f463400,
0xc0bcff40,
0x6f2d5200,
0xc0915180,
0x6f146200,
0xc065adc0,
0x6efb5e00,
0xc03a13c0,
0x6ee24b80,
0xc00e8380,
0x6ec92580,
0xbfe2fd00,
0x6eaff100,
0xbfb78080,
0x6e96a880,
0xbf8c0e00,
0x6e7d5200,
0xbf60a580,
0x6e63e780,
0xbf354700,
0x6e4a6f00,
0xbf09f200,
0x6e30e280,
0xbedea780,
0x6e174800,
0xbeb36700,
0x6dfd9980,
0xbe883080,
0x6de3dd00,
0xbe5d0400,
0x6dca0c80,
0xbe31e200,
0x6db02e00,
0xbe06c980,
0x6d963b80,
0xbddbbc00,
0x6d7c3b80,
0xbdb0b800,
0x6d622700,
0xbd85be80,
0x6d480580,
0xbd5acf00,
0x6d2dcf00,
0xbd2fea00,
0x6d138c00,
0xbd050f80,
0x6cf93400,
0xbcda3f00,
0x6cdecf00,
0xbcaf7900,
0x6cc45580,
0xbc84bd80,
0x6ca9cf00,
0xbc5a0c00,
0x6c8f3400,
0xbc2f6580,
0x6c748c00,
0xbc04c900,
0x6c59cf80,
0xbbda3780,
0x6c3f0600,
0xbbafb000,
0x6c242800,
0xbb853380,
0x6c093d80,
0xbb5ac100,
0x6bee3e00,
0xbb305980,
0x6bd33200,
0xbb05fc80,
0x6bb81180,
0xbadbaa00,
0x6b9ce400,
0xbab16280,
0x6b81a280,
0xba872500,
0x6b665400,
0xba5cf300,
0x6b4af100,
0xba32cb00,
0x6b2f8180,
0xba08ae80,
0x6b13fd80,
0xb9de9c00,
0x6af86d00,
0xb9b49500,
0x6adcc800,
0xb98a9880,
0x6ac11680,
0xb960a700,
0x6aa55080,
0xb936c080,
0x6a897e00,
0xb90ce480,
0x6a6d9700,
0xb8e31400,
0x6a51a400,
0xb8b94e00,
0x6a359c00,
0xb88f9380,
0x6a198880,
0xb865e380,
0x69fd5f80,
0xb83c3f00,
0x69e12b80,
0xb812a500,
0x69c4e180,
0xb7e91680,
0x69a88d00,
0xb7bf9300,
0x698c2280,
0xb7961a80,
0x696fad80,
0xb76cad80,
0x69532280,
0xb7434b80,
0x69368d00,
0xb719f480,
0x6919e180,
0xb6f0a900,
0x68fd2b80,
0xb6c76880,
0x68e05f80,
0xb69e3380,
0x68c38900,
0xb6750a00,
0x68a69d00,
0xb64beb80,
0x6889a600,
0xb622d880,
0x686c9a00,
0xb5f9d100,
0x684f8280,
0xb5d0d500,
0x68325680,
0xb5a7e400,
0x68151e80,
0xb57eff00,
0x67f7d280,
0xb5562500,
0x67da7a80,
0xb52d5700,
0x67bd0e80,
0xb5049400,
0x679f9680,
0xb4dbdd00,
0x67820a80,
0xb4b33180,
0x67647280,
0xb48a9180,
0x6746c680,
0xb461fd00,
0x67290f00,
0xb4397480,
0x670b4300,
0xb410f780,
0x66ed6b80,
0xb3e88680,
0x66cf8000,
0xb3c02080,
0x66b18880,
0xb397c700,
0x66937d80,
0xb36f7900,
0x66756680,
0xb3473700,
0x66573b80,
0xb31f0080,
0x66390500,
0xb2f6d600,
0x661aba80,
0xb2ceb780,
0x65fc6480,
0xb2a6a480,
0x65ddfa80,
0xb27e9e00,
0x65bf8500,
0xb256a300,
0x65a0fb80,
0xb22eb480,
0x65826700,
0xb206d180,
0x6563be00,
0xb1defb00,
0x65450a00,
0xb1b73000,
0x65264200,
0xb18f7180,
0x65076f00,
0xb167be80,
0x64e88780,
0xb1401880,
0x64c99580,
0xb1187d80,
0x64aa8f00,
0xb0f0f000,
0x648b7e00,
0xb0c96d80,
0x646c5880,
0xb0a1f880,
0x644d2880,
0xb07a8e00,
0x642de400,
0xb0533180,
0x640e9500,
0xb02be000,
0x63ef3180,
0xb0049c00,
0x63cfc380,
0xafdd6300,
0x63b04180,
0xafb63780,
0x6390b480,
0xaf8f1780,
0x63711400,
0xaf680480,
0x63516800,
0xaf40fd80,
0x6331a900,
0xaf1a0380,
0x6311de80,
0xaef31580,
0x62f20100,
0xaecc3480,
0x62d21800,
0xaea55f80,
0x62b21c00,
0xae7e9780,
0x62921480,
0xae57db80,
0x6271fa00,
0xae312c80,
0x6251d400,
0xae0a8a00,
0x62319b00,
0xade3f400,
0x62115700,
0xadbd6b00,
0x61f0ff80,
0xad96ee80,
0x61d09d80,
0xad707e80,
0x61b02780,
0xad4a1b80,
0x618fa780,
0xad23c500,
0x616f1380,
0xacfd7b80,
0x614e7580,
0xacd73f00,
0x612dc380,
0xacb10f00,
0x610d0780,
0xac8aec00,
0x60ec3780,
0xac64d600,
0x60cb5d80,
0xac3ecc80,
0x60aa6f80,
0xac18d080,
0x60897800,
0xabf2e080,
0x60686c00,
0xabccfe80,
0x60475680,
0xaba72880,
0x60262d00,
0xab816080,
0x6004fa00,
0xab5ba480,
0x5fe3b280,
0xab35f680,
0x5fc26200,
0xab105500,
0x5fa0fd00,
0xaaeac100,
0x5f7f8f00,
0xaac53980,
0x5f5e0c80,
0xaa9fc000,
0x5f3c8100,
0xaa7a5300,
0x5f1ae180,
0xaa54f380,
0x5ef93880,
0xaa2fa100,
0x5ed77b80,
0xaa0a5c00,
0x5eb5b580,
0xa9e52400,
0x5e93db00,
0xa9bff980,
0x5e71f800,
0xa99adc00,
0x5e500000,
0xa975cc00,
0x5e2e0000,
0xa950c980,
0x5e0beb00,
0xa92bd400,
0x5de9ce00,
0xa906ec80,
0x5dc79c00,
0xa8e21180,
0x5da56200,
0xa8bd4500,
0x5d831300,
0xa8988500,
0x5d60bc80,
0xa873d380,
0x5d3e5080,
0xa84f2e80,
0x5d1bdd00,
0xa82a9800,
0x5cf95480,
0xa8060e00,
0x5cd6c480,
0xa7e19280,
0x5cb41f00,
0xa7bd2380,
0x5c917280,
0xa798c380,
0x5c6eb080,
0xa7746f80,
0x5c4be780,
0xa7502b00,
0x5c290900,
0xa72bf200,
0x5c062380,
0xa707c900,
0x5be32880,
0xa6e3ab80,
0x5bc02680,
0xa6bf9e00,
0x5b9d0f80,
0xa69b9c00,
0x5b79f100,
0xa677aa00,
0x5b56be00,
0xa653c380,
0x5b338300,
0xa62fed00,
0x5b103400,
0xa60c2280,
0x5aecdd00,
0xa5e86780,
0x5ac97200,
0xa5c4b900,
0x5aa5ff00,
0xa5a11980,
0x5a827800,
0xa57d8700
};

I32 post_twid_table_512[514]={
0x7fffffff,
0x00000000,
0x7fffd880,
0xff9b781d,
0x7fff6200,
0xff36f078,
0x7ffe9c80,
0xfed26950,
0x7ffd8880,
0xfe6de2e0,
0x7ffc2500,
0xfe095d6a,
0x7ffa7300,
0xfda4d928,
0x7ff87180,
0xfd40565c,
0x7ff62180,
0xfcdbd540,
0x7ff38280,
0xfc775618,
0x7ff09480,
0xfc12d918,
0x7fed5780,
0xfbae5e88,
0x7fe9cc00,
0xfb49e6a0,
0x7fe5f100,
0xfae571a0,
0x7fe1c780,
0xfa80ffc8,
0x7fdd4f00,
0xfa1c9150,
0x7fd88780,
0xf9b82680,
0x7fd37180,
0xf953bf88,
0x7fce0c00,
0xf8ef5cb8,
0x7fc85880,
0xf88afe38,
0x7fc25580,
0xf826a460,
0x7fbc0400,
0xf7c24f50,
0x7fb56380,
0xf75dff60,
0x7fae7480,
0xf6f9b4c0,
0x7fa73680,
0xf6956fb0,
0x7f9faa00,
0xf6313070,
0x7f97ce80,
0xf5ccf740,
0x7f8fa480,
0xf568c450,
0x7f872b80,
0xf50497f0,
0x7f7e6480,
0xf4a07250,
0x7f754e00,
0xf43c53c0,
0x7f6bea00,
0xf3d83c60,
0x7f623600,
0xf3742c90,
0x7f583500,
0xf3102470,
0x7f4de400,
0xf2ac2460,
0x7f434580,
0xf2482c70,
0x7f385780,
0xf1e43d10,
0x7f2d1c00,
0xf1805650,
0x7f219100,
0xf11c7890,
0x7f15b900,
0xf0b8a3f0,
0x7f099100,
0xf054d8d0,
0x7efd1c80,
0xeff11740,
0x7ef05780,
0xef8d5fc0,
0x7ee34680,
0xef29b240,
0x7ed5e500,
0xeec60f40,
0x7ec83780,
0xee6276c0,
0x7eba3980,
0xedfee940,
0x7eabef80,
0xed9b66c0,
0x7e9d5580,
0xed37efa0,
0x7e8e6f00,
0xecd48420,
0x7e7f3900,
0xec712460,
0x7e6fb680,
0xec0dd0c0,
0x7e5fe400,
0xebaa8960,
0x7e4fc600,
0xeb474ea0,
0x7e3f5780,
0xeae42080,
0x7e2e9d80,
0xea80ffa0,
0x7e1d9380,
0xea1debc0,
0x7e0c3e00,
0xe9bae5a0,
0x7dfa9800,
0xe957ed00,
0x7de8a780,
0xe8f502a0,
0x7dd66600,
0xe8922620,
0x7dc3da00,
0xe82f5880,
0x7db0fd80,
0xe7cc9920,
0x7d9dd680,
0xe769e920,
0x7d8a5f00,
0xe70747c0,
0x7d769d00,
0xe6a4b660,
0x7d628a80,
0xe6423400,
0x7d4e2e00,
0xe5dfc220,
0x7d398080,
0xe57d5fc0,
0x7d248980,
0xe51b0e60,
0x7d0f4180,
0xe4b8cd00,
0x7cf9b080,
0xe4569d00,
0x7ce3ce00,
0xe3f47d80,
0x7ccda300,
0xe3926fe0,
0x7cb72680,
0xe3307340,
0x7ca06180,
0xe2ce88e0,
0x7c894b00,
0xe26cb000,
0x7c71ec80,
0xe20ae9e0,
0x7c5a3c80,
0xe1a935c0,
0x7c424480,
0xe14794e0,
0x7c29fb00,
0xe0e60660,
0x7c116a00,
0xe0848ba0,
0x7bf88780,
0xe02323c0,
0x7bdf5d80,
0xdfc1d000,
0x7bc5e200,
0xdf608fc0,
0x7bac1f00,
0xdeff6400,
0x7b920b00,
0xde9e4c40,
0x7b77af80,
0xde3d4980,
0x7b5d0300,
0xdddc5b00,
0x7b420f80,
0xdd7b8240,
0x7b26ca80,
0xdd1abe00,
0x7b0b3f00,
0xdcba1040,
0x7aef6280,
0xdc597740,
0x7ad33f00,
0xdbf8f540,
0x7ab6cb00,
0xdb988880,
0x7a9a1000,
0xdb383300,
0x7a7d0480,
0xdad7f380,
0x7a5fb280,
0xda77cb80,
0x7a421000,
0xda17ba40,
0x7a242700,
0xd9b7c0c0,
0x7a05ee00,
0xd957de80,
0x79e76e00,
0xd8f81480,
0x79c89f00,
0xd8986200,
0x79a98880,
0xd838c880,
0x798a2380,
0xd7d946c0,
0x796a7680,
0xd779de80,
0x794a7c00,
0xd71a8e80,
0x792a3900,
0xd6bb5880,
0x7909a900,
0xd65c3b40,
0x78e8d080,
0xd5fd3880,
0x78c7ab80,
0xd59e4ec0,
0x78a63e00,
0xd53f8000,
0x78848400,
0xd4e0cac0,
0x78628180,
0xd4823100,
0x78403300,
0xd423b140,
0x781d9c00,
0xd3c54d40,
0x77fab980,
0xd3670400,
0x77d78e80,
0xd308d6c0,
0x77b41800,
0xd2aac4c0,
0x77905900,
0xd24ccf40,
0x776c4f00,
0xd1eef540,
0x7747fc80,
0xd1913880,
0x77235f80,
0xd1339780,
0x76fe7980,
0xd0d61440,
0x76d94a00,
0xd078ad40,
0x76b3d100,
0xd01b6480,
0x768e0f00,
0xcfbe3840,
0x76680400,
0xcf612ac0,
0x7641af80,
0xcf043a40,
0x761b1280,
0xcea76900,
0x75f42c80,
0xce4ab540,
0x75ccfd80,
0xcdee2100,
0x75a58680,
0xcd91aac0,
0x757dc600,
0xcd355480,
0x7555be00,
0xccd91cc0,
0x752d6c80,
0xcc7d0580,
0x7504d400,
0xcc210d00,
0x74dbf200,
0xcbc53580,
0x74b2c900,
0xcb697d40,
0x74895700,
0xcb0de640,
0x745f9e80,
0xcab26f40,
0x74359c80,
0xca5719c0,
0x740b5480,
0xc9fbe4c0,
0x73e0c380,
0xc9a0d1c0,
0x73b5ec80,
0xc945df80,
0x738acc80,
0xc8eb0fc0,
0x735f6700,
0xc8906140,
0x7333b880,
0xc835d5c0,
0x7307c480,
0xc7db6bc0,
0x72db8800,
0xc7812580,
0x72af0680,
0xc72700c0,
0x72823c00,
0xc6cd0080,
0x72552d80,
0xc6732240,
0x7227d580,
0xc61968c0,
0x71fa3a80,
0xc5bfd1c0,
0x71cc5580,
0xc5665fc0,
0x719e2e00,
0xc50d10c0,
0x716fbd00,
0xc4b3e740,
0x71410900,
0xc45ae140,
0x71120c80,
0xc4020140,
0x70e2cd00,
0xc3a94500,
0x70b34500,
0xc350af40,
0x70837a00,
0xc2f83d80,
0x70536780,
0xc29ff300,
0x70231180,
0xc247ccc0,
0x6ff27480,
0xc1efce00,
0x6fc19480,
0xc197f440,
0x6f906d80,
0xc1404240,
0x6f5f0380,
0xc0e8b5c0,
0x6f2d5300,
0xc0915140,
0x6efb6000,
0xc03a1300,
0x6ec92680,
0xbfe2fd00,
0x6e96aa80,
0xbf8c0d80,
0x6e63e880,
0xbf354700,
0x6e30e400,
0xbedea700,
0x6dfd9a00,
0xbe883080,
0x6dca0e00,
0xbe31e100,
0x6d963c00,
0xbddbbb80,
0x6d622900,
0xbd85bd80,
0x6d2dd000,
0xbd2fea00,
0x6cf93600,
0xbcda3e00,
0x6cc45680,
0xbc84bd00,
0x6c8f3600,
0xbc2f6480,
0x6c59d080,
0xbbda3680,
0x6c242a80,
0xbb853200,
0x6bee3f00,
0xbb305880,
0x6bb81400,
0xbadba880,
0x6b81a380,
0xba872400,
0x6b4af380,
0xba32c980,
0x6b13fe80,
0xb9de9b00,
0x6adcca80,
0xb98a9700,
0x6aa55180,
0xb936bf00,
0x6a6d9980,
0xb8e31280,
0x6a359d80,
0xb88f9200,
0x69fd6200,
0xb83c3d00,
0x69c4e300,
0xb7e91500,
0x698c2500,
0xb7961900,
0x69532400,
0xb7434a00,
0x6919e380,
0xb6f0a780,
0x68e06100,
0xb69e3280,
0x68a69f00,
0xb64bea00,
0x686c9b00,
0xb5f9d000,
0x68325800,
0xb5a7e280,
0x67f7d380,
0xb5562400,
0x67bd1000,
0xb5049280,
0x67820b80,
0xb4b33080,
0x6746c800,
0xb461fb80,
0x670b4400,
0xb410f680,
0x66cf8180,
0xb3c01f00,
0x66937e80,
0xb36f7800,
0x66573d00,
0xb31efe80,
0x661abb80,
0xb2ceb680,
0x65ddfc00,
0xb27e9c00,
0x65a0fd00,
0xb22eb380,
0x6563bf80,
0xb1def880,
0x65264380,
0xb18f7080,
0x64e88900,
0xb1401600,
0x64aa9080,
0xb0f0ef00,
0x646c5980,
0xb0a1f600,
0x642de500,
0xb0533080,
0x63ef3280,
0xb0049980,
0x63b04280,
0xafb63680,
0x63711480,
0xaf680280,
0x6331aa00,
0xaf1a0280,
0x62f20180,
0xaecc3280,
0x62b21c80,
0xae7e9680,
0x6271fa00,
0xae312a80,
0x62319b80,
0xade3f380,
0x61f10000,
0xad96ec80,
0x61b02880,
0xad4a1b00,
0x616f1400,
0xacfd7a00,
0x612dc480,
0xacb10e80,
0x60ec3800,
0xac64d400,
0x60aa7080,
0xac18cf80,
0x60686c80,
0xabccfc80,
0x60262e00,
0xab815f80,
0x5fe3b300,
0xab35f480,
0x5fa0fe80,
0xaaeac000,
0x5f5e0d00,
0xaa9fbe00,
0x5f1ae300,
0xaa54f280,
0x5ed77c00,
0xaa0a5a00,
0x5e93dc80,
0xa9bff880,
0x5e500100,
0xa975ca00,
0x5e0bed00,
0xa92bd300,
0x5dc79d00,
0xa8e20f80,
0x5d831580,
0xa8988400,
0x5d3e5180,
0xa84f2c00,
0x5cf95700,
0xa8060c80,
0x5cb42000,
0xa7bd2100,
0x5c6eb300,
0xa7746e00,
0x5c290a00,
0xa72bf000,
0x5be32b00,
0xa6e3aa00,
0x5b9d1080,
0xa69b9a00,
0x5b56c080,
0xa653c200,
0x5b103500,
0xa60c2080,
0x5ac97480,
0xa5c4b780,
0x5a827900,
0xa57d8500
};

I32 post_twid_table_256[258]={
0x7fffffff,
0x00000000,
0x7fff6200,
0xff36f078,
0x7ffd8880,
0xfe6de2e0,
0x7ffa7280,
0xfda4d928,
0x7ff62180,
0xfcdbd540,
0x7ff09400,
0xfc12d918,
0x7fe9cb80,
0xfb49e6a0,
0x7fe1c700,
0xfa80ffc8,
0x7fd88780,
0xf9b82680,
0x7fce0c00,
0xf8ef5cb8,
0x7fc25580,
0xf826a460,
0x7fb56380,
0xf75dff60,
0x7fa73680,
0xf6956fb0,
0x7f97ce80,
0xf5ccf740,
0x7f872b80,
0xf50497f0,
0x7f754e80,
0xf43c53d0,
0x7f623600,
0xf3742c90,
0x7f4de480,
0xf2ac2470,
0x7f385780,
0xf1e43d10,
0x7f219200,
0xf11c78a0,
0x7f099180,
0xf054d8c0,
0x7ef05880,
0xef8d5fc0,
0x7ed5e580,
0xeec60f20,
0x7eba3a80,
0xedfee940,
0x7e9d5580,
0xed37ef80,
0x7e7f3980,
0xec712460,
0x7e5fe400,
0xebaa8940,
0x7e3f5800,
0xeae42080,
0x7e1d9380,
0xea1deba0,
0x7dfa9880,
0xe957ed00,
0x7dd66600,
0xe8922600,
0x7db0fe00,
0xe7cc9920,
0x7d8a5e80,
0xe70747a0,
0x7d628b00,
0xe6423420,
0x7d398000,
0xe57d5fc0,
0x7d0f4280,
0xe4b8cd20,
0x7ce3ce00,
0xe3f47d80,
0x7cb72780,
0xe3307360,
0x7c894b00,
0xe26cb000,
0x7c5a3d80,
0xe1a93600,
0x7c29fb00,
0xe0e60660,
0x7bf88880,
0xe0232400,
0x7bc5e180,
0xdf608fc0,
0x7b920c00,
0xde9e4c80,
0x7b5d0280,
0xdddc5b00,
0x7b26cc00,
0xdd1abe80,
0x7aef6200,
0xdc597740,
0x7ab6cc80,
0xdb9888c0,
0x7a7d0400,
0xdad7f340,
0x7a421180,
0xda17ba80,
0x7a05ed80,
0xd957de00,
0x79c8a000,
0xd8986240,
0x798a2280,
0xd7d94640,
0x794a7c80,
0xd71a8f00,
0x7909a800,
0xd65c3b00,
0x78c7ac00,
0xd59e4f40,
0x78848300,
0xd4e0ca80,
0x78403380,
0xd423b1c0,
0x77fab880,
0xd36703c0,
0x77b41800,
0xd2aac540,
0x776c4e00,
0xd1eef500,
0x77235f80,
0xd1339800,
0x76d94880,
0xd078ad00,
0x768e0f00,
0xcfbe38c0,
0x7641ae00,
0xcf043a00,
0x75f42c80,
0xce4ab5c0,
0x75a58480,
0xcd91aa80,
0x7555bd80,
0xccd91d40,
0x7504d200,
0xcc210cc0,
0x74b2c880,
0xcb697dc0,
0x745f9c80,
0xcab26f00,
0x740b5400,
0xc9fbe540,
0x73b5ea80,
0xc945df40,
0x735f6600,
0xc89061c0,
0x7307c280,
0xc7db6bc0,
0x72af0580,
0xc7270180,
0x72552b00,
0xc6732240,
0x71fa3900,
0xc5bfd240,
0x719e2b80,
0xc50d10c0,
0x71410780,
0xc45ae200,
0x70e2ca80,
0xc3a94500,
0x70837880,
0xc2f83e40,
0x70230f80,
0xc247ccc0,
0x6fc19300,
0xc197f500,
0x6f5f0180,
0xc0e8b5c0,
0x6efb5e80,
0xc03a1380,
0x6e96a880,
0xbf8c0d80,
0x6e30e280,
0xbedea780,
0x6dca0c00,
0xbe31e100,
0x6d622700,
0xbd85be80,
0x6cf93400,
0xbcda3e00,
0x6c8f3400,
0xbc2f6580,
0x6c242880,
0xbb853200,
0x6bb81180,
0xbadba980,
0x6b4af180,
0xba32ca00,
0x6adcc800,
0xb98a9800,
0x6a6d9780,
0xb8e31280,
0x69fd6000,
0xb83c3e00,
0x698c2380,
0xb7961900,
0x6919e200,
0xb6f0a880,
0x68a69d80,
0xb64bea00,
0x68325680,
0xb5a7e400,
0x67bd0e80,
0xb5049280,
0x6746c680,
0xb461fd00,
0x66cf8000,
0xb3c01f00,
0x66573b80,
0xb31f0080,
0x65ddfa80,
0xb27e9c00,
0x6563be80,
0xb1defa80,
0x64e88800,
0xb1401600,
0x646c5880,
0xb0a1f780,
0x63ef3180,
0xb0049980,
0x63711380,
0xaf680400,
0x62f20080,
0xaecc3200,
0x6271f900,
0xae312c00,
0x61f0ff00,
0xad96ec00,
0x616f1300,
0xacfd7b80,
0x60ec3700,
0xac64d380,
0x60686b80,
0xabccfe00,
0x5fe3b280,
0xab35f400,
0x5f5e0c80,
0xaa9fbf80,
0x5ed77b80,
0xaa0a5980,
0x5e500000,
0xa975cb80,
0x5dc79c80,
0xa8e20f80,
0x5d3e5100,
0xa84f2e00,
0x5cb42000,
0xa7bd2100,
0x5c290980,
0xa72bf200,
0x5b9d1080,
0xa69b9a00,
0x5b103480,
0xa60c2280,
0x5a827900,
0xa57d8500
};

I32 post_twid_table_128[130]={
0x7fffffff,
0x00000000,
0x7ffd8880,
0xfe6de2e0,
0x7ff62180,
0xfcdbd540,
0x7fe9cc00,
0xfb49e6a0,
0x7fd88780,
0xf9b82680,
0x7fc25600,
0xf826a460,
0x7fa73680,
0xf6956fb0,
0x7f872c80,
0xf5049800,
0x7f623680,
0xf3742c90,
0x7f385880,
0xf1e43d20,
0x7f099180,
0xf054d8c0,
0x7ed5e680,
0xeec60f40,
0x7e9d5580,
0xed37ef80,
0x7e5fe580,
0xebaa8960,
0x7e1d9380,
0xea1deba0,
0x7dd66780,
0xe8922640,
0x7d8a5f00,
0xe70747a0,
0x7d398200,
0xe57d6000,
0x7ce3ce80,
0xe3f47d60,
0x7c894d00,
0xe26cb040,
0x7c29fb80,
0xe0e60640,
0x7bc5e380,
0xdf609000,
0x7b5d0300,
0xdddc5b00,
0x7aef6400,
0xdc5977c0,
0x7a7d0480,
0xdad7f380,
0x7a05ef80,
0xd957dec0,
0x798a2300,
0xd7d946c0,
0x7909aa00,
0xd65c3bc0,
0x78848380,
0xd4e0cb00,
0x77faba80,
0xd3670480,
0x776c4e80,
0xd1eef580,
0x76d94a80,
0xd078adc0,
0x7641af00,
0xcf043a80,
0x75a58700,
0xcd91ab40,
0x7504d300,
0xcc210d40,
0x745f9f00,
0xcab26fc0,
0x73b5eb80,
0xc945dfc0,
0x7307c500,
0xc7db6c80,
0x72552c00,
0xc6732280,
0x719e2e00,
0xc50d1180,
0x70e2cb80,
0xc3a94540,
0x70231200,
0xc247cd80,
0x6f5f0280,
0xc0e8b600,
0x6e96ab00,
0xbf8c0e00,
0x6dca0d00,
0xbe31e180,
0x6cf93680,
0xbcda3f00,
0x6c242980,
0xbb853280,
0x6b4af400,
0xba32ca80,
0x6a6d9900,
0xb8e31300,
0x698c2600,
0xb7961980,
0x68a69f00,
0xb64bea80,
0x67bd1180,
0xb5049380,
0x66cf8180,
0xb3c01f80,
0x65ddfd80,
0xb27e9d80,
0x64e88980,
0xb1401700,
0x63ef3400,
0xb0049b00,
0x62f20200,
0xaecc3300,
0x61f10180,
0xad96ee00,
0x60ec3880,
0xac64d480,
0x5fe3b500,
0xab35f600,
0x5ed77d00,
0xaa0a5a80,
0x5dc79f00,
0xa8e21180,
0x5cb42180,
0xa7bd2200,
0x5b9d1300,
0xa69b9c00,
0x5a827a00,
0xa57d8580
};

 I32 post_twid_table_64[68]={
0x7fffffff,
0x00000000,
0x7ff62180,
0xfcdbd540,
0x7fd88780,
0xf9b82680,
0x7fa73680,
0xf6956fb0,
0x7f623680,
0xf3742ca0,
0x7f099180,
0xf054d8d0,
0x7e9d5600,
0xed37efa0,
0x7e1d9380,
0xea1debc0,
0x7d8a5f80,
0xe70747e0,
0x7ce3ce80,
0xe3f47da0,
0x7c29fc00,
0xe0e606a0,
0x7b5d0380,
0xdddc5b40,
0x7a7d0580,
0xdad7f3c0,
0x798a2380,
0xd7d946c0,
0x78848400,
0xd4e0cb40,
0x776c4e80,
0xd1eef580,
0x7641af00,
0xcf043b00,
0x7504d300,
0xcc210d40,
0x73b5eb80,
0xc945e040,
0x72552c80,
0xc6732280,
0x70e2cb80,
0xc3a94600,
0x6f5f0280,
0xc0e8b600,
0x6dca0d00,
0xbe31e200,
0x6c242900,
0xbb853280,
0x6a6d9880,
0xb8e31380,
0x68a69e00,
0xb64bea80,
0x66cf8100,
0xb3c02080,
0x64e88880,
0xb1401700,
0x62f20180,
0xaecc3400,
0x60ec3780,
0xac64d480,
0x5ed77c80,
0xaa0a5c00,
0x5cb42000,
0xa7bd2200,
0x5a827980,
0xa57d8780
};

unsigned short gSinflt_rise_msa[3968] = {
0x0192, 
0x04b6, 
0x07da, 
0x0afe, 
0x0e21, 
0x1144, 
0x1466, 
0x1787, 
0x1aa7, 
0x1dc7, 
0x20e5, 
0x2402, 
0x271d, 
0x2a37, 
0x2d50, 
0x3066, 
0x337b, 
0x368e, 
0x399f, 
0x3cad, 
0x3fb9, 
0x42c3, 
0x45ca, 
0x48ce, 
0x4bd0, 
0x4ecf, 
0x51ca, 
0x54c3, 
0x57b8, 
0x5aaa, 
0x5d98, 
0x6083, 
0x636a, 
0x664d, 
0x692d, 
0x6c08, 
0x6edf, 
0x71b1, 
0x7480, 
0x774a, 
0x7a0f, 
0x7cd0, 
0x7f8b, 
0x8242, 
0x84f4, 
0x87a1, 
0x8a48, 
0x8cea, 
0x8f87, 
0x921e, 
0x94b0, 
0x973c, 
0x99c1, 
0x9c42, 
0x9ebc, 
0xa12f, 
0xa39d, 
0xa605, 
0xa866, 
0xaac0, 
0xad14, 
0xaf61, 
0xb1a8, 
0xb3e7, 
0xb620, 
0xb852, 
0xba7c, 
0xbca0, 
0xbebc, 
0xc0d0, 
0xc2de, 
0xc4e3, 
0xc6e2, 
0xc8d8, 
0xcac7, 
0xccae, 
0xce8d, 
0xd064, 
0xd233, 
0xd3fa, 
0xd5b9, 
0xd770, 
0xd91e, 
0xdac4, 
0xdc61, 
0xddf6, 
0xdf83, 
0xe106, 
0xe282, 
0xe3f4, 
0xe55e, 
0xe6be, 
0xe816, 
0xe965, 
0xeaab, 
0xebe8, 
0xed1c, 
0xee46, 
0xef68, 
0xf080, 
0xf18f, 
0xf294, 
0xf391, 
0xf484, 
0xf56d, 
0xf64d, 
0xf724, 
0xf7f1, 
0xf8b4, 
0xf96e, 
0xfa1e, 
0xfac5, 
0xfb61, 
0xfbf5, 
0xfc7e, 
0xfcfe, 
0xfd74, 
0xfde0, 
0xfe43, 
0xfe9b, 
0xfeea, 
0xff2f, 
0xff6a, 
0xff9c, 
0xffc3, 
0xffe1, 
0xfff4, 
0xfffe,
0x00c9, 
0x025b, 
0x03ed, 
0x057f, 
0x0711, 
0x08a3, 
0x0a35, 
0x0bc6, 
0x0d58, 
0x0eea, 
0x107b, 
0x120c, 
0x139d, 
0x152e, 
0x16bf, 
0x184f, 
0x19df, 
0x1b6f, 
0x1cff, 
0x1e8e, 
0x201d, 
0x21ac, 
0x233b, 
0x24c9, 
0x2656, 
0x27e4, 
0x2971, 
0x2afe, 
0x2c8a, 
0x2e15, 
0x2fa1, 
0x312c, 
0x32b6, 
0x3440, 
0x35c9, 
0x3752, 
0x38db, 
0x3a62, 
0x3bea, 
0x3d70, 
0x3ef6, 
0x407c, 
0x4201, 
0x4385, 
0x4508, 
0x468b, 
0x480e, 
0x498f, 
0x4b10, 
0x4c90, 
0x4e0f, 
0x4f8e, 
0x510c, 
0x5289, 
0x5405, 
0x5581, 
0x56fb, 
0x5875, 
0x59ee, 
0x5b66, 
0x5cdd, 
0x5e53, 
0x5fc9, 
0x613d, 
0x62b1, 
0x6423, 
0x6595, 
0x6705, 
0x6875, 
0x69e4, 
0x6b51, 
0x6cbe, 
0x6e29, 
0x6f94, 
0x70fd, 
0x7265, 
0x73cd, 
0x7533, 
0x7698, 
0x77fb, 
0x795e, 
0x7ac0, 
0x7c20, 
0x7d7f, 
0x7edd, 
0x803a, 
0x8195, 
0x82ef, 
0x8448, 
0x85a0, 
0x86f6, 
0x884b, 
0x899f, 
0x8af1, 
0x8c42, 
0x8d92, 
0x8ee0, 
0x902d, 
0x9179, 
0x92c3, 
0x940c, 
0x9553, 
0x9699, 
0x97de, 
0x9921, 
0x9a62, 
0x9ba2, 
0x9ce1, 
0x9e1e, 
0x9f59, 
0xa093, 
0xa1cb, 
0xa302, 
0xa438, 
0xa56b, 
0xa69d, 
0xa7ce, 
0xa8fd, 
0xaa2a, 
0xab56, 
0xac80, 
0xada8, 
0xaece, 
0xaff3, 
0xb117, 
0xb238, 
0xb358, 
0xb476, 
0xb592, 
0xb6ad, 
0xb7c6, 
0xb8dd, 
0xb9f2, 
0xbb06, 
0xbc17, 
0xbd27, 
0xbe35, 
0xbf41, 
0xc04c, 
0xc154, 
0xc25b, 
0xc360, 
0xc463, 
0xc564, 
0xc663, 
0xc760, 
0xc85b, 
0xc955, 
0xca4c, 
0xcb41, 
0xcc35, 
0xcd26, 
0xce16, 
0xcf04, 
0xcfef, 
0xd0d9, 
0xd1c0, 
0xd2a6, 
0xd389, 
0xd46b, 
0xd54a, 
0xd627, 
0xd703, 
0xd7dc, 
0xd8b3, 
0xd988, 
0xda5b, 
0xdb2c, 
0xdbfb, 
0xdcc7, 
0xdd92, 
0xde5a, 
0xdf20, 
0xdfe4, 
0xe0a6, 
0xe166, 
0xe224, 
0xe2df, 
0xe398, 
0xe44f, 
0xe504, 
0xe5b7, 
0xe667, 
0xe715, 
0xe7c1, 
0xe86b, 
0xe912, 
0xe9b7, 
0xea5a, 
0xeafb, 
0xeb99, 
0xec36, 
0xecd0, 
0xed67, 
0xedfc, 
0xee8f, 
0xef20, 
0xefaf, 
0xf03b, 
0xf0c5, 
0xf14c, 
0xf1d1, 
0xf254, 
0xf2d4, 
0xf353, 
0xf3ce, 
0xf448, 
0xf4bf, 
0xf534, 
0xf5a6, 
0xf616, 
0xf684, 
0xf6ef, 
0xf758, 
0xf7be, 
0xf822, 
0xf884, 
0xf8e3, 
0xf940, 
0xf99b, 
0xf9f3, 
0xfa49, 
0xfa9c, 
0xfaed, 
0xfb3b, 
0xfb87, 
0xfbd1, 
0xfc18, 
0xfc5d, 
0xfc9f, 
0xfcdf, 
0xfd1c, 
0xfd57, 
0xfd90, 
0xfdc6, 
0xfdfa, 
0xfe2b, 
0xfe5a, 
0xfe86, 
0xfeb0, 
0xfed7, 
0xfefc, 
0xff1f, 
0xff3f, 
0xff5c, 
0xff78, 
0xff90, 
0xffa6, 
0xffba, 
0xffcb, 
0xffda, 
0xffe7, 
0xfff0, 
0xfff8, 
0xfffd, 
0xffff,
0x0064, 
0x012d, 
0x01f6, 
0x02bf, 
0x0388, 
0x0451, 
0x051a, 
0x05e3, 
0x06ac, 
0x0775, 
0x083e, 
0x0907, 
0x09d0, 
0x0a99, 
0x0b62, 
0x0c2b, 
0x0cf4, 
0x0dbc, 
0x0e85, 
0x0f4e, 
0x1017, 
0x10df, 
0x11a8, 
0x1270, 
0x1339, 
0x1401, 
0x14ca, 
0x1592, 
0x165a, 
0x1723, 
0x17eb, 
0x18b3, 
0x197b, 
0x1a43, 
0x1b0b, 
0x1bd3, 
0x1c9b, 
0x1d63, 
0x1e2a, 
0x1ef2, 
0x1fba, 
0x2081, 
0x2148, 
0x2210, 
0x22d7, 
0x239e, 
0x2465, 
0x252c, 
0x25f3, 
0x26ba, 
0x2781, 
0x2847, 
0x290e, 
0x29d4, 
0x2a9a, 
0x2b61, 
0x2c27, 
0x2ced, 
0x2db3, 
0x2e78, 
0x2f3e, 
0x3004, 
0x30c9, 
0x318e, 
0x3254, 
0x3319, 
0x33de, 
0x34a2, 
0x3567, 
0x362c, 
0x36f0, 
0x37b4, 
0x3879, 
0x393d, 
0x3a01, 
0x3ac4, 
0x3b88, 
0x3c4b, 
0x3d0f, 
0x3dd2, 
0x3e95, 
0x3f58, 
0x401b, 
0x40dd, 
0x41a0, 
0x4262, 
0x4324, 
0x43e6, 
0x44a8, 
0x4569, 
0x462b, 
0x46ec, 
0x47ad, 
0x486e, 
0x492f, 
0x49ef, 
0x4ab0, 
0x4b70, 
0x4c30, 
0x4cf0, 
0x4db0, 
0x4e6f, 
0x4f2e, 
0x4fed, 
0x50ac, 
0x516b, 
0x522a, 
0x52e8, 
0x53a6, 
0x5464, 
0x5522, 
0x55df, 
0x569d, 
0x575a, 
0x5817, 
0x58d3, 
0x5990, 
0x5a4c, 
0x5b08, 
0x5bc4, 
0x5c7f, 
0x5d3b, 
0x5df6, 
0x5eb1, 
0x5f6b, 
0x6026, 
0x60e0, 
0x619a, 
0x6254, 
0x630d, 
0x63c7, 
0x6480, 
0x6539, 
0x65f1, 
0x66a9, 
0x6761, 
0x6819, 
0x68d1, 
0x6988, 
0x6a3f, 
0x6af6, 
0x6bad, 
0x6c63, 
0x6d19, 
0x6dcf, 
0x6e84, 
0x6f39, 
0x6fee, 
0x70a3, 
0x7157, 
0x720c, 
0x72bf, 
0x7373, 
0x7426, 
0x74d9, 
0x758c, 
0x763f, 
0x76f1, 
0x77a3, 
0x7854, 
0x7906, 
0x79b7, 
0x7a67, 
0x7b18, 
0x7bc8, 
0x7c78, 
0x7d27, 
0x7dd7, 
0x7e86, 
0x7f34, 
0x7fe2, 
0x8090, 
0x813e, 
0x81ec, 
0x8299, 
0x8345, 
0x83f2, 
0x849e, 
0x854a, 
0x85f5, 
0x86a1, 
0x874b, 
0x87f6, 
0x88a0, 
0x894a, 
0x89f4, 
0x8a9d, 
0x8b46, 
0x8bee, 
0x8c96, 
0x8d3e, 
0x8de6, 
0x8e8d, 
0x8f34, 
0x8fda, 
0x9080, 
0x9126, 
0x91cc, 
0x9271, 
0x9315, 
0x93ba, 
0x945e, 
0x9502, 
0x95a5, 
0x9648, 
0x96ea, 
0x978d, 
0x982e, 
0x98d0, 
0x9971, 
0x9a12, 
0x9ab2, 
0x9b52, 
0x9bf2, 
0x9c91, 
0x9d30, 
0x9dcf, 
0x9e6d, 
0x9f0a, 
0x9fa8, 
0xa045, 
0xa0e1, 
0xa17e, 
0xa219, 
0xa2b5, 
0xa350, 
0xa3ea, 
0xa485, 
0xa51f, 
0xa5b8, 
0xa651, 
0xa6ea, 
0xa782, 
0xa81a, 
0xa8b1, 
0xa948, 
0xa9df, 
0xaa75, 
0xab0b, 
0xaba0, 
0xac35, 
0xacca, 
0xad5e, 
0xadf2, 
0xae85, 
0xaf18, 
0xafaa, 
0xb03c, 
0xb0ce, 
0xb15f, 
0xb1f0, 
0xb280, 
0xb310, 
0xb3a0, 
0xb42f, 
0xb4bd, 
0xb54b, 
0xb5d9, 
0xb667, 
0xb6f3, 
0xb780, 
0xb80c, 
0xb897, 
0xb922, 
0xb9ad, 
0xba37, 
0xbac1, 
0xbb4a, 
0xbbd3, 
0xbc5b, 
0xbce3, 
0xbd6b, 
0xbdf2, 
0xbe79, 
0xbeff, 
0xbf84, 
0xc009, 
0xc08e, 
0xc112, 
0xc196, 
0xc21a, 
0xc29c, 
0xc31f, 
0xc3a1, 
0xc422, 
0xc4a3, 
0xc524, 
0xc5a4, 
0xc623, 
0xc6a2, 
0xc721, 
0xc79f, 
0xc81d, 
0xc89a, 
0xc916, 
0xc993, 
0xca0e, 
0xca8a, 
0xcb04, 
0xcb7f, 
0xcbf8, 
0xcc72, 
0xccea, 
0xcd63, 
0xcdda, 
0xce52, 
0xcec8, 
0xcf3f, 
0xcfb4, 
0xd02a, 
0xd09f, 
0xd113, 
0xd187, 
0xd1fa, 
0xd26d, 
0xd2df, 
0xd351, 
0xd3c2, 
0xd433, 
0xd4a3, 
0xd512, 
0xd582, 
0xd5f0, 
0xd65f, 
0xd6cc, 
0xd739, 
0xd7a6, 
0xd812, 
0xd87e, 
0xd8e9, 
0xd953, 
0xd9bd, 
0xda27, 
0xda90, 
0xdaf8, 
0xdb60, 
0xdbc7, 
0xdc2e, 
0xdc94, 
0xdcfa, 
0xdd5f, 
0xddc4, 
0xde28, 
0xde8c, 
0xdeef, 
0xdf52, 
0xdfb4, 
0xe015, 
0xe076, 
0xe0d6, 
0xe136, 
0xe196, 
0xe1f4, 
0xe253, 
0xe2b0, 
0xe30d, 
0xe36a, 
0xe3c6, 
0xe422, 
0xe47d, 
0xe4d7, 
0xe531, 
0xe58a, 
0xe5e3, 
0xe63b, 
0xe693, 
0xe6ea, 
0xe740, 
0xe796, 
0xe7ec, 
0xe841, 
0xe895, 
0xe8e9, 
0xe93c, 
0xe98e, 
0xe9e0, 
0xea32, 
0xea83, 
0xead3, 
0xeb23, 
0xeb72, 
0xebc1, 
0xec0f, 
0xec5c, 
0xeca9, 
0xecf6, 
0xed41, 
0xed8d, 
0xedd7, 
0xee21, 
0xee6b, 
0xeeb4, 
0xeefc, 
0xef44, 
0xef8b, 
0xefd2, 
0xf018, 
0xf05d, 
0xf0a2, 
0xf0e7, 
0xf12a, 
0xf16d, 
0xf1b0, 
0xf1f2, 
0xf233, 
0xf274, 
0xf2b5, 
0xf2f4, 
0xf333, 
0xf372, 
0xf3b0, 
0xf3ed, 
0xf42a, 
0xf466, 
0xf4a1, 
0xf4dc, 
0xf517, 
0xf550, 
0xf58a, 
0xf5c2, 
0xf5fa, 
0xf632, 
0xf668, 
0xf69f, 
0xf6d4, 
0xf709, 
0xf73e, 
0xf772, 
0xf7a5, 
0xf7d7, 
0xf80a, 
0xf83b, 
0xf86c, 
0xf89c, 
0xf8cc, 
0xf8fb, 
0xf929, 
0xf957, 
0xf984, 
0xf9b1, 
0xf9dd, 
0xfa09, 
0xfa33, 
0xfa5e, 
0xfa87, 
0xfab0, 
0xfad9, 
0xfb01, 
0xfb28, 
0xfb4e, 
0xfb74, 
0xfb9a, 
0xfbbf, 
0xfbe3, 
0xfc06, 
0xfc29, 
0xfc4c, 
0xfc6e, 
0xfc8f, 
0xfcaf, 
0xfccf, 
0xfcef, 
0xfd0d, 
0xfd2b, 
0xfd49, 
0xfd66, 
0xfd82, 
0xfd9e, 
0xfdb9, 
0xfdd3, 
0xfded, 
0xfe06, 
0xfe1f, 
0xfe37, 
0xfe4e, 
0xfe65, 
0xfe7b, 
0xfe91, 
0xfea6, 
0xfeba, 
0xfece, 
0xfee1, 
0xfef3, 
0xff05, 
0xff16, 
0xff27, 
0xff37, 
0xff46, 
0xff55, 
0xff63, 
0xff71, 
0xff7e, 
0xff8a, 
0xff96, 
0xffa1, 
0xffac, 
0xffb5, 
0xffbf, 
0xffc7, 
0xffcf, 
0xffd7, 
0xffdd, 
0xffe4, 
0xffe9, 
0xffee, 
0xfff2, 
0xfff6, 
0xfff9, 
0xfffc, 
0xfffe, 
0xffff, 
0xffff,
0x0032, 
0x0096, 
0x00fb, 
0x015f, 
0x01c4, 
0x0228, 
0x028d, 
0x02f1, 
0x0356, 
0x03bb, 
0x041f, 
0x0484, 
0x04e8, 
0x054d, 
0x05b1, 
0x0616, 
0x067a, 
0x06df, 
0x0743, 
0x07a8, 
0x080c, 
0x0871, 
0x08d5, 
0x0939, 
0x099e, 
0x0a02, 
0x0a67, 
0x0acb, 
0x0b30, 
0x0b94, 
0x0bf9, 
0x0c5d, 
0x0cc1, 
0x0d26, 
0x0d8a, 
0x0def, 
0x0e53, 
0x0eb7, 
0x0f1c, 
0x0f80, 
0x0fe4, 
0x1049, 
0x10ad, 
0x1111, 
0x1176, 
0x11da, 
0x123e, 
0x12a2, 
0x1307, 
0x136b, 
0x13cf, 
0x1433, 
0x1498, 
0x14fc, 
0x1560, 
0x15c4, 
0x1628, 
0x168d, 
0x16f1, 
0x1755, 
0x17b9, 
0x181d, 
0x1881, 
0x18e5, 
0x1949, 
0x19ad, 
0x1a11, 
0x1a75, 
0x1ad9, 
0x1b3d, 
0x1ba1, 
0x1c05, 
0x1c69, 
0x1ccd, 
0x1d31, 
0x1d95, 
0x1df8, 
0x1e5c, 
0x1ec0, 
0x1f24, 
0x1f88, 
0x1feb, 
0x204f, 
0x20b3, 
0x2117, 
0x217a, 
0x21de, 
0x2242, 
0x22a5, 
0x2309, 
0x236c, 
0x23d0, 
0x2433, 
0x2497, 
0x24fa, 
0x255e, 
0x25c1, 
0x2625, 
0x2688, 
0x26ec, 
0x274f, 
0x27b2, 
0x2816, 
0x2879, 
0x28dc, 
0x293f, 
0x29a2, 
0x2a06, 
0x2a69, 
0x2acc, 
0x2b2f, 
0x2b92, 
0x2bf5, 
0x2c58, 
0x2cbb, 
0x2d1e, 
0x2d81, 
0x2de4, 
0x2e47, 
0x2eaa, 
0x2f0d, 
0x2f6f, 
0x2fd2, 
0x3035, 
0x3098, 
0x30fa, 
0x315d, 
0x31c0, 
0x3222, 
0x3285, 
0x32e7, 
0x334a, 
0x33ac, 
0x340f, 
0x3471, 
0x34d4, 
0x3536, 
0x3598, 
0x35fb, 
0x365d, 
0x36bf, 
0x3721, 
0x3783, 
0x37e5, 
0x3848, 
0x38aa, 
0x390c, 
0x396e, 
0x39d0, 
0x3a31, 
0x3a93, 
0x3af5, 
0x3b57, 
0x3bb9, 
0x3c1b, 
0x3c7c, 
0x3cde, 
0x3d40, 
0x3da1, 
0x3e03, 
0x3e64, 
0x3ec6, 
0x3f27, 
0x3f89, 
0x3fea, 
0x404b, 
0x40ad, 
0x410e, 
0x416f, 
0x41d0, 
0x4231, 
0x4292, 
0x42f3, 
0x4354, 
0x43b5, 
0x4416, 
0x4477, 
0x44d8, 
0x4539, 
0x459a, 
0x45fa, 
0x465b, 
0x46bc, 
0x471c, 
0x477d, 
0x47dd, 
0x483e, 
0x489e, 
0x48ff, 
0x495f, 
0x49bf, 
0x4a1f, 
0x4a80, 
0x4ae0, 
0x4b40, 
0x4ba0, 
0x4c00, 
0x4c60, 
0x4cc0, 
0x4d20, 
0x4d80, 
0x4ddf, 
0x4e3f, 
0x4e9f, 
0x4eff, 
0x4f5e, 
0x4fbe, 
0x501d, 
0x507d, 
0x50dc, 
0x513b, 
0x519b, 
0x51fa, 
0x5259, 
0x52b8, 
0x5317, 
0x5377, 
0x53d6, 
0x5435, 
0x5493, 
0x54f2, 
0x5551, 
0x55b0, 
0x560f, 
0x566d, 
0x56cc, 
0x572a, 
0x5789, 
0x57e7, 
0x5846, 
0x58a4, 
0x5902, 
0x5961, 
0x59bf, 
0x5a1d, 
0x5a7b, 
0x5ad9, 
0x5b37, 
0x5b95, 
0x5bf3, 
0x5c50, 
0x5cae, 
0x5d0c, 
0x5d6a, 
0x5dc7, 
0x5e25, 
0x5e82, 
0x5edf, 
0x5f3d, 
0x5f9a, 
0x5ff7, 
0x6054, 
0x60b2, 
0x610f, 
0x616c, 
0x61c9, 
0x6225, 
0x6282, 
0x62df, 
0x633c, 
0x6398, 
0x63f5, 
0x6451, 
0x64ae, 
0x650a, 
0x6567, 
0x65c3, 
0x661f, 
0x667b, 
0x66d7, 
0x6733, 
0x678f, 
0x67eb, 
0x6847, 
0x68a3, 
0x68ff, 
0x695a, 
0x69b6, 
0x6a11, 
0x6a6d, 
0x6ac8, 
0x6b24, 
0x6b7f, 
0x6bda, 
0x6c35, 
0x6c90, 
0x6ceb, 
0x6d46, 
0x6da1, 
0x6dfc, 
0x6e57, 
0x6eb1, 
0x6f0c, 
0x6f67, 
0x6fc1, 
0x701b, 
0x7076, 
0x70d0, 
0x712a, 
0x7184, 
0x71df, 
0x7239, 
0x7292, 
0x72ec, 
0x7346, 
0x73a0, 
0x73fa, 
0x7453, 
0x74ad, 
0x7506, 
0x755f, 
0x75b9, 
0x7612, 
0x766b, 
0x76c4, 
0x771d, 
0x7776, 
0x77cf, 
0x7828, 
0x7881, 
0x78d9, 
0x7932, 
0x798a, 
0x79e3, 
0x7a3b, 
0x7a93, 
0x7aec, 
0x7b44, 
0x7b9c, 
0x7bf4, 
0x7c4c, 
0x7ca4, 
0x7cfb, 
0x7d53, 
0x7dab, 
0x7e02, 
0x7e5a, 
0x7eb1, 
0x7f09, 
0x7f60, 
0x7fb7, 
0x800e, 
0x8065, 
0x80bc, 
0x8113, 
0x816a, 
0x81c0, 
0x8217, 
0x826d, 
0x82c4, 
0x831a, 
0x8371, 
0x83c7, 
0x841d, 
0x8473, 
0x84c9, 
0x851f, 
0x8575, 
0x85cb, 
0x8620, 
0x8676, 
0x86cb, 
0x8721, 
0x8776, 
0x87cb, 
0x8821, 
0x8876, 
0x88cb, 
0x8920, 
0x8974, 
0x89c9, 
0x8a1e, 
0x8a72, 
0x8ac7, 
0x8b1b, 
0x8b70, 
0x8bc4, 
0x8c18, 
0x8c6c, 
0x8cc0, 
0x8d14, 
0x8d68, 
0x8dbc, 
0x8e10, 
0x8e63, 
0x8eb7, 
0x8f0a, 
0x8f5d, 
0x8fb1, 
0x9004, 
0x9057, 
0x90aa, 
0x90fd, 
0x9150, 
0x91a2, 
0x91f5, 
0x9247, 
0x929a, 
0x92ec, 
0x933f, 
0x9391, 
0x93e3, 
0x9435, 
0x9487, 
0x94d9, 
0x952a, 
0x957c, 
0x95ce, 
0x961f, 
0x9670, 
0x96c2, 
0x9713, 
0x9764, 
0x97b5, 
0x9806, 
0x9857, 
0x98a8, 
0x98f8, 
0x9949, 
0x9999, 
0x99ea, 
0x9a3a, 
0x9a8a, 
0x9ada, 
0x9b2a, 
0x9b7a, 
0x9bca, 
0x9c1a, 
0x9c69, 
0x9cb9, 
0x9d08, 
0x9d58, 
0x9da7, 
0x9df6, 
0x9e45, 
0x9e94, 
0x9ee3, 
0x9f32, 
0x9f80, 
0x9fcf, 
0xa01e, 
0xa06c, 
0xa0ba, 
0xa108, 
0xa157, 
0xa1a5, 
0xa1f2, 
0xa240, 
0xa28e, 
0xa2dc, 
0xa329, 
0xa376, 
0xa3c4, 
0xa411, 
0xa45e, 
0xa4ab, 
0xa4f8, 
0xa545, 
0xa592, 
0xa5de, 
0xa62b, 
0xa677, 
0xa6c4, 
0xa710, 
0xa75c, 
0xa7a8, 
0xa7f4, 
0xa840, 
0xa88b, 
0xa8d7, 
0xa922, 
0xa96e, 
0xa9b9, 
0xaa04, 
0xaa50, 
0xaa9b, 
0xaae5, 
0xab30, 
0xab7b, 
0xabc6, 
0xac10, 
0xac5a, 
0xaca5, 
0xacef, 
0xad39, 
0xad83, 
0xadcd, 
0xae17, 
0xae60, 
0xaeaa, 
0xaef3, 
0xaf3d, 
0xaf86, 
0xafcf, 
0xb018, 
0xb061, 
0xb0aa, 
0xb0f2, 
0xb13b, 
0xb183, 
0xb1cc, 
0xb214, 
0xb25c, 
0xb2a4, 
0xb2ec, 
0xb334, 
0xb37c, 
0xb3c3, 
0xb40b, 
0xb452, 
0xb49a, 
0xb4e1, 
0xb528, 
0xb56f, 
0xb5b6, 
0xb5fd, 
0xb643, 
0xb68a, 
0xb6d0, 
0xb717, 
0xb75d, 
0xb7a3, 
0xb7e9, 
0xb82f, 
0xb874, 
0xb8ba, 
0xb900, 
0xb945, 
0xb98a, 
0xb9d0, 
0xba15, 
0xba5a, 
0xba9f, 
0xbae3, 
0xbb28, 
0xbb6d, 
0xbbb1, 
0xbbf5, 
0xbc39, 
0xbc7e, 
0xbcc1, 
0xbd05, 
0xbd49, 
0xbd8d, 
0xbdd0, 
0xbe14, 
0xbe57, 
0xbe9a, 
0xbedd, 
0xbf20, 
0xbf63, 
0xbfa6, 
0xbfe8, 
0xc02b, 
0xc06d, 
0xc0af, 
0xc0f1, 
0xc133, 
0xc175, 
0xc1b7, 
0xc1f9, 
0xc23a, 
0xc27c, 
0xc2bd, 
0xc2fe, 
0xc33f, 
0xc380, 
0xc3c1, 
0xc402, 
0xc442, 
0xc483, 
0xc4c3, 
0xc504, 
0xc544, 
0xc584, 
0xc5c4, 
0xc603, 
0xc643, 
0xc683, 
0xc6c2, 
0xc701, 
0xc740, 
0xc780, 
0xc7be, 
0xc7fd, 
0xc83c, 
0xc87b, 
0xc8b9, 
0xc8f7, 
0xc936, 
0xc974, 
0xc9b2, 
0xc9ef, 
0xca2d, 
0xca6b, 
0xcaa8, 
0xcae6, 
0xcb23, 
0xcb60, 
0xcb9d, 
0xcbda, 
0xcc17, 
0xcc53, 
0xcc90, 
0xcccc, 
0xcd08, 
0xcd45, 
0xcd81, 
0xcdbc, 
0xcdf8, 
0xce34, 
0xce6f, 
0xceab, 
0xcee6, 
0xcf21, 
0xcf5c, 
0xcf97, 
0xcfd2, 
0xd00c, 
0xd047, 
0xd081, 
0xd0bc, 
0xd0f6, 
0xd130, 
0xd16a, 
0xd1a3, 
0xd1dd, 
0xd217, 
0xd250, 
0xd289, 
0xd2c2, 
0xd2fb, 
0xd334, 
0xd36d, 
0xd3a6, 
0xd3de, 
0xd416, 
0xd44f, 
0xd487, 
0xd4bf, 
0xd4f7, 
0xd52e, 
0xd566, 
0xd59d, 
0xd5d5, 
0xd60c, 
0xd643, 
0xd67a, 
0xd6b1, 
0xd6e7, 
0xd71e, 
0xd754, 
0xd78b, 
0xd7c1, 
0xd7f7, 
0xd82d, 
0xd863, 
0xd898, 
0xd8ce, 
0xd903, 
0xd939, 
0xd96e, 
0xd9a3, 
0xd9d8, 
0xda0c, 
0xda41, 
0xda75, 
0xdaaa, 
0xdade, 
0xdb12, 
0xdb46, 
0xdb7a, 
0xdbad, 
0xdbe1, 
0xdc14, 
0xdc48, 
0xdc7b, 
0xdcae, 
0xdce1, 
0xdd13, 
0xdd46, 
0xdd79, 
0xddab, 
0xdddd, 
0xde0f, 
0xde41, 
0xde73, 
0xdea5, 
0xded6, 
0xdf08, 
0xdf39, 
0xdf6a, 
0xdf9b, 
0xdfcc, 
0xdffd, 
0xe02d, 
0xe05e, 
0xe08e, 
0xe0be, 
0xe0ee, 
0xe11e, 
0xe14e, 
0xe17e, 
0xe1ad, 
0xe1dd, 
0xe20c, 
0xe23b, 
0xe26a, 
0xe299, 
0xe2c8, 
0xe2f6, 
0xe325, 
0xe353, 
0xe381, 
0xe3af, 
0xe3dd, 
0xe40b, 
0xe438, 
0xe466, 
0xe493, 
0xe4c0, 
0xe4ed, 
0xe51a, 
0xe547, 
0xe574, 
0xe5a0, 
0xe5cd, 
0xe5f9, 
0xe625, 
0xe651, 
0xe67d, 
0xe6a9, 
0xe6d4, 
0xe6ff, 
0xe72b, 
0xe756, 
0xe781, 
0xe7ac, 
0xe7d6, 
0xe801, 
0xe82b, 
0xe856, 
0xe880, 
0xe8aa, 
0xe8d4, 
0xe8fd, 
0xe927, 
0xe950, 
0xe97a, 
0xe9a3, 
0xe9cc, 
0xe9f5, 
0xea1e, 
0xea46, 
0xea6f, 
0xea97, 
0xeabf, 
0xeae7, 
0xeb0f, 
0xeb37, 
0xeb5e, 
0xeb86, 
0xebad, 
0xebd4, 
0xebfb, 
0xec22, 
0xec49, 
0xec70, 
0xec96, 
0xecbc, 
0xece3, 
0xed09, 
0xed2f, 
0xed54, 
0xed7a, 
0xed9f, 
0xedc5, 
0xedea, 
0xee0f, 
0xee34, 
0xee59, 
0xee7d, 
0xeea2, 
0xeec6, 
0xeeea, 
0xef0e, 
0xef32, 
0xef56, 
0xef79, 
0xef9d, 
0xefc0, 
0xefe3, 
0xf006, 
0xf029, 
0xf04c, 
0xf06f, 
0xf091, 
0xf0b3, 
0xf0d6, 
0xf0f8, 
0xf119, 
0xf13b, 
0xf15d, 
0xf17e, 
0xf19f, 
0xf1c1, 
0xf1e2, 
0xf202, 
0xf223, 
0xf244, 
0xf264, 
0xf284, 
0xf2a5, 
0xf2c4, 
0xf2e4, 
0xf304, 
0xf324, 
0xf343, 
0xf362, 
0xf381, 
0xf3a0, 
0xf3bf, 
0xf3de, 
0xf3fc, 
0xf41b, 
0xf439, 
0xf457, 
0xf475, 
0xf492, 
0xf4b0, 
0xf4ce, 
0xf4eb, 
0xf508, 
0xf525, 
0xf542, 
0xf55f, 
0xf57b, 
0xf598, 
0xf5b4, 
0xf5d0, 
0xf5ec, 
0xf608, 
0xf624, 
0xf63f, 
0xf65b, 
0xf676, 
0xf691, 
0xf6ac, 
0xf6c7, 
0xf6e2, 
0xf6fc, 
0xf716, 
0xf731, 
0xf74b, 
0xf765, 
0xf77e, 
0xf798, 
0xf7b2, 
0xf7cb, 
0xf7e4, 
0xf7fd, 
0xf816, 
0xf82f, 
0xf847, 
0xf860, 
0xf878, 
0xf890, 
0xf8a8, 
0xf8c0, 
0xf8d8, 
0xf8ef, 
0xf906, 
0xf91e, 
0xf935, 
0xf94c, 
0xf962, 
0xf979, 
0xf990, 
0xf9a6, 
0xf9bc, 
0xf9d2, 
0xf9e8, 
0xf9fe, 
0xfa13, 
0xfa29, 
0xfa3e, 
0xfa53, 
0xfa68, 
0xfa7d, 
0xfa92, 
0xfaa6, 
0xfaba, 
0xfacf, 
0xfae3, 
0xfaf7, 
0xfb0a, 
0xfb1e, 
0xfb31, 
0xfb45, 
0xfb58, 
0xfb6b, 
0xfb7e, 
0xfb91, 
0xfba3, 
0xfbb5, 
0xfbc8, 
0xfbda, 
0xfbec, 
0xfbfe, 
0xfc0f, 
0xfc21, 
0xfc32, 
0xfc43, 
0xfc54, 
0xfc65, 
0xfc76, 
0xfc86, 
0xfc97, 
0xfca7, 
0xfcb7, 
0xfcc7, 
0xfcd7, 
0xfce7, 
0xfcf6, 
0xfd06, 
0xfd15, 
0xfd24, 
0xfd33, 
0xfd42, 
0xfd50, 
0xfd5f, 
0xfd6d, 
0xfd7b, 
0xfd89, 
0xfd97, 
0xfda5, 
0xfdb2, 
0xfdbf, 
0xfdcd, 
0xfdda, 
0xfde7, 
0xfdf3, 
0xfe00, 
0xfe0c, 
0xfe19, 
0xfe25, 
0xfe31, 
0xfe3d, 
0xfe48, 
0xfe54, 
0xfe5f, 
0xfe6b, 
0xfe76, 
0xfe81, 
0xfe8b, 
0xfe96, 
0xfea0, 
0xfeab, 
0xfeb5, 
0xfebf, 
0xfec9, 
0xfed3, 
0xfedc, 
0xfee5, 
0xfeef, 
0xfef8, 
0xff01, 
0xff0a, 
0xff12, 
0xff1b, 
0xff23, 
0xff2b, 
0xff33, 
0xff3b, 
0xff43, 
0xff4a, 
0xff52, 
0xff59, 
0xff60, 
0xff67, 
0xff6e, 
0xff74, 
0xff7b, 
0xff81, 
0xff87, 
0xff8d, 
0xff93, 
0xff99, 
0xff9e, 
0xffa4, 
0xffa9, 
0xffae, 
0xffb3, 
0xffb8, 
0xffbc, 
0xffc1, 
0xffc5, 
0xffc9, 
0xffcd, 
0xffd1, 
0xffd5, 
0xffd8, 
0xffdc, 
0xffdf, 
0xffe2, 
0xffe5, 
0xffe8, 
0xffeb, 
0xffed, 
0xffef, 
0xfff1, 
0xfff3, 
0xfff5, 
0xfff7, 
0xfff9, 
0xfffa, 
0xfffb, 
0xfffc, 
0xfffd, 
0xfffe, 
0xffff, 
0xffff, 
0xffff, 
0xffff,
0x0019, 
0x004b, 
0x007d, 
0x00af, 
0x00e2, 
0x0114, 
0x0146, 
0x0178, 
0x01ab, 
0x01dd, 
0x020f, 
0x0242, 
0x0274, 
0x02a6, 
0x02d8, 
0x030b, 
0x033d, 
0x036f, 
0x03a1, 
0x03d4, 
0x0406, 
0x0438, 
0x046a, 
0x049d, 
0x04cf, 
0x0501, 
0x0533, 
0x0566, 
0x0598, 
0x05ca, 
0x05fc, 
0x062f, 
0x0661, 
0x0693, 
0x06c5, 
0x06f8, 
0x072a, 
0x075c, 
0x078e, 
0x07c1, 
0x07f3, 
0x0825, 
0x0857, 
0x088a, 
0x08bc, 
0x08ee, 
0x0920, 
0x0953, 
0x0985, 
0x09b7, 
0x09e9, 
0x0a1b, 
0x0a4e, 
0x0a80, 
0x0ab2, 
0x0ae4, 
0x0b17, 
0x0b49, 
0x0b7b, 
0x0bad, 
0x0bdf, 
0x0c12, 
0x0c44, 
0x0c76, 
0x0ca8, 
0x0cdb, 
0x0d0d, 
0x0d3f, 
0x0d71, 
0x0da3, 
0x0dd5, 
0x0e08, 
0x0e3a, 
0x0e6c, 
0x0e9e, 
0x0ed0, 
0x0f03, 
0x0f35, 
0x0f67, 
0x0f99, 
0x0fcb, 
0x0ffd, 
0x1030, 
0x1062, 
0x1094, 
0x10c6, 
0x10f8, 
0x112a, 
0x115d, 
0x118f, 
0x11c1, 
0x11f3, 
0x1225, 
0x1257, 
0x1289, 
0x12bc, 
0x12ee, 
0x1320, 
0x1352, 
0x1384, 
0x13b6, 
0x13e8, 
0x141a, 
0x144d, 
0x147f, 
0x14b1, 
0x14e3, 
0x1515, 
0x1547, 
0x1579, 
0x15ab, 
0x15dd, 
0x160f, 
0x1641, 
0x1674, 
0x16a6, 
0x16d8, 
0x170a, 
0x173c, 
0x176e, 
0x17a0, 
0x17d2, 
0x1804, 
0x1836, 
0x1868, 
0x189a, 
0x18cc, 
0x18fe, 
0x1930, 
0x1962, 
0x1994, 
0x19c6, 
0x19f8, 
0x1a2a, 
0x1a5c, 
0x1a8e, 
0x1ac0, 
0x1af2, 
0x1b24, 
0x1b56, 
0x1b88, 
0x1bba, 
0x1bec, 
0x1c1e, 
0x1c50, 
0x1c82, 
0x1cb4, 
0x1ce6, 
0x1d18, 
0x1d4a, 
0x1d7c, 
0x1dae, 
0x1de0, 
0x1e11, 
0x1e43, 
0x1e75, 
0x1ea7, 
0x1ed9, 
0x1f0b, 
0x1f3d, 
0x1f6f, 
0x1fa1, 
0x1fd3, 
0x2004, 
0x2036, 
0x2068, 
0x209a, 
0x20cc, 
0x20fe, 
0x2130, 
0x2161, 
0x2193, 
0x21c5, 
0x21f7, 
0x2229, 
0x225a, 
0x228c, 
0x22be, 
0x22f0, 
0x2322, 
0x2353, 
0x2385, 
0x23b7, 
0x23e9, 
0x241b, 
0x244c, 
0x247e, 
0x24b0, 
0x24e2, 
0x2513, 
0x2545, 
0x2577, 
0x25a8, 
0x25da, 
0x260c, 
0x263e, 
0x266f, 
0x26a1, 
0x26d3, 
0x2704, 
0x2736, 
0x2768, 
0x2799, 
0x27cb, 
0x27fd, 
0x282e, 
0x2860, 
0x2892, 
0x28c3, 
0x28f5, 
0x2926, 
0x2958, 
0x298a, 
0x29bb, 
0x29ed, 
0x2a1e, 
0x2a50, 
0x2a82, 
0x2ab3, 
0x2ae5, 
0x2b16, 
0x2b48, 
0x2b79, 
0x2bab, 
0x2bdc, 
0x2c0e, 
0x2c3f, 
0x2c71, 
0x2ca2, 
0x2cd4, 
0x2d05, 
0x2d37, 
0x2d68, 
0x2d9a, 
0x2dcb, 
0x2dfd, 
0x2e2e, 
0x2e60, 
0x2e91, 
0x2ec2, 
0x2ef4, 
0x2f25, 
0x2f57, 
0x2f88, 
0x2fba, 
0x2feb, 
0x301c, 
0x304e, 
0x307f, 
0x30b0, 
0x30e2, 
0x3113, 
0x3144, 
0x3176, 
0x31a7, 
0x31d8, 
0x320a, 
0x323b, 
0x326c, 
0x329d, 
0x32cf, 
0x3300, 
0x3331, 
0x3362, 
0x3394, 
0x33c5, 
0x33f6, 
0x3427, 
0x3459, 
0x348a, 
0x34bb, 
0x34ec, 
0x351d, 
0x354f, 
0x3580, 
0x35b1, 
0x35e2, 
0x3613, 
0x3644, 
0x3675, 
0x36a6, 
0x36d8, 
0x3709, 
0x373a, 
0x376b, 
0x379c, 
0x37cd, 
0x37fe, 
0x382f, 
0x3860, 
0x3891, 
0x38c2, 
0x38f3, 
0x3924, 
0x3955, 
0x3986, 
0x39b7, 
0x39e8, 
0x3a19, 
0x3a4a, 
0x3a7b, 
0x3aac, 
0x3add, 
0x3b0e, 
0x3b3f, 
0x3b6f, 
0x3ba0, 
0x3bd1, 
0x3c02, 
0x3c33, 
0x3c64, 
0x3c95, 
0x3cc5, 
0x3cf6, 
0x3d27, 
0x3d58, 
0x3d89, 
0x3dba, 
0x3dea, 
0x3e1b, 
0x3e4c, 
0x3e7d, 
0x3ead, 
0x3ede, 
0x3f0f, 
0x3f3f, 
0x3f70, 
0x3fa1, 
0x3fd2, 
0x4002, 
0x4033, 
0x4064, 
0x4094, 
0x40c5, 
0x40f5, 
0x4126, 
0x4157, 
0x4187, 
0x41b8, 
0x41e8, 
0x4219, 
0x424a, 
0x427a, 
0x42ab, 
0x42db, 
0x430c, 
0x433c, 
0x436d, 
0x439d, 
0x43ce, 
0x43fe, 
0x442f, 
0x445f, 
0x448f, 
0x44c0, 
0x44f0, 
0x4521, 
0x4551, 
0x4581, 
0x45b2, 
0x45e2, 
0x4613, 
0x4643, 
0x4673, 
0x46a4, 
0x46d4, 
0x4704, 
0x4734, 
0x4765, 
0x4795, 
0x47c5, 
0x47f5, 
0x4826, 
0x4856, 
0x4886, 
0x48b6, 
0x48e7, 
0x4917, 
0x4947, 
0x4977, 
0x49a7, 
0x49d7, 
0x4a07, 
0x4a38, 
0x4a68, 
0x4a98, 
0x4ac8, 
0x4af8, 
0x4b28, 
0x4b58, 
0x4b88, 
0x4bb8, 
0x4be8, 
0x4c18, 
0x4c48, 
0x4c78, 
0x4ca8, 
0x4cd8, 
0x4d08, 
0x4d38, 
0x4d68, 
0x4d98, 
0x4dc8, 
0x4df7, 
0x4e27, 
0x4e57, 
0x4e87, 
0x4eb7, 
0x4ee7, 
0x4f16, 
0x4f46, 
0x4f76, 
0x4fa6, 
0x4fd6, 
0x5005, 
0x5035, 
0x5065, 
0x5095, 
0x50c4, 
0x50f4, 
0x5124, 
0x5153, 
0x5183, 
0x51b3, 
0x51e2, 
0x5212, 
0x5241, 
0x5271, 
0x52a1, 
0x52d0, 
0x5300, 
0x532f, 
0x535f, 
0x538e, 
0x53be, 
0x53ed, 
0x541d, 
0x544c, 
0x547c, 
0x54ab, 
0x54db, 
0x550a, 
0x5539, 
0x5569, 
0x5598, 
0x55c8, 
0x55f7, 
0x5626, 
0x5656, 
0x5685, 
0x56b4, 
0x56e3, 
0x5713, 
0x5742, 
0x5771, 
0x57a0, 
0x57d0, 
0x57ff, 
0x582e, 
0x585d, 
0x588c, 
0x58bc, 
0x58eb, 
0x591a, 
0x5949, 
0x5978, 
0x59a7, 
0x59d6, 
0x5a05, 
0x5a34, 
0x5a63, 
0x5a92, 
0x5ac1, 
0x5af0, 
0x5b1f, 
0x5b4e, 
0x5b7d, 
0x5bac, 
0x5bdb, 
0x5c0a, 
0x5c39, 
0x5c68, 
0x5c97, 
0x5cc6, 
0x5cf4, 
0x5d23, 
0x5d52, 
0x5d81, 
0x5db0, 
0x5dde, 
0x5e0d, 
0x5e3c, 
0x5e6b, 
0x5e99, 
0x5ec8, 
0x5ef7, 
0x5f25, 
0x5f54, 
0x5f83, 
0x5fb1, 
0x5fe0, 
0x600f, 
0x603d, 
0x606c, 
0x609a, 
0x60c9, 
0x60f7, 
0x6126, 
0x6154, 
0x6183, 
0x61b1, 
0x61e0, 
0x620e, 
0x623d, 
0x626b, 
0x6299, 
0x62c8, 
0x62f6, 
0x6325, 
0x6353, 
0x6381, 
0x63b0, 
0x63de, 
0x640c, 
0x643a, 
0x6469, 
0x6497, 
0x64c5, 
0x64f3, 
0x6521, 
0x6550, 
0x657e, 
0x65ac, 
0x65da, 
0x6608, 
0x6636, 
0x6664, 
0x6692, 
0x66c0, 
0x66ee, 
0x671c, 
0x674a, 
0x6778, 
0x67a6, 
0x67d4, 
0x6802, 
0x6830, 
0x685e, 
0x688c, 
0x68ba, 
0x68e8, 
0x6916, 
0x6943, 
0x6971, 
0x699f, 
0x69cd, 
0x69fb, 
0x6a28, 
0x6a56, 
0x6a84, 
0x6ab1, 
0x6adf, 
0x6b0d, 
0x6b3a, 
0x6b68, 
0x6b96, 
0x6bc3, 
0x6bf1, 
0x6c1e, 
0x6c4c, 
0x6c7a, 
0x6ca7, 
0x6cd5, 
0x6d02, 
0x6d30, 
0x6d5d, 
0x6d8a, 
0x6db8, 
0x6de5, 
0x6e13, 
0x6e40, 
0x6e6d, 
0x6e9b, 
0x6ec8, 
0x6ef5, 
0x6f23, 
0x6f50, 
0x6f7d, 
0x6faa, 
0x6fd8, 
0x7005, 
0x7032, 
0x705f, 
0x708c, 
0x70ba, 
0x70e7, 
0x7114, 
0x7141, 
0x716e, 
0x719b, 
0x71c8, 
0x71f5, 
0x7222, 
0x724f, 
0x727c, 
0x72a9, 
0x72d6, 
0x7303, 
0x7330, 
0x735d, 
0x7389, 
0x73b6, 
0x73e3, 
0x7410, 
0x743d, 
0x7469, 
0x7496, 
0x74c3, 
0x74f0, 
0x751c, 
0x7549, 
0x7576, 
0x75a2, 
0x75cf, 
0x75fc, 
0x7628, 
0x7655, 
0x7681, 
0x76ae, 
0x76da, 
0x7707, 
0x7733, 
0x7760, 
0x778c, 
0x77b9, 
0x77e5, 
0x7812, 
0x783e, 
0x786a, 
0x7897, 
0x78c3, 
0x78ef, 
0x791c, 
0x7948, 
0x7974, 
0x79a0, 
0x79cd, 
0x79f9, 
0x7a25, 
0x7a51, 
0x7a7d, 
0x7aaa, 
0x7ad6, 
0x7b02, 
0x7b2e, 
0x7b5a, 
0x7b86, 
0x7bb2, 
0x7bde, 
0x7c0a, 
0x7c36, 
0x7c62, 
0x7c8e, 
0x7cba, 
0x7ce6, 
0x7d11, 
0x7d3d, 
0x7d69, 
0x7d95, 
0x7dc1, 
0x7dec, 
0x7e18, 
0x7e44, 
0x7e70, 
0x7e9b, 
0x7ec7, 
0x7ef3, 
0x7f1e, 
0x7f4a, 
0x7f76, 
0x7fa1, 
0x7fcd, 
0x7ff8, 
0x8024, 
0x804f, 
0x807b, 
0x80a6, 
0x80d2, 
0x80fd, 
0x8129, 
0x8154, 
0x817f, 
0x81ab, 
0x81d6, 
0x8201, 
0x822d, 
0x8258, 
0x8283, 
0x82ae, 
0x82da, 
0x8305, 
0x8330, 
0x835b, 
0x8386, 
0x83b1, 
0x83dc, 
0x8407, 
0x8433, 
0x845e, 
0x8489, 
0x84b4, 
0x84df, 
0x8509, 
0x8534, 
0x855f, 
0x858a, 
0x85b5, 
0x85e0, 
0x860b, 
0x8636, 
0x8660, 
0x868b, 
0x86b6, 
0x86e1, 
0x870b, 
0x8736, 
0x8761, 
0x878b, 
0x87b6, 
0x87e1, 
0x880b, 
0x8836, 
0x8860, 
0x888b, 
0x88b5, 
0x88e0, 
0x890a, 
0x8935, 
0x895f, 
0x898a, 
0x89b4, 
0x89de, 
0x8a09, 
0x8a33, 
0x8a5d, 
0x8a88, 
0x8ab2, 
0x8adc, 
0x8b06, 
0x8b31, 
0x8b5b, 
0x8b85, 
0x8baf, 
0x8bd9, 
0x8c03, 
0x8c2d, 
0x8c57, 
0x8c81, 
0x8cab, 
0x8cd5, 
0x8cff, 
0x8d29, 
0x8d53, 
0x8d7d, 
0x8da7, 
0x8dd1, 
0x8dfb, 
0x8e24, 
0x8e4e, 
0x8e78, 
0x8ea2, 
0x8ecb, 
0x8ef5, 
0x8f1f, 
0x8f49, 
0x8f72, 
0x8f9c, 
0x8fc5, 
0x8fef, 
0x9019, 
0x9042, 
0x906c, 
0x9095, 
0x90bf, 
0x90e8, 
0x9111, 
0x913b, 
0x9164, 
0x918e, 
0x91b7, 
0x91e0, 
0x920a, 
0x9233, 
0x925c, 
0x9285, 
0x92af, 
0x92d8, 
0x9301, 
0x932a, 
0x9353, 
0x937c, 
0x93a5, 
0x93ce, 
0x93f7, 
0x9420, 
0x9449, 
0x9472, 
0x949b, 
0x94c4, 
0x94ed, 
0x9516, 
0x953f, 
0x9568, 
0x9590, 
0x95b9, 
0x95e2, 
0x960b, 
0x9633, 
0x965c, 
0x9685, 
0x96ad, 
0x96d6, 
0x96ff, 
0x9727, 
0x9750, 
0x9778, 
0x97a1, 
0x97c9, 
0x97f2, 
0x981a, 
0x9843, 
0x986b, 
0x9893, 
0x98bc, 
0x98e4, 
0x990c, 
0x9935, 
0x995d, 
0x9985, 
0x99ad, 
0x99d6, 
0x99fe, 
0x9a26, 
0x9a4e, 
0x9a76, 
0x9a9e, 
0x9ac6, 
0x9aee, 
0x9b16, 
0x9b3e, 
0x9b66, 
0x9b8e, 
0x9bb6, 
0x9bde, 
0x9c06, 
0x9c2e, 
0x9c55, 
0x9c7d, 
0x9ca5, 
0x9ccd, 
0x9cf4, 
0x9d1c, 
0x9d44, 
0x9d6c, 
0x9d93, 
0x9dbb, 
0x9de2, 
0x9e0a, 
0x9e31, 
0x9e59, 
0x9e80, 
0x9ea8, 
0x9ecf, 
0x9ef7, 
0x9f1e, 
0x9f45, 
0x9f6d, 
0x9f94, 
0x9fbb, 
0x9fe3, 
0xa00a, 
0xa031, 
0xa058, 
0xa07f, 
0xa0a7, 
0xa0ce, 
0xa0f5, 
0xa11c, 
0xa143, 
0xa16a, 
0xa191, 
0xa1b8, 
0xa1df, 
0xa206, 
0xa22d, 
0xa254, 
0xa27b, 
0xa2a1, 
0xa2c8, 
0xa2ef, 
0xa316, 
0xa33c, 
0xa363, 
0xa38a, 
0xa3b0, 
0xa3d7, 
0xa3fe, 
0xa424, 
0xa44b, 
0xa471, 
0xa498, 
0xa4be, 
0xa4e5, 
0xa50b, 
0xa532, 
0xa558, 
0xa57e, 
0xa5a5, 
0xa5cb, 
0xa5f1, 
0xa618, 
0xa63e, 
0xa664, 
0xa68a, 
0xa6b0, 
0xa6d7, 
0xa6fd, 
0xa723, 
0xa749, 
0xa76f, 
0xa795, 
0xa7bb, 
0xa7e1, 
0xa807, 
0xa82d, 
0xa853, 
0xa878, 
0xa89e, 
0xa8c4, 
0xa8ea, 
0xa910, 
0xa935, 
0xa95b, 
0xa981, 
0xa9a6, 
0xa9cc, 
0xa9f2, 
0xaa17, 
0xaa3d, 
0xaa62, 
0xaa88, 
0xaaad, 
0xaad3, 
0xaaf8, 
0xab1e, 
0xab43, 
0xab68, 
0xab8e, 
0xabb3, 
0xabd8, 
0xabfd, 
0xac23, 
0xac48, 
0xac6d, 
0xac92, 
0xacb7, 
0xacdc, 
0xad01, 
0xad26, 
0xad4b, 
0xad70, 
0xad95, 
0xadba, 
0xaddf, 
0xae04, 
0xae29, 
0xae4e, 
0xae73, 
0xae97, 
0xaebc, 
0xaee1, 
0xaf06, 
0xaf2a, 
0xaf4f, 
0xaf73, 
0xaf98, 
0xafbd, 
0xafe1, 
0xb006, 
0xb02a, 
0xb04f, 
0xb073, 
0xb097, 
0xb0bc, 
0xb0e0, 
0xb104, 
0xb129, 
0xb14d, 
0xb171, 
0xb196, 
0xb1ba, 
0xb1de, 
0xb202, 
0xb226, 
0xb24a, 
0xb26e, 
0xb292, 
0xb2b6, 
0xb2da, 
0xb2fe, 
0xb322, 
0xb346, 
0xb36a, 
0xb38e, 
0xb3b2, 
0xb3d5, 
0xb3f9, 
0xb41d, 
0xb441, 
0xb464, 
0xb488, 
0xb4ac, 
0xb4cf, 
0xb4f3, 
0xb516, 
0xb53a, 
0xb55d, 
0xb581, 
0xb5a4, 
0xb5c8, 
0xb5eb, 
0xb60e, 
0xb632, 
0xb655, 
0xb678, 
0xb69b, 
0xb6bf, 
0xb6e2, 
0xb705, 
0xb728, 
0xb74b, 
0xb76e, 
0xb791, 
0xb7b4, 
0xb7d7, 
0xb7fa, 
0xb81d, 
0xb840, 
0xb863, 
0xb886, 
0xb8a9, 
0xb8cb, 
0xb8ee, 
0xb911, 
0xb934, 
0xb956, 
0xb979, 
0xb99c, 
0xb9be, 
0xb9e1, 
0xba03, 
0xba26, 
0xba48, 
0xba6b, 
0xba8d, 
0xbab0, 
0xbad2, 
0xbaf4, 
0xbb17, 
0xbb39, 
0xbb5b, 
0xbb7e, 
0xbba0, 
0xbbc2, 
0xbbe4, 
0xbc06, 
0xbc28, 
0xbc4a, 
0xbc6c, 
0xbc8f, 
0xbcb0, 
0xbcd2, 
0xbcf4, 
0xbd16, 
0xbd38, 
0xbd5a, 
0xbd7c, 
0xbd9e, 
0xbdbf, 
0xbde1, 
0xbe03, 
0xbe24, 
0xbe46, 
0xbe68, 
0xbe89, 
0xbeab, 
0xbecc, 
0xbeee, 
0xbf0f, 
0xbf31, 
0xbf52, 
0xbf74, 
0xbf95, 
0xbfb6, 
0xbfd8, 
0xbff9, 
0xc01a, 
0xc03b, 
0xc05c, 
0xc07e, 
0xc09f, 
0xc0c0, 
0xc0e1, 
0xc102, 
0xc123, 
0xc144, 
0xc165, 
0xc186, 
0xc1a7, 
0xc1c8, 
0xc1e8, 
0xc209, 
0xc22a, 
0xc24b, 
0xc26b, 
0xc28c, 
0xc2ad, 
0xc2cd, 
0xc2ee, 
0xc30f, 
0xc32f, 
0xc350, 
0xc370, 
0xc391, 
0xc3b1, 
0xc3d1, 
0xc3f2, 
0xc412, 
0xc432, 
0xc453, 
0xc473, 
0xc493, 
0xc4b3, 
0xc4d3, 
0xc4f4, 
0xc514, 
0xc534, 
0xc554, 
0xc574, 
0xc594, 
0xc5b4, 
0xc5d4, 
0xc5f3, 
0xc613, 
0xc633, 
0xc653, 
0xc673, 
0xc692, 
0xc6b2, 
0xc6d2, 
0xc6f1, 
0xc711, 
0xc731, 
0xc750, 
0xc770, 
0xc78f, 
0xc7af, 
0xc7ce, 
0xc7ee, 
0xc80d, 
0xc82c, 
0xc84c, 
0xc86b, 
0xc88a, 
0xc8a9, 
0xc8c9, 
0xc8e8, 
0xc907, 
0xc926, 
0xc945, 
0xc964, 
0xc983, 
0xc9a2, 
0xc9c1, 
0xc9e0, 
0xc9ff, 
0xca1e, 
0xca3d, 
0xca5b, 
0xca7a, 
0xca99, 
0xcab8, 
0xcad6, 
0xcaf5, 
0xcb14, 
0xcb32, 
0xcb51, 
0xcb6f, 
0xcb8e, 
0xcbac, 
0xcbcb, 
0xcbe9, 
0xcc07, 
0xcc26, 
0xcc44, 
0xcc62, 
0xcc81, 
0xcc9f, 
0xccbd, 
0xccdb, 
0xccf9, 
0xcd17, 
0xcd36, 
0xcd54, 
0xcd72, 
0xcd90, 
0xcdad, 
0xcdcb, 
0xcde9, 
0xce07, 
0xce25, 
0xce43, 
0xce60, 
0xce7e, 
0xce9c, 
0xceba, 
0xced7, 
0xcef5, 
0xcf12, 
0xcf30, 
0xcf4d, 
0xcf6b, 
0xcf88, 
0xcfa6, 
0xcfc3, 
0xcfe0, 
0xcffe, 
0xd01b, 
0xd038, 
0xd056, 
0xd073, 
0xd090, 
0xd0ad, 
0xd0ca, 
0xd0e7, 
0xd104, 
0xd121, 
0xd13e, 
0xd15b, 
0xd178, 
0xd195, 
0xd1b2, 
0xd1cf, 
0xd1eb, 
0xd208, 
0xd225, 
0xd242, 
0xd25e, 
0xd27b, 
0xd298, 
0xd2b4, 
0xd2d1, 
0xd2ed, 
0xd30a, 
0xd326, 
0xd342, 
0xd35f, 
0xd37b, 
0xd397, 
0xd3b4, 
0xd3d0, 
0xd3ec, 
0xd408, 
0xd424, 
0xd441, 
0xd45d, 
0xd479, 
0xd495, 
0xd4b1, 
0xd4cd, 
0xd4e9, 
0xd505, 
0xd520, 
0xd53c, 
0xd558, 
0xd574, 
0xd590, 
0xd5ab, 
0xd5c7, 
0xd5e3, 
0xd5fe, 
0xd61a, 
0xd635, 
0xd651, 
0xd66c, 
0xd688, 
0xd6a3, 
0xd6be, 
0xd6da, 
0xd6f5, 
0xd710, 
0xd72c, 
0xd747, 
0xd762, 
0xd77d, 
0xd798, 
0xd7b3, 
0xd7ce, 
0xd7ea, 
0xd804, 
0xd81f, 
0xd83a, 
0xd855, 
0xd870, 
0xd88b, 
0xd8a6, 
0xd8c1, 
0xd8db, 
0xd8f6, 
0xd911, 
0xd92b, 
0xd946, 
0xd960, 
0xd97b, 
0xd995, 
0xd9b0, 
0xd9ca, 
0xd9e5, 
0xd9ff, 
0xda19, 
0xda34, 
0xda4e, 
0xda68, 
0xda82, 
0xda9d, 
0xdab7, 
0xdad1, 
0xdaeb, 
0xdb05, 
0xdb1f, 
0xdb39, 
0xdb53, 
0xdb6d, 
0xdb87, 
0xdba1, 
0xdbba, 
0xdbd4, 
0xdbee, 
0xdc08, 
0xdc21, 
0xdc3b, 
0xdc54, 
0xdc6e, 
0xdc88, 
0xdca1, 
0xdcbb, 
0xdcd4, 
0xdced, 
0xdd07, 
0xdd20, 
0xdd39, 
0xdd53, 
0xdd6c, 
0xdd85, 
0xdd9e, 
0xddb8, 
0xddd1, 
0xddea, 
0xde03, 
0xde1c, 
0xde35, 
0xde4e, 
0xde67, 
0xde7f, 
0xde98, 
0xdeb1, 
0xdeca, 
0xdee3, 
0xdefb, 
0xdf14, 
0xdf2d, 
0xdf45, 
0xdf5e, 
0xdf76, 
0xdf8f, 
0xdfa7, 
0xdfc0, 
0xdfd8, 
0xdff1, 
0xe009, 
0xe021, 
0xe03a, 
0xe052, 
0xe06a, 
0xe082, 
0xe09a, 
0xe0b2, 
0xe0ca, 
0xe0e2, 
0xe0fa, 
0xe112, 
0xe12a, 
0xe142, 
0xe15a, 
0xe172, 
0xe18a, 
0xe1a2, 
0xe1b9, 
0xe1d1, 
0xe1e9, 
0xe200, 
0xe218, 
0xe22f, 
0xe247, 
0xe25e, 
0xe276, 
0xe28d, 
0xe2a5, 
0xe2bc, 
0xe2d3, 
0xe2eb, 
0xe302, 
0xe319, 
0xe330, 
0xe347, 
0xe35f, 
0xe376, 
0xe38d, 
0xe3a4, 
0xe3bb, 
0xe3d2, 
0xe3e9, 
0xe3ff, 
0xe416, 
0xe42d, 
0xe444, 
0xe45b, 
0xe471, 
0xe488, 
0xe49f, 
0xe4b5, 
0xe4cc, 
0xe4e2, 
0xe4f9, 
0xe50f, 
0xe526, 
0xe53c, 
0xe552, 
0xe569, 
0xe57f, 
0xe595, 
0xe5ab, 
0xe5c2, 
0xe5d8, 
0xe5ee, 
0xe604, 
0xe61a, 
0xe630, 
0xe646, 
0xe65c, 
0xe672, 
0xe688, 
0xe69e, 
0xe6b3, 
0xe6c9, 
0xe6df, 
0xe6f5, 
0xe70a, 
0xe720, 
0xe736, 
0xe74b, 
0xe761, 
0xe776, 
0xe78c, 
0xe7a1, 
0xe7b6, 
0xe7cc, 
0xe7e1, 
0xe7f6, 
0xe80c, 
0xe821, 
0xe836, 
0xe84b, 
0xe860, 
0xe875, 
0xe88a, 
0xe89f, 
0xe8b4, 
0xe8c9, 
0xe8de, 
0xe8f3, 
0xe908, 
0xe91d, 
0xe931, 
0xe946, 
0xe95b, 
0xe96f, 
0xe984, 
0xe999, 
0xe9ad, 
0xe9c2, 
0xe9d6, 
0xe9eb, 
0xe9ff, 
0xea13, 
0xea28, 
0xea3c, 
0xea50, 
0xea64, 
0xea79, 
0xea8d, 
0xeaa1, 
0xeab5, 
0xeac9, 
0xeadd, 
0xeaf1, 
0xeb05, 
0xeb19, 
0xeb2d, 
0xeb41, 
0xeb54, 
0xeb68, 
0xeb7c, 
0xeb90, 
0xeba3, 
0xebb7, 
0xebcb, 
0xebde, 
0xebf2, 
0xec05, 
0xec19, 
0xec2c, 
0xec3f, 
0xec53, 
0xec66, 
0xec79, 
0xec8c, 
0xeca0, 
0xecb3, 
0xecc6, 
0xecd9, 
0xecec, 
0xecff, 
0xed12, 
0xed25, 
0xed38, 
0xed4b, 
0xed5e, 
0xed71, 
0xed83, 
0xed96, 
0xeda9, 
0xedbb, 
0xedce, 
0xede1, 
0xedf3, 
0xee06, 
0xee18, 
0xee2b, 
0xee3d, 
0xee4f, 
0xee62, 
0xee74, 
0xee86, 
0xee99, 
0xeeab, 
0xeebd, 
0xeecf, 
0xeee1, 
0xeef3, 
0xef05, 
0xef17, 
0xef29, 
0xef3b, 
0xef4d, 
0xef5f, 
0xef71, 
0xef82, 
0xef94, 
0xefa6, 
0xefb7, 
0xefc9, 
0xefdb, 
0xefec, 
0xeffe, 
0xf00f, 
0xf021, 
0xf032, 
0xf043, 
0xf055, 
0xf066, 
0xf077, 
0xf089, 
0xf09a, 
0xf0ab, 
0xf0bc, 
0xf0cd, 
0xf0de, 
0xf0ef, 
0xf100, 
0xf111, 
0xf122, 
0xf133, 
0xf144, 
0xf154, 
0xf165, 
0xf176, 
0xf187, 
0xf197, 
0xf1a8, 
0xf1b8, 
0xf1c9, 
0xf1d9, 
0xf1ea, 
0xf1fa, 
0xf20b, 
0xf21b, 
0xf22b, 
0xf23c, 
0xf24c, 
0xf25c, 
0xf26c, 
0xf27c, 
0xf28c, 
0xf29c, 
0xf2ad, 
0xf2bd, 
0xf2cc, 
0xf2dc, 
0xf2ec, 
0xf2fc, 
0xf30c, 
0xf31c, 
0xf32b, 
0xf33b, 
0xf34b, 
0xf35a, 
0xf36a, 
0xf379, 
0xf389, 
0xf398, 
0xf3a8, 
0xf3b7, 
0xf3c7, 
0xf3d6, 
0xf3e5, 
0xf3f5, 
0xf404, 
0xf413, 
0xf422, 
0xf431, 
0xf440, 
0xf44f, 
0xf45e, 
0xf46d, 
0xf47c, 
0xf48b, 
0xf49a, 
0xf4a9, 
0xf4b8, 
0xf4c6, 
0xf4d5, 
0xf4e4, 
0xf4f2, 
0xf501, 
0xf50f, 
0xf51e, 
0xf52c, 
0xf53b, 
0xf549, 
0xf558, 
0xf566, 
0xf574, 
0xf582, 
0xf591, 
0xf59f, 
0xf5ad, 
0xf5bb, 
0xf5c9, 
0xf5d7, 
0xf5e5, 
0xf5f3, 
0xf601, 
0xf60f, 
0xf61d, 
0xf62b, 
0xf638, 
0xf646, 
0xf654, 
0xf662, 
0xf66f, 
0xf67d, 
0xf68a, 
0xf698, 
0xf6a5, 
0xf6b3, 
0xf6c0, 
0xf6ce, 
0xf6db, 
0xf6e8, 
0xf6f5, 
0xf703, 
0xf710, 
0xf71d, 
0xf72a, 
0xf737, 
0xf744, 
0xf751, 
0xf75e, 
0xf76b, 
0xf778, 
0xf785, 
0xf792, 
0xf79e, 
0xf7ab, 
0xf7b8, 
0xf7c5, 
0xf7d1, 
0xf7de, 
0xf7ea, 
0xf7f7, 
0xf803, 
0xf810, 
0xf81c, 
0xf828, 
0xf835, 
0xf841, 
0xf84d, 
0xf85a, 
0xf866, 
0xf872, 
0xf87e, 
0xf88a, 
0xf896, 
0xf8a2, 
0xf8ae, 
0xf8ba, 
0xf8c6, 
0xf8d2, 
0xf8dd, 
0xf8e9, 
0xf8f5, 
0xf901, 
0xf90c, 
0xf918, 
0xf923, 
0xf92f, 
0xf93b, 
0xf946, 
0xf951, 
0xf95d, 
0xf968, 
0xf973, 
0xf97f, 
0xf98a, 
0xf995, 
0xf9a0, 
0xf9ab, 
0xf9b7, 
0xf9c2, 
0xf9cd, 
0xf9d8, 
0xf9e3, 
0xf9ed, 
0xf9f8, 
0xfa03, 
0xfa0e, 
0xfa19, 
0xfa23, 
0xfa2e, 
0xfa39, 
0xfa43, 
0xfa4e, 
0xfa58, 
0xfa63, 
0xfa6d, 
0xfa78, 
0xfa82, 
0xfa8c, 
0xfa97, 
0xfaa1, 
0xfaab, 
0xfab5, 
0xfac0, 
0xfaca, 
0xfad4, 
0xfade, 
0xfae8, 
0xfaf2, 
0xfafc, 
0xfb05, 
0xfb0f, 
0xfb19, 
0xfb23, 
0xfb2d, 
0xfb36, 
0xfb40, 
0xfb4a, 
0xfb53, 
0xfb5d, 
0xfb66, 
0xfb70, 
0xfb79, 
0xfb83, 
0xfb8c, 
0xfb95, 
0xfb9e, 
0xfba8, 
0xfbb1, 
0xfbba, 
0xfbc3, 
0xfbcc, 
0xfbd5, 
0xfbde, 
0xfbe7, 
0xfbf0, 
0xfbf9, 
0xfc02, 
0xfc0b, 
0xfc14, 
0xfc1c, 
0xfc25, 
0xfc2e, 
0xfc36, 
0xfc3f, 
0xfc47, 
0xfc50, 
0xfc58, 
0xfc61, 
0xfc69, 
0xfc72, 
0xfc7a, 
0xfc82, 
0xfc8b, 
0xfc93, 
0xfc9b, 
0xfca3, 
0xfcab, 
0xfcb3, 
0xfcbb, 
0xfcc3, 
0xfccb, 
0xfcd3, 
0xfcdb, 
0xfce3, 
0xfceb, 
0xfcf2, 
0xfcfa, 
0xfd02, 
0xfd09, 
0xfd11, 
0xfd19, 
0xfd20, 
0xfd28, 
0xfd2f, 
0xfd36, 
0xfd3e, 
0xfd45, 
0xfd4c, 
0xfd54, 
0xfd5b, 
0xfd62, 
0xfd69, 
0xfd70, 
0xfd77, 
0xfd7f, 
0xfd86, 
0xfd8c, 
0xfd93, 
0xfd9a, 
0xfda1, 
0xfda8, 
0xfdaf, 
0xfdb5, 
0xfdbc, 
0xfdc3, 
0xfdc9, 
0xfdd0, 
0xfdd6, 
0xfddd, 
0xfde3, 
0xfdea, 
0xfdf0, 
0xfdf7, 
0xfdfd, 
0xfe03, 
0xfe09, 
0xfe10, 
0xfe16, 
0xfe1c, 
0xfe22, 
0xfe28, 
0xfe2e, 
0xfe34, 
0xfe3a, 
0xfe40, 
0xfe46, 
0xfe4b, 
0xfe51, 
0xfe57, 
0xfe5d, 
0xfe62, 
0xfe68, 
0xfe6d, 
0xfe73, 
0xfe78, 
0xfe7e, 
0xfe83, 
0xfe89, 
0xfe8e, 
0xfe93, 
0xfe99, 
0xfe9e, 
0xfea3, 
0xfea8, 
0xfead, 
0xfeb2, 
0xfeb7, 
0xfebc, 
0xfec1, 
0xfec6, 
0xfecb, 
0xfed0, 
0xfed5, 
0xfeda, 
0xfede, 
0xfee3, 
0xfee8, 
0xfeec, 
0xfef1, 
0xfef6, 
0xfefa, 
0xfeff, 
0xff03, 
0xff07, 
0xff0c, 
0xff10, 
0xff14, 
0xff19, 
0xff1d, 
0xff21, 
0xff25, 
0xff29, 
0xff2d, 
0xff31, 
0xff35, 
0xff39, 
0xff3d, 
0xff41, 
0xff45, 
0xff48, 
0xff4c, 
0xff50, 
0xff53, 
0xff57, 
0xff5b, 
0xff5e, 
0xff62, 
0xff65, 
0xff69, 
0xff6c, 
0xff6f, 
0xff73, 
0xff76, 
0xff79, 
0xff7c, 
0xff80, 
0xff83, 
0xff86, 
0xff89, 
0xff8c, 
0xff8f, 
0xff92, 
0xff95, 
0xff97, 
0xff9a, 
0xff9d, 
0xffa0, 
0xffa2, 
0xffa5, 
0xffa8, 
0xffaa, 
0xffad, 
0xffaf, 
0xffb2, 
0xffb4, 
0xffb7, 
0xffb9, 
0xffbb, 
0xffbe, 
0xffc0, 
0xffc2, 
0xffc4, 
0xffc6, 
0xffc8, 
0xffca, 
0xffcc, 
0xffce, 
0xffd0, 
0xffd2, 
0xffd4, 
0xffd6, 
0xffd8, 
0xffd9, 
0xffdb, 
0xffdd, 
0xffde, 
0xffe0, 
0xffe1, 
0xffe3, 
0xffe4, 
0xffe6, 
0xffe7, 
0xffe9, 
0xffea, 
0xffeb, 
0xffec, 
0xffee, 
0xffef, 
0xfff0, 
0xfff1, 
0xfff2, 
0xfff3, 
0xfff4, 
0xfff5, 
0xfff6, 
0xfff7, 
0xfff7, 
0xfff8, 
0xfff9, 
0xfffa, 
0xfffa, 
0xfffb, 
0xfffb, 
0xfffc, 
0xfffc, 
0xfffd, 
0xfffd, 
0xfffe, 
0xfffe, 
0xfffe, 
0xffff, 
0xffff, 
0xffff, 
0xffff, 
0xffff, 
0xffff, 
0xffff};

U32 gSinflt_2048_rise[2048] = {
0x001921fb,
0x004b65f1,
0x007da9e4,
0x00afedd1,
0x00e231b9,
0x01147597,
0x0146b96b,
0x0178fd32,
0x01ab40ea,
0x01dd8492,
0x020fc828,
0x02420ba9,
0x02744f14,
0x02a69267,
0x02d8d5a0,
0x030b18bc,
0x033d5bbb,
0x036f9e9a,
0x03a1e156,
0x03d423ef,
0x04066662,
0x0438a8ad,
0x046aeacf,
0x049d2cc5,
0x04cf6e8d,
0x0501b026,
0x0533f18e,
0x056632c2,
0x059873c1,
0x05cab489,
0x05fcf517,
0x062f356b,
0x06617581,
0x0693b559,
0x06c5f4ef,
0x06f83443,
0x072a7352,
0x075cb21a,
0x078ef09a,
0x07c12ecf,
0x07f36cb7,
0x0825aa51,
0x0857e79a,
0x088a2492,
0x08bc6134,
0x08ee9d81,
0x0920d976,
0x09531510,
0x0985504e,
0x09b78b2f,
0x09e9c5af,
0x0a1bffce,
0x0a4e3989,
0x0a8072de,
0x0ab2abcc,
0x0ae4e450,
0x0b171c68,
0x0b495413,
0x0b7b8b4e,
0x0badc219,
0x0bdff870,
0x0c122e52,
0x0c4463bc,
0x0c7698ae,
0x0ca8cd24,
0x0cdb011e,
0x0d0d3499,
0x0d3f6793,
0x0d719a0a,
0x0da3cbfc,
0x0dd5fd68,
0x0e082e4c,
0x0e3a5ea4,
0x0e6c8e71,
0x0e9ebdaf,
0x0ed0ec5d,
0x0f031a78,
0x0f3547ff,
0x0f6774f1,
0x0f99a14a,
0x0fcbcd09,
0x0ffdf82d,
0x103022b2,
0x10624c98,
0x109475dc,
0x10c69e7c,
0x10f8c677,
0x112aedcb,
0x115d1474,
0x118f3a73,
0x11c15fc4,
0x11f38466,
0x1225a857,
0x1257cb95,
0x1289ee1d,
0x12bc0fef,
0x12ee3108,
0x13205166,
0x13527107,
0x13848fea,
0x13b6ae0c,
0x13e8cb6b,
0x141ae806,
0x144d03da,
0x147f1ee6,
0x14b13928,
0x14e3529d,
0x15156b45,
0x1547831c,
0x15799a21,
0x15abb052,
0x15ddc5ae,
0x160fda31,
0x1641eddb,
0x167400a9,
0x16a6129a,
0x16d823ab,
0x170a33db,
0x173c4327,
0x176e518e,
0x17a05f0d,
0x17d26ba4,
0x1804774f,
0x1836820d,
0x18688bdc,
0x189a94bb,
0x18cc9ca6,
0x18fea39d,
0x1930a99d,
0x1962aea5,
0x1994b2b2,
0x19c6b5c2,
0x19f8b7d4,
0x1a2ab8e6,
0x1a5cb8f5,
0x1a8eb801,
0x1ac0b606,
0x1af2b303,
0x1b24aef6,
0x1b56a9de,
0x1b88a3b7,
0x1bba9c81,
0x1bec9439,
0x1c1e8add,
0x1c50806c,
0x1c8274e4,
0x1cb46842,
0x1ce65a85,
0x1d184baa,
0x1d4a3bb1,
0x1d7c2a96,
0x1dae1858,
0x1de004f6,
0x1e11f06c,
0x1e43daba,
0x1e75c3dd,
0x1ea7abd3,
0x1ed9929b,
0x1f0b7833,
0x1f3d5c98,
0x1f6f3fc8,
0x1fa121c3,
0x1fd30285,
0x2004e20d,
0x2036c059,
0x20689d68,
0x209a7936,
0x20cc53c2,
0x20fe2d0b,
0x2130050f,
0x2161dbca,
0x2193b13c,
0x21c58563,
0x21f7583d,
0x222929c7,
0x225afa00,
0x228cc8e6,
0x22be9677,
0x22f062b1,
0x23222d93,
0x2353f719,
0x2385bf43,
0x23b7860e,
0x23e94b79,
0x241b0f82,
0x244cd226,
0x247e9363,
0x24b05339,
0x24e211a4,
0x2513cea4,
0x25458a35,
0x25774457,
0x25a8fd07,
0x25dab443,
0x260c6a09,
0x263e1e58,
0x266fd12e,
0x26a18288,
0x26d33265,
0x2704e0c3,
0x27368da0,
0x276838f9,
0x2799e2ce,
0x27cb8b1c,
0x27fd31e1,
0x282ed71b,
0x28607ac9,
0x28921ce9,
0x28c3bd78,
0x28f55c74,
0x2926f9dd,
0x295895af,
0x298a2fe9,
0x29bbc889,
0x29ed5f8d,
0x2a1ef4f4,
0x2a5088ba,
0x2a821ae0,
0x2ab3ab61,
0x2ae53a3d,
0x2b16c772,
0x2b4852fd,
0x2b79dcde,
0x2bab6511,
0x2bdceb95,
0x2c0e7068,
0x2c3ff389,
0x2c7174f5,
0x2ca2f4aa,
0x2cd472a6,
0x2d05eee9,
0x2d37696e,
0x2d68e236,
0x2d9a593d,
0x2dcbce82,
0x2dfd4204,
0x2e2eb3bf,
0x2e6023b2,
0x2e9191dc,
0x2ec2fe3a,
0x2ef468cb,
0x2f25d18c,
0x2f57387c,
0x2f889d99,
0x2fba00e1,
0x2feb6251,
0x301cc1e9,
0x304e1fa6,
0x307f7b85,
0x30b0d587,
0x30e22da8,
0x311383e6,
0x3144d840,
0x31762ab4,
0x31a77b3f,
0x31d8c9e0,
0x320a1696,
0x323b615e,
0x326caa35,
0x329df11c,
0x32cf360e,
0x3300790b,
0x3331ba11,
0x3362f91e,
0x3394362f,
0x33c57143,
0x33f6aa58,
0x3427e16d,
0x3459167f,
0x348a498c,
0x34bb7a92,
0x34eca990,
0x351dd684,
0x354f016b,
0x35802a45,
0x35b1510e,
0x35e275c5,
0x36139869,
0x3644b8f7,
0x3675d76d,
0x36a6f3ca,
0x36d80e0b,
0x3709262f,
0x373a3c34,
0x376b5018,
0x379c61d8,
0x37cd7174,
0x37fe7eea,
0x382f8a36,
0x38609358,
0x38919a4e,
0x38c29f15,
0x38f3a1ac,
0x3924a211,
0x3955a042,
0x39869c3d,
0x39b79601,
0x39e88d8b,
0x3a1982d9,
0x3a4a75ea,
0x3a7b66bb,
0x3aac554b,
0x3add4199,
0x3b0e2ba1,
0x3b3f1362,
0x3b6ff8db,
0x3ba0dc09,
0x3bd1bceb,
0x3c029b7e,
0x3c3377c1,
0x3c6451b1,
0x3c95294e,
0x3cc5fe95,
0x3cf6d184,
0x3d27a219,
0x3d587052,
0x3d893c2f,
0x3dba05ac,
0x3deaccc7,
0x3e1b9180,
0x3e4c53d3,
0x3e7d13c0,
0x3eadd144,
0x3ede8c5d,
0x3f0f450a,
0x3f3ffb49,
0x3f70af17,
0x3fa16073,
0x3fd20f5b,
0x4002bbcd,
0x403365c8,
0x40640d49,
0x4094b24e,
0x40c554d6,
0x40f5f4df,
0x41269266,
0x41572d6b,
0x4187c5ea,
0x41b85be3,
0x41e8ef53,
0x42198039,
0x424a0e92,
0x427a9a5e,
0x42ab2399,
0x42dbaa42,
0x430c2e57,
0x433cafd6,
0x436d2ebe,
0x439dab0c,
0x43ce24bf,
0x43fe9bd5,
0x442f104c,
0x445f8221,
0x448ff154,
0x44c05de3,
0x44f0c7ca,
0x45212f0a,
0x4551939f,
0x4581f587,
0x45b254c2,
0x45e2b14d,
0x46130b26,
0x4643624c,
0x4673b6bc,
0x46a40875,
0x46d45775,
0x4704a3b9,
0x4734ed41,
0x4765340a,
0x47957812,
0x47c5b958,
0x47f5f7d9,
0x48263394,
0x48566c87,
0x4886a2b0,
0x48b6d60d,
0x48e7069d,
0x4917345d,
0x49475f4c,
0x49778767,
0x49a7acae,
0x49d7cf1d,
0x4a07eeb4,
0x4a380b70,
0x4a68254f,
0x4a983c51,
0x4ac85071,
0x4af861b0,
0x4b28700b,
0x4b587b80,
0x4b88840e,
0x4bb889b2,
0x4be88c6a,
0x4c188c36,
0x4c488912,
0x4c7882fe,
0x4ca879f7,
0x4cd86dfb,
0x4d085f09,
0x4d384d1e,
0x4d68383a,
0x4d982059,
0x4dc8057b,
0x4df7e79d,
0x4e27c6bd,
0x4e57a2da,
0x4e877bf2,
0x4eb75203,
0x4ee7250b,
0x4f16f508,
0x4f46c1f9,
0x4f768bdb,
0x4fa652ad,
0x4fd6166c,
0x5005d718,
0x503594ae,
0x50654f2c,
0x50950691,
0x50c4badb,
0x50f46c07,
0x51241a15,
0x5153c501,
0x51836ccb,
0x51b31171,
0x51e2b2f0,
0x52125147,
0x5241ec74,
0x52718475,
0x52a11948,
0x52d0aaec,
0x5300395f,
0x532fc49e,
0x535f4ca8,
0x538ed17c,
0x53be5317,
0x53edd177,
0x541d4c9b,
0x544cc480,
0x547c3926,
0x54abaa8a,
0x54db18aa,
0x550a8385,
0x5539eb18,
0x55694f63,
0x5598b062,
0x55c80e14,
0x55f76878,
0x5626bf8c,
0x5656134d,
0x568563ba,
0x56b4b0d1,
0x56e3fa90,
0x571340f6,
0x57428400,
0x5771c3ae,
0x57a0fffc,
0x57d038e9,
0x57ff6e73,
0x582ea099,
0x585dcf59,
0x588cfab1,
0x58bc229e,
0x58eb4720,
0x591a6835,
0x594985d9,
0x5978a00d,
0x59a7b6ce,
0x59d6ca19,
0x5a05d9ee,
0x5a34e64b,
0x5a63ef2d,
0x5a92f493,
0x5ac1f67b,
0x5af0f4e4,
0x5b1fefcb,
0x5b4ee72e,
0x5b7ddb0d,
0x5baccb64,
0x5bdbb833,
0x5c0aa176,
0x5c39872e,
0x5c686957,
0x5c9747f1,
0x5cc622f8,
0x5cf4fa6c,
0x5d23ce4a,
0x5d529e91,
0x5d816b3f,
0x5db03453,
0x5ddef9c9,
0x5e0dbba1,
0x5e3c79d9,
0x5e6b346f,
0x5e99eb61,
0x5ec89ead,
0x5ef74e51,
0x5f25fa4d,
0x5f54a29d,
0x5f834741,
0x5fb1e835,
0x5fe0857a,
0x600f1f0c,
0x603db4ea,
0x606c4712,
0x609ad582,
0x60c96039,
0x60f7e735,
0x61266a74,
0x6154e9f4,
0x618365b3,
0x61b1ddb0,
0x61e051e9,
0x620ec25b,
0x623d2f06,
0x626b97e7,
0x6299fcfd,
0x62c85e46,
0x62f6bbc0,
0x63251569,
0x63536b3f,
0x6381bd42,
0x63b00b6e,
0x63de55c2,
0x640c9c3d,
0x643adedc,
0x64691d9e,
0x64975881,
0x64c58f83,
0x64f3c2a2,
0x6521f1dd,
0x65501d33,
0x657e44a0,
0x65ac6823,
0x65da87bb,
0x6608a366,
0x6636bb21,
0x6664ceec,
0x6692dec5,
0x66c0eaa8,
0x66eef296,
0x671cf68c,
0x674af688,
0x6778f289,
0x67a6ea8c,
0x67d4de91,
0x6802ce95,
0x6830ba96,
0x685ea293,
0x688c8689,
0x68ba6678,
0x68e8425d,
0x69161a37,
0x6943ee04,
0x6971bdc2,
0x699f896f,
0x69cd510a,
0x69fb1490,
0x6a28d400,
0x6a568f59,
0x6a844698,
0x6ab1f9bc,
0x6adfa8c3,
0x6b0d53ab,
0x6b3afa72,
0x6b689d18,
0x6b963b99,
0x6bc3d5f4,
0x6bf16c28,
0x6c1efe32,
0x6c4c8c11,
0x6c7a15c3,
0x6ca79b47,
0x6cd51c9a,
0x6d0299bb,
0x6d3012a9,
0x6d5d8760,
0x6d8af7e1,
0x6db86428,
0x6de5cc34,
0x6e133003,
0x6e408f95,
0x6e6deae6,
0x6e9b41f5,
0x6ec894c0,
0x6ef5e346,
0x6f232d85,
0x6f50737b,
0x6f7db527,
0x6faaf286,
0x6fd82b97,
0x70056058,
0x703290c7,
0x705fbce4,
0x708ce4ab,
0x70ba081b,
0x70e72733,
0x711441f0,
0x71415851,
0x716e6a55,
0x719b77f9,
0x71c8813b,
0x71f5861b,
0x72228696,
0x724f82ab,
0x727c7a57,
0x72a96d9a,
0x72d65c70,
0x730346da,
0x73302cd4,
0x735d0e5d,
0x7389eb74,
0x73b6c416,
0x73e39843,
0x741067f7,
0x743d3333,
0x7469f9f2,
0x7496bc35,
0x74c379fa,
0x74f0333d,
0x751ce7ff,
0x7549983d,
0x757643f5,
0x75a2eb26,
0x75cf8dce,
0x75fc2beb,
0x7628c57c,
0x76555a7e,
0x7681eaf1,
0x76ae76d2,
0x76dafe20,
0x770780d8,
0x7733fefa,
0x77607884,
0x778ced73,
0x77b95dc6,
0x77e5c97b,
0x78123092,
0x783e9307,
0x786af0d9,
0x78974a07,
0x78c39e8f,
0x78efee6f,
0x791c39a5,
0x79488030,
0x7974c20e,
0x79a0ff3d,
0x79cd37bc,
0x79f96b89,
0x7a259aa2,
0x7a51c505,
0x7a7deab1,
0x7aaa0ba4,
0x7ad627dd,
0x7b023f59,
0x7b2e5217,
0x7b5a6015,
0x7b866952,
0x7bb26dcc,
0x7bde6d80,
0x7c0a686f,
0x7c365e95,
0x7c624ff1,
0x7c8e3c82,
0x7cba2445,
0x7ce60739,
0x7d11e55d,
0x7d3dbeae,
0x7d69932b,
0x7d9562d2,
0x7dc12da2,
0x7decf399,
0x7e18b4b5,
0x7e4470f4,
0x7e702855,
0x7e9bdad6,
0x7ec78876,
0x7ef33132,
0x7f1ed50a,
0x7f4a73fb,
0x7f760e03,
0x7fa1a322,
0x7fcd3354,
0x7ff8be9a,
0x80244688,
0x804fc740,
0x807b4410,
0x80a6b910,
0x80d22e10,
0x80fd9b40,
0x81290488,
0x81546600,
0x817fc390,
0x81ab1d38,
0x81d672f8,
0x8201c4d0,
0x822d0ed8,
0x825854f8,
0x82839348,
0x82aecdb0,
0x82da0430,
0x830536c8,
0x83306578,
0x835b8c58,
0x8386af50,
0x83b1ca78,
0x83dce1b8,
0x8407f510,
0x84330480,
0x845e0c20,
0x84890fd8,
0x84b40fa8,
0x84df07a8,
0x8509fbc0,
0x8534ebf0,
0x855fd838,
0x858abcb0,
0x85b59d40,
0x85e07600,
0x860b4ad8,
0x86361bc8,
0x8660e8d0,
0x868bae08,
0x86b66f58,
0x86e128d8,
0x870bde70,
0x87369020,
0x87613de8,
0x878be3e0,
0x87b685f0,
0x87e12418,
0x880bba70,
0x88364ce0,
0x8860d780,
0x888b5e38,
0x88b5e108,
0x88e05ff0,
0x890ad708,
0x89354650,
0x895fb598,
0x898a1d10,
0x89b480a0,
0x89dedc60,
0x8a093438,
0x8a338828,
0x8a5dd448,
0x8a881c80,
0x8ab25ce8,
0x8adc9968,
0x8b06d200,
0x8b3102c8,
0x8b5b3390,
0x8b8558a0,
0x8baf79c8,
0x8bd99708,
0x8c03b060,
0x8c2dc1e8,
0x8c57cf88,
0x8c81d558,
0x8cabd740,
0x8cd5d540,
0x8cffcb70,
0x8d29bdb8,
0x8d53a830,
0x8d7d8ec0,
0x8da77168,
0x8dd14c40,
0x8dfb2330,
0x8e24f250,
0x8e4ebd88,
0x8e7884d8,
0x8ea24458,
0x8ecbfff0,
0x8ef5b3b8,
0x8f1f6398,
0x8f490f90,
0x8f72b3b8,
0x8f9c53f8,
0x8fc5ec68,
0x8fef80f0,
0x90191190,
0x90429a60,
0x906c1b60,
0x90959878,
0x90bf11a8,
0x90e886f0,
0x9111f468,
0x913b5a10,
0x9164bbd0,
0x918e19a8,
0x91b76fb0,
0x91e0c1d0,
0x920a0c20,
0x92335288,
0x925c9120,
0x9285cbd0,
0x92af0298,
0x92d83190,
0x93015ca0,
0x932a7fe0,
0x93539f38,
0x937cb6c0,
0x93a5ca60,
0x93ced630,
0x93f7de18,
0x9420de30,
0x9449da60,
0x9472d2a8,
0x949bc320,
0x94c4afb0,
0x94ed9470,
0x95167160,
0x953f4e50,
0x95681f88,
0x9590f0c0,
0x95b9b640,
0x95e27bc0,
0x960b3588,
0x9633ef50,
0x965ca148,
0x96854b70,
0x96adf1b0,
0x96d69020,
0x96ff2aa8,
0x9727bd60,
0x97504c30,
0x9778d718,
0x97a15a30,
0x97c9d578,
0x97f24cd8,
0x981ac050,
0x98432810,
0x986b8fd0,
0x9893efc0,
0x98bc47e0,
0x98e49c18,
0x990cec68,
0x99353100,
0x995d7598,
0x9985b260,
0x99ade758,
0x99d61868,
0x99fe41a8,
0x9a266700,
0x9a4e8488,
0x9a769e28,
0x9a9eaff8,
0x9ac6bde0,
0x9aeec3f8,
0x9b16c628,
0x9b3ec088,
0x9b66b318,
0x9b8ea1c0,
0x9bb68c80,
0x9bde6f70,
0x9c064a90,
0x9c2e21c8,
0x9c55f518,
0x9c7dbcb0,
0x9ca58448,
0x9ccd4028,
0x9cf4fc08,
0x9d1cac30,
0x9d445870,
0x9d6c00c8,
0x9d93a150,
0x9dbb3a08,
0x9de2ced8,
0x9e0a5bd8,
0x9e31e4f0,
0x9e596638,
0x9e80e398,
0x9ea85928,
0x9ecfc6e8,
0x9ef730c0,
0x9f1e96b0,
0x9f45f4d0,
0x9f6d4b20,
0x9f9499a0,
0x9fbbe438,
0x9fe32ae8,
0xa00a69c8,
0xa031a0d8,
0xa058d400,
0xa07fff58,
0xa0a726c8,
0xa0ce4668,
0xa0f55e38,
0xa11c7220,
0xa1437e38,
0xa16a8668,
0xa19186c8,
0xa1b87f58,
0xa1df7400,
0xa20660d8,
0xa22d49c8,
0xa2542ae8,
0xa27b0438,
0xa2a1d9a0,
0xa2c8ab20,
0xa2ef70e8,
0xa31632c8,
0xa33cf0c0,
0xa363a300,
0xa38a5540,
0xa3b0fbc8,
0xa3d79e68,
0xa3fe3938,
0xa424d020,
0xa44b5f38,
0xa471ea68,
0xa4986dc8,
0xa4bee958,
0xa4e56100,
0xa50bd0d8,
0xa53238e0,
0xa5589d00,
0xa57ef950,
0xa5a54dd0,
0xa5cb9e68,
0xa5f1e730,
0xa6182c10,
0xa63e6920,
0xa6649e60,
0xa68acfb8,
0xa6b0f940,
0xa6d71af8,
0xa6fd38c8,
0xa7234ec8,
0xa7495cf8,
0xa76f6740,
0xa79569b8,
0xa7bb6460,
0xa7e15b20,
0xa8074a10,
0xa82d3518,
0xa8531468,
0xa878f3b8,
0xa89ec750,
0xa8c49700,
0xa8ea5ee0,
0xa91022d8,
0xa935db18,
0xa95b9358,
0xa9813fe0,
0xa9a6e880,
0xa9cc8950,
0xa9f22250,
0xaa17b768,
0xaa3d44b0,
0xaa62ce10,
0xaa884bb8,
0xaaadc578,
0xaad33b50,
0xaaf8a958,
0xab1e0f90,
0xab436df8,
0xab68c490,
0xab8e1740,
0xabb36608,
0xabd8a918,
0xabfde840,
0xac231f98,
0xac485308,
0xac6d7ac0,
0xac929e90,
0xacb7be78,
0xacdcd2a8,
0xad01e2f0,
0xad26eb68,
0xad4beff8,
0xad70ecb8,
0xad95e1a8,
0xadbacec8,
0xaddfb800,
0xae049968,
0xae297300,
0xae4e48b0,
0xae7312a8,
0xae97d8b8,
0xaebc9ae0,
0xaee15150,
0xaf0603d8,
0xaf2aae90,
0xaf4f5560,
0xaf73f460,
0xaf988b90,
0xafbd1af0,
0xafe1a280,
0xb0062628,
0xb02aa200,
0xb04f1608,
0xb0738628,
0xb097ee78,
0xb0bc4ef8,
0xb0e0a7a8,
0xb104fc70,
0xb1294968,
0xb14d8e90,
0xb171cbe8,
0xb1960558,
0xb1ba3310,
0xb1de60c8,
0xb20282c8,
0xb2269cf8,
0xb24ab340,
0xb26ec1b8,
0xb292cc48,
0xb2b6cb20,
0xb2dac610,
0xb2feb930,
0xb322a480,
0xb3468800,
0xb36a6798,
0xb38e3f60,
0xb3b20f58,
0xb3d5db68,
0xb3f99bc0,
0xb41d5830,
0xb4410cd0,
0xb464b9a0,
0xb4886288,
0xb4ac03a0,
0xb4cf9900,
0xb4f32e60,
0xb516b808,
0xb53a3dc8,
0xb55db7d0,
0xb5812df0,
0xb5a49c40,
0xb5c806a8,
0xb5eb6558,
0xb60ec020,
0xb6321318,
0xb6556228,
0xb678a580,
0xb69be4f0,
0xb6bf18a8,
0xb6e24878,
0xb7057460,
0xb7289490,
0xb74bb0d8,
0xb76ec168,
0xb791ce10,
0xb7b4d2e8,
0xb7d7d3d8,
0xb7fac910,
0xb81dba60,
0xb840a3e0,
0xb8638590,
0xb8865f70,
0xb8a93568,
0xb8cbffa8,
0xb8eec600,
0xb9118488,
0xb9343b40,
0xb956ee10,
0xb9799528,
0xb99c3858,
0xb9bed3b8,
0xb9e16748,
0xba03f308,
0xba2676f8,
0xba48f318,
0xba6b6b50,
0xba8ddbb8,
0xbab04450,
0xbad2a518,
0xbaf4fe10,
0xbb175320,
0xbb399c78,
0xbb5be1e8,
0xbb7e1f88,
0xbba05558,
0xbbc28358,
0xbbe4a988,
0xbc06cbd0,
0xbc28e648,
0xbc4af508,
0xbc6cffe0,
0xbc8f02e8,
0xbcb0fe20,
0xbcd2f570,
0xbcf4e108,
0xbd16c8b8,
0xbd38a898,
0xbd5a7cc0,
0xbd7c4d00,
0xbd9e1570,
0xbdbfd9f8,
0xbde192c8,
0xbe0347b0,
0xbe24f0e0,
0xbe469628,
0xbe6833a0,
0xbe89c948,
0xbeab5720,
0xbeccdd28,
0xbeee5f48,
0xbf0fd5b0,
0xbf314830,
0xbf52aef8,
0xbf7411d8,
0xbf956ce8,
0xbfb6c028,
0xbfd80b98,
0xbff94f38,
0xc01a8ef0,
0xc03bc2f0,
0xc05cf308,
0xc07e1768,
0xc09f37e0,
0xc0c05088,
0xc0e16160,
0xc1026a68,
0xc1236ba0,
0xc1446508,
0xc1655a88,
0xc1864450,
0xc1a72a30,
0xc1c80458,
0xc1e8da98,
0xc209a908,
0xc22a6bc0,
0xc24b2a90,
0xc26be190,
0xc28c94a8,
0xc2ad3c08,
0xc2cddb98,
0xc2ee7358,
0xc30f0730,
0xc32f8f50,
0xc3501388,
0xc3708c08,
0xc39100a0,
0xc3b16d68,
0xc3d1d260,
0xc3f22f88,
0xc41284e0,
0xc432d268,
0xc4531820,
0xc4735608,
0xc4938c20,
0xc4b3ba68,
0xc4d3e4c8,
0xc4f40370,
0xc5141e30,
0xc5342d38,
0xc5543858,
0xc57437c0,
0xc5943340,
0xc5b426f0,
0xc5d40ee8,
0xc5f3f2f8,
0xc613cf38,
0xc633a3a8,
0xc6537048,
0xc6733518,
0xc692f218,
0xc6b2a748,
0xc6d254a8,
0xc6f1fa38,
0xc7119be0,
0xc73131d0,
0xc750bff0,
0xc7704640,
0xc78fc8a8,
0xc7af3f58,
0xc7ceae38,
0xc7ee1930,
0xc80d7870,
0xc82cd3c8,
0xc84c2368,
0xc86b6f20,
0xc88aaf20,
0xc8a9eb38,
0xc8c91b98,
0xc8e84810,
0xc9076cb8,
0xc92685a8,
0xc9459ab0,
0xc964a7e8,
0xc983a968,
0xc9a2a700,
0xc9c19cc8,
0xc9e086d8,
0xc9ff6d00,
0xca1e4b58,
0xca3d1df8,
0xca5becb0,
0xca7ab398,
0xca9972b0,
0xcab82610,
0xcad6d588,
0xcaf57d30,
0xcb141920,
0xcb32b128,
0xcb514160,
0xcb6fc9c8,
0xcb8e4678,
0xcbacbf40,
0xcbcb3038,
0xcbe99578,
0xcc07f6d0,
0xcc265058,
0xcc449e28,
0xcc62e810,
0xcc812640,
0xcc9f6088,
0xccbd8f18,
0xccdbb9c0,
0xccf9d8b0,
0xcd17f3b8,
0xcd360308,
0xcd540e70,
0xcd720e20,
0xcd9009e8,
0xcdadf9f8,
0xcdcbe238,
0xcde9c690,
0xce079f30,
0xce257000,
0xce433900,
0xce60fa30,
0xce7eb778,
0xce9c6908,
0xceba12c8,
0xced7b4b8,
0xcef54ed8,
0xcf12e128,
0xcf3067c0,
0xcf4dea70,
0xcf6b6550,
0xcf88d860,
0xcfa63fb8,
0xcfc3a328,
0xcfe0fec8,
0xcffe4eb0,
0xd01b9ab0,
0xd038daf8,
0xd0561370,
0xd0734800,
0xd09070d8,
0xd0ad91e0,
0xd0caab18,
0xd0e7bc80,
0xd104ca00,
0xd121c7e0,
0xd13ec1d8,
0xd15bb400,
0xd1789e58,
0xd19580e0,
0xd1b257b0,
0xd1cf2a98,
0xd1ebf1c8,
0xd208b510,
0xd2256ca0,
0xd2421c60,
0xd25ec838,
0xd27b6858,
0xd29800a8,
0xd2b49128,
0xd2d115f0,
0xd2ed96d0,
0xd30a0fe0,
0xd3268120,
0xd342e6a8,
0xd35f4848,
0xd37b9e30,
0xd397ec48,
0xd3b43678,
0xd3d074f0,
0xd3ecab98,
0xd408da70,
0xd424fd90,
0xd4411cc8,
0xd45d3430,
0xd4793fe0,
0xd49547a8,
0xd4b143b8,
0xd4cd37f8,
0xd4e92850,
0xd5050cf0,
0xd520e9c0,
0xd53cbad8,
0xd5588808,
0xd5744d68,
0xd5900710,
0xd5abbcd0,
0xd5c766d8,
0xd5e30910,
0xd5fea378,
0xd61a3610,
0xd635c0d8,
0xd65143d0,
0xd66cbef8,
0xd6882e68,
0xd6a399f0,
0xd6bef9c0,
0xd6da51c0,
0xd6f5a1f0,
0xd710ea50,
0xd72c2ae0,
0xd74763a0,
0xd76290a8,
0xd77db9c8,
0xd798d730,
0xd7b3ecc8,
0xd7cefa90,
0xd7ea0088,
0xd804feb0,
0xd81ff120,
0xd83adfa8,
0xd855c278,
0xd870a160,
0xd88b7490,
0xd8a63ff0,
0xd8c10380,
0xd8dbbb58,
0xd8f66f48,
0xd9111780,
0xd92bbbd0,
0xd9465468,
0xd960e530,
0xd97b6a40,
0xd995eb68,
0xd9b064c0,
0xd9cad260,
0xd9e53830,
0xd9ff9630,
0xda19ec60,
0xda343ac0,
0xda4e8150,
0xda68bc28,
0xda82f318,
0xda9d1e50,
0xdab741b8,
0xdad15d50,
0xdaeb6d30,
0xdb057928,
0xdb1f7968,
0xdb3975c0,
0xdb536660,
0xdb6d4f30,
0xdb872c48,
0xdba10578,
0xdbbad2f0,
0xdbd49898,
0xdbee5670,
0xdc080c78,
0xdc21bab0,
0xdc3b6118,
0xdc54fbc8,
0xdc6e8ea8,
0xdc8819b8,
0xdca19cf8,
0xdcbb1868,
0xdcd48820,
0xdcedf008,
0xdd075408,
0xdd20ac50,
0xdd39f8e0,
0xdd534188,
0xdd6c7e78,
0xdd85b398,
0xdd9ee0e8,
0xddb80668,
0xddd12418,
0xddea3610,
0xde034420,
0xde1c4678,
0xde354100,
0xde4e2fd0,
0xde671ab8,
0xde7ff9e8,
0xde98d148,
0xdeb1a0d8,
0xdeca6898,
0xdee324a0,
0xdefbdcc0,
0xdf148928,
0xdf2d2dc0,
0xdf45c6a0,
0xdf5e5b98,
0xdf76e4d8,
0xdf8f6648,
0xdfa7dfe8,
0xdfc051b8,
0xdfd8b7d0,
0xdff11618,
0xe0096c90,
0xe021bb38,
0xe03a0210,
0xe0523d30,
0xe06a7468,
0xe0829fe8,
0xe09abfb0,
0xe0b2db90,
0xe0caebb8,
0xe0e2f410,
0xe0faf498,
0xe112ed50,
0xe12ada50,
0xe142c368,
0xe15aa0c8,
0xe1727270,
0xe18a4030,
0xe1a20238,
0xe1b9bc70,
0xe1d16ed8,
0xe1e91970,
0xe200b850,
0xe2184f60,
0xe22fdea0,
0xe2476610,
0xe25ee5b0,
0xe2765998,
0xe28dc5b0,
0xe2a529f8,
0xe2bc8288,
0xe2d3d348,
0xe2eb2020,
0xe3025d58,
0xe31996a8,
0xe330c440,
0xe347ea08,
0xe35f0800,
0xe3761e28,
0xe38d2898,
0xe3a42b38,
0xe3bb2608,
0xe3d21908,
0xe3e90050,
0xe3ffdfc8,
0xe416b770,
0xe42d8748,
0xe4444b68,
0xe45b07b8,
0xe471bc38,
0xe48868e8,
0xe49f09e0,
0xe4b5a308,
0xe4cc3460,
0xe4e2bde8,
0xe4f93bb8,
0xe50fb1b8,
0xe5261fe8,
0xe53c8648,
0xe552e0f0,
0xe56933c8,
0xe57f7ed0,
0xe595be20,
0xe5abf5a0,
0xe5c22550,
0xe5d84d30,
0xe5ee6d40,
0xe6048198,
0xe61a8e20,
0xe6308ef0,
0xe6468bd8,
0xe65c7d08,
0xe6726280,
0xe6884410,
0xe69e19e8,
0xe6b3e7f0,
0xe6c9ae28,
0xe6df68a8,
0xe6f51b58,
0xe70ac638,
0xe7206948,
0xe73600a0,
0xe74b9028,
0xe76117e0,
0xe77693e0,
0xe78c0bf8,
0xe7a17470,
0xe7b6d900,
0xe7cc31d8,
0xe7e182e0,
0xe7f6cc18,
0xe80c0d80,
0xe8214330,
0xe8367110,
0xe84b9338,
0xe860ad90,
0xe875c018,
0xe88acad0,
0xe89fc9d0,
0xe8b4c4e8,
0xe8c9b060,
0xe8de97f0,
0xe8f373c8,
0xe90847d0,
0xe91d1408,
0xe931d488,
0xe9468d38,
0xe95b3e18,
0xe96fe340,
0xe9848098,
0xe9991620,
0xe9ad9ff0,
0xe9c225d8,
0xe9d69c20,
0xe9eb0e80,
0xe9ff7528,
0xea13d400,
0xea282b08,
0xea3c7658,
0xea50b9d8,
0xea64f588,
0xea792580,
0xea8d4da8,
0xeaa16e00,
0xeab58688,
0xeac99358,
0xeadd9470,
0xeaf191a0,
0xeb058318,
0xeb196cc0,
0xeb2d4ab0,
0xeb4124b8,
0xeb54f308,
0xeb68b5a0,
0xeb7c7068,
0xeb902360,
0xeba3ce88,
0xebb76df8,
0xebcb0598,
0xebde9568,
0xebf21980,
0xec0595c8,
0xec190a40,
0xec2c7300,
0xec3fd3f0,
0xec532928,
0xec667a78,
0xec79c010,
0xec8cf9f0,
0xeca02fe8,
0xecb35a28,
0xecc678b0,
0xecd99350,
0xececa238,
0xecffa568,
0xed12a0c8,
0xed259458,
0xed388018,
0xed4b6020,
0xed5e3858,
0xed7108c0,
0xed83cd70,
0xed968a50,
0xeda93b78,
0xedbbe8b8,
0xedce8658,
0xede12010,
0xedf3ae10,
0xee063440,
0xee18aeb8,
0xee2b2160,
0xee3d8c38,
0xee4fef40,
0xee624690,
0xee749228,
0xee86d9d8,
0xee9915d0,
0xeeab4610,
0xeebd7268,
0xeecf8f20,
0xeee1a7f0,
0xeef3b508,
0xef05ba50,
0xef17b7c8,
0xef29a988,
0xef3b8f90,
0xef4d71b0,
0xef5f4818,
0xef7116b0,
0xef82d990,
0xef9494a0,
0xefa647e0,
0xefb7ef68,
0xefc98f20,
0xefdb2320,
0xefecaf50,
0xeffe33b0,
0xf00fac58,
0xf0211d30,
0xf0328638,
0xf043e388,
0xf0553908,
0xf06686b8,
0xf077c8b0,
0xf08902d8,
0xf09a3148,
0xf0ab57e8,
0xf0bc76b8,
0xf0cd89d0,
0xf0de9518,
0xf0ef9890,
0xf1009050,
0xf1118040,
0xf1226478,
0xf13340e0,
0xf1441578,
0xf154de58,
0xf1659f68,
0xf17654c0,
0xf1870248,
0xf197a800,
0xf1a84200,
0xf1b8d430,
0xf1c95e90,
0xf1d9dd38,
0xf1ea5410,
0xf1fabf30,
0xf20b2280,
0xf21b7e00,
0xf22bcdc8,
0xf23c15c0,
0xf24c55e8,
0xf25c8a58,
0xf26cb310,
0xf27cd7e0,
0xf28cf0f8,
0xf29cfe58,
0xf2ad03e8,
0xf2bd01a8,
0xf2ccf3b0,
0xf2dcdde8,
0xf2ecc050,
0xf2fc9700,
0xf30c65e0,
0xf31c2908,
0xf32be460,
0xf33b9400,
0xf34b3bd0,
0xf35adbd0,
0xf36a7018,
0xf379fc90,
0xf3898138,
0xf398fa28,
0xf3a86b48,
0xf3b7d0b0,
0xf3c72e48,
0xf3d68028,
0xf3e5ce20,
0xf3f50c78,
0xf40446e8,
0xf41371b8,
0xf42298a0,
0xf431b3d0,
0xf440c730,
0xf44fced8,
0xf45eceb0,
0xf46dc2d0,
0xf47caf20,
0xf48b93a0,
0xf49a6c68,
0xf4a93978,
0xf4b802a0,
0xf4c6c010,
0xf4d571c8,
0xf4e41bb0,
0xf4f2bdc8,
0xf5015428,
0xf50fe2b8,
0xf51e6978,
0xf52ce480,
0xf53b53d0,
0xf549bb50,
0xf5581b00,
0xf5666ef8,
0xf574bb20,
0xf582ff78,
0xf5913818,
0xf59f6500,
0xf5ad8e00,
0xf5bba760,
0xf5c9bcd8,
0xf5d7c698,
0xf5e5c4a0,
0xf5f3bad8,
0xf601a940,
0xf60f8bf0,
0xf61d66d0,
0xf62b35f8,
0xf638fd50,
0xf646bcd8,
0xf65470a8,
0xf66218c0,
0xf66fbcf0,
0xf67d5180,
0xf68ae228,
0xf6986718,
0xf6a5e050,
0xf6b351b8,
0xf6c0bb50,
0xf6ce1930,
0xf6db6f40,
0xf6e8b998,
0xf6f5fc20,
0xf70332f0,
0xf71061f0,
0xf71d8920,
0xf72aa498,
0xf737b458,
0xf744c030,
0xf751bc68,
0xf75eb4b8,
0xf76ba150,
0xf7788230,
0xf7855b40,
0xf7922c80,
0xf79ef208,
0xf7abafc0,
0xf7b861c0,
0xf7c50bf0,
0xf7d1aa68,
0xf7de4110,
0xf7eacc00,
0xf7f74f20,
0xf803ca70,
0xf8103a08,
0xf81ca1d0,
0xf828fde0,
0xf8355220,
0xf8419aa8,
0xf84ddb60,
0xf85a1060,
0xf8663d90,
0xf87262f0,
0xf87e7c98,
0xf88a8e70,
0xf8969490,
0xf8a28ef8,
0xf8ae8578,
0xf8ba7040,
0xf8c64f50,
0xf8d22690,
0xf8ddf218,
0xf8e9b5d0,
0xf8f571b8,
0xf90121e8,
0xf90cc660,
0xf91866f0,
0xf923f7e0,
0xf92f8100,
0xf93b0250,
0xf9467bd0,
0xf951e5b0,
0xf95d4ba8,
0xf968a5e8,
0xf973f470,
0xf97f3b28,
0xf98a7a10,
0xf995ad40,
0xf9a0d4b8,
0xf9abf848,
0xf9b70c38,
0xf9c21c40,
0xf9cd1ca8,
0xf9d81928,
0xf9e30608,
0xf9edef00,
0xf9f8cc40,
0xfa039dc8,
0xfa0e6780,
0xfa192968,
0xfa23df98,
0xfa2e8a10,
0xfa392cb8,
0xfa43c790,
0xfa4e56b0,
0xfa58de00,
0xfa635998,
0xfa6dcd60,
0xfa783570,
0xfa8295b0,
0xfa8cea38,
0xfa9736f0,
0xfaa177f0,
0xfaabb120,
0xfab5e280,
0xfac00828,
0xfaca2218,
0xfad43438,
0xfade3e88,
0xfae83d20,
0xfaf23000,
0xfafc1b10,
0xfb05fe50,
0xfb0fd5d8,
0xfb19a590,
0xfb236990,
0xfb2d25c0,
0xfb36d638,
0xfb407ee0,
0xfb4a1bd0,
0xfb53b0f0,
0xfb5d3a58,
0xfb66bbf0,
0xfb7031d0,
0xfb799fe0,
0xfb830238,
0xfb8c5cc0,
0xfb95af78,
0xfb9ef678,
0xfba831c0,
0xfbb16538,
0xfbba90e0,
0xfbc3b0d0,
0xfbccc508,
0xfbd5d170,
0xfbded608,
0xfbe7cee8,
0xfbf0bc10,
0xfbf9a168,
0xfc027ef0,
0xfc0b50c0,
0xfc141ac0,
0xfc1cd908,
0xfc258f80,
0xfc2e3a40,
0xfc36d948,
0xfc3f7468,
0xfc47ffe8,
0xfc508398,
0xfc58ff78,
0xfc616fa0,
0xfc69d7f8,
0xfc723498,
0xfc7a8968,
0xfc82d280,
0xfc8b13c8,
0xfc934958,
0xfc9b7718,
0xfca39920,
0xfcabb358,
0xfcb3c5c0,
0xfcbbc888,
0xfcc3c768,
0xfccbb6a8,
0xfcd3a200,
0xfcdb81a0,
0xfce35588,
0xfceb21a0,
0xfcf2e200,
0xfcfa9a90,
0xfd024768,
0xfd09ec70,
0xfd1185c0,
0xfd191740,
0xfd20a0f0,
0xfd281ee8,
0xfd2f9128,
0xfd36fb98,
0xfd3e5a50,
0xfd45b138,
0xfd4cfc68,
0xfd543fc8,
0xfd5b7b58,
0xfd62a748,
0xfd69cf50,
0xfd70eba0,
0xfd77fc38,
0xfd7f0500,
0xfd860210,
0xfd8cf750,
0xfd93e0d8,
0xfd9ac290,
0xfda19c78,
0xfda866c0,
0xfdaf2d20,
0xfdb5e7c8,
0xfdbc96b8,
0xfdc33dd8,
0xfdc9d940,
0xfdd06cd8,
0xfdd6f4b8,
0xfddd74c8,
0xfde3e920,
0xfdea55a8,
0xfdf0b678,
0xfdf70f78,
0xfdfd5cc0,
0xfe03a238,
0xfe09dbf8,
0xfe100de8,
0xfe163420,
0xfe1c5288,
0xfe226538,
0xfe287018,
0xfe2e6f40,
0xfe346698,
0xfe3a5238,
0xfe403608,
0xfe460e20,
0xfe4bde68,
0xfe51a2f8,
0xfe575fb8,
0xfe5d10c0,
0xfe62b610,
0xfe685390,
0xfe6de940,
0xfe737338,
0xfe78f560,
0xfe7e6bd0,
0xfe83d688,
0xfe893970,
0xfe8e9488,
0xfe93e3e8,
0xfe992790,
0xfe9e6368,
0xfea39770,
0xfea8bfc0,
0xfeaddc58,
0xfeb2f120,
0xfeb7fe18,
0xfebcff58,
0xfec1f4e0,
0xfec6e298,
0xfecbc498,
0xfed09ec8,
0xfed57128,
0xfeda33e8,
0xfedef2c0,
0xfee3a5e0,
0xfee84d48,
0xfeecece0,
0xfef180c0,
0xfef60cd0,
0xfefa8d28,
0xfeff01c8,
0xff037280,
0xff07d398,
0xff0c2ce0,
0xff107e58,
0xff14c418,
0xff190208,
0xff1d3440,
0xff215ac0,
0xff257970,
0xff299050,
0xff2d9b78,
0xff319ed0,
0xff359288,
0xff398258,
0xff3d6670,
0xff413ed0,
0xff450f60,
0xff48d820,
0xff4c9140,
0xff504678,
0xff53eff8,
0xff578dc0,
0xff5b23b8,
0xff5eadf8,
0xff623068,
0xff65a720,
0xff691608,
0xff6c7938,
0xff6fd0b0,
0xff732058,
0xff766830,
0xff79a450,
0xff7cd8a0,
0xff800138,
0xff831e18,
0xff863328,
0xff894068,
0xff8c41f0,
0xff8f37c0,
0xff9225c0,
0xff950bf0,
0xff97e280,
0xff9ab528,
0xff9d7c18,
0xffa03750,
0xffa2eab8,
0xffa59268,
0xffa83248,
0xffaac670,
0xffad52c8,
0xffafd368,
0xffb24850,
0xffb4b568,
0xffb71ab0,
0xffb97440,
0xffbbc600,
0xffbe0c08,
0xffc04658,
0xffc278d8,
0xffc4a388,
0xffc6be98,
0xffc8d5c0,
0xffcae130,
0xffcce0e8,
0xffced8d0,
0xffd0c500,
0xffd2a960,
0xffd48208,
0xffd652e0,
0xffd81800,
0xffd9d550,
0xffdb86e8,
0xffdd30b0,
0xffdecec0,
0xffe06118,
0xffe1eba0,
0xffe36e58,
0xffe4e558,
0xffe650a0,
0xffe7b418,
0xffe90fc0,
0xffea5fb0,
0xffeba3e8,
0xffece050,
0xffee1100,
0xffef39e0,
0xfff05708,
0xfff16c60,
0xfff27600,
0xfff377d0,
0xfff46de8,
0xfff55c30,
0xfff63ec0,
0xfff71598,
0xfff7e4a0,
0xfff8abd8,
0xfff96758,
0xfffa1720,
0xfffabf18,
0xfffb5f40,
0xfffbf3b0,
0xfffc7c68,
0xfffcfd50,
0xfffd7280,
0xfffddfe0,
0xfffe4188,
0xfffe9b60,
0xfffee980,
0xffff2fd0,
0xffff6a68,
0xffff9d30,
0xffffc440,
0xffffdf98,
0xfffff320,
0xfffffed8
} ;




U32 gSinflt_1024_rise[1024] = {
0x003243f6,
0x0096cbdb,
0x00fb53a9,
0x015fdb50,
0x01c462c0,
0x0228e9eb,
0x028d70c1,
0x02f1f732,
0x03567d2e,
0x03bb02a7,
0x041f878d,
0x04840bcf,
0x04e88f60,
0x054d122f,
0x05b1942c,
0x06161549,
0x067a9575,
0x06df14a2,
0x074392bf,
0x07a80fbe,
0x080c8b8e,
0x08710620,
0x08d57f66,
0x0939f74e,
0x099e6dca,
0x0a02e2cb,
0x0a675640,
0x0acbc81b,
0x0b30384b,
0x0b94a6c2,
0x0bf9136f,
0x0c5d7e44,
0x0cc1e731,
0x0d264e26,
0x0d8ab314,
0x0def15eb,
0x0e53769c,
0x0eb7d518,
0x0f1c314e,
0x0f808b30,
0x0fe4e2af,
0x104937b9,
0x10ad8a41,
0x1111da36,
0x11762789,
0x11da722b,
0x123eba0c,
0x12a2ff1d,
0x1307414e,
0x136b8090,
0x13cfbcd4,
0x1433f609,
0x14982c20,
0x14fc5f0b,
0x15608eb9,
0x15c4bb1b,
0x1628e422,
0x168d09bd,
0x16f12bdf,
0x17554a77,
0x17b96576,
0x181d7ccc,
0x1881906a,
0x18e5a040,
0x1949ac40,
0x19adb45a,
0x1a11b87d,
0x1a75b89c,
0x1ad9b4a6,
0x1b3dac8c,
0x1ba1a03e,
0x1c058fae,
0x1c697acb,
0x1ccd6187,
0x1d3143d1,
0x1d95219c,
0x1df8fad6,
0x1e5ccf71,
0x1ec09f5d,
0x1f246a8c,
0x1f8830ec,
0x1febf270,
0x204faf08,
0x20b366a5,
0x21171936,
0x217ac6ad,
0x21de6efa,
0x2242120e,
0x22a5afda,
0x2309484d,
0x236cdb5a,
0x23d068f0,
0x2433f100,
0x2497737b,
0x24faf052,
0x255e6774,
0x25c1d8d3,
0x26254460,
0x2688aa0b,
0x26ec09c4,
0x274f637d,
0x27b2b726,
0x281604b0,
0x28794c0b,
0x28dc8d28,
0x293fc7f9,
0x29a2fc6c,
0x2a062a74,
0x2a695201,
0x2acc7304,
0x2b2f8d6d,
0x2b92a12d,
0x2bf5ae35,
0x2c58b476,
0x2cbbb3df,
0x2d1eac63,
0x2d819df2,
0x2de4887c,
0x2e476bf2,
0x2eaa4845,
0x2f0d1d66,
0x2f6feb45,
0x2fd2b1d4,
0x30357103,
0x309828c2,
0x30fad903,
0x315d81b7,
0x31c022cd,
0x3222bc38,
0x32854de7,
0x32e7d7cc,
0x334a59d7,
0x33acd3f9,
0x340f4623,
0x3471b046,
0x34d41252,
0x35366c39,
0x3598bdeb,
0x35fb075a,
0x365d4875,
0x36bf812e,
0x3721b175,
0x3783d93c,
0x37e5f874,
0x38480f0d,
0x38aa1cf7,
0x390c2225,
0x396e1e87,
0x39d0120d,
0x3a31fca9,
0x3a93de4b,
0x3af5b6e5,
0x3b578668,
0x3bb94cc3,
0x3c1b09e9,
0x3c7cbdca,
0x3cde6857,
0x3d400981,
0x3da1a139,
0x3e032f70,
0x3e64b417,
0x3ec62f1e,
0x3f27a077,
0x3f890813,
0x3fea65e3,
0x404bb9d8,
0x40ad03e2,
0x410e43f3,
0x416f79fb,
0x41d0a5ec,
0x4231c7b7,
0x4292df4d,
0x42f3ec9f,
0x4354ef9d,
0x43b5e839,
0x4416d664,
0x4477ba0f,
0x44d8932b,
0x453961a9,
0x459a257b,
0x45fade90,
0x465b8cdb,
0x46bc304c,
0x471cc8d5,
0x477d5666,
0x47ddd8f1,
0x483e5067,
0x489ebcb8,
0x48ff1dd7,
0x495f73b4,
0x49bfbe40,
0x4a1ffd6d,
0x4a80312c,
0x4ae0596d,
0x4b407623,
0x4ba0873d,
0x4c008cae,
0x4c608666,
0x4cc07458,
0x4d205673,
0x4d802ca9,
0x4ddff6ec,
0x4e3fb52c,
0x4e9f675b,
0x4eff0d6b,
0x4f5ea74b,
0x4fbe34ef,
0x501db646,
0x507d2b42,
0x50dc93d5,
0x513befef,
0x519b3f83,
0x51fa8281,
0x5259b8da,
0x52b8e280,
0x5317ff65,
0x53770f79,
0x53d612ae,
0x543508f5,
0x5493f240,
0x54f2ce80,
0x55519da7,
0x55b05fa5,
0x560f146c,
0x566dbbee,
0x56cc561c,
0x572ae2e7,
0x57896241,
0x57e7d41b,
0x58463866,
0x58a48f15,
0x5902d818,
0x59611361,
0x59bf40e2,
0x5a1d608c,
0x5a7b7250,
0x5ad97620,
0x5b376bed,
0x5b9553a9,
0x5bf32d46,
0x5c50f8b5,
0x5caeb5e7,
0x5d0c64ce,
0x5d6a055c,
0x5dc79782,
0x5e251b31,
0x5e82905c,
0x5edff6f4,
0x5f3d4eeb,
0x5f9a9831,
0x5ff7d2b9,
0x6054fe75,
0x60b21b55,
0x610f294c,
0x616c284c,
0x61c91845,
0x6225f92a,
0x6282caec,
0x62df8d7d,
0x633c40cf,
0x6398e4d3,
0x63f5797b,
0x6451feb9,
0x64ae747e,
0x650adabd,
0x65673166,
0x65c3786d,
0x661fafc2,
0x667bd757,
0x66d7ef1e,
0x6733f709,
0x678fef0a,
0x67ebd713,
0x6847af15,
0x68a37702,
0x68ff2ecc,
0x695ad665,
0x69b66dbf,
0x6a11f4cb,
0x6a6d6b7c,
0x6ac8d1c3,
0x6b242793,
0x6b7f6cdd,
0x6bdaa193,
0x6c35c5a7,
0x6c90d90b,
0x6cebdbb1,
0x6d46cd8b,
0x6da1ae8b,
0x6dfc7ea3,
0x6e573dc5,
0x6eb1ebe3,
0x6f0c88ef,
0x6f6714db,
0x6fc18f98,
0x701bf91a,
0x70765152,
0x70d09832,
0x712acdac,
0x7184f1b3,
0x71df0438,
0x7239052d,
0x7292f486,
0x72ecd233,
0x73469e27,
0x73a05854,
0x73fa00ac,
0x74539722,
0x74ad1ba7,
0x75068e2f,
0x755feeaa,
0x75b93d0b,
0x76127945,
0x766ba34a,
0x76c4bb0b,
0x771dc07c,
0x7776b38e,
0x77cf9435,
0x78286261,
0x78811e05,
0x78d9c714,
0x79325d80,
0x798ae13c,
0x79e35239,
0x7a3bb06a,
0x7a93fbc2,
0x7aec3432,
0x7b4459ae,
0x7b9c6c27,
0x7bf46b91,
0x7c4c57dc,
0x7ca430fd,
0x7cfbf6e5,
0x7d53a987,
0x7dab48d5,
0x7e02d4c2,
0x7e5a4d40,
0x7eb1b242,
0x7f0903bb,
0x7f60419c,
0x7fb76bd8,
0x800e8438,
0x806585a8,
0x80bc7390,
0x81134df0,
0x816a14c8,
0x81c0c818,
0x821767e0,
0x826df420,
0x82c46cd8,
0x831ace20,
0x83711be0,
0x83c75618,
0x841d7cc8,
0x84738ff0,
0x84c98ba8,
0x851f73d8,
0x85754880,
0x85cb09a0,
0x8620b350,
0x86764978,
0x86cbcc18,
0x87213b30,
0x877692d8,
0x87cbd310,
0x882103a8,
0x88761cd0,
0x88cb1e88,
0x892010a0,
0x8974eb48,
0x89c9ae80,
0x8a1e5e30,
0x8a72f670,
0x8ac77b28,
0x8b1bec58,
0x8b704618,
0x8bc48c50,
0x8c18bb18,
0x8c6cd270,
0x8cc0d640,
0x8d14c688,
0x8d689b78,
0x8dbc60c8,
0x8e100ac0,
0x8e63a130,
0x8eb72418,
0x8f0a8f90,
0x8f5de398,
0x8fb12030,
0x90044940,
0x90575ae0,
0x90aa58f8,
0x90fd3bb8,
0x91500af0,
0x91a2c6a0,
0x91f566f8,
0x9247f3c8,
0x929a6928,
0x92ecc718,
0x933f0d98,
0x93914090,
0x93e35c18,
0x94356030,
0x94874cd8,
0x94d92210,
0x952adfd8,
0x957c8a18,
0x95ce1900,
0x961f9460,
0x9670f468,
0x96c240e8,
0x971375f8,
0x97649398,
0x97b599c8,
0x980684a0,
0x98575bf0,
0x98a81bd0,
0x98f8c440,
0x99495540,
0x9999ced0,
0x99ea2d08,
0x9a3a77b8,
0x9a8aa710,
0x9adac2e0,
0x9b2ac358,
0x9b7aac60,
0x9bca7df8,
0x9c1a3820,
0x9c69dad8,
0x9cb96238,
0x9d08d610,
0x9d582e90,
0x9da76fa0,
0x9df69558,
0x9e45a788,
0x9e949e60,
0x9ee37dc8,
0x9f3245c0,
0x9f80f260,
0x9fcf8790,
0xa01e0550,
0xa06c6ba0,
0xa0bab698,
0xa108ea20,
0xa1570250,
0xa1a50310,
0xa1f2ec60,
0xa240ba58,
0xa28e70e0,
0xa2dc0ff8,
0xa32993b8,
0xa376fc20,
0xa3c44d18,
0xa41186a0,
0xa45ea4d0,
0xa4abab90,
0xa4f896f8,
0xa5456af0,
0xa5922390,
0xa5dec4c0,
0xa62b4a98,
0xa677b518,
0xa6c40828,
0xa71043c8,
0xa75c6410,
0xa7a86900,
0xa7f45298,
0xa84024c0,
0xa88bdf78,
0xa8d77af0,
0xa922fef8,
0xa96e67a8,
0xa9b9b8e8,
0xaa04eed0,
0xaa500960,
0xaa9b0c80,
0xaae5f060,
0xab30bcd0,
0xab7b71d0,
0xabc60790,
0xac1085e0,
0xac5ae8d8,
0xaca53078,
0xacef5cc0,
0xad396db0,
0xad836730,
0xadcd4558,
0xae170828,
0xae60afa0,
0xaeaa3bc0,
0xaef3ac88,
0xaf3d01f8,
0xaf863ff8,
0xafcf5eb8,
0xb0186608,
0xb0614e18,
0xb0aa1eb8,
0xb0f2d400,
0xb13b6a08,
0xb183e8a0,
0xb1cc4be0,
0xb2148fe0,
0xb25cbc70,
0xb2a4cda8,
0xb2ecbfa0,
0xb3349640,
0xb37c5570,
0xb3c3f560,
0xb40b79f8,
0xb452e338,
0xb49a3120,
0xb4e163b0,
0xb5287ae8,
0xb56f76c8,
0xb5b65368,
0xb5fd14b0,
0xb643baa0,
0xb68a4538,
0xb6d0b478,
0xb7170478,
0xb75d3920,
0xb7a35270,
0xb7e95068,
0xb82f2f20,
0xb874f280,
0xb8ba9a88,
0xb9002738,
0xb94594a8,
0xb98ae6c0,
0xb9d01d80,
0xba153500,
0xba5a3128,
0xba9f11f8,
0xbae3d388,
0xbb2879c0,
0xbb6d00b8,
0xbbb16c58,
0xbbf5bca0,
0xbc39eda8,
0xbc7e0358,
0xbcc1f9c8,
0xbd05d4e0,
0xbd4994a0,
0xbd8d3520,
0xbdd0b660,
0xbe141c48,
0xbe5766d8,
0xbe9a9228,
0xbedd9e38,
0xbf208ef0,
0xbf636068,
0xbfa61688,
0xbfe8ad68,
0xc02b28f0,
0xc06d8538,
0xc0afc628,
0xc0f1e7d8,
0xc133ea48,
0xc175d160,
0xc1b79938,
0xc1f941d0,
0xc23acf10,
0xc27c3d10,
0xc2bd8bd0,
0xc2febf38,
0xc33fd360,
0xc380c848,
0xc3c1a1d8,
0xc4025840,
0xc442f350,
0xc4837308,
0xc4c3cf98,
0xc50410d0,
0xc54432c8,
0xc5843580,
0xc5c41ce0,
0xc603e118,
0xc64389f8,
0xc6831398,
0xc6c27df8,
0xc701cd00,
0xc740f8e0,
0xc7800968,
0xc7bef6c8,
0xc7fdc8d0,
0xc83c7b98,
0xc87b0f20,
0xc8b98368,
0xc8f7dc58,
0xc9361220,
0xc97428a8,
0xc9b21ff0,
0xc9effbe0,
0xca2db4a8,
0xca6b5218,
0xcaa8cc60,
0xcae62b50,
0xcb236718,
0xcb6083a0,
0xcb9d84d0,
0xcbda62d8,
0xcc1721a0,
0xcc53c510,
0xcc904558,
0xcccca660,
0xcd08e828,
0xcd450ab0,
0xcd810df8,
0xcdbcee18,
0xcdf8b2e0,
0xce345480,
0xce6fdac8,
0xceab3de8,
0xcee681c8,
0xcf21a668,
0xcf5ca7e0,
0xcf978e00,
0xcfd250f8,
0xd00cf4b0,
0xd0477928,
0xd081de60,
0xd0bc2070,
0xd0f64340,
0xd13046d0,
0xd16a2b20,
0xd1a3ec48,
0xd1dd8e30,
0xd21710d8,
0xd2507440,
0xd289b480,
0xd2c2d580,
0xd2fbd358,
0xd334b5d8,
0xd36d7530,
0xd3a61160,
0xd3de8e50,
0xd416ec00,
0xd44f2a70,
0xd48745b8,
0xd4bf41c0,
0xd4f71aa0,
0xd52ed440,
0xd5666ab8,
0xd59de1f0,
0xd5d539e8,
0xd60c6eb8,
0xd6438448,
0xd67a76b0,
0xd6b149d8,
0xd6e7f9d8,
0xd71e8a98,
0xd754fc18,
0xd78b4688,
0xd7c175a0,
0xd7f78190,
0xd82d6a58,
0xd86333e0,
0xd898da40,
0xd8ce6160,
0xd903c558,
0xd9390628,
0xd96e27b8,
0xd9a32a08,
0xd9d80930,
0xda0cc530,
0xda415e08,
0xda75d7a0,
0xdaaa31f8,
0xdade6540,
0xdb127948,
0xdb466e10,
0xdb7a3fb0,
0xdbadee28,
0xdbe17978,
0xdc14e588,
0xdc482e70,
0xdc7b5430,
0xdcae5ab0,
0xdce13e08,
0xdd13fe38,
0xdd469f28,
0xdd791cf0,
0xddab7790,
0xddddaf08,
0xde0fc358,
0xde41b868,
0xde738a50,
0xdea53910,
0xded6c890,
0xdf083100,
0xdf397a30,
0xdf6aa038,
0xdf9ba318,
0xdfcc86b8,
0xdffd4348,
0xe02de098,
0xe05e5ac0,
0xe08eb1c0,
0xe0bee598,
0xe0eef648,
0xe11ee3d0,
0xe14eb218,
0xe17e5950,
0xe1ade148,
0xe1dd4618,
0xe20c87c0,
0xe23ba258,
0xe26a9db0,
0xe29979c8,
0xe2c82ed0,
0xe2f6c0b0,
0xe3252f68,
0xe3537af8,
0xe381a360,
0xe3afac88,
0xe3dd8ea0,
0xe40b4d90,
0xe438e958,
0xe46665e0,
0xe493bb58,
0xe4c0eda8,
0xe4edfcd0,
0xe51ae8d0,
0xe547b590,
0xe5745b40,
0xe5a0ddc8,
0xe5cd3d28,
0xe5f97578,
0xe6258e88,
0xe6518470,
0xe67d5348,
0xe6a902e0,
0xe6d48b68,
0xe6fff4b0,
0xe72b36e8,
0xe75655f8,
0xe78151e0,
0xe7ac2aa0,
0xe7d6dc50,
0xe8016ec0,
0xe82bda20,
0xe8562258,
0xe8804768,
0xe8aa4950,
0xe8d42428,
0xe8fddfc0,
0xe9277448,
0xe950e5a8,
0xe97a33e0,
0xe9a35b08,
0xe9cc62f0,
0xe9f543c8,
0xea1e0178,
0xea469818,
0xea6f0f78,
0xea975fc8,
0xeabf8cf0,
0xeae79308,
0xeb0f79e0,
0xeb3739a8,
0xeb5ed648,
0xeb864bd8,
0xebad9e40,
0xebd4cd80,
0xebfbd998,
0xec22bea0,
0xec498080,
0xec701f38,
0xec9696e0,
0xecbceb60,
0xece318d0,
0xed092700,
0xed2f0a38,
0xed54ce30,
0xed7a6b18,
0xed9fe4d8,
0xedc53788,
0xedea6710,
0xee0f7370,
0xee3458c0,
0xee591ae8,
0xee7db600,
0xeea22df0,
0xeec682b8,
0xeeeab070,
0xef0ebb00,
0xef329e80,
0xef565ed8,
0xef79f820,
0xef9d6e40,
0xefc0bd50,
0xefe3e938,
0xf006f1f8,
0xf029d3a8,
0xf04c9230,
0xf06f29a8,
0xf0919a10,
0xf0b3e750,
0xf0d61168,
0xf0f81470,
0xf119f450,
0xf13bad20,
0xf15d3ee0,
0xf17ead78,
0xf19ff8e8,
0xf1c11d48,
0xf1e21a98,
0xf202f4c0,
0xf223a7d8,
0xf24437c8,
0xf264a0a8,
0xf284e278,
0xf2a50120,
0xf2c4fca0,
0xf2e4d110,
0xf3047e70,
0xf32408a8,
0xf3436bd0,
0xf362a7e8,
0xf381c0d8,
0xf3a0b2b8,
0xf3bf8170,
0xf3de2918,
0xf3fca9b0,
0xf41b0720,
0xf4393d80,
0xf4574cd0,
0xf47538f8,
0xf492fe10,
0xf4b0a000,
0xf4ce1ae0,
0xf4eb6eb0,
0xf5089b70,
0xf525a508,
0xf5428790,
0xf55f46f0,
0xf57bdf40,
0xf5985080,
0xf5b49ab0,
0xf5d0c1b8,
0xf5ecc1b0,
0xf6089a98,
0xf6245058,
0xf63fdf08,
0xf65b46a8,
0xf6768738,
0xf691a4a0,
0xf6ac9af8,
0xf6c76a40,
0xf6e21660,
0xf6fc9788,
0xf716f588,
0xf7312c78,
0xf74b4040,
0xf7652cf8,
0xf77ef2a0,
0xf7989138,
0xf7b208c0,
0xf7cb5d20,
0xf7e48688,
0xf7fd90b0,
0xf8166fe0,
0xf82f2800,
0xf847bcf8,
0xf8602ae0,
0xf87871b8,
0xf8909180,
0xf8a88a38,
0xf8c05fc8,
0xf8d80e48,
0xf8ef95b8,
0xf906f618,
0xf91e2f68,
0xf9354590,
0xf94c30c0,
0xf962f8c8,
0xf97999c0,
0xf99013a8,
0xf9a66680,
0xf9bc9630,
0xf9d29ae8,
0xf9e87c78,
0xf9fe36f8,
0xfa13ca68,
0xfa2936c8,
0xfa3e7c18,
0xfa539a58,
0xfa689570,
0xfa7d6590,
0xfa921288,
0xfaa69870,
0xfabaf360,
0xfacf2b28,
0xfae33be0,
0xfaf72970,
0xfb0aec08,
0xfb1e8790,
0xfb31fff0,
0xfb454d58,
0xfb587798,
0xfb6b76e0,
0xfb7e5300,
0xfb910810,
0xfba39610,
0xfbb5fd00,
0xfbc83ce0,
0xfbda55b0,
0xfbec4770,
0xfbfe1220,
0xfc0fb5c0,
0xfc213638,
0xfc328bb8,
0xfc43ba28,
0xfc54c570,
0xfc65a5c0,
0xfc7662e8,
0xfc86f518,
0xfc976420,
0xfca7a830,
0xfcb7c918,
0xfcc7bf08,
0xfcd791d0,
0xfce73d88,
0xfcf6be48,
0xfd061be0,
0xfd155268,
0xfd245df8,
0xfd334660,
0xfd4207b8,
0xfd50a200,
0xfd5f1150,
0xfd6d5d78,
0xfd7b8290,
0xfd897cb0,
0xfd9753a8,
0xfda50390,
0xfdb28880,
0xfdbfea48,
0xfdcd2500,
0xfdda34c0,
0xfde72158,
0xfdf3e6e0,
0xfe008170,
0xfe0cf8d8,
0xfe194548,
0xfe256e90,
0xfe316ce0,
0xfe3d4420,
0xfe48f838,
0xfe548158,
0xfe5fe368,
0xfe6b2250,
0xfe763640,
0xfe812320,
0xfe8be8f0,
0xfe9687b0,
0xfea0ff60,
0xfeab5000,
0xfeb57990,
0xfebf7c10,
0xfec95398,
0xfed307f8,
0xfedc9548,
0xfee5f7a0,
0xfeef36d0,
0xfef84b08,
0xff013c18,
0xff0a0230,
0xff12a138,
0xff1b1d18,
0xff236e00,
0xff2b97d8,
0xff339aa0,
0xff3b7658,
0xff432b00,
0xff4ab4b0,
0xff521b38,
0xff595ab0,
0xff606f30,
0xff676088,
0xff6e26e8,
0xff74c638,
0xff7b3e78,
0xff818fa8,
0xff87b9c8,
0xff8dbcd8,
0xff9398d8,
0xff994dc8,
0xff9edba8,
0xffa43e90,
0xffa97e50,
0xffae9318,
0xffb380d0,
0xffb84778,
0xffbce710,
0xffc15f98,
0xffc5b110,
0xffc9db78,
0xffcdded0,
0xffd1b730,
0xffd56c68,
0xffd8f6a8,
0xffdc5dc0,
0xffdf99e0,
0xffe2aef0,
0xffe59cf0,
0xffe863e0,
0xffeb03c0,
0xffed78a8,
0xffefca68,
0xfff1f130,
0xfff3f4d0,
0xfff5cd78,
0xfff77f10,
0xfff90998,
0xfffa6d10,
0xfffba978,
0xfffcbed0,
0xfffda930,
0xfffe7068,
0xffff0ca8,
0xffff85c0,
0xffffd3e0,
0xfffffaf0
}; 



U32 gSinflt_512_rise[512]  = {
0x006487eb,
0x012d9782,
0x01f6a660,
0x02bfb407,
0x0388bffc,
0x0451c9c3,
0x051ad0e0,
0x05e3d4d7,
0x06acd52c,
0x0775d163,
0x083ec900,
0x0907bb86,
0x09d0a87b,
0x0a998f62,
0x0b626fbf,
0x0c2b4916,
0x0cf41aeb,
0x0dbce4c3,
0x0e85a622,
0x0f4e5e8b,
0x10170d83,
0x10dfb28f,
0x11a84d31,
0x1270dcf0,
0x1339614e,
0x1401d9d1,
0x14ca45fc,
0x1592a554,
0x165af75e,
0x17233b9d,
0x17eb7197,
0x18b398cf,
0x197bb0cb,
0x1a43b90e,
0x1b0bb11e,
0x1bd3987f,
0x1c9b6eb6,
0x1d633348,
0x1e2ae5b8,
0x1ef2858d,
0x1fba124b,
0x20818b77,
0x2148f095,
0x2210412c,
0x22d77cbf,
0x239ea2d5,
0x2465b2f1,
0x252cac9a,
0x25f38f55,
0x26ba5aa7,
0x27810e14,
0x2847a924,
0x290e2b5b,
0x29d4943f,
0x2a9ae355,
0x2b611823,
0x2c27322f,
0x2ced30ff,
0x2db31418,
0x2e78db01,
0x2f3e853f,
0x30041258,
0x30c981d3,
0x318ed336,
0x32540608,
0x331919cd,
0x33de0e0e,
0x34a2e250,
0x3567961a,
0x362c28f3,
0x36f09a61,
0x37b4e9eb,
0x38791719,
0x393d2170,
0x3a010879,
0x3ac4cbba,
0x3b886abb,
0x3c4be503,
0x3d0f3a1a,
0x3dd26986,
0x3e9572cf,
0x3f58557e,
0x401b111a,
0x40dda52a,
0x41a01138,
0x426254ca,
0x43246f69,
0x43e6609e,
0x44a827f0,
0x4569c4e9,
0x462b3710,
0x46ec7dee,
0x47ad990d,
0x486e87f5,
0x492f4a2f,
0x49efdf44,
0x4ab046bd,
0x4b708024,
0x4c308b02,
0x4cf066e1,
0x4db0134a,
0x4e6f8fc7,
0x4f2edbe2,
0x4fedf725,
0x50ace11a,
0x516b994b,
0x522a1f43,
0x52e8728c,
0x53a692b0,
0x54647f3b,
0x552237b8,
0x55dfbbb0,
0x569d0ab0,
0x575a2443,
0x581707f3,
0x58d3b54d,
0x59902bdc,
0x5a4c6b2b,
0x5b0872c8,
0x5bc4423c,
0x5c7fd916,
0x5d3b36e1,
0x5df65b29,
0x5eb1457c,
0x5f6bf565,
0x60266a71,
0x60e0a42f,
0x619aa22a,
0x625463f0,
0x630de90e,
0x63c73113,
0x64803b8b,
0x65390805,
0x65f1960e,
0x66a9e535,
0x6761f508,
0x6819c516,
0x68d154ec,
0x6988a41b,
0x6a3fb230,
0x6af67ebb,
0x6bad094b,
0x6c635170,
0x6d1956b9,
0x6dcf18b5,
0x6e8496f6,
0x6f39d10a,
0x6feec681,
0x70a376ee,
0x7157e1df,
0x720c06e5,
0x72bfe593,
0x73737d77,
0x7426ce24,
0x74d9d72c,
0x758c981f,
0x763f108f,
0x76f1400f,
0x77a32630,
0x7854c285,
0x7906149f,
0x79b71c13,
0x7a67d872,
0x7b184950,
0x7bc86e3f,
0x7c7846d3,
0x7d27d2a0,
0x7dd71139,
0x7e860232,
0x7f34a51f,
0x7fe2f995,
0x8090fe90,
0x813eb738,
0x81ec1dd8,
0x82993270,
0x8345f8e8,
0x83f26d58,
0x849e8fc0,
0x854a6408,
0x85f5e260,
0x86a10eb0,
0x874be8f8,
0x87f66d50,
0x88a09fa0,
0x894a7fe8,
0x89f40a40,
0x8a9d3ea8,
0x8b461d20,
0x8beea5a8,
0x8c96d840,
0x8d3eb4e8,
0x8de637b8,
0x8e8d6498,
0x8f343b88,
0x8fdab8a0,
0x9080dbe0,
0x9126a548,
0x91cc18c0,
0x92713260,
0x9315ee40,
0x93ba5048,
0x945e5878,
0x950202e8,
0x95a55380,
0x96484658,
0x96eadf58,
0x978d16b0,
0x982ef430,
0x98d073f0,
0x99719208,
0x9a125648,
0x9ab2b8e0,
0x9b52b9d0,
0x9bf25d00,
0x9c91a270,
0x9d308638,
0x9dcf0470,
0x9e6d24e8,
0x9f0ae3b8,
0x9fa840e0,
0xa0453c60,
0xa0e1d250,
0xa17e0698,
0xa219d550,
0xa2b54260,
0xa35049e0,
0xa3eaefb8,
0xa4852c18,
0xa51f02e8,
0xa5b87810,
0xa65183c0,
0xa6ea29e0,
0xa7826688,
0xa81a4188,
0xa8b1af28,
0xa948b738,
0xa9df55d0,
0xaa758ed8,
0xab0b5a80,
0xaba0c098,
0xac35b950,
0xacca4890,
0xad5e6e58,
0xadf22aa8,
0xae857998,
0xaf185b28,
0xafaad340,
0xb03cddf8,
0xb0ce7b50,
0xb15faf30,
0xb1f071c8,
0xb280c700,
0xb310aed8,
0xb3a02950,
0xb42f3280,
0xb4bdce50,
0xb54bfcc0,
0xb5d9b600,
0xb66701e0,
0xb6f3e060,
0xb78049b0,
0xb80c41b8,
0xb897cc60,
0xb922e1d8,
0xb9ad8608,
0xba37b508,
0xbac176a8,
0xbb4abf30,
0xbbd39a58,
0xbc5bfc68,
0xbce3ed30,
0xbd6b68c8,
0xbdf26f30,
0xbe790068,
0xbeff1c70,
0xbf84bf60,
0xc009f108,
0xc08ea998,
0xc112ecf8,
0xc196b740,
0xc21a0c58,
0xc29ce858,
0xc31f4b40,
0xc3a138f8,
0xc422a9b0,
0xc4a3a538,
0xc52427a8,
0xc5a42d18,
0xc623b970,
0xc6a2ccb0,
0xc72166d8,
0xc79f8400,
0xc81d2810,
0xc89a4f20,
0xc916f930,
0xc9932a28,
0xca0ede20,
0xca8a1130,
0xcb04cb28,
0xcb7f0820,
0xcbf8c818,
0xcc720728,
0xcceac938,
0xcd630e48,
0xcddad658,
0xce521d80,
0xcec8e3c0,
0xcf3f2d00,
0xcfb4f558,
0xd02a3cc8,
0xd09f0350,
0xd11348f0,
0xd1871190,
0xd1fa5560,
0xd26d1848,
0xd2df5a48,
0xd3511778,
0xd3c253c0,
0xd4330f20,
0xd4a345b0,
0xd512fb58,
0xd5822c30,
0xd5f0d838,
0xd65f0358,
0xd6cca5c0,
0xd739c740,
0xd7a663f0,
0xd81277e8,
0xd87e0af8,
0xd8e91550,
0xd9539ad8,
0xd9bd9b90,
0xda271778,
0xda900aa8,
0xdaf87520,
0xdb605ac8,
0xdbc7b7b8,
0xdc2e8fd8,
0xdc94db58,
0xdcfaa208,
0xdd5fe000,
0xddc49540,
0xde28c1c8,
0xde8c6598,
0xdeef80b0,
0xdf521310,
0xdfb418d0,
0xe01595d8,
0xe0768a28,
0xe0d6f1d8,
0xe136d0d0,
0xe1962328,
0xe1f4e8e0,
0xe25325e0,
0xe2b0d640,
0xe30dfa00,
0xe36a9508,
0xe3c69f88,
0xe4222150,
0xe47d1290,
0xe4d77b18,
0xe5315318,
0xe58a9e78,
0xe5e35d38,
0xe63b8f58,
0xe69330f0,
0xe6ea45e8,
0xe740ca58,
0xe796c228,
0xe7ec2970,
0xe8410418,
0xe8954e38,
0xe8e907d0,
0xe93c30e0,
0xe98ecd50,
0xe9e0d550,
0xea3250b0,
0xea833b88,
0xead395d8,
0xeb235fa0,
0xeb7294f8,
0xebc139c8,
0xec0f51f8,
0xec5cd1d0,
0xeca9c508,
0xecf623d0,
0xed41f210,
0xed8d2be0,
0xedd7d528,
0xee21ea00,
0xee6b6e50,
0xeeb45e30,
0xeefcb9a0,
0xef4480a0,
0xef8bb718,
0xefd25920,
0xf01866b8,
0xf05ddfe0,
0xf0a2c498,
0xf0e718c8,
0xf12ad4a0,
0xf16dfc08,
0xf1b08f00,
0xf1f289a0,
0xf233f3b8,
0xf274c578,
0xf2b502c8,
0xf2f4aba8,
0xf333bc30,
0xf3723848,
0xf3b01ff0,
0xf3ed6f40,
0xf42a2638,
0xf46648c0,
0xf4a1d2f0,
0xf4dcc8b0,
0xf5172618,
0xf550eb28,
0xf58a1bc8,
0xf5c2b410,
0xf5fab400,
0xf6321b98,
0xf668ead8,
0xf69f25a8,
0xf6d4c438,
0xf709ca70,
0xf73e3c38,
0xf77211c0,
0xf7a552d8,
0xf7d7f7b0,
0xf80a0430,
0xf83b7858,
0xf86c5040,
0xf89c93b8,
0xf8cc3af0,
0xf8fb49d0,
0xf929c058,
0xf9579aa0,
0xf984dc90,
0xf9b18240,
0xf9dd8f98,
0xfa090498,
0xfa33dd58,
0xfa5e1dc0,
0xfa87c1e8,
0xfab0c9d0,
0xfad93960,
0xfb010cb0,
0xfb2847a8,
0xfb4ee660,
0xfb74e8d8,
0xfb9a52f8,
0xfbbf20d8,
0xfbe35278,
0xfc06e7d8,
0xfc29e4e0,
0xfc4c45a8,
0xfc6e0a30,
0xfc8f3278,
0xfcafbe80,
0xfccfae48,
0xfcef01d0,
0xfd0dbd00,
0xfd2bd808,
0xfd4956d0,
0xfd663d40,
0xfd828388,
0xfd9e3178,
0xfdb93f40,
0xfdd3b0c8,
0xfded89f8,
0xfe06c300,
0xfe1f5fc8,
0xfe375c68,
0xfe4ec0b0,
0xfe6588b8,
0xfe7bb098,
0xfe913c38,
0xfea62b98,
0xfeba7eb8,
0xfece3598,
0xfee14c50,
0xfef3c6c8,
0xff05a500,
0xff16e310,
0xff2788c8,
0xff378e58,
0xff46f3c0,
0xff55c0d0,
0xff63edb8,
0xff717a78,
0xff7e6ee0,
0xff8ac320,
0xff967738,
0xffa192f8,
0xffac0aa8,
0xffb5ea00,
0xffbf2930,
0xffc7cc20,
0xffcfcee8,
0xffd73570,
0xffddffb8,
0xffe429d8,
0xffe9b7b8,
0xffeea570,
0xfff2f6e8,
0xfff6ac20,
0xfff9c130,
0xfffc3a00,
0xfffe12a8,
0xffff4f10,
0xffffeb50
} ;

U32 gSinflt_256_rise[256]  = {
0x00c90fc6,
0x025b2d62,
0x03ed452d,
0x057f5348,
0x071153d3,
0x08a342ee,
0x0a351cb8,
0x0bc6dd53,
0x0d5880df,
0x0eea037d,
0x107b614e,
0x120c9675,
0x139d9f13,
0x152e774a,
0x16bf1b3e,
0x184f8713,
0x19dfb6eb,
0x1b6fa6ec,
0x1cff533b,
0x1e8eb7fe,
0x201dd15b,
0x21ac9b79,
0x233b1281,
0x24c9329c,
0x2656f7f3,
0x27e45eb0,
0x297162ff,
0x2afe010d,
0x2c8a3506,
0x2e15fb1a,
0x2fa14f78,
0x312c2e50,
0x32b693d3,
0x34407c36,
0x35c9e3ac,
0x3752c66a,
0x38db20a7,
0x3a62ee9a,
0x3bea2c7e,
0x3d70d68c,
0x3ef6e901,
0x407c601b,
0x42013818,
0x43856d38,
0x4508fbbf,
0x468bdff0,
0x480e160f,
0x498f9a65,
0x4b10693a,
0x4c907ed9,
0x4e0fd78d,
0x4f8e6fa6,
0x510c4372,
0x52894f44,
0x54058f70,
0x5581004c,
0x56fb9e2e,
0x58756572,
0x59ee5273,
0x5b66618e,
0x5cdd8f25,
0x5e53d798,
0x5fc9374e,
0x613daaac,
0x62b12e1b,
0x6423be08,
0x659556df,
0x6705f510,
0x6875950f,
0x69e4334f,
0x6b51cc49,
0x6cbe5c77,
0x6e29e054,
0x6f945460,
0x70fdb51d,
0x7265ff0e,
0x73cd2ebc,
0x753340af,
0x76983174,
0x77fbfd9b,
0x795ea1b5,
0x7ac01a58,
0x7c20641b,
0x7d7f7b99,
0x7edd5d71,
0x803a04f0,
0x81957258,
0x82ef9f70,
0x84488850,
0x85a02cf8,
0x86f68598,
0x884b9230,
0x899f4ed8,
0x8af1b7a8,
0x8c42c8b8,
0x8d928208,
0x8ee0dbc8,
0x902dd5f8,
0x91796cb0,
0x92c39c08,
0x940c6018,
0x9553b8e0,
0x96999e90,
0x97de1128,
0x992110a8,
0x9a629158,
0x9ba29720,
0x9ce11e18,
0x9e1e2258,
0x9f599ff8,
0xa0939310,
0xa1cbfba0,
0xa302d1d8,
0xa43819a0,
0xa56bcb28,
0xa69de288,
0xa7ce5fc0,
0xa8fd42d0,
0xaa2a8000,
0xab561b38,
0xac801090,
0xada85838,
0xaecef618,
0xaff3e648,
0xb11720f8,
0xb238aa10,
0xb35879c0,
0xb4769008,
0xb592e900,
0xb6ad80c0,
0xb7c65360,
0xb8dd64c8,
0xb9f2ad28,
0xbb062898,
0xbc17d718,
0xbd27b8a8,
0xbe35c578,
0xbf41fd88,
0xc04c5cf0,
0xc154dfc8,
0xc25b89f8,
0xc3604fc8,
0xc4633908,
0xc5643a00,
0xc66352b0,
0xc7608318,
0xc85bcb38,
0xc9551f58,
0xca4c8748,
0xcb41fb38,
0xcc357740,
0xcd26fb60,
0xce168798,
0xcf041800,
0xcfefa8b0,
0xd0d935c0,
0xd1c0c318,
0xd2a648e8,
0xd389c730,
0xd46b3a08,
0xd54aa558,
0xd627fd68,
0xd7034620,
0xd7dc7f80,
0xd8b3a1b8,
0xd988acc8,
0xda5ba0b0,
0xdb2c7988,
0xdbfb3368,
0xdcc7d238,
0xdd924e28,
0xde5aa738,
0xdf20d980,
0xdfe4e8e8,
0xe0a6cda0,
0xe1668b90,
0xe2241ae8,
0xe2df7ba8,
0xe398add0,
0xe44fad78,
0xe5047aa0,
0xe5b71160,
0xe66771b8,
0xe71597c0,
0xe7c18760,
0xe86b38c8,
0xe912afe0,
0xe9b7e4d8,
0xea5ad7b0,
0xeafb8c50,
0xeb99fae8,
0xec362378,
0xecd00600,
0xed67a280,
0xedfcf128,
0xee8ff5e0,
0xef20b0a8,
0xefaf19b0,
0xf03b34e0,
0xf0c50238,
0xf14c79e8,
0xf1d19fd8,
0xf2547020,
0xf2d4eac0,
0xf3530fb8,
0xf3cedb20,
0xf4484910,
0xf4bf6158,
0xf5341c28,
0xf5a67980,
0xf6167960,
0xf6841bc8,
0xf6ef5cd0,
0xf7583890,
0xf7beb6d8,
0xf822cfd8,
0xf8848778,
0xf8e3d5e8,
0xf940bf10,
0xf99b42f0,
0xf9f35da0,
0xfa490f20,
0xfa9c5770,
0xfaed3690,
0xfb3bac80,
0xfb87b170,
0xfbd14d30,
0xfc187bd8,
0xfc5d3980,
0xfc9f8a10,
0xfcdf6d88,
0xfd1cdc18,
0xfd57dd90,
0xfd906e08,
0xfdc68d80,
0xfdfa3810,
0xfe2b71a0,
0xfe5a3648,
0xfe8689f0,
0xfeb068b0,
0xfed7d288,
0xfefcc778,
0xff1f4780,
0xff3f52a0,
0xff5ce8d8,
0xff780640,
0xff90aec0,
0xffa6e258,
0xffba9d20,
0xffcbe300,
0xffdab010,
0xffe70450,
0xfff0e3a8,
0xfff84a30,
0xfffd37e8,
0xffffb0b8
} ;


U32 gSinflt_128_rise[128] = {
0x01921f10,
0x04b64daf,
0x07da4dcc,
0x0afe0069,
0x0e214689,
0x11440135,
0x14661179,
0x1787586a,
0x1aa7b724,
0x1dc70ecc,
0x20e5408f,
0x24022daa,
0x271db762,
0x2a37bf0b,
0x2d50260a,
0x3066cdd1,
0x337b97e6,
0x368e65de,
0x399f1966,
0x3cad943c,
0x3fb9b836,
0x42c3673f,
0x45ca835e,
0x48ceeeaf,
0x4bd08b6c,
0x4ecf3be8,
0x51cae295,
0x54c36203,
0x57b89cde,
0x5aaa75f7,
0x5d98d03d,
0x60838ec1,
0x636a94bb,
0x664dc585,
0x692d049f,
0x6c0835b2,
0x6edf3c8c,
0x71b1fd26,
0x74805ba4,
0x774a3c52,
0x7a0f83ac,
0x7cd01659,
0x7f8bd930,
0x8242b1e8,
0x84f483a8,
0x87a134e8,
0x8a48ae38,
0x8cead058,
0x8f8783d8,
0x921eb148,
0x94b03968,
0x973c08b0,
0x99c1ffe0,
0x9c420b70,
0x9ebc1008,
0xa12ffa20,
0xa39daa78,
0xa60509a0,
0xa8660410,
0xaac08258,
0xad146920,
0xaf61a4e0,
0xb1a81e28,
0xb3e7bd88,
0xb6206b90,
0xb85214b8,
0xba7ca578,
0xbca00278,
0xbebc1c18,
0xc0d0dae8,
0xc2de2778,
0xc4e3f610,
0xc6e22b58,
0xc8d8b3c8,
0xcac77fc0,
0xccae77d0,
0xce8d9040,
0xd064adb8,
0xd233c480,
0xd3fac110,
0xd5b993c8,
0xd7702538,
0xd91e69a8,
0xdac45178,
0xdc61c538,
0xddf6bd18,
0xdf832590,
0xe106f2e8,
0xe2821198,
0xe3f47200,
0xe55e0c50,
0xe6becd00,
0xe816a858,
0xe96592a0,
0xeaab7c38,
0xebe85968,
0xed1c1e78,
0xee46bfb0,
0xef683158,
0xf08067b8,
0xf18f5718,
0xf294f7a8,
0xf3913db0,
0xf4842160,
0xf56d9700,
0xf64d96c0,
0xf72418d0,
0xf7f11178,
0xf8b478e8,
0xf96e4f20,
0xfa1e8480,
0xfac51520,
0xfb61fd18,
0xfbf530b0,
0xfc7eafe8,
0xfcfe72f0,
0xfd7475e0,
0xfde0b0e8,
0xfe432408,
0xfe9bc770,
0xfeea9b20,
0xff2f9f18,
0xff6ac7a0,
0xff9c18a0,
0xffc38e30,
0xffe12850,
0xfff4e700,
0xfffec270
};


#endif //_SINCOS_ORIG_TBL_H_
