//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
/* -------------------------------------------------------------------------
 *
 *  Microsoft Windows Media
 *
 *  Copyright (C) Microsoft Corporation, 1999 - 1999
 *
 *  File:       wavfileio.h
 *
 * ---------------------------------------------------------------------- */

#ifndef _WAV_FILE_IO_H_
#define _WAV_FILE_IO_H_

/* use this to turn off the use of mmio* calls */
#define WFIO_NO_WIN32 1

/* use this to control the endian-ness */
#define WFIO_LITTLE_ENDIAN 1

#if WFIO_NO_WIN32

#include <stdio.h>
//#include "macros.h"
#include <tchar.h>

//***********************************************************************
//   Data type
//***********************************************************************
typedef unsigned char		  WAV_UINT8;
typedef char			        WAV_INT8;
typedef unsigned short		WAV_UINT16;
typedef short		        	WAV_INT16;
typedef unsigned int		  WAV_UINT32;
typedef int			          WAV_INT32;
typedef WAV_UINT32        WAV_Bool;
#if _WIN32
typedef unsigned __int64        WAV_UINT64;
typedef __int64                 WAV_INT64;
#else
typedef unsigned long long      WAV_UINT64;
typedef long long               WAV_INT64;
#endif

typedef unsigned char		  U8;
typedef char			        I8;
typedef unsigned short		U16;
typedef short		        	I16;
typedef unsigned int		  U32;
typedef int			          I32;
typedef I32               Bool;
#if _WIN32
typedef unsigned __int64        U64;
typedef __int64                 I64;
#else
typedef unsigned long long      U64;
typedef long long               I64;
#endif

#define WMAB_FALSE 0
#define WMAB_TRUE  1

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_
#ifndef _Embedded_x86
#pragma COMPILER_PACKALIGN(1)
#endif
typedef struct tWAVEFORMATEX
{
    WAV_UINT16     wFormatTag;        /* format type */
    WAV_UINT16     nChannels;         /* number of channels (i.e. mono, stereo...) */
    WAV_UINT32     nSamplesPerSec;    /* sample rate */
    WAV_UINT32     nAvgBytesPerSec;   /* for buffer estimation */
    WAV_UINT16     nBlockAlign;       /* block size of data */
    WAV_UINT16     wBitsPerSample;    /* Number of bits per sample of mono data */
    WAV_UINT16     cbSize;            /* The count in bytes of the size of
                                    extra information (after cbSize) */

} WAVEFORMATEX, *PWAVEFORMATEX, *LPWAVEFORMATEX;
#ifndef _Embedded_x86
#pragma COMPILER_PACKALIGN_DEFAULT
#endif
#endif /* _WAVEFORMATEX_ */

#ifndef MMSYSERR_NOERROR
#define MMSYSERR_NOERROR     0
#define MMSYSERR_ERROR       1
#define MMSYSERR_NOMEM       7
#define MMSYSERR_READERROR   16
#define MMSYSERR_WRITEERROR  17
#endif /* MMSYSERR_NOERROR */

#ifndef WAVE_FORMAT_PCM
#define WAVE_FORMAT_PCM 1
#endif /* WAVE_FORMAT_PCM */

#else  /* WFIO_NO_WIN32 */

#include <mmsystem.h>
#include <mmreg.h>

#endif /* WFIO_NO_WIN32 */

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/* flag for WavFileIO */
enum
{
    wfioModeRead = 0,
    wfioModeWrite
};

/* ===========================================================================
 * WavFileIO struct
 */
typedef struct WavFileIO_tag
{
    WAV_INT32      m_mode;

#if WFIO_NO_WIN32
    FILE    *m_fpWav;

    size_t   m_posRiffLength;
    size_t   m_posDataLength;
#else  /* WFIO_NO_WIN32 */
    HMMIO    m_hmmio;
    MMIOINFO m_mmioinfo;

    MMCKINFO m_ckWave;
    MMCKINFO m_ck;
#endif /* WFIO_NO_WIN32 */

    WAVEFORMATEX *m_pFormat;      /* but allocated using BYTEs...  */
    WAV_UINT32   m_sizeFormat;

    WAV_UINT32   m_sizeData;
    WAV_UINT32   m_posDataStart;

} WavFileIO;


/* ---------------------------------------------------------------------------
 * member functions
 */

WavFileIO * wfioNew();
void wfioDelete(WavFileIO *pwfio);

/* pFormat and cbFormat are only for writing... */
WAV_INT32 wfioOpen(WavFileIO *pwfio, const TCHAR *szFile, WAVEFORMATEX *pFormat, WAV_UINT32 cbFormat, WAV_INT32 mode);
void wfioClose(WavFileIO *pwfio);

/* origin can be SEEK_SET, SEEK_CUR, or SEEK_END */
WAV_INT32 wfioSeek(WavFileIO *pwfio, WAV_INT32 position, WAV_INT32 origin);

WAV_INT32 wfioRead(WavFileIO *pwfio, WAV_UINT8 *pBuf, WAV_INT32 cbBuf, WAV_INT8 iSize);
WAV_INT32 wfioWrite(WavFileIO *pwfio, WAV_UINT8 *pBuf, WAV_INT32 cbBuf);

WAVEFORMATEX * wfioGetFormat(WavFileIO *pwfio);
WAV_UINT32 wfioGetFormatLength(WavFileIO *pwfio);

WAV_UINT32 wfioGetSampleSize(WavFileIO *pwfio);
WAV_UINT32 wfioGetDataLength(WavFileIO *pwfio);

WAV_INT32 wfioGetMode(WavFileIO *pwfio);
WAV_INT32 wfioIsOpened(WavFileIO *pwfio);

/* utility functions */
WAV_UINT16 adjustByteOrder16(WAV_UINT16 val);
WAV_UINT32 adjustByteOrder32(WAV_UINT32 val);

#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif /* _WAV_FILE_IO_H_ */
