// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003-2007 - Steve Merrony 

/* This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "configParser.h"

#include <stdio.h>
#include <qregexp.h>
#include <qstring.h>
    
#include <iostream>
using namespace std;

//Section section;

// Override the methods we're interested in

bool ConfigParser::startDocument() {
  indent = "";
  man_count = -1;
  toe_piston_count = -1;
  thumb_piston = FALSE;
  toe_piston = FALSE;

  return TRUE;
}

bool ConfigParser::startElement( const QString&,
				 const QString&,
				 const QString& qName,
				 const QXmlAttributes& ) {

  elName = qName;
  
  // deal with section headings in the config file, (re)setting counters as required

  if (elName == "manual" || elName == "division") {
    man_count++;
    console.num_divisions = man_count + 1;
    console.divisions[man_count].colour = "DEFAULT";
    console.divisions[man_count].num_stops = 0;
    console.divisions[man_count].num_pistons = 0;
    console.divisions[man_count].num_couplers = 0;
    stop_count = -1;
    piston_count = -1;
    coupler_count = -1;
    // deprecation 
    if (elName == "manual") cout << "Warning: Use of 'manual' is deprecated, please use 'division'\n";
  }

  if (elName == "stop") {
    stop_count++;
    console.divisions[man_count].num_stops = stop_count + 1;
    console.divisions[man_count].stops[stop_count].colour = "DEFAULT";
    console.divisions[man_count].stops[stop_count].pulled = FALSE;
    console.divisions[man_count].stops[stop_count].velocity = DEFAULT_VELOCITY;
    console.divisions[man_count].stops[stop_count].kbdMidiChannel = FREE_CHANNEL;
  }

  if (elName == "preset" || elName == "piston") {
    piston_count++;
    console.divisions[man_count].num_pistons = piston_count + 1;
    console.divisions[man_count].pistons[piston_count].active = FALSE;
    console.divisions[man_count].pistons[piston_count].numPistonStops = 0;
    console.divisions[man_count].pistons[piston_count].widgetID = 0;
    piston_stop_count = -1;
    thumb_piston = TRUE;
    toe_piston = FALSE;
    // deprecation
    if (elName == "preset" ) cout << "\tWarning: Use of 'preset' is deprecated, please use 'piston'\n";
  }

  if ( elName == "toePiston" ) {
    toe_piston_count++;
    console.num_toePistons = toe_piston_count + 1;
    console.toePistons[toe_piston_count].active = FALSE;
    console.toePistons[toe_piston_count].numPistonStops = 0;
    console.toePistons[toe_piston_count].widgetID = 0;
    console.toePistons[toe_piston_count].midiChannel = FREE_CHANNEL;
    piston_stop_count = -1;
    toe_piston = TRUE;
    thumb_piston = FALSE;
  }

  if (elName == "presetStop" || elName == "pistonStop") {
    piston_stop_count++;
    if (thumb_piston) {
      console.divisions[man_count].pistons[piston_count].numPistonStops = piston_stop_count + 1;
    }
    else {
      console.toePistons[toe_piston_count].numPistonStops = piston_stop_count + 1; 
    }
  }

  if (elName == "coupler") {
    coupler_count++;
    console.divisions[man_count].num_couplers = coupler_count + 1;
    console.divisions[man_count].couplers[coupler_count].length = 8; // default to no transposition
    console.divisions[man_count].couplers[coupler_count].active = FALSE;
  }

  return TRUE;
}

bool ConfigParser::characters( const QString& ch ) {
  // ignore whitespace
  QRegExp rxp = QRegExp( "^([A-Z]|[a-z]|[0-9])", TRUE, FALSE );
  if (ch.contains( rxp ) ) { 
    //    printf( ": %s", (const char*)ch );
    
    // header stuff
    if (elName == "organName") console.organName = ch;
    if (elName == "soundFont") console.soundFont = ch;
    if (elName == "description") console.description = ch;
    if (elName == "acceleratorStyle") console.acceleratorStyle = ch;

    // manual stuff
    if (elName == "manualLabel" || elName == "divisionLabel") console.divisions[man_count].label = ch;
    if (elName == "manualName" || elName == "divisionName") { 
      console.divisions[man_count].name = ch;
      cout << ch << " division loading\n";
    }
    if (elName == "manualColour" || elName == "divisionColour") console.divisions[man_count].colour = ch;
    if (elName == "midiChannel" && !toe_piston) {
      console.divisions[man_count].midiChannel = ch.toInt() - 1; // it seems ALSA MIDI channel numbers start @ 0, not 1
      console.channel_division_map[ch.toInt() - 1] = man_count; 
    }
    // stop stuff
    if (elName == "stopLabel" ) console.divisions[man_count].stops[stop_count].label = ch;
    if (elName == "stopName" )  { 
      console.divisions[man_count].stops[stop_count].name  = ch;
      cout << "\tStop: " << ch << "\n"; 
    }
    if (elName == "stopColour" )  console.divisions[man_count].stops[stop_count].colour = ch ;
    if (elName == "isReed" )    console.divisions[man_count].stops[stop_count].isReed = (bool) ch.toInt();
    if (elName == "midiBank" )  console.divisions[man_count].stops[stop_count].midiBank  = ch.toInt();
    if (elName == "midiVoice" ) console.divisions[man_count].stops[stop_count].midiVoice = ch.toInt();
    if (elName == "velocity" )  console.divisions[man_count].stops[stop_count].velocity  = (unsigned char) ch.toInt();

    // thumb pistons
    if (thumb_piston) {
      if (elName == "presetLabel" || elName == "pistonLabel") console.divisions[man_count].pistons[piston_count].label = ch;
      if (elName == "presetName" || elName == "pistonName") { 
	console.divisions[man_count].pistons[piston_count].name  = ch;
	cout << "\tPiston: " << ch << "\n"; 
      }

      // thumb piston Stops
      if (elName == "presetStopLabel" || elName == "pistonStopLabel") console.divisions[man_count].pistons[piston_count].pistonStops[piston_stop_count].stopLabel = ch;
    }
    
    // toe pistons
    if (toe_piston) {
      if (elName == "pistonLabel") console.toePistons[toe_piston_count].label = ch;
      if (elName == "pistonName") {
	 console.toePistons[toe_piston_count].name = ch;
	 cout << "Toe Piston: " << ch << "\n";
      }
      if (elName == "midiChannel") console.toePistons[toe_piston_count].midiChannel = ch.toInt();
      
      // toe piston stops
      if (elName == "pistonStopLabel") console.toePistons[toe_piston_count].pistonStops[piston_stop_count].stopLabel = ch;
      
    }
    // coupler stuff
    if (elName == "couplerLabel" ) console.divisions[man_count].couplers[coupler_count].label = ch;
    if (elName == "couplerName" ) { 
      console.divisions[man_count].couplers[coupler_count].name = ch;
      cout << "\tCoupler: " << ch << "\n"; 
    }
    if (elName == "coupleTo" )    console.divisions[man_count].couplers[coupler_count].coupleTo = ch;
    if (elName == "length" )      console.divisions[man_count].couplers[coupler_count].length = ch.toInt();
  }
  return TRUE;
}

bool ConfigParser::endElement( const QString&,
			       const QString&,
			       const QString& ) {
  indent.remove( 0, 4 );
  return TRUE;
}
 
bool ConfigParser::endDocument() {

  // sort out the couplers now - we cannot do this until everything is defined 
  // due to the cross-referencing required.

  for (int m = 0; m < console.num_divisions; m++) {
    for (int c = 0; c < console.divisions[m].num_couplers; c++) {
      console.divisions[m].couplers[c].fromChannel = console.divisions[m].midiChannel;
      for (int destman = 0; destman < console.num_divisions; destman++) {
	if ( QString::compare( console.divisions[destman].label, console.divisions[m].couplers[c].coupleTo ) == 0) {
	  console.divisions[m].couplers[c].toChannel = console.divisions[destman].midiChannel;
	  cout << "Coupling " << m << " to " << destman << " @ " << console.divisions[m].couplers[c].length << "\n";
	  break;
	}
      }
    }
  }

  // no voices set (stops pulled) at startup
  for (int v = 0;  v < MAX_MIDI_VOICES; v++) {
      console.voices[v].active = FALSE;
      console.voices[v].manual_channel = FREE_CHANNEL;
      console.voices[v].velocity = 0;
      console.voices[v].synth = 0;
      console.voices[v].bank = 0;
      console.voices[v].voice = 0;
  }

  cout << "Organ parsed\n";
  // for (int c = 0; c<16; c++) printf( "console.channel_division_map[%d] = %d\n", c, console.channel_division_map[c] );

  return TRUE;
}

bool ConfigParser::copyConfig( Console *cp ) {

  cp->organName = console.organName; 
  //cp->verboseMode = console.verboseMode;
  //cp->singleStopMode = console.singleStopMode;
  //cp->requestedOutput = console.requestedOutput;
  //cp->requestedOutClient = console.requestedOutClient;
  //cp->requestedOutPort = console.requestedOutPort;
  cp->soundFont = console.soundFont;
  cp->description = console.description;
  cp->acceleratorStyle = console.acceleratorStyle;
  for (int mc = 0; mc < MAX_INPUT_CHANNELS; mc++) {
    cp->channel_division_map[mc] = console.channel_division_map[mc];
  }

  cp->num_divisions = console.num_divisions;
  for (int m = 0;  m < console.num_divisions; m++) {
    // printf( "Copying manual %i\n", m );
    cp->divisions[m].label = console.divisions[m].label;
    cp->divisions[m].name = console.divisions[m].name;
    cp->divisions[m].colour = console.divisions[m].colour;
    cp->divisions[m].midiChannel = console.divisions[m].midiChannel;

    cp->divisions[m].num_stops = console.divisions[m].num_stops;
    for (int s = 0; s < cp->divisions[m].num_stops; s++ ) {
      cp->divisions[m].stops[s].label = console.divisions[m].stops[s].label;
      cp->divisions[m].stops[s].name = console.divisions[m].stops[s].name;
      cp->divisions[m].stops[s].colour = console.divisions[m].stops[s].colour;
      cp->divisions[m].stops[s].isReed = console.divisions[m].stops[s].isReed;
      cp->divisions[m].stops[s].midiBank = console.divisions[m].stops[s].midiBank;
      cp->divisions[m].stops[s].midiVoice = console.divisions[m].stops[s].midiVoice;
      cp->divisions[m].stops[s].pulled = console.divisions[m].stops[s].pulled;
      cp->divisions[m].stops[s].velocity = console.divisions[m].stops[s].velocity;
      cp->divisions[m].stops[s].kbdMidiChannel = console.divisions[m].stops[s].kbdMidiChannel;
      cp->divisions[m].stops[s].voiceIndex = console.divisions[m].stops[s].voiceIndex;
    }

    cp->divisions[m].num_pistons = console.divisions[m].num_pistons;
    for (int p = 0; p < cp->divisions[m].num_pistons; p++ ) {
      cp->divisions[m].pistons[p].label = console.divisions[m].pistons[p].label;
      cp->divisions[m].pistons[p].name = console.divisions[m].pistons[p].name;
      cp->divisions[m].pistons[p].active = console.divisions[m].pistons[p].active;
      cp->divisions[m].pistons[p].widgetID = console.divisions[m].pistons[p].widgetID;

      cp->divisions[m].pistons[p].numPistonStops = console.divisions[m].pistons[p].numPistonStops;
      for (int ps = 0; ps < cp->divisions[m].pistons[p].numPistonStops; ps++) {
	cp->divisions[m].pistons[p].pistonStops[ps].divisionLabel = console.divisions[m].pistons[p].pistonStops[ps].divisionLabel;
	cp->divisions[m].pistons[p].pistonStops[ps].stopLabel = console.divisions[m].pistons[p].pistonStops[ps].stopLabel;
      }
    }

    cp->divisions[m].num_couplers = console.divisions[m].num_couplers;
    for (int c = 0; c < cp->divisions[m].num_couplers; c++) {
      cp->divisions[m].couplers[c].label       = console.divisions[m].couplers[c].label;
      cp->divisions[m].couplers[c].name        = console.divisions[m].couplers[c].name;
      cp->divisions[m].couplers[c].coupleTo    = console.divisions[m].couplers[c].coupleTo;
      cp->divisions[m].couplers[c].fromChannel = console.divisions[m].couplers[c].fromChannel;
      cp->divisions[m].couplers[c].length      = console.divisions[m].couplers[c].length;
      cp->divisions[m].couplers[c].toChannel   = console.divisions[m].couplers[c].toChannel;
      cp->divisions[m].couplers[c].active      = console.divisions[m].couplers[c].active;
    }
  }

  cp->num_toePistons = console.num_toePistons;
  for (int tp = 0; tp < cp->num_toePistons; tp++) {
    cp->toePistons[tp].label = console.toePistons[tp].label;
    cp->toePistons[tp].name = console.toePistons[tp].name;
    cp->toePistons[tp].active = console.toePistons[tp].active;
    cp->toePistons[tp].widgetID = console.toePistons[tp].widgetID;
    cp->toePistons[tp].midiChannel = console.toePistons[tp].midiChannel;
    cp->toePistons[tp].numPistonStops = console.toePistons[tp].numPistonStops;
    for (int tps = 0; tps < cp->toePistons[tp].numPistonStops; tps++) {
      cp->toePistons[tp].pistonStops[tps].divisionLabel = console.toePistons[tp].pistonStops[tps].divisionLabel;
      cp->toePistons[tp].pistonStops[tps].stopLabel = console.toePistons[tp].pistonStops[tps].stopLabel;
    }
    
  }

  for (int v = 0;  v < MAX_INPUT_CHANNELS * MAX_MIDI_OUTPUT_PORTS; v++) {
      cp->voices[v].active         = console.voices[v].active;
      cp->voices[v].manual_channel = console.voices[v].manual_channel;
      cp->voices[v].velocity       = console.voices[v].velocity;
      cp->voices[v].synth          = console.voices[v].synth;
      cp->voices[v].bank           = console.voices[v].bank;
      cp->voices[v].voice          = console.voices[v].voice;
    }

  return TRUE;
}

