// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003,2004 - Steve Merrony 

// This program is free software; you may redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.

// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.

// You should have received a copy of the GNU General Public License along with 
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple 
// Place, Suite 330, Boston, MA 02111-1307 USA

#include <qapplication.h>
#include <qregexp.h>

#include "application.h"
#include "console.h"
#include "midiThread.h"
    
#include <iostream>
using namespace std;

int main( int argc, char ** argv ) {

  Console *console = new Console();


  QApplication a( argc, argv );

  QString argStr;
  QString clientStr;
  QString portStr;

  console->orgFileName = QString::null;
  console->verboseMode = FALSE;
  console->requestedOutput = FALSE;

  // handle any arguments passed in
  if ( a.argc() > 1 ) {
    for (int arg = 1; arg<a.argc(); arg++) {
      argStr = a.argv()[arg];
      if (argStr.compare( "--help" ) == 0) {
	cout << "\nUsage: genpo [options] [file]\n\
Options:\n\
  --help                     This help\n\
  --verbose                  Be a lot more verbose in the console while genpo is running\n\
  --outport=<client>:<port>  Hint that genpo should try to send output to a particular ALSA device\n\
  --singlestop               Only permit one stop at a time (incompatible with pistons)\n\
\n\
If a filename (ending in '.org') is specifield genpo will try to load that organ specification at startup.\n\
\n\
For more information please visit http://genpo.sourceforge.net/\n";
	exit(0);
      }
      if (argStr.endsWith( ".org" )) { console->orgFileName = argStr; continue; }
      if (argStr.compare( "--verbose" ) == 0) { console->verboseMode = TRUE; continue; }
      if (argStr.compare( "--singlestop" ) == 0) { console->singleStopMode = TRUE; continue; }
      if (argStr.startsWith( "--outport=" )) {
	// syntax is <client#>:<port#>
	console->requestedOutput = TRUE;
	clientStr = argStr.mid( argStr.find( QRegExp( "=" ) ) +1, argStr.find( QRegExp( ":" )) - argStr.find( QRegExp( "=" ))-1 );
	console->requestedOutClient = clientStr.toInt();
	portStr = argStr.right( argStr.length() - argStr.find( QRegExp( ":" ) ) -1);
	console->requestedOutPort = portStr.toInt();
        // printf( "\n%s yields: Client: <%s>, Port: <%s>\n", argStr.ascii(), clientStr.ascii(), portStr.ascii() );
      }
    }
  }

  ApplicationWindow * mw = new ApplicationWindow( console );
  a.setMainWidget( mw );
  mw->setCaption( APP_NAME );
  mw->show();
  a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
  
  MidiThread *mThread = new MidiThread( console );
  mThread->start();
  
  return a.exec();
}

